/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-06-05 10:47:14 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=216 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "A WordPress Commenter", "wapuu@wordpress.example", "https://wordpress.org/", "", "2025-06-05 10:38:50", "2025-06-05 10:38:50", "Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com/\">Gravatar</a>.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20250605_neatandtidy", "c82a396452c45dfa9061_20250605104711", "21", "2025-06-05 10:47:14", "Lorrainw", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-06-05 10:47:11\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.8.1\";s:9:\"VersionDB\";s:6:\"8.0.35\";s:10:\"VersionPHP\";s:6:\"8.2.23\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";i:1;s:4:\"Name\";s:20:\"20250605_neatandtidy\";s:4:\"Hash\";s:35:\"c82a396452c45dfa9061_20250605104711\";s:8:\"NameHash\";s:56:\"20250605_neatandtidy_c82a396452c45dfa9061_20250605104711\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:66:\"20250605_neatandtidy_c82a396452c45dfa9061_20250605104711_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.4\";s:6:\"WPUser\";s:8:\"Lorrainw\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:68:\"20250605_neatandtidy_c82a396452c45dfa9061_20250605104711_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:57:\"/Users/lorrainejones/Local Sites/neat-and-tidy/app/public\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1329;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:6880;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-06-05 10:47:11\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.8.1\";s:9:\"VersionDB\";s:6:\"8.0.35\";s:10:\"VersionPHP\";s:6:\"8.2.23\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:20:\"20250605_neatandtidy\";s:4:\"Hash\";s:35:\"c82a396452c45dfa9061_20250605104711\";s:8:\"NameHash\";s:56:\"20250605_neatandtidy_c82a396452c45dfa9061_20250605104711\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:74:\"20250605_neatandtidy_c82a396452c45dfa9061_20250605104711_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:71:\"/Users/lorrainejones/Local Sites/neat-and-tidy/app/public/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:69:\"20250605_neatandtidy_c82a396452c45dfa9061_20250605104711_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:159:\"/Users/lorrainejones/Local Sites/neat-and-tidy/app/public/wp-content/backups-dup-lite/tmp/20250605_neatandtidy_c82a396452c45dfa9061_20250605104711_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:66:\"/Users/lorrainejones/Local Sites/neat-and-tidy/app/public/wp-admin\";i:1;s:69:\"/Users/lorrainejones/Local Sites/neat-and-tidy/app/public/wp-includes\";i:2;s:78:\"/Users/lorrainejones/Local Sites/neat-and-tidy/app/public/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:57:\"/Users/lorrainejones/Local Sites/neat-and-tidy/app/public\";i:1;s:57:\"/Users/lorrainejones/Local Sites/neat-and-tidy/app/public\";i:2;s:68:\"/Users/lorrainejones/Local Sites/neat-and-tidy/app/public/wp-content\";i:3;s:76:\"/Users/lorrainejones/Local Sites/neat-and-tidy/app/public/wp-content/uploads\";i:4;s:76:\"/Users/lorrainejones/Local Sites/neat-and-tidy/app/public/wp-content/plugins\";i:5;s:79:\"/Users/lorrainejones/Local Sites/neat-and-tidy/app/public/wp-content/mu-plugins\";i:6;s:75:\"/Users/lorrainejones/Local Sites/neat-and-tidy/app/public/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:89:\"/Users/lorrainejones/Local Sites/neat-and-tidy/app/public/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_e_events */
INSERT INTO `wp_e_events` VALUES("1", "{\"event\":\"modal load\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"account\\\",\\\"user_state\\\":\\\"anon\\\"}\",\"ts\":\"2025-06-05T11:40:51.981-01:00\"}", "2025-06-05 11:40:52");
INSERT INTO `wp_e_events` VALUES("2", "{\"event\":\"skip\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"account\\\"}\",\"ts\":\"2025-06-05T11:40:57.859-01:00\"}", "2025-06-05 11:40:58");
INSERT INTO `wp_e_events` VALUES("3", "{\"event\":\"modal load\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"chooseFeatures\\\",\\\"user_state\\\":\\\"anon\\\"}\",\"ts\":\"2025-06-05T11:40:57.872-01:00\"}", "2025-06-05 11:40:58");
INSERT INTO `wp_e_events` VALUES("4", "{\"event\":\"skip\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"chooseFeatures\\\"}\",\"ts\":\"2025-06-05T11:41:10.415-01:00\"}", "2025-06-05 13:41:10");
INSERT INTO `wp_e_events` VALUES("5", "{\"event\":\"modal load\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"goodToGo\\\",\\\"user_state\\\":\\\"anon\\\"}\",\"ts\":\"2025-06-05T11:41:10.426-01:00\"}", "2025-06-05 13:41:10");
INSERT INTO `wp_e_events` VALUES("6", "{\"event\":\"skip\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"goodToGo\\\"}\",\"ts\":\"2025-06-05T11:41:12.007-01:00\"}", "2025-06-05 13:41:12");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "cron", "a:12:{i:1749123530;a:2:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1749125330;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1749127130;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1749163156;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1749206330;a:2:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1749206356;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1749206357;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1749206451;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1749477600;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1749503828;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1749724786;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("2", "siteurl", "http://localhost:10033", "on");
INSERT INTO `wp_options` VALUES("3", "home", "http://localhost:10033", "on");
INSERT INTO `wp_options` VALUES("4", "blogname", "Neat and Tidy", "on");
INSERT INTO `wp_options` VALUES("5", "blogdescription", "", "on");
INSERT INTO `wp_options` VALUES("6", "users_can_register", "0", "on");
INSERT INTO `wp_options` VALUES("7", "admin_email", "lorrainej@euromediaal.com", "on");
INSERT INTO `wp_options` VALUES("8", "start_of_week", "1", "on");
INSERT INTO `wp_options` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `wp_options` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `wp_options` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `wp_options` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `wp_options` VALUES("13", "posts_per_rss", "10", "on");
INSERT INTO `wp_options` VALUES("14", "rss_use_excerpt", "0", "on");
INSERT INTO `wp_options` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `wp_options` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `wp_options` VALUES("17", "mailserver_pass", "", "on");
INSERT INTO `wp_options` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `wp_options` VALUES("19", "default_category", "1", "on");
INSERT INTO `wp_options` VALUES("20", "default_comment_status", "open", "on");
INSERT INTO `wp_options` VALUES("21", "default_ping_status", "open", "on");
INSERT INTO `wp_options` VALUES("22", "default_pingback_flag", "1", "on");
INSERT INTO `wp_options` VALUES("23", "posts_per_page", "10", "on");
INSERT INTO `wp_options` VALUES("24", "date_format", "F j, Y", "on");
INSERT INTO `wp_options` VALUES("25", "time_format", "g:i a", "on");
INSERT INTO `wp_options` VALUES("26", "links_updated_date_format", "F j, Y g:i a", "on");
INSERT INTO `wp_options` VALUES("27", "comment_moderation", "0", "on");
INSERT INTO `wp_options` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `wp_options` VALUES("29", "permalink_structure", "/%postname%/", "on");
INSERT INTO `wp_options` VALUES("30", "rewrite_rules", "a:112:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:46:\"e-floating-buttons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"e-floating-buttons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"e-floating-buttons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"e-floating-buttons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"e-floating-buttons/([^/]+)/embed/?$\";s:51:\"index.php?e-floating-buttons=$matches[1]&embed=true\";s:39:\"e-floating-buttons/([^/]+)/trackback/?$\";s:45:\"index.php?e-floating-buttons=$matches[1]&tb=1\";s:47:\"e-floating-buttons/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&paged=$matches[2]\";s:54:\"e-floating-buttons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&cpage=$matches[2]\";s:43:\"e-floating-buttons/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?e-floating-buttons=$matches[1]&page=$matches[2]\";s:35:\"e-floating-buttons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"e-floating-buttons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"e-floating-buttons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"e-floating-buttons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=6&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "on");
INSERT INTO `wp_options` VALUES("31", "hack_file", "0", "on");
INSERT INTO `wp_options` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `wp_options` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `wp_options` VALUES("34", "active_plugins", "a:2:{i:0;s:25:\"duplicator/duplicator.php\";i:1;s:23:\"elementor/elementor.php\";}", "on");
INSERT INTO `wp_options` VALUES("35", "category_base", "", "on");
INSERT INTO `wp_options` VALUES("36", "ping_sites", "http://rpc.pingomatic.com/", "on");
INSERT INTO `wp_options` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `wp_options` VALUES("38", "gmt_offset", "0", "on");
INSERT INTO `wp_options` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `wp_options` VALUES("40", "recently_edited", "", "off");
INSERT INTO `wp_options` VALUES("41", "template", "hello-elementor", "on");
INSERT INTO `wp_options` VALUES("42", "stylesheet", "hello-elementor", "on");
INSERT INTO `wp_options` VALUES("43", "comment_registration", "0", "on");
INSERT INTO `wp_options` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `wp_options` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `wp_options` VALUES("46", "default_role", "subscriber", "on");
INSERT INTO `wp_options` VALUES("47", "db_version", "58975", "on");
INSERT INTO `wp_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `wp_options` VALUES("49", "upload_path", "", "on");
INSERT INTO `wp_options` VALUES("50", "blog_public", "1", "on");
INSERT INTO `wp_options` VALUES("51", "default_link_category", "2", "on");
INSERT INTO `wp_options` VALUES("52", "show_on_front", "page", "on");
INSERT INTO `wp_options` VALUES("53", "tag_base", "", "on");
INSERT INTO `wp_options` VALUES("54", "show_avatars", "1", "on");
INSERT INTO `wp_options` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `wp_options` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `wp_options` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `wp_options` VALUES("60", "medium_size_w", "300", "on");
INSERT INTO `wp_options` VALUES("61", "medium_size_h", "300", "on");
INSERT INTO `wp_options` VALUES("62", "avatar_default", "mystery", "on");
INSERT INTO `wp_options` VALUES("63", "large_size_w", "1024", "on");
INSERT INTO `wp_options` VALUES("64", "large_size_h", "1024", "on");
INSERT INTO `wp_options` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `wp_options` VALUES("66", "image_default_size", "", "on");
INSERT INTO `wp_options` VALUES("67", "image_default_align", "", "on");
INSERT INTO `wp_options` VALUES("68", "close_comments_for_old_posts", "0", "on");
INSERT INTO `wp_options` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `wp_options` VALUES("70", "thread_comments", "1", "on");
INSERT INTO `wp_options` VALUES("71", "thread_comments_depth", "5", "on");
INSERT INTO `wp_options` VALUES("72", "page_comments", "0", "on");
INSERT INTO `wp_options` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `wp_options` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `wp_options` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `wp_options` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("77", "widget_categories", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("78", "widget_text", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("79", "widget_rss", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("80", "uninstall_plugins", "a:1:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}}", "off");
INSERT INTO `wp_options` VALUES("81", "timezone_string", "", "on");
INSERT INTO `wp_options` VALUES("82", "page_for_posts", "0", "on");
INSERT INTO `wp_options` VALUES("83", "page_on_front", "6", "on");
INSERT INTO `wp_options` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `wp_options` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `wp_options` VALUES("87", "site_icon", "0", "on");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `wp_options` VALUES("90", "wp_page_for_privacy_policy", "3", "on");
INSERT INTO `wp_options` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `wp_options` VALUES("92", "admin_email_lifespan", "1764671930", "on");
INSERT INTO `wp_options` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `wp_options` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `wp_options` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `wp_options` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `wp_options` VALUES("99", "wp_force_deactivated_plugins", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("101", "initial_db_version", "58975", "on");
INSERT INTO `wp_options` VALUES("102", "wp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "on");
INSERT INTO `wp_options` VALUES("103", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("104", "user_count", "1", "off");
INSERT INTO `wp_options` VALUES("105", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("106", "sidebars_widgets", "a:2:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:13:\"array_version\";i:3;}", "auto");
INSERT INTO `wp_options` VALUES("107", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("108", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("109", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("110", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("111", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("112", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("113", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("114", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("115", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("116", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("117", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("118", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("119", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("120", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("121", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:5:\"6.8.1\";s:5:\"files\";a:536:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:21:\"button/editor-rtl.css\";i:29;s:25:\"button/editor-rtl.min.css\";i:30;s:17:\"button/editor.css\";i:31;s:21:\"button/editor.min.css\";i:32;s:20:\"button/style-rtl.css\";i:33;s:24:\"button/style-rtl.min.css\";i:34;s:16:\"button/style.css\";i:35;s:20:\"button/style.min.css\";i:36;s:22:\"buttons/editor-rtl.css\";i:37;s:26:\"buttons/editor-rtl.min.css\";i:38;s:18:\"buttons/editor.css\";i:39;s:22:\"buttons/editor.min.css\";i:40;s:21:\"buttons/style-rtl.css\";i:41;s:25:\"buttons/style-rtl.min.css\";i:42;s:17:\"buttons/style.css\";i:43;s:21:\"buttons/style.min.css\";i:44;s:22:\"calendar/style-rtl.css\";i:45;s:26:\"calendar/style-rtl.min.css\";i:46;s:18:\"calendar/style.css\";i:47;s:22:\"calendar/style.min.css\";i:48;s:25:\"categories/editor-rtl.css\";i:49;s:29:\"categories/editor-rtl.min.css\";i:50;s:21:\"categories/editor.css\";i:51;s:25:\"categories/editor.min.css\";i:52;s:24:\"categories/style-rtl.css\";i:53;s:28:\"categories/style-rtl.min.css\";i:54;s:20:\"categories/style.css\";i:55;s:24:\"categories/style.min.css\";i:56;s:19:\"code/editor-rtl.css\";i:57;s:23:\"code/editor-rtl.min.css\";i:58;s:15:\"code/editor.css\";i:59;s:19:\"code/editor.min.css\";i:60;s:18:\"code/style-rtl.css\";i:61;s:22:\"code/style-rtl.min.css\";i:62;s:14:\"code/style.css\";i:63;s:18:\"code/style.min.css\";i:64;s:18:\"code/theme-rtl.css\";i:65;s:22:\"code/theme-rtl.min.css\";i:66;s:14:\"code/theme.css\";i:67;s:18:\"code/theme.min.css\";i:68;s:22:\"columns/editor-rtl.css\";i:69;s:26:\"columns/editor-rtl.min.css\";i:70;s:18:\"columns/editor.css\";i:71;s:22:\"columns/editor.min.css\";i:72;s:21:\"columns/style-rtl.css\";i:73;s:25:\"columns/style-rtl.min.css\";i:74;s:17:\"columns/style.css\";i:75;s:21:\"columns/style.min.css\";i:76;s:33:\"comment-author-name/style-rtl.css\";i:77;s:37:\"comment-author-name/style-rtl.min.css\";i:78;s:29:\"comment-author-name/style.css\";i:79;s:33:\"comment-author-name/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:26:\"comment-date/style-rtl.css\";i:85;s:30:\"comment-date/style-rtl.min.css\";i:86;s:22:\"comment-date/style.css\";i:87;s:26:\"comment-date/style.min.css\";i:88;s:31:\"comment-edit-link/style-rtl.css\";i:89;s:35:\"comment-edit-link/style-rtl.min.css\";i:90;s:27:\"comment-edit-link/style.css\";i:91;s:31:\"comment-edit-link/style.min.css\";i:92;s:32:\"comment-reply-link/style-rtl.css\";i:93;s:36:\"comment-reply-link/style-rtl.min.css\";i:94;s:28:\"comment-reply-link/style.css\";i:95;s:32:\"comment-reply-link/style.min.css\";i:96;s:30:\"comment-template/style-rtl.css\";i:97;s:34:\"comment-template/style-rtl.min.css\";i:98;s:26:\"comment-template/style.css\";i:99;s:30:\"comment-template/style.min.css\";i:100;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:101;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:102;s:38:\"comments-pagination-numbers/editor.css\";i:103;s:42:\"comments-pagination-numbers/editor.min.css\";i:104;s:34:\"comments-pagination/editor-rtl.css\";i:105;s:38:\"comments-pagination/editor-rtl.min.css\";i:106;s:30:\"comments-pagination/editor.css\";i:107;s:34:\"comments-pagination/editor.min.css\";i:108;s:33:\"comments-pagination/style-rtl.css\";i:109;s:37:\"comments-pagination/style-rtl.min.css\";i:110;s:29:\"comments-pagination/style.css\";i:111;s:33:\"comments-pagination/style.min.css\";i:112;s:29:\"comments-title/editor-rtl.css\";i:113;s:33:\"comments-title/editor-rtl.min.css\";i:114;s:25:\"comments-title/editor.css\";i:115;s:29:\"comments-title/editor.min.css\";i:116;s:23:\"comments/editor-rtl.css\";i:117;s:27:\"comments/editor-rtl.min.css\";i:118;s:19:\"comments/editor.css\";i:119;s:23:\"comments/editor.min.css\";i:120;s:22:\"comments/style-rtl.css\";i:121;s:26:\"comments/style-rtl.min.css\";i:122;s:18:\"comments/style.css\";i:123;s:22:\"comments/style.min.css\";i:124;s:20:\"cover/editor-rtl.css\";i:125;s:24:\"cover/editor-rtl.min.css\";i:126;s:16:\"cover/editor.css\";i:127;s:20:\"cover/editor.min.css\";i:128;s:19:\"cover/style-rtl.css\";i:129;s:23:\"cover/style-rtl.min.css\";i:130;s:15:\"cover/style.css\";i:131;s:19:\"cover/style.min.css\";i:132;s:22:\"details/editor-rtl.css\";i:133;s:26:\"details/editor-rtl.min.css\";i:134;s:18:\"details/editor.css\";i:135;s:22:\"details/editor.min.css\";i:136;s:21:\"details/style-rtl.css\";i:137;s:25:\"details/style-rtl.min.css\";i:138;s:17:\"details/style.css\";i:139;s:21:\"details/style.min.css\";i:140;s:20:\"embed/editor-rtl.css\";i:141;s:24:\"embed/editor-rtl.min.css\";i:142;s:16:\"embed/editor.css\";i:143;s:20:\"embed/editor.min.css\";i:144;s:19:\"embed/style-rtl.css\";i:145;s:23:\"embed/style-rtl.min.css\";i:146;s:15:\"embed/style.css\";i:147;s:19:\"embed/style.min.css\";i:148;s:19:\"embed/theme-rtl.css\";i:149;s:23:\"embed/theme-rtl.min.css\";i:150;s:15:\"embed/theme.css\";i:151;s:19:\"embed/theme.min.css\";i:152;s:19:\"file/editor-rtl.css\";i:153;s:23:\"file/editor-rtl.min.css\";i:154;s:15:\"file/editor.css\";i:155;s:19:\"file/editor.min.css\";i:156;s:18:\"file/style-rtl.css\";i:157;s:22:\"file/style-rtl.min.css\";i:158;s:14:\"file/style.css\";i:159;s:18:\"file/style.min.css\";i:160;s:23:\"footnotes/style-rtl.css\";i:161;s:27:\"footnotes/style-rtl.min.css\";i:162;s:19:\"footnotes/style.css\";i:163;s:23:\"footnotes/style.min.css\";i:164;s:23:\"freeform/editor-rtl.css\";i:165;s:27:\"freeform/editor-rtl.min.css\";i:166;s:19:\"freeform/editor.css\";i:167;s:23:\"freeform/editor.min.css\";i:168;s:22:\"gallery/editor-rtl.css\";i:169;s:26:\"gallery/editor-rtl.min.css\";i:170;s:18:\"gallery/editor.css\";i:171;s:22:\"gallery/editor.min.css\";i:172;s:21:\"gallery/style-rtl.css\";i:173;s:25:\"gallery/style-rtl.min.css\";i:174;s:17:\"gallery/style.css\";i:175;s:21:\"gallery/style.min.css\";i:176;s:21:\"gallery/theme-rtl.css\";i:177;s:25:\"gallery/theme-rtl.min.css\";i:178;s:17:\"gallery/theme.css\";i:179;s:21:\"gallery/theme.min.css\";i:180;s:20:\"group/editor-rtl.css\";i:181;s:24:\"group/editor-rtl.min.css\";i:182;s:16:\"group/editor.css\";i:183;s:20:\"group/editor.min.css\";i:184;s:19:\"group/style-rtl.css\";i:185;s:23:\"group/style-rtl.min.css\";i:186;s:15:\"group/style.css\";i:187;s:19:\"group/style.min.css\";i:188;s:19:\"group/theme-rtl.css\";i:189;s:23:\"group/theme-rtl.min.css\";i:190;s:15:\"group/theme.css\";i:191;s:19:\"group/theme.min.css\";i:192;s:21:\"heading/style-rtl.css\";i:193;s:25:\"heading/style-rtl.min.css\";i:194;s:17:\"heading/style.css\";i:195;s:21:\"heading/style.min.css\";i:196;s:19:\"html/editor-rtl.css\";i:197;s:23:\"html/editor-rtl.min.css\";i:198;s:15:\"html/editor.css\";i:199;s:19:\"html/editor.min.css\";i:200;s:20:\"image/editor-rtl.css\";i:201;s:24:\"image/editor-rtl.min.css\";i:202;s:16:\"image/editor.css\";i:203;s:20:\"image/editor.min.css\";i:204;s:19:\"image/style-rtl.css\";i:205;s:23:\"image/style-rtl.min.css\";i:206;s:15:\"image/style.css\";i:207;s:19:\"image/style.min.css\";i:208;s:19:\"image/theme-rtl.css\";i:209;s:23:\"image/theme-rtl.min.css\";i:210;s:15:\"image/theme.css\";i:211;s:19:\"image/theme.min.css\";i:212;s:29:\"latest-comments/style-rtl.css\";i:213;s:33:\"latest-comments/style-rtl.min.css\";i:214;s:25:\"latest-comments/style.css\";i:215;s:29:\"latest-comments/style.min.css\";i:216;s:27:\"latest-posts/editor-rtl.css\";i:217;s:31:\"latest-posts/editor-rtl.min.css\";i:218;s:23:\"latest-posts/editor.css\";i:219;s:27:\"latest-posts/editor.min.css\";i:220;s:26:\"latest-posts/style-rtl.css\";i:221;s:30:\"latest-posts/style-rtl.min.css\";i:222;s:22:\"latest-posts/style.css\";i:223;s:26:\"latest-posts/style.min.css\";i:224;s:18:\"list/style-rtl.css\";i:225;s:22:\"list/style-rtl.min.css\";i:226;s:14:\"list/style.css\";i:227;s:18:\"list/style.min.css\";i:228;s:22:\"loginout/style-rtl.css\";i:229;s:26:\"loginout/style-rtl.min.css\";i:230;s:18:\"loginout/style.css\";i:231;s:22:\"loginout/style.min.css\";i:232;s:25:\"media-text/editor-rtl.css\";i:233;s:29:\"media-text/editor-rtl.min.css\";i:234;s:21:\"media-text/editor.css\";i:235;s:25:\"media-text/editor.min.css\";i:236;s:24:\"media-text/style-rtl.css\";i:237;s:28:\"media-text/style-rtl.min.css\";i:238;s:20:\"media-text/style.css\";i:239;s:24:\"media-text/style.min.css\";i:240;s:19:\"more/editor-rtl.css\";i:241;s:23:\"more/editor-rtl.min.css\";i:242;s:15:\"more/editor.css\";i:243;s:19:\"more/editor.min.css\";i:244;s:30:\"navigation-link/editor-rtl.css\";i:245;s:34:\"navigation-link/editor-rtl.min.css\";i:246;s:26:\"navigation-link/editor.css\";i:247;s:30:\"navigation-link/editor.min.css\";i:248;s:29:\"navigation-link/style-rtl.css\";i:249;s:33:\"navigation-link/style-rtl.min.css\";i:250;s:25:\"navigation-link/style.css\";i:251;s:29:\"navigation-link/style.min.css\";i:252;s:33:\"navigation-submenu/editor-rtl.css\";i:253;s:37:\"navigation-submenu/editor-rtl.min.css\";i:254;s:29:\"navigation-submenu/editor.css\";i:255;s:33:\"navigation-submenu/editor.min.css\";i:256;s:25:\"navigation/editor-rtl.css\";i:257;s:29:\"navigation/editor-rtl.min.css\";i:258;s:21:\"navigation/editor.css\";i:259;s:25:\"navigation/editor.min.css\";i:260;s:24:\"navigation/style-rtl.css\";i:261;s:28:\"navigation/style-rtl.min.css\";i:262;s:20:\"navigation/style.css\";i:263;s:24:\"navigation/style.min.css\";i:264;s:23:\"nextpage/editor-rtl.css\";i:265;s:27:\"nextpage/editor-rtl.min.css\";i:266;s:19:\"nextpage/editor.css\";i:267;s:23:\"nextpage/editor.min.css\";i:268;s:24:\"page-list/editor-rtl.css\";i:269;s:28:\"page-list/editor-rtl.min.css\";i:270;s:20:\"page-list/editor.css\";i:271;s:24:\"page-list/editor.min.css\";i:272;s:23:\"page-list/style-rtl.css\";i:273;s:27:\"page-list/style-rtl.min.css\";i:274;s:19:\"page-list/style.css\";i:275;s:23:\"page-list/style.min.css\";i:276;s:24:\"paragraph/editor-rtl.css\";i:277;s:28:\"paragraph/editor-rtl.min.css\";i:278;s:20:\"paragraph/editor.css\";i:279;s:24:\"paragraph/editor.min.css\";i:280;s:23:\"paragraph/style-rtl.css\";i:281;s:27:\"paragraph/style-rtl.min.css\";i:282;s:19:\"paragraph/style.css\";i:283;s:23:\"paragraph/style.min.css\";i:284;s:35:\"post-author-biography/style-rtl.css\";i:285;s:39:\"post-author-biography/style-rtl.min.css\";i:286;s:31:\"post-author-biography/style.css\";i:287;s:35:\"post-author-biography/style.min.css\";i:288;s:30:\"post-author-name/style-rtl.css\";i:289;s:34:\"post-author-name/style-rtl.min.css\";i:290;s:26:\"post-author-name/style.css\";i:291;s:30:\"post-author-name/style.min.css\";i:292;s:26:\"post-author/editor-rtl.css\";i:293;s:30:\"post-author/editor-rtl.min.css\";i:294;s:22:\"post-author/editor.css\";i:295;s:26:\"post-author/editor.min.css\";i:296;s:25:\"post-author/style-rtl.css\";i:297;s:29:\"post-author/style-rtl.min.css\";i:298;s:21:\"post-author/style.css\";i:299;s:25:\"post-author/style.min.css\";i:300;s:33:\"post-comments-form/editor-rtl.css\";i:301;s:37:\"post-comments-form/editor-rtl.min.css\";i:302;s:29:\"post-comments-form/editor.css\";i:303;s:33:\"post-comments-form/editor.min.css\";i:304;s:32:\"post-comments-form/style-rtl.css\";i:305;s:36:\"post-comments-form/style-rtl.min.css\";i:306;s:28:\"post-comments-form/style.css\";i:307;s:32:\"post-comments-form/style.min.css\";i:308;s:26:\"post-content/style-rtl.css\";i:309;s:30:\"post-content/style-rtl.min.css\";i:310;s:22:\"post-content/style.css\";i:311;s:26:\"post-content/style.min.css\";i:312;s:23:\"post-date/style-rtl.css\";i:313;s:27:\"post-date/style-rtl.min.css\";i:314;s:19:\"post-date/style.css\";i:315;s:23:\"post-date/style.min.css\";i:316;s:27:\"post-excerpt/editor-rtl.css\";i:317;s:31:\"post-excerpt/editor-rtl.min.css\";i:318;s:23:\"post-excerpt/editor.css\";i:319;s:27:\"post-excerpt/editor.min.css\";i:320;s:26:\"post-excerpt/style-rtl.css\";i:321;s:30:\"post-excerpt/style-rtl.min.css\";i:322;s:22:\"post-excerpt/style.css\";i:323;s:26:\"post-excerpt/style.min.css\";i:324;s:34:\"post-featured-image/editor-rtl.css\";i:325;s:38:\"post-featured-image/editor-rtl.min.css\";i:326;s:30:\"post-featured-image/editor.css\";i:327;s:34:\"post-featured-image/editor.min.css\";i:328;s:33:\"post-featured-image/style-rtl.css\";i:329;s:37:\"post-featured-image/style-rtl.min.css\";i:330;s:29:\"post-featured-image/style.css\";i:331;s:33:\"post-featured-image/style.min.css\";i:332;s:34:\"post-navigation-link/style-rtl.css\";i:333;s:38:\"post-navigation-link/style-rtl.min.css\";i:334;s:30:\"post-navigation-link/style.css\";i:335;s:34:\"post-navigation-link/style.min.css\";i:336;s:27:\"post-template/style-rtl.css\";i:337;s:31:\"post-template/style-rtl.min.css\";i:338;s:23:\"post-template/style.css\";i:339;s:27:\"post-template/style.min.css\";i:340;s:24:\"post-terms/style-rtl.css\";i:341;s:28:\"post-terms/style-rtl.min.css\";i:342;s:20:\"post-terms/style.css\";i:343;s:24:\"post-terms/style.min.css\";i:344;s:24:\"post-title/style-rtl.css\";i:345;s:28:\"post-title/style-rtl.min.css\";i:346;s:20:\"post-title/style.css\";i:347;s:24:\"post-title/style.min.css\";i:348;s:26:\"preformatted/style-rtl.css\";i:349;s:30:\"preformatted/style-rtl.min.css\";i:350;s:22:\"preformatted/style.css\";i:351;s:26:\"preformatted/style.min.css\";i:352;s:24:\"pullquote/editor-rtl.css\";i:353;s:28:\"pullquote/editor-rtl.min.css\";i:354;s:20:\"pullquote/editor.css\";i:355;s:24:\"pullquote/editor.min.css\";i:356;s:23:\"pullquote/style-rtl.css\";i:357;s:27:\"pullquote/style-rtl.min.css\";i:358;s:19:\"pullquote/style.css\";i:359;s:23:\"pullquote/style.min.css\";i:360;s:23:\"pullquote/theme-rtl.css\";i:361;s:27:\"pullquote/theme-rtl.min.css\";i:362;s:19:\"pullquote/theme.css\";i:363;s:23:\"pullquote/theme.min.css\";i:364;s:39:\"query-pagination-numbers/editor-rtl.css\";i:365;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:366;s:35:\"query-pagination-numbers/editor.css\";i:367;s:39:\"query-pagination-numbers/editor.min.css\";i:368;s:31:\"query-pagination/editor-rtl.css\";i:369;s:35:\"query-pagination/editor-rtl.min.css\";i:370;s:27:\"query-pagination/editor.css\";i:371;s:31:\"query-pagination/editor.min.css\";i:372;s:30:\"query-pagination/style-rtl.css\";i:373;s:34:\"query-pagination/style-rtl.min.css\";i:374;s:26:\"query-pagination/style.css\";i:375;s:30:\"query-pagination/style.min.css\";i:376;s:25:\"query-title/style-rtl.css\";i:377;s:29:\"query-title/style-rtl.min.css\";i:378;s:21:\"query-title/style.css\";i:379;s:25:\"query-title/style.min.css\";i:380;s:25:\"query-total/style-rtl.css\";i:381;s:29:\"query-total/style-rtl.min.css\";i:382;s:21:\"query-total/style.css\";i:383;s:25:\"query-total/style.min.css\";i:384;s:20:\"query/editor-rtl.css\";i:385;s:24:\"query/editor-rtl.min.css\";i:386;s:16:\"query/editor.css\";i:387;s:20:\"query/editor.min.css\";i:388;s:19:\"quote/style-rtl.css\";i:389;s:23:\"quote/style-rtl.min.css\";i:390;s:15:\"quote/style.css\";i:391;s:19:\"quote/style.min.css\";i:392;s:19:\"quote/theme-rtl.css\";i:393;s:23:\"quote/theme-rtl.min.css\";i:394;s:15:\"quote/theme.css\";i:395;s:19:\"quote/theme.min.css\";i:396;s:23:\"read-more/style-rtl.css\";i:397;s:27:\"read-more/style-rtl.min.css\";i:398;s:19:\"read-more/style.css\";i:399;s:23:\"read-more/style.min.css\";i:400;s:18:\"rss/editor-rtl.css\";i:401;s:22:\"rss/editor-rtl.min.css\";i:402;s:14:\"rss/editor.css\";i:403;s:18:\"rss/editor.min.css\";i:404;s:17:\"rss/style-rtl.css\";i:405;s:21:\"rss/style-rtl.min.css\";i:406;s:13:\"rss/style.css\";i:407;s:17:\"rss/style.min.css\";i:408;s:21:\"search/editor-rtl.css\";i:409;s:25:\"search/editor-rtl.min.css\";i:410;s:17:\"search/editor.css\";i:411;s:21:\"search/editor.min.css\";i:412;s:20:\"search/style-rtl.css\";i:413;s:24:\"search/style-rtl.min.css\";i:414;s:16:\"search/style.css\";i:415;s:20:\"search/style.min.css\";i:416;s:20:\"search/theme-rtl.css\";i:417;s:24:\"search/theme-rtl.min.css\";i:418;s:16:\"search/theme.css\";i:419;s:20:\"search/theme.min.css\";i:420;s:24:\"separator/editor-rtl.css\";i:421;s:28:\"separator/editor-rtl.min.css\";i:422;s:20:\"separator/editor.css\";i:423;s:24:\"separator/editor.min.css\";i:424;s:23:\"separator/style-rtl.css\";i:425;s:27:\"separator/style-rtl.min.css\";i:426;s:19:\"separator/style.css\";i:427;s:23:\"separator/style.min.css\";i:428;s:23:\"separator/theme-rtl.css\";i:429;s:27:\"separator/theme-rtl.min.css\";i:430;s:19:\"separator/theme.css\";i:431;s:23:\"separator/theme.min.css\";i:432;s:24:\"shortcode/editor-rtl.css\";i:433;s:28:\"shortcode/editor-rtl.min.css\";i:434;s:20:\"shortcode/editor.css\";i:435;s:24:\"shortcode/editor.min.css\";i:436;s:24:\"site-logo/editor-rtl.css\";i:437;s:28:\"site-logo/editor-rtl.min.css\";i:438;s:20:\"site-logo/editor.css\";i:439;s:24:\"site-logo/editor.min.css\";i:440;s:23:\"site-logo/style-rtl.css\";i:441;s:27:\"site-logo/style-rtl.min.css\";i:442;s:19:\"site-logo/style.css\";i:443;s:23:\"site-logo/style.min.css\";i:444;s:27:\"site-tagline/editor-rtl.css\";i:445;s:31:\"site-tagline/editor-rtl.min.css\";i:446;s:23:\"site-tagline/editor.css\";i:447;s:27:\"site-tagline/editor.min.css\";i:448;s:26:\"site-tagline/style-rtl.css\";i:449;s:30:\"site-tagline/style-rtl.min.css\";i:450;s:22:\"site-tagline/style.css\";i:451;s:26:\"site-tagline/style.min.css\";i:452;s:25:\"site-title/editor-rtl.css\";i:453;s:29:\"site-title/editor-rtl.min.css\";i:454;s:21:\"site-title/editor.css\";i:455;s:25:\"site-title/editor.min.css\";i:456;s:24:\"site-title/style-rtl.css\";i:457;s:28:\"site-title/style-rtl.min.css\";i:458;s:20:\"site-title/style.css\";i:459;s:24:\"site-title/style.min.css\";i:460;s:26:\"social-link/editor-rtl.css\";i:461;s:30:\"social-link/editor-rtl.min.css\";i:462;s:22:\"social-link/editor.css\";i:463;s:26:\"social-link/editor.min.css\";i:464;s:27:\"social-links/editor-rtl.css\";i:465;s:31:\"social-links/editor-rtl.min.css\";i:466;s:23:\"social-links/editor.css\";i:467;s:27:\"social-links/editor.min.css\";i:468;s:26:\"social-links/style-rtl.css\";i:469;s:30:\"social-links/style-rtl.min.css\";i:470;s:22:\"social-links/style.css\";i:471;s:26:\"social-links/style.min.css\";i:472;s:21:\"spacer/editor-rtl.css\";i:473;s:25:\"spacer/editor-rtl.min.css\";i:474;s:17:\"spacer/editor.css\";i:475;s:21:\"spacer/editor.min.css\";i:476;s:20:\"spacer/style-rtl.css\";i:477;s:24:\"spacer/style-rtl.min.css\";i:478;s:16:\"spacer/style.css\";i:479;s:20:\"spacer/style.min.css\";i:480;s:20:\"table/editor-rtl.css\";i:481;s:24:\"table/editor-rtl.min.css\";i:482;s:16:\"table/editor.css\";i:483;s:20:\"table/editor.min.css\";i:484;s:19:\"table/style-rtl.css\";i:485;s:23:\"table/style-rtl.min.css\";i:486;s:15:\"table/style.css\";i:487;s:19:\"table/style.min.css\";i:488;s:19:\"table/theme-rtl.css\";i:489;s:23:\"table/theme-rtl.min.css\";i:490;s:15:\"table/theme.css\";i:491;s:19:\"table/theme.min.css\";i:492;s:24:\"tag-cloud/editor-rtl.css\";i:493;s:28:\"tag-cloud/editor-rtl.min.css\";i:494;s:20:\"tag-cloud/editor.css\";i:495;s:24:\"tag-cloud/editor.min.css\";i:496;s:23:\"tag-cloud/style-rtl.css\";i:497;s:27:\"tag-cloud/style-rtl.min.css\";i:498;s:19:\"tag-cloud/style.css\";i:499;s:23:\"tag-cloud/style.min.css\";i:500;s:28:\"template-part/editor-rtl.css\";i:501;s:32:\"template-part/editor-rtl.min.css\";i:502;s:24:\"template-part/editor.css\";i:503;s:28:\"template-part/editor.min.css\";i:504;s:27:\"template-part/theme-rtl.css\";i:505;s:31:\"template-part/theme-rtl.min.css\";i:506;s:23:\"template-part/theme.css\";i:507;s:27:\"template-part/theme.min.css\";i:508;s:30:\"term-description/style-rtl.css\";i:509;s:34:\"term-description/style-rtl.min.css\";i:510;s:26:\"term-description/style.css\";i:511;s:30:\"term-description/style.min.css\";i:512;s:27:\"text-columns/editor-rtl.css\";i:513;s:31:\"text-columns/editor-rtl.min.css\";i:514;s:23:\"text-columns/editor.css\";i:515;s:27:\"text-columns/editor.min.css\";i:516;s:26:\"text-columns/style-rtl.css\";i:517;s:30:\"text-columns/style-rtl.min.css\";i:518;s:22:\"text-columns/style.css\";i:519;s:26:\"text-columns/style.min.css\";i:520;s:19:\"verse/style-rtl.css\";i:521;s:23:\"verse/style-rtl.min.css\";i:522;s:15:\"verse/style.css\";i:523;s:19:\"verse/style.min.css\";i:524;s:20:\"video/editor-rtl.css\";i:525;s:24:\"video/editor-rtl.min.css\";i:526;s:16:\"video/editor.css\";i:527;s:20:\"video/editor.min.css\";i:528;s:19:\"video/style-rtl.css\";i:529;s:23:\"video/style-rtl.min.css\";i:530;s:15:\"video/style.css\";i:531;s:19:\"video/style.min.css\";i:532;s:19:\"video/theme-rtl.css\";i:533;s:23:\"video/theme-rtl.min.css\";i:534;s:15:\"video/theme.css\";i:535;s:19:\"video/theme.min.css\";}}", "on");
INSERT INTO `wp_options` VALUES("125", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("126", "WPLANG", "", "auto");
INSERT INTO `wp_options` VALUES("127", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.8.1.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.8.1.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-6.8.1-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-6.8.1-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.8.1\";s:7:\"version\";s:5:\"6.8.1\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1749120004;s:15:\"version_checked\";s:5:\"6.8.1\";s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("129", "_site_transient_timeout_theme_roots", "1749121834", "off");
INSERT INTO `wp_options` VALUES("130", "_site_transient_theme_roots", "a:4:{s:15:\"hello-elementor\";s:7:\"/themes\";s:16:\"twentytwentyfive\";s:7:\"/themes\";s:16:\"twentytwentyfour\";s:7:\"/themes\";s:17:\"twentytwentythree\";s:7:\"/themes\";}", "off");
INSERT INTO `wp_options` VALUES("133", "_site_transient_timeout_browser_5b2ba492da1bf8b88f5f71b161575820", "1749724757", "off");
INSERT INTO `wp_options` VALUES("134", "_site_transient_browser_5b2ba492da1bf8b88f5f71b161575820", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"137.0.0.0\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `wp_options` VALUES("135", "_site_transient_timeout_php_check_a34f4a08303dd29cee70e79d780daa9d", "1749724757", "off");
INSERT INTO `wp_options` VALUES("136", "_site_transient_php_check_a34f4a08303dd29cee70e79d780daa9d", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("138", "_site_transient_timeout_community-events-d41d8cd98f00b204e9800998ecf8427e", "1749163623", "off");
INSERT INTO `wp_options` VALUES("139", "_site_transient_community-events-d41d8cd98f00b204e9800998ecf8427e", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";b:0;}s:6:\"events\";a:1:{i:0;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:39:\"BeeWUG - Blackburn WordPress User Group\";s:3:\"url\";s:66:\"https://www.meetup.com/blackburn-wordpress-meetup/events/307984686\";s:6:\"meetup\";s:26:\"Blackburn WordPress Meetup\";s:10:\"meetup_url\";s:50:\"https://www.meetup.com/Blackburn-WordPress-Meetup/\";s:4:\"date\";s:19:\"2025-06-11 18:30:00\";s:8:\"end_date\";s:19:\"2025-06-11 20:30:00\";s:20:\"start_unix_timestamp\";i:1749663000;s:18:\"end_unix_timestamp\";i:1749670200;s:8:\"location\";a:4:{s:8:\"location\";s:6:\"Online\";s:7:\"country\";s:2:\"GB\";s:8:\"latitude\";d:53.75;s:9:\"longitude\";d:-2.4900000000000002;}}}}", "off");
INSERT INTO `wp_options` VALUES("140", "can_compress_scripts", "0", "on");
INSERT INTO `wp_options` VALUES("141", "_transient_timeout_feed_9bbd59226dc36b9b26cd43f15694c5c3", "1749163158", "off");
INSERT INTO `wp_options` VALUES("142", "_transient_feed_9bbd59226dc36b9b26cd43f15694c5c3", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"The latest news about WordPress and the WordPress community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 27 May 2025 16:59:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.9-alpha-60281\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"Announcing the Formation of the WordPress AI Team\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://wordpress.org/news/2025/05/announcing-the-formation-of-the-wordpress-ai-team/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 27 May 2025 16:28:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18769\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:397:\"Today, I’m pleased to announce the formation of a new WordPress AI Team, a dedicated group focused on accelerating and coordinating artificial intelligence projects across the WordPress ecosystem. AI is already transforming how people create and manage content online. As this technology evolves, it’s essential that WordPress remains at the forefront, ensuring innovation happens in [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Mary Hubbard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2961:\"\n<p>Today, I’m pleased to announce the formation of a new <strong>WordPress AI Team,</strong> a dedicated group focused on accelerating and coordinating artificial intelligence projects across the WordPress ecosystem.</p>\n\n\n\n<p>AI is already transforming how people create and manage content online. As this technology evolves, it’s essential that WordPress remains at the forefront, ensuring innovation happens in the open, guided by community values, and built to core standards.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Why This Matters</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Strategic focus</strong>: A unified team stewards AI development thoughtfully, avoids fragmentation, and ensures alignment with the long-term goals of WordPress. </li>\n\n\n\n<li><strong>Shared innovation</strong>: Contributors and companies are actively exploring AI across the ecosystem. This team provides a central place to collaborate, share ideas, and build together.</li>\n\n\n\n<li><strong>Rapid iteration</strong>: Like the Performance Team, we’ll take a plugin-first approach. <a href=\"https://make.wordpress.org/core/2022/09/11/canonical-plugins-revisited/\">Canonical Plugins</a> will allow us to move quickly, gather feedback, and deliver real value without waiting on the Core release cycle.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">What to Expect</h2>\n\n\n\n<p>The AI Team will:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Coordinate cross-team efforts to explore AI-powered features responsibly and inclusively.</li>\n\n\n\n<li>Publish and maintain a public roadmap of AI initiatives and Canonical Plugins.</li>\n\n\n\n<li>Collaborate closely with Core, Design, Accessibility, and other teams to ensure strong integration and shared standards.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Meet the Team</h2>\n\n\n\n<p>The WordPress AI Team brings deep experience in open-source, performance, and product development and a strong commitment to building AI features the WordPress way. The team will launch with the following team contributors:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>James LePage</strong> – Automattic</li>\n\n\n\n<li><strong>Felix Arntz</strong> – Google</li>\n\n\n\n<li><strong>Pascal Birchler</strong> – Google</li>\n\n\n\n<li><strong>Jeff Paul</strong> – 10up</li>\n</ul>\n\n\n\n<p>To help get things started, James and Felix will serve as the initial <a href=\"https://make.wordpress.org/updates/team-reps/\">Team Reps</a> in supporting team organization, communication, and coordination with other Make WordPress teams.</p>\n\n\n\n<p>This is an exciting and important step in WordPress’s evolution. I look forward to seeing what we’ll create together and in the open.</p>\n\n\n\n<p>If you’re interested in contributing or following along, please join the conversations in <a href=\"https://wordpress.slack.com/archives/C08TJ8BPULS\">#core-ai</a> and watch for upcoming meeting announcements on <a href=\"https://make.wordpress.org/ai/\">https://make.wordpress.org/ai/</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18769\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"WordPress Campus Connect Expands\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/news/2025/05/wordpress-campus-connect-expands/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 07 May 2025 12:40:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18726\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:391:\"WordPress Campus Connect, initially launched in October 2024 as a pilot program, has now been formally established as an official event series due to its resounding success. The inaugural program, spearheaded by myself, Anand Upadhyay, garnered immense enthusiasm from 400 Indian students who were eager to engage in hands-on WordPress training. WordPress Campus Connect transcends [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Anand Upadhyay\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:27763:\"\n<p>WordPress Campus Connect, <a href=\"https://central.wordcamp.org/news/2024/12/wp-campus-connect-recap-a-journey-of-empowering-students-and-building-community/\">initially launched in October 2024 as a pilot program</a>, has now been formally established as an official event series due to its resounding success. The inaugural program, spearheaded by myself, <a href=\"https://profiles.wordpress.org/anandau14/\">Anand Upadhyay</a>, garnered immense enthusiasm from 400 Indian students who were eager to engage in hands-on WordPress training.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped has-border-color has-darker-grey-background-color has-background wp-block-gallery-1 is-layout-flex wp-block-gallery-is-layout-flex\" style=\"border-color:#1c2024;border-width:20px;border-radius:2px\">\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;684173c545f6e&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18733\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A6596.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18733\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A6596-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A6596-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A6596-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A6596-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A6596-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;684173c5462cb&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18735\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A8902.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18735\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A8902-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A8902-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A8902-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A8902-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A8902-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;684173c5465a3&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18732\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A6763.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18732\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A6763-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A6763-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A6763-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A6763-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A6763-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;684173c54684c&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"682\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18728\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/05/image-3.jpeg?resize=1024%2C682&#038;ssl=1\" alt=\"\" class=\"wp-image-18728\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/05/image-3.jpeg?resize=1024%2C682&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/05/image-3.jpeg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/05/image-3.jpeg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/05/image-3.jpeg?resize=1536%2C1023&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/05/image-3.jpeg?w=1600&amp;ssl=1 1600w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;684173c546b18&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"682\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18729\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/05/image.jpeg?resize=1024%2C682&#038;ssl=1\" alt=\"\" class=\"wp-image-18729\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/05/image.jpeg?resize=1024%2C682&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/05/image.jpeg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/05/image.jpeg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/05/image.jpeg?resize=1536%2C1023&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/05/image.jpeg?w=1600&amp;ssl=1 1600w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;684173c546ef5&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"682\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18730\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/05/image-1.jpeg?resize=1024%2C682&#038;ssl=1\" alt=\"\" class=\"wp-image-18730\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/05/image-1.jpeg?resize=1024%2C682&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/05/image-1.jpeg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/05/image-1.jpeg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/05/image-1.jpeg?resize=1536%2C1023&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/05/image-1.jpeg?w=1600&amp;ssl=1 1600w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;684173c54730f&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18737\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A8923.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18737\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A8923-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A8923-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A8923-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A8923-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A8923-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;684173c547646&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"682\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18731\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/05/image-2.jpeg?resize=1024%2C682&#038;ssl=1\" alt=\"\" class=\"wp-image-18731\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/05/image-2.jpeg?resize=1024%2C682&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/05/image-2.jpeg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/05/image-2.jpeg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/05/image-2.jpeg?resize=1536%2C1023&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/05/image-2.jpeg?w=1600&amp;ssl=1 1600w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;684173c547958&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18739\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A8821.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18739\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A8821-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A8821-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A8821-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A8821-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A8821-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;684173c547c33&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18734\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A6765.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18734\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A6765-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A6765-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A6765-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A6765-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A6765-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;684173c547f38&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18741\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A9926.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18741\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A9926-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A9926-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A9926-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A9926-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A9926-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;684173c5481fc&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18740\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A9269.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18740\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A9269-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A9269-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A9269-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A9269-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/05/1H4A9269-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n</figure>\n\n\n\n<p>WordPress Campus Connect transcends the conventional workshop model by fostering a holistic learning community. It couples on-campus event learning with a diverse range of post-event activities, including meetups, website challenges, scholarships, and volunteering opportunities, all geared towards nurturing student development. The program&#8217;s efficacy has prompted other organizations in India to express interest in replicating its structure.</p>\n\n\n\n<p>Looking ahead, multiple local WordPress communities in India aim to reach more students in India through WordPress Campus Connect events. The curriculum will include beginner content, delve into more advanced WordPress concepts, and feature specialized sessions tailored for students with prior WordPress experience.&nbsp;</p>\n\n\n\n<div class=\"wp-block-group is-layout-constrained wp-container-core-group-is-layout-8a400663 wp-block-group-is-layout-constrained\">\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"351\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/05/wpcc-logo-transparent.png?resize=1024%2C351&#038;ssl=1\" alt=\"\" class=\"wp-image-18743\" style=\"object-fit:cover\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/05/wpcc-logo-transparent-scaled.png?resize=1024%2C351&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/05/wpcc-logo-transparent-scaled.png?resize=300%2C103&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/05/wpcc-logo-transparent-scaled.png?resize=768%2C263&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/05/wpcc-logo-transparent-scaled.png?resize=1536%2C527&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/05/wpcc-logo-transparent-scaled.png?resize=2048%2C702&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n</div>\n\n\n\n<p>The official recognition of WordPress Campus Connect as an event series paves the way for further expansion, giving the series similar support and standing as WordCamps but with a student education-first goal and focus. Future plans include organizing large-scale student events, establishing WordPress clubs on college campuses, and facilitating mentorship connections for students.</p>\n\n\n\n<p>To support these ambitious goals, volunteers identified several key next steps:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Volunteer Handbook Development:</strong> Creating a comprehensive guidebook to equip volunteers with the necessary resources and information.</li>\n\n\n\n<li><strong>GatherPress Integration:</strong> Exploring the feasibility of integrating GatherPress as a tool for student groups.</li>\n\n\n\n<li><strong>Volunteer Recruitment:</strong> Actively seeking and onboarding volunteers to support WordPress Campus Connect initiatives through activities such as:\n<ol class=\"wp-block-list\">\n<li>Creating a workflow and guidelines for processing Student Club applications</li>\n\n\n\n<li>On-site facilitation or assistance for WordPress Campus Connect events</li>\n</ol>\n</li>\n\n\n\n<li><strong>Landing Page Creation</strong>: Creating a landing page describing what WordPress Campus Connect is all about</li>\n\n\n\n<li><strong>Student Groups: </strong>Drafting a framework for students to create their own groups for hosting WordPress events and activities.&nbsp;</li>\n</ul>\n\n\n\n<p>The overwhelming success of WordPress Campus Connect and the enthusiasm it has generated serve as a testament to the transformative power of passion and dedication. As WordPress Campus Connect continues to evolve and expand, it holds the promise of shaping the future of WordPress education and community engagement.</p>\n\n\n\n<p class=\"has-off-white-background-color has-background\">If you’re interested in helping shape the future of education with WordPress, <a href=\"https://wordpress.slack.com/archives/C08QK4V94AF\">join us in the #campusconnect Make Slack channel</a> today!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18726\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 6.8.1 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2025/04/wordpress-6-8-1-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 30 Apr 2025 17:17:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18721\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:371:\"WordPress 6.8.1 is now available! This minor release includes fixes for 15 bugs throughout Core and the Block Editor addressing issues affecting multiple areas of WordPress including the block editor, multisite, and REST API. For a full list of bug fixes, please refer to the release candidate announcement. WordPress 6.8.1 is a short-cycle maintenance release. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Aaron Jorbin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6967:\"\n<h2 class=\"wp-block-heading\">WordPress 6.8.1 is now available!</h2>\n\n\n\n<p>This minor release includes fixes for 15 bugs <a href=\"https://core.trac.wordpress.org/query?resolution=fixed&amp;milestone=6.8.1&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">throughout Core</a> and <a href=\"https://github.com/WordPress/wordpress-develop/pull/8752\">the Block Editor</a> addressing issues affecting multiple areas of WordPress including the block editor, multisite, and REST API. For a full list of bug fixes, please refer to the <a href=\"https://make.wordpress.org/core/2025/04/28/wordpress-6-8-1-rc1-is-now-available/\">release candidate announcement.</a></p>\n\n\n\n<p>WordPress 6.8.1 is a short-cycle maintenance release. More maintenance releases will be made available throughout 2025.</p>\n\n\n\n<p>If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>You can <a href=\"https://wordpress.org/wordpress-6.8.1.zip\">download WordPress 6.8.1 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”. For more information on this release, please <a href=\"https://wordpress.org/support/wordpress-version/version-6-8-1\">visit the HelpHub site</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>This release was led by <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>.</p>\n\n\n\n<p>WordPress 6.8.1 would not have been possible without the contributions of the following people. Their asynchronous coordination to deliver maintenance fixes into a stable release is a testament to the power and capability of the WordPress community.</p>\n\n\n\n<p class=\"is-style-wporg-props-medium\"><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/wildworks\">Aki Hamano</a>, <a href=\"https://profiles.wordpress.org/ankitmaru\">Ankit Panchal</a>, <a href=\"https://profiles.wordpress.org/bernhard-reiter\">bernhard-reiter</a>, <a href=\"https://profiles.wordpress.org/poena\">Carolina Nymark</a>, <a href=\"https://profiles.wordpress.org/codeamp\">Code Amp</a>, <a href=\"https://profiles.wordpress.org/talldanwp\">Daniel Richards</a>, <a href=\"https://profiles.wordpress.org/davidbaumwald\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/justlevine\">David Levine</a>, <a href=\"https://profiles.wordpress.org/dilipbheda\">Dilip Bheda</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/dsawyers\">dsawyers</a>, <a href=\"https://profiles.wordpress.org/eduwass\">eduwass</a>, <a href=\"https://profiles.wordpress.org/ethitter\">Erick Hitter</a>, <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a>, <a href=\"https://profiles.wordpress.org/fabiankaegy\">Fabian Kägy</a>, <a href=\"https://profiles.wordpress.org/mamaduka\">George Mamadashvili</a>, <a href=\"https://profiles.wordpress.org/gziolo\">Greg Ziółkowski</a>, <a href=\"https://profiles.wordpress.org/kabir93\">H. Kabir</a>, <a href=\"https://profiles.wordpress.org/hideishi\">hideishi</a>, <a href=\"https://profiles.wordpress.org/abcd95\">Himanshu Pathak</a>, <a href=\"https://profiles.wordpress.org/jarekmorawski\">jarekmorawski</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/JeffPaul\">Jeffrey Paul</a>, <a href=\"https://profiles.wordpress.org/jeffr0\">Jeffro</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/joen\">Joen A.</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/verygoode\">Joshua Goode</a>, <a href=\"https://profiles.wordpress.org/karthikeya01\">Karthikeya Bethu</a>, <a href=\"https://profiles.wordpress.org/iamkingsleyf\">Kingsley Felix</a>, <a href=\"https://profiles.wordpress.org/obenland\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/0mirka00\">Lena Morita</a>, <a href=\"https://profiles.wordpress.org/lilgames\">LilGames</a>, <a href=\"https://profiles.wordpress.org/megane9988\">megane9988</a>, <a href=\"https://profiles.wordpress.org/marktimemedia\">Michelle Schulp Hunt</a>, <a href=\"https://profiles.wordpress.org/presstoke\">Mitchell Austin</a>, <a href=\"https://profiles.wordpress.org/mukesh27\">Mukesh Panchal</a>, <a href=\"https://profiles.wordpress.org/nickwilmot\">nickwilmot</a>, <a href=\"https://profiles.wordpress.org/nikunj8866\">Nikunj Hatkar</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/pbiron\">Paul Biron</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/pratiklondhe\">Pratik Londhe</a>, <a href=\"https://profiles.wordpress.org/presskopp\">Presskopp</a>, <a href=\"https://profiles.wordpress.org/sainathpoojary\">Sainath Poojary</a>, <a href=\"https://profiles.wordpress.org/sc0ttkclark\">Scott Kingsley Clark</a>, <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/SergeyBiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/SirLouen\">SirLouen</a>, <a href=\"https://profiles.wordpress.org/soean\">Sören Wünsch</a>, <a href=\"https://profiles.wordpress.org/sourav08\">Sourav Pahwa</a>, <a href=\"https://profiles.wordpress.org/sabernhardt\">Stephen Bernhardt</a>, <a href=\"https://profiles.wordpress.org/takuword\">takuword</a>, <a href=\"https://profiles.wordpress.org/tusharaddweb\">Tushar Patel</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/yogeshbhutkar\">Yogesh Bhutkar</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac, <a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation in the <a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a> and <a href=\"https://wordpress.slack.com/archives/C080HLPP2Q6\">#6-8-release-leads</a> channels. Need help? Check out the <a href=\"https://make.wordpress.org/core/handbook/\">Core Contributor Handbook</a>.</p>\n\n\n\n<p><em>Props to <a href=\'https://profiles.wordpress.org/estelaris/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>estelaris</a> and <a href=\'https://profiles.wordpress.org/joedolson/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joedolson</a> for proofreading.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18721\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"WordPress Jubilee\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://wordpress.org/news/2025/04/jubilee/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 22 Apr 2025 02:07:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18716\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:289:\"As I said, we&#8217;re dropping all the human blocks. Community guidelines, directory guidelines, and such will need to be followed going forward, but whatever blocks were in place before are now cleared. It may take a few days, but any pre-existing blocks are considered bugs to be fixed.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:298:\"\n<p>As I said, we&#8217;re dropping all the human blocks. Community guidelines, directory guidelines, and such will need to be followed going forward, but whatever blocks were in place before are now cleared. It may take a few days, but any pre-existing blocks are considered bugs to be fixed.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18716\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:66:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"WordPress 6.8 “Cecil”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"https://wordpress.org/news/2025/04/cecil/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Apr 2025 17:00:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18701\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:395:\"WordPress 6.8, code-named “Cecil,” refines your creative workflow with a streamlined Style Book, now available in select Classic themes. Enjoy faster navigation via speculative loading, stronger security with bcrypt password hashing, and over 100 accessibility improvements. With thoughtful editor upgrades and behind-the-scenes performance boosts, 6.8 delivers polish, power, and precision.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Jeffrey Paul\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:80555:\"\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"535\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/04/WordPress-6-8-Cecil.png?resize=1024%2C535&#038;ssl=1\" alt=\"Simulated record album featuring a grid of brightly-colored duotone portraits of Cecil Taylor\" class=\"wp-image-18708\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/04/WordPress-6-8-Cecil.png?resize=1024%2C535&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/04/WordPress-6-8-Cecil.png?resize=300%2C157&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/04/WordPress-6-8-Cecil.png?resize=768%2C401&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/04/WordPress-6-8-Cecil.png?resize=1536%2C802&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/04/WordPress-6-8-Cecil.png?resize=2048%2C1070&amp;ssl=1 2048w, https://i0.wp.com/wordpress.org/news/files/2025/04/WordPress-6-8-Cecil.png?w=3000&amp;ssl=1 3000w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>Each WordPress release celebrates an artist who has left an indelible mark on music.&nbsp; WordPress 6.8, code-named “Cecil,” honors the legendary pianist and jazz pioneer Cecil Taylor.</p>\n\n\n\n<p>Classically trained yet relentlessly unconventional, Taylor reimagined the piano as a percussive instrument—layering tone clusters, polyphony, and rhythm into a sound both chaotic and precise. His music defied expectation, finding form in disorder and harmony in dissonance.</p>\n\n\n\n<p>That same spirit drives WordPress 6.8. Embrace its bold new features with the same curiosity and experimentation that defined Cecil’s sound.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Welcome to WordPress 6.8!</h2>\n\n\n\n<p>WordPress 6.8 polishes and refines the tools that you use every day, making your site faster, more secure, and easier to manage.&nbsp; The Style Book now has a structured layout and works with Classic themes, giving you more control over global styles. Speculative loading speeds up navigation by preloading links before users navigate to them, bcrypt hashing strengthens password security automatically, and database optimizations improve performance.</p>\n\n\n\n<p><a href=\"https://wordpress.org/wordpress-6.8.zip\">Download WordPress 6.8 “Cecil”</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">A release polished to a high sheen.</h2>\n\n\n\n<h3 class=\"wp-block-heading\">The Style Book gets a cleaner look—and a few new tricks.</h3>\n\n\n\n<p>The Style Book has a new, structured layout and clearer labels, to make it even easier to edit colors, typography—almost all your site styles—in one place.</p>\n\n\n\n<p>Plus, now you can see it in Classic themes that have editor-styles or a theme.json file.&nbsp; Find the Style Book under Appearance &gt; Design and use it to preview your theme’s evolution, as you edit CSS or make changes in the Customizer.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"900\" height=\"900\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-style-book.png?resize=900%2C900&#038;ssl=1\" alt=\"\" class=\"wp-image-18703\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-style-book.png?w=900&amp;ssl=1 900w, https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-style-book.png?resize=300%2C300&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-style-book.png?resize=150%2C150&amp;ssl=1 150w, https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-style-book.png?resize=768%2C768&amp;ssl=1 768w\" sizes=\"auto, (max-width: 900px) 100vw, 900px\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Editor improvements</h3>\n\n\n\n<p>Easier ways to see your options in Data Views, and you can exclude sticky posts from the Query Loop.&nbsp; Plus, you’ll find lots of little improvements in the editor that smooth your way through everything you build.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"900\" height=\"900\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-editor-improvements.png?resize=900%2C900&#038;ssl=1\" alt=\"\" class=\"wp-image-18705\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-editor-improvements.png?w=900&amp;ssl=1 900w, https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-editor-improvements.png?resize=300%2C300&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-editor-improvements.png?resize=150%2C150&amp;ssl=1 150w, https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-editor-improvements.png?resize=768%2C768&amp;ssl=1 768w\" sizes=\"auto, (max-width: 900px) 100vw, 900px\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Near-instant page loads, thanks to Speculative Loading</h3>\n\n\n\n<p>In WordPress 6.8, pages load faster than ever.&nbsp; When you or your user hovers over or clicks a link, WordPress may preload the next page, for a smoother, near-instant experience. The system balances speed and efficiency, and you can control how it works, with a plugin or your own code.&nbsp; This feature only works in modern browsers—older ones will simply ignore it without any impact.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"900\" height=\"900\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-speculative-loading-1.png?resize=900%2C900&#038;ssl=1\" alt=\"\" class=\"wp-image-18706\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-speculative-loading-1.png?w=900&amp;ssl=1 900w, https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-speculative-loading-1.png?resize=300%2C300&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-speculative-loading-1.png?resize=150%2C150&amp;ssl=1 150w, https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-speculative-loading-1.png?resize=768%2C768&amp;ssl=1 768w\" sizes=\"auto, (max-width: 900px) 100vw, 900px\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Stronger password security with bcrypt</h3>\n\n\n\n<p>Now passwords are harder to crack with bcrypt hashing, which takes a lot more computing power to break.&nbsp; This strengthens overall security, as do other encryption improvements across WordPress.&nbsp; You don’t need to do anything—everything updates automatically.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"900\" height=\"900\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-stronger-password-security-bcrypt.png?resize=900%2C900&#038;ssl=1\" alt=\"\" class=\"wp-image-18707\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-stronger-password-security-bcrypt.png?w=900&amp;ssl=1 900w, https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-stronger-password-security-bcrypt.png?resize=300%2C300&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-stronger-password-security-bcrypt.png?resize=150%2C150&amp;ssl=1 150w, https://i0.wp.com/wordpress.org/news/files/2025/04/6-8-stronger-password-security-bcrypt.png?resize=768%2C768&amp;ssl=1 768w\" sizes=\"auto, (max-width: 900px) 100vw, 900px\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Accessibility improvements</h3>\n\n\n\n<p>100+ accessibility fixes and enhancements touch a broad spectrum of the WordPress experience.&nbsp; This release includes fixes to every bundled theme, improvements to the navigation menu management, the customizer, and simplified labeling.&nbsp; The Block Editor has over 70 improvements to blocks, DataViews, and to its overall user experience.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Performance updates</h3>\n\n\n\n<p>WordPress 6.8 packs a wide range of performance fixes and enhancements to speed up everything from editing to browsing.&nbsp; Beyond speculative loading, WordPress 6.8 pays special attention to the block editor, block type registration, and query caching.&nbsp; Plus, imagine never waiting longer than 50 milliseconds—for any interaction.&nbsp; In WordPress 6.8, the Interactivity API takes a first step toward that goal.</p>\n\n\n\n<h3 class=\"wp-block-heading\">And much more</h3>\n\n\n\n<p>For a comprehensive overview of all the new features and enhancements in WordPress 6.8, please visit the feature-showcase website.</p>\n\n\n\n<p><a href=\"https://wordpress.org/download/releases/6-8/\">Check out what’s new</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Learn more about WordPress 6.8</h2>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\">Learn WordPress</a> is a free resource for new and experienced WordPress users.&nbsp; Learn is stocked with how-to videos on using various features in WordPress, <a href=\"https://learn.wordpress.org/social-learning/\">interactive workshops</a> for exploring topics in-depth, and lesson plans for diving deep into specific areas of WordPress.</p>\n\n\n\n<p>Read the <a href=\"https://wordpress.org/documentation/wordpress-version/version-6.8\">WordPress 6.8 Release Notes</a> for information on installation, enhancements, fixed issues, release contributors, learning resources, and the list of file changes.</p>\n\n\n\n<p>Explore the <a href=\"https://make.wordpress.org/core/2025/03/28/wordpress-6-8-field-guide/\">WordPress 6.8 Field Guide</a>.&nbsp; Learn about the changes in this release with detailed developer notes to help you build with WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The 6.8 release squad</h2>\n\n\n\n<p>Every release comes to you from a dedicated team of enthusiastic contributors who help keep things on track and moving smoothly.&nbsp; The team that has led 6.8 is a cross-functional group of contributors who are always ready to champion ideas, remove blockers, and resolve issues.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Release Lead: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Release Coordination: <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> and <a href=\"https://profiles.wordpress.org/michelleames/\">Michelle Frechette</a></li>\n\n\n\n<li>Tech Leads: <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, and <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a></li>\n\n\n\n<li>Triage Lead: <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a></li>\n\n\n\n<li>Design Lead: <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a></li>\n\n\n\n<li>Performance Lead: <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a></li>\n\n\n\n<li>Test Lead: <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Thank you, contributors</strong></h2>\n\n\n\n<p>The mission of WordPress is to <a href=\"https://wordpress.org/about/\">democratize publishing</a> and embody the <a href=\"https://opensource.org/osd-annotated\">freedoms that come with open source</a>.&nbsp; A global and diverse community of people collaborating to strengthen the software supports this effort.</p>\n\n\n\n<p>WordPress 6.8 reflects the tireless efforts and passion of more than 900 contributors in more than 60 countries all over the world. This release also welcomed over 250 first-time contributors!&nbsp;</p>\n\n\n\n<p>Their collaboration delivered more than 320 enhancements and fixes, ensuring a stable release for all—a testament to the power and capability of the WordPress open source community.</p>\n\n\n<p class=\"has-small-font-size\"><a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/thehercules/\">Aashish Sharma</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/hiabhaykulkarni/\">Abhay Kulkarni</a> · <a href=\"https://profiles.wordpress.org/abhi3315/\">Abhishek Sharma</a> · <a href=\"https://profiles.wordpress.org/adakaleh/\">AdaKaleh</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zieliński</a> · <a href=\"https://profiles.wordpress.org/adhun/\">Adhun Anand</a> · <a href=\"https://profiles.wordpress.org/adityab98/\">Aditya Bansode</a> · <a href=\"https://profiles.wordpress.org/stromhalm/\">Adrian Jagusch</a> · <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a> · <a href=\"https://profiles.wordpress.org/hemant-ahir/\">Ahir Hemant</a> · <a href=\"https://profiles.wordpress.org/ahmarzaidi/\">Ahmar Zaidi</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/ahsankhan316/\">Ahsan Khan</a> · <a href=\"https://profiles.wordpress.org/aishwarryapande/\">Aishwarrya Pande</a> · <a href=\"https://profiles.wordpress.org/ajayghaghretiya1/\">Ajay Ghaghretiya</a> · <a href=\"https://profiles.wordpress.org/ajmaurya/\">Ajay Maurya</a> · <a href=\"https://profiles.wordpress.org/ajitbohra/\">Ajit Bohra</a> · <a href=\"https://profiles.wordpress.org/akanshusingh/\">Akanshu Singh</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/aks30498/\">aks30498</a> · <a href=\"https://profiles.wordpress.org/akshat2802/\">Akshat Kakkad</a> · <a href=\"https://profiles.wordpress.org/akshaydhere/\">Akshay Dhere</a> · <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juh&#233; Lluveras</a> · <a href=\"https://profiles.wordpress.org/ralessio/\">Alessio</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/alexflorisca/\">Alex Florisca</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/albigdd/\">Alexander Bigga</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/alexus450/\">Alexei Samarschi</a> · <a href=\"https://profiles.wordpress.org/alexschmitz/\">alexschmitz</a> · <a href=\"https://profiles.wordpress.org/alireyad/\">Ali Akbar Reyad</a> · <a href=\"https://profiles.wordpress.org/firewatch/\">allilevine</a> · <a href=\"https://profiles.wordpress.org/alpipego/\">alpipego</a> · <a href=\"https://profiles.wordpress.org/mrfoxtalbot/\">Alvaro G&#243;mez</a> · <a href=\"https://profiles.wordpress.org/akrocks/\">Amaan Khan</a> · <a href=\"https://profiles.wordpress.org/alh0319/\">Amber Hinds</a> · <a href=\"https://profiles.wordpress.org/amimulihsanmahdi/\">Amimul Ihsan</a> · <a href=\"https://profiles.wordpress.org/amin7/\">Amin</a> · <a href=\"https://profiles.wordpress.org/amincharoliya/\">Amin Charoliya</a> · <a href=\"https://profiles.wordpress.org/amitbhosale/\">Amit Bhosale</a> · <a href=\"https://profiles.wordpress.org/amitraj2203/\">Amit Raj</a> · <a href=\"https://profiles.wordpress.org/ammarmassoud/\">Ammar Mohamed Fath Allah Abd-Elaaty Massoud</a> · <a href=\"https://profiles.wordpress.org/amolebonde/\">amolebonde</a> · <a href=\"https://profiles.wordpress.org/anandraj346/\">Anand Raj</a> · <a href=\"https://profiles.wordpress.org/anlino/\">Anders Nor&#233;n</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/awetz583/\">Andrea Roenning</a> · <a href=\"https://profiles.wordpress.org/bowedk/\">Andreas Pedersen</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/andrewssanya/\">Andrew Ssanya</a> · <a href=\"https://profiles.wordpress.org/rarst/\">Andrey \"Rarst\" Savchenko</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/rilwis/\">Anh Tran</a> · <a href=\"https://profiles.wordpress.org/wpgurudev/\">Ankit Gade</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitkumarshah/\">Ankit Kumar Shah</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/ankitpatel1578/\">Ankit Patel</a> · <a href=\"https://profiles.wordpress.org/anmolverma404/\">Anmol Verma</a> · <a href=\"https://profiles.wordpress.org/annchichi/\">annchichi</a> · <a href=\"https://profiles.wordpress.org/annebovelett/\">Anne-Mieke Bovelett</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">annezazu</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ahortin/\">Anthony Hortin</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/anujrathore24/\">Anuj Singh</a> · <a href=\"https://profiles.wordpress.org/anveshika/\">Anveshika Srivastava</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/arielmaidana/\">Ariel Maidana</a> · <a href=\"https://profiles.wordpress.org/arnaudbroes/\">arnaudbroes</a> · <a href=\"https://profiles.wordpress.org/arnoutblueshell/\">arnoutblueshell</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/mrashishjain/\">Ashish Jain</a> · <a href=\"https://profiles.wordpress.org/mohonchandra/\">Asish Chandra Mohon</a> · <a href=\"https://profiles.wordpress.org/auareyou/\">Au</a> · <a href=\"https://profiles.wordpress.org/autotutorial/\">autotutorial</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/azharderaiya/\">Azhar Deraiya</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">B&#233;ryl de La Grandi&#232;re</a> · <a href=\"https://profiles.wordpress.org/back2backdvm/\">back2backdvm</a> · <a href=\"https://profiles.wordpress.org/neo2k23/\">BackuPs</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/barry/\">Barry</a> · <a href=\"https://profiles.wordpress.org/bayejid00/\">Bayejid Ahmed</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/benharri/\">ben</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/bsutcliffe/\">Ben Sutcliffe</a> · <a href=\"https://profiles.wordpress.org/benazeer/\">Benazeer</a> · <a href=\"https://profiles.wordpress.org/benniledl/\">Benedikt Ledl</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/berislavgrgicak/\">Bero</a> · <a href=\"https://profiles.wordpress.org/bgermann/\">bgermann</a> · <a href=\"https://profiles.wordpress.org/albatross10/\">Bhavik Kalpesh</a> · <a href=\"https://profiles.wordpress.org/bijit027/\">Bijit Deb</a> · <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/rainynewt/\">Bishal Shrestha</a> · <a href=\"https://profiles.wordpress.org/bjornw/\">BjornW</a> · <a href=\"https://profiles.wordpress.org/bluantinoo/\">bluantinoo</a> · <a href=\"https://profiles.wordpress.org/bogdanungureanu/\">BogdanUngureanu</a> · <a href=\"https://profiles.wordpress.org/bor0/\">Boro Sitnikovski</a> · <a href=\"https://profiles.wordpress.org/veryard/\">Brad</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradleyt/\">Bradley Taylor</a> · <a href=\"https://profiles.wordpress.org/bhubbard/\">Brandon Hubbard</a> · <a href=\"https://profiles.wordpress.org/bpayton/\">Brandon Payton</a> · <a href=\"https://profiles.wordpress.org/brettsmason/\">brettsmason</a> · <a href=\"https://profiles.wordpress.org/brevilo/\">brevilo</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a> · <a href=\"https://profiles.wordpress.org/bronsonquick/\">Bronson Quick</a> · <a href=\"https://profiles.wordpress.org/bschneidewind/\">Bryan Schneidewind</a> · <a href=\"https://profiles.wordpress.org/burakkaptan/\">burak</a> · <a href=\"https://profiles.wordpress.org/burnuser/\">burnuser</a> · <a href=\"https://profiles.wordpress.org/snicco/\">Calvin Alkan</a> · <a href=\"https://profiles.wordpress.org/calvinalkan/\">Calvin Alkan</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/cgastrell/\">cgastrell</a> · <a href=\"https://profiles.wordpress.org/charleslf/\">charleslf</a> · <a href=\"https://profiles.wordpress.org/mel_cha/\">chiilog (Chiaki Okamoto)</a> · <a href=\"https://profiles.wordpress.org/chintanmachhi207/\">chintanmachhi207</a> · <a href=\"https://profiles.wordpress.org/chrico/\">ChriCo</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/chrisdotdotdot/\">chrisdotdotdot</a> · <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a> · <a href=\"https://profiles.wordpress.org/claimableperch/\">claimableperch</a> · <a href=\"https://profiles.wordpress.org/claudiulodro/\">Claudiu Lodromanean</a> · <a href=\"https://profiles.wordpress.org/codeamp/\">Code Amp</a> · <a href=\"https://profiles.wordpress.org/codebymikey/\">codebymikey</a> · <a href=\"https://profiles.wordpress.org/codersantosh/\">codersantosh</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/colind/\">ColinD</a> · <a href=\"https://profiles.wordpress.org/colinleroy/\">colinleroy</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/cbusquets1989/\">Cris Busquets</a> · <a href=\"https://profiles.wordpress.org/mitogh/\">Crisoforo Gaspar</a> · <a href=\"https://profiles.wordpress.org/ctienshi/\">ctienshi</a> · <a href=\"https://profiles.wordpress.org/cweiske/\">cweiske</a> · <a href=\"https://profiles.wordpress.org/didierjm/\">cybeardjm</a> · <a href=\"https://profiles.wordpress.org/coquardcyr/\">Cyrille</a> · <a href=\"https://profiles.wordpress.org/css31/\">Cyrille Sanson</a> · <a href=\"https://profiles.wordpress.org/daedalon/\">Daedalon</a> · <a href=\"https://profiles.wordpress.org/acketon/\">Dakota Chichester</a> · <a href=\"https://profiles.wordpress.org/dalleyne/\">Damien Alleyne</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/dpknauss/\">Dan Knauss</a> · <a href=\"https://profiles.wordpress.org/danht/\">danht</a> · <a href=\"https://profiles.wordpress.org/daniguardiola/\">Dani Guardiola</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/danielpost/\">Daniel Post</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/danielpataki/\">danielpataki</a> · <a href=\"https://profiles.wordpress.org/danielvann/\">danielvann</a> · <a href=\"https://profiles.wordpress.org/dkotter/\">Darin Kotter</a> · <a href=\"https://profiles.wordpress.org/dhewercorus/\">Darren Hewer</a> · <a href=\"https://profiles.wordpress.org/davelo/\">Dave Loodts</a> · <a href=\"https://profiles.wordpress.org/davilera/\">David Aguilera</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">David Arenas</a> · <a href=\"https://profiles.wordpress.org/darnado/\">David Arnado</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/davidabowman/\">David Bowman</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dafargier/\">David FARGIER</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/david-innes/\">David Innes</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/daviedr/\">David Rozando</a> · <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/daymobrew/\">daymobrew</a> · <a href=\"https://profiles.wordpress.org/deadduck169/\">deadduck169</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/dkarfa/\">Debabrata Karfa</a> · <a href=\"https://profiles.wordpress.org/debarghyabanerjee/\">DEBARGHYA BANERJEE</a> · <a href=\"https://profiles.wordpress.org/deeppatel8950/\">Deep Patel</a> · <a href=\"https://profiles.wordpress.org/deepakrohilla/\">Deepak Rohilla</a> · <a href=\"https://profiles.wordpress.org/realloc/\">Dennis Ploetner</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/densinakum/\">Densi Nakum</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/devansh2002/\">Devansh Chaudhary</a> · <a href=\"https://profiles.wordpress.org/dhananjaykuber/\">Dhananjay Kuber</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhavalkapadane/\">Dhaval Kapadane</a> · <a href=\"https://profiles.wordpress.org/dheeraj2995/\">Dheeraj Bhosale</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruvang21/\">Dhruvang21</a> · <a href=\"https://profiles.wordpress.org/dhruvishah2203/\">Dhruvi Shah</a> · <a href=\"https://profiles.wordpress.org/dhruvik18/\">Dhruvik Malaviya</a> · <a href=\"https://profiles.wordpress.org/diguj/\">Digvijay Zite</a> · <a href=\"https://profiles.wordpress.org/dilipom13/\">dilip</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/diliphingarajiya/\">Dilip Hingarajiya</a> · <a href=\"https://profiles.wordpress.org/dilip2615/\">Dilip Modhavadiya</a> · <a href=\"https://profiles.wordpress.org/dingguodong/\">DingGuodong</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/divyeshk71/\">Divyesh_kakrecha</a> · <a href=\"https://profiles.wordpress.org/djcowan/\">dj.cowan</a> · <a href=\"https://profiles.wordpress.org/mediaformat/\">Django</a> · <a href=\"https://profiles.wordpress.org/dnnsjsk/\">dnnsjsk</a> · <a href=\"https://profiles.wordpress.org/doekenorg/\">Doeke Norg</a> · <a href=\"https://profiles.wordpress.org/dogee/\">dogee</a> · <a href=\"https://profiles.wordpress.org/domenicdenicola/\">domenicdenicola</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/donalirl/\">donalirl</a> · <a href=\"https://profiles.wordpress.org/dooperweb/\">dooperweb</a> · <a href=\"https://profiles.wordpress.org/dougwollison/\">Doug Wollison</a> · <a href=\"https://profiles.wordpress.org/dretzlaff/\">dretzlaff</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/drivingralle/\">Drivingralle</a> · <a href=\"https://profiles.wordpress.org/dsawyers/\">dsawyers</a> · <a href=\"https://profiles.wordpress.org/dwainm/\">Dwain Maralack</a> · <a href=\"https://profiles.wordpress.org/earthman100/\">Earthman Media</a> · <a href=\"https://profiles.wordpress.org/eclev91/\">eclev91</a> · <a href=\"https://profiles.wordpress.org/eddystile/\">Eddy</a> · <a href=\"https://profiles.wordpress.org/eduwass/\">eduwass</a> · <a href=\"https://profiles.wordpress.org/cais/\">Edward Caissie</a> · <a href=\"https://profiles.wordpress.org/eceleste/\">efc</a> · <a href=\"https://profiles.wordpress.org/talksina/\">Elena Brescacin</a> · <a href=\"https://profiles.wordpress.org/elizaan36/\">elizaan36</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a> · <a href=\"https://profiles.wordpress.org/codex-m/\">Emerson Maningo</a> · <a href=\"https://profiles.wordpress.org/emlebrun/\">Emilie LEBRUN</a> · <a href=\"https://profiles.wordpress.org/eatse/\">Emmanuel Ats&#233;</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/ericdye/\">Eric Dye</a> · <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a> · <a href=\"https://profiles.wordpress.org/codekraft/\">Erik</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/im3dabasia1/\">Eshaan Dabasiya</a> · <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a> · <a href=\"https://profiles.wordpress.org/eherman24/\">Evan Herman</a> · <a href=\"https://profiles.wordpress.org/etobiesen/\">Even Tobiesen</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fazyshah/\">Faizan Nabi</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/ffffelix/\">Felix Renicks</a> · <a href=\"https://profiles.wordpress.org/finntown/\">finntown</a> · <a href=\"https://profiles.wordpress.org/firoz2456/\">Firoz Sabaliya</a> · <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a> · <a href=\"https://profiles.wordpress.org/franciscabusas22/\">Francis Cabusas</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco</a> · <a href=\"https://profiles.wordpress.org/frankbiganski/\">Frank B.</a> · <a href=\"https://profiles.wordpress.org/frank-klein/\">Frank Klein</a> · <a href=\"https://profiles.wordpress.org/franz00/\">Fransisca H</a> · <a href=\"https://profiles.wordpress.org/frkly/\">frkly</a> · <a href=\"https://profiles.wordpress.org/fushar/\">fushar</a> · <a href=\"https://profiles.wordpress.org/fxbenard/\">FX B&#233;nard</a> · <a href=\"https://profiles.wordpress.org/gaellebesson/\">gaellebesson</a> · <a href=\"https://profiles.wordpress.org/gajendrasingh/\">Gajendra Singh</a> · <a href=\"https://profiles.wordpress.org/galibh/\">Galib Hayder</a> · <a href=\"https://profiles.wordpress.org/ecgan/\">Gan Eng Chin</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/garyj/\">Gary Jones</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/ghinamt/\">ghinamt</a> · <a href=\"https://profiles.wordpress.org/girishpanchal/\">Girish Panchal</a> · <a href=\"https://profiles.wordpress.org/giuriani/\">giuriani</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/glynnquelch/\">Glynn Quelch</a> · <a href=\"https://profiles.wordpress.org/ingeniumed/\">Gopal Krishnan</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/gregbenz/\">gregbenz</a> · <a href=\"https://profiles.wordpress.org/grgarside/\">grgarside</a> · <a href=\"https://profiles.wordpress.org/growwbuddy/\">GrowwBuddy</a> · <a href=\"https://profiles.wordpress.org/guido07111975/\">Guido</a> · <a href=\"https://profiles.wordpress.org/guillaumeturpin/\">Guillaume TURPIN</a> · <a href=\"https://profiles.wordpress.org/gulamdastgir04/\">Gulamdastgir Momin</a> · <a href=\"https://profiles.wordpress.org/priethor/\">H&#233;ctor Prieto</a> · <a href=\"https://profiles.wordpress.org/kabir93/\">H. Kabir</a> · <a href=\"https://profiles.wordpress.org/gencmedya/\">Halil Kaya</a> · <a href=\"https://profiles.wordpress.org/yahaly/\">Halyna Yampolska</a> · <a href=\"https://profiles.wordpress.org/hameem1102/\">Hameem Mahdad Kader</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">Hannes Leismann</a> · <a href=\"https://profiles.wordpress.org/hage/\">Hans-Gerd Gerhards</a> · <a href=\"https://profiles.wordpress.org/hardipparmar/\">Hardip Parmar</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/harishanker/\">Hari Shanker R</a> · <a href=\"https://profiles.wordpress.org/harrym/\">harrym</a> · <a href=\"https://profiles.wordpress.org/harshalkadu/\">Harshal Kadu</a> · <a href=\"https://profiles.wordpress.org/hazdiego/\">Haz</a> · <a href=\"https://profiles.wordpress.org/hekuranredev/\">hekuranredev</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/hdkothari81/\">Hemant Kothari</a> · <a href=\"https://profiles.wordpress.org/iamarinoh/\">Henrique Iamarino</a> · <a href=\"https://profiles.wordpress.org/henrywright/\">Henry Wright</a> · <a href=\"https://profiles.wordpress.org/rvouill/\">Herve THOMAS</a> · <a href=\"https://profiles.wordpress.org/hideishi/\">hideishi</a> · <a href=\"https://profiles.wordpress.org/kurudrive/\">Hidekazu Ishikawa</a> · <a href=\"https://profiles.wordpress.org/hilayt24/\">Hilay Trivedi</a> · <a href=\"https://profiles.wordpress.org/panchalhimani711/\">Himani Panchal</a> · <a href=\"https://profiles.wordpress.org/abcd95/\">Himanshu Pathak</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/hitendra-chopda/\">Hitendra Chopda</a> · <a href=\"https://profiles.wordpress.org/hiteshhuptechweb/\">Hitesh Dhokai</a> · <a href=\"https://profiles.wordpress.org/hovhanneshovakimyan/\">Hovhannes Hovakimyan</a> · <a href=\"https://profiles.wordpress.org/hueitan/\">hueitan</a> · <a href=\"https://profiles.wordpress.org/humanify/\">humanify</a> · <a href=\"https://profiles.wordpress.org/hussain896/\">hussain896</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/ilovecats7/\">ilovecats7</a> · <a href=\"https://profiles.wordpress.org/imranhasanraaz/\">Imran</a> · <a href=\"https://profiles.wordpress.org/imranh920/\">Imran Hossain (a11n)</a> · <a href=\"https://profiles.wordpress.org/indirabiswas27/\">Indira Biswas</a> · <a href=\"https://profiles.wordpress.org/indithemes/\">indithemes</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/iseulde/\">iseulde</a> · <a href=\"https://profiles.wordpress.org/isuke01/\">Isu</a> · <a href=\"https://profiles.wordpress.org/ivankristianto/\">Ivan Kristianto</a> · <a href=\"https://profiles.wordpress.org/moxie/\">Jack</a> · <a href=\"https://profiles.wordpress.org/jagirbahesh/\">Jagir Bahesh</a> · <a href=\"https://profiles.wordpress.org/jainil07/\">Jainil Shah</a> · <a href=\"https://profiles.wordpress.org/whyisjake/\">Jake Spurlock</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/jhmonroe/\">James Monroe</a> · <a href=\"https://profiles.wordpress.org/jopdop30/\">James Payne</a> · <a href=\"https://profiles.wordpress.org/imaginarymedia/\">James Robinson</a> · <a href=\"https://profiles.wordpress.org/q0rban/\">James Sansbury</a> · <a href=\"https://profiles.wordpress.org/jamieblomerus/\">Jamie Blomerus</a> · <a href=\"https://profiles.wordpress.org/jammycakes/\">jammycakes</a> · <a href=\"https://profiles.wordpress.org/lysyjan87/\">Jan Lys&#253;</a> · <a href=\"https://profiles.wordpress.org/janak007/\">janak Kaneriya</a> · <a href=\"https://profiles.wordpress.org/janusdev/\">janusdev</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarekmorawski/\">jarekmorawski</a> · <a href=\"https://profiles.wordpress.org/boogah/\">Jason Cosper</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/jasonsa19/\">Jason Sauerwald</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/shovan_jaya/\">Jayaram</a> · <a href=\"https://profiles.wordpress.org/jdahir0789/\">Jaydip Ahir</a> · <a href=\"https://profiles.wordpress.org/jdnd/\">jdnd</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/krokodok/\">Jeff Chi</a> · <a href=\"https://profiles.wordpress.org/maverick3x6/\">Jeff Golenski</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeff Paul</a> · <a href=\"https://profiles.wordpress.org/jeffr0/\">Jeffro</a> · <a href=\"https://profiles.wordpress.org/jeflopodev/\">jeflopo</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jepperask/\">jepperask</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeremy80/\">jeremy80</a> · <a href=\"https://profiles.wordpress.org/jeremyroman/\">jeremyroman</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/jessedyck/\">jessedyck</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jigar-bhanushali/\">Jigar Bhanushali</a> · <a href=\"https://profiles.wordpress.org/jigar9998/\">Jigar Panchal</a> · <a href=\"https://profiles.wordpress.org/jnweaver/\">jnweaver</a> · <a href=\"https://profiles.wordpress.org/jartes/\">Joan Artes</a> · <a href=\"https://profiles.wordpress.org/jodamo5/\">jodamo5</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joecsmalley/\">joecsmalley</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/timse201/\">Johannes J&#252;lg</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnregan3/\">John Regan</a> · <a href=\"https://profiles.wordpress.org/arrcorona/\">Jomar Jay Corona</a> · <a href=\"https://profiles.wordpress.org/jomonthomaslobo1/\">Jomon Thomas Lobo</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/jongycastillo/\">Jong</a> · <a href=\"https://profiles.wordpress.org/n2erjo00/\">Joni Erkkil&#228;</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jonnyauk/\">jonnyauk</a> · <a href=\"https://profiles.wordpress.org/joomskys/\">joomskys</a> · <a href=\"https://profiles.wordpress.org/joostdevalk/\">Joost de Valk</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/josvelasco/\">Jos Velasco</a> · <a href=\"https://profiles.wordpress.org/josevarghese/\">Jose Varghese</a> · <a href=\"https://profiles.wordpress.org/blogitsolutions/\">Josef Seidl</a> · <a href=\"https://profiles.wordpress.org/josephscott/\">Joseph Scott</a> · <a href=\"https://profiles.wordpress.org/verygoode/\">Joshua Goode</a> · <a href=\"https://profiles.wordpress.org/joshuawold/\">Joshua Wold</a> · <a href=\"https://profiles.wordpress.org/jottevanger/\">jottevanger</a> · <a href=\"https://profiles.wordpress.org/jokanane/\">Jouni Kananen</a> · <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanbuis/\">juanbuis</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juanwp22/\">juanwp22</a> · <a href=\"https://profiles.wordpress.org/jules-colle/\">Jules Colle</a> · <a href=\"https://profiles.wordpress.org/julianmar/\">julianmar</a> · <a href=\"https://profiles.wordpress.org/juliemoynat/\">Julie Moynat</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/juliobox/\">Julio Potier</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/juzar/\">Juzar</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/kaitohm/\">Kaito Hanamori</a> · <a href=\"https://profiles.wordpress.org/ikamal/\">Kamal Hosen</a> · <a href=\"https://profiles.wordpress.org/kapasias/\">KAP ASIAs</a> · <a href=\"https://profiles.wordpress.org/kapilpaul/\">Kapil Paul</a> · <a href=\"https://profiles.wordpress.org/karlgroves/\">karlgroves</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/karthickmurugan/\">Karthick Murugan</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/karthikeya01/\">Karthikeya Bethu</a> · <a href=\"https://profiles.wordpress.org/kasparsd/\">Kaspars</a> · <a href=\"https://profiles.wordpress.org/zoonini/\">Kathryn Presner</a> · <a href=\"https://profiles.wordpress.org/kausaralm/\">Kausar Alam</a> · <a href=\"https://profiles.wordpress.org/keithdevon/\">keithdevon</a> · <a href=\"https://profiles.wordpress.org/kel-dc/\">Kel Santiago-Pilarski</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/tinypixel/\">Kelly Mears</a> · <a href=\"https://profiles.wordpress.org/keoshi/\">keoshi</a> · <a href=\"https://profiles.wordpress.org/ketanniruke/\">Ketan Niruke</a> · <a href=\"https://profiles.wordpress.org/patelketan/\">Ketan Patel</a> · <a href=\"https://profiles.wordpress.org/kevinlearynet/\">Kevin Leary</a> · <a href=\"https://profiles.wordpress.org/kharisblank/\">Kharis Sulistiyono</a> · <a href=\"https://profiles.wordpress.org/iamkingsleyf/\">Kingsley Felix</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kjroelke/\">KJ Roelke</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/kohheepeace/\">kohheepeace</a> · <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a> · <a href=\"https://profiles.wordpress.org/kmgalanakis/\">Konstantinos Galanakis</a> · <a href=\"https://profiles.wordpress.org/xkon/\">Konstantinos Xenos</a> · <a href=\"https://profiles.wordpress.org/kristastevens/\">kristastevens</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupaly2k/\">Krupal Lakhia</a> · <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a> · <a href=\"https://profiles.wordpress.org/lakshmananphp/\">Lax Mariappan</a> · <a href=\"https://profiles.wordpress.org/laxman-prajapati/\">Laxman Prajapati</a> · <a href=\"https://profiles.wordpress.org/lcarevic/\">lcarevic</a> · <a href=\"https://profiles.wordpress.org/leecollings/\">Lee</a> · <a href=\"https://profiles.wordpress.org/leewillis77/\">Lee Willis</a> · <a href=\"https://profiles.wordpress.org/leedxw/\">leedxw</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/lenasterg/\">lenasterg</a> · <a href=\"https://profiles.wordpress.org/leszeks/\">leszeks</a> · <a href=\"https://profiles.wordpress.org/leup/\">leup</a> · <a href=\"https://profiles.wordpress.org/levskipg/\">levskipg</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/lilgames/\">LilGames</a> · <a href=\"https://profiles.wordpress.org/louislaugesen/\">Louis</a> · <a href=\"https://profiles.wordpress.org/louwie17/\">Lourens</a> · <a href=\"https://profiles.wordpress.org/lovesoni1999/\">Love Soni</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/lovewpmu/\">lovewpmu</a> · <a href=\"https://profiles.wordpress.org/lovor/\">Lovro Hrust</a> · <a href=\"https://profiles.wordpress.org/dreadlox/\">Lox</a> · <a href=\"https://profiles.wordpress.org/ltrihan/\">ltrihan</a> · <a href=\"https://profiles.wordpress.org/gigitux/\">Luigi Teschio</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/wpfed/\">Lukasz</a> · <a href=\"https://profiles.wordpress.org/lukecavanagh/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/gadelhas/\">M&#225;rio Santos</a> · <a href=\"https://profiles.wordpress.org/maciejmackowiak/\">maciejmackowiak</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/madpeter/\">madpeter</a> · <a href=\"https://profiles.wordpress.org/magdarogier/\">Magda Rogier</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/mp518/\">Mahesh Prajapati</a> · <a href=\"https://profiles.wordpress.org/mai21/\">Mai</a> · <a href=\"https://profiles.wordpress.org/maikelraow/\">maikelraow</a> · <a href=\"https://profiles.wordpress.org/travel_girl/\">Maja Benke</a> · <a href=\"https://profiles.wordpress.org/mkrndmane/\">Makarand G. Mane</a> · <a href=\"https://profiles.wordpress.org/tomdxw/\">mallorydxw-old</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manojmaharrshi/\">Manoj Maharrshi</a> · <a href=\"https://profiles.wordpress.org/manzoorwanijk/\">Manzoor Wani</a> · <a href=\"https://profiles.wordpress.org/mdxfr/\">Marc</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/marchalyoan/\">marchalyoan</a> · <a href=\"https://profiles.wordpress.org/afmarchetti/\">Marchetti Design</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/mariayohana/\">Maria Yohana</a> · <a href=\"https://profiles.wordpress.org/marian1/\">marian1</a> · <a href=\"https://profiles.wordpress.org/nuryko/\">Marianna</a> · <a href=\"https://profiles.wordpress.org/plari/\">Marie</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/marineevain/\">Marine EVAIN</a> · <a href=\"https://profiles.wordpress.org/nofearinc/\">Mario Peshev</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/mapk/\">Mark Uraine</a> · <a href=\"https://profiles.wordpress.org/mark-k/\">Mark-k</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/4thhubbard/\">Mary Hubbard</a> · <a href=\"https://profiles.wordpress.org/immasud/\">Masud Rana</a> · <a href=\"https://profiles.wordpress.org/paapst/\">Mathieu Paapst</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/iammattthomas/\">Matt (Thomas) Miklic</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/mattyrob/\">Matt Robinson</a> · <a href=\"https://profiles.wordpress.org/mattwest/\">Matt West</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/kinggmobb/\">Matthew</a> · <a href=\"https://profiles.wordpress.org/mboynes/\">Matthew Boynes</a> · <a href=\"https://profiles.wordpress.org/mattryanwalker/\">mattryanwalker</a> · <a href=\"https://profiles.wordpress.org/azouamauriac/\">Mauriac AZOUA</a> · <a href=\"https://profiles.wordpress.org/maximemeganck/\">Maxime Meganck</a> · <a href=\"https://profiles.wordpress.org/maximebj/\">maximebj</a> · <a href=\"https://profiles.wordpress.org/mayanktripathi32/\">Mayank Tripathi</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/faithcoder/\">Md Abdullah Al Arif</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/itsmhrahman/\">Md Hafijur Rahman</a> · <a href=\"https://profiles.wordpress.org/kawsar007/\">MD Kawsar Chowdhury</a> · <a href=\"https://profiles.wordpress.org/mehdi01/\">Md Mahdi Hasan</a> · <a href=\"https://profiles.wordpress.org/mdibrahimk48/\">Md. Ibrahim Khalil</a> · <a href=\"https://profiles.wordpress.org/najmulsaju/\">Md. Najmul Islam</a> · <a href=\"https://profiles.wordpress.org/mehedi_csit/\">Md.Mehedi Hasan</a> · <a href=\"https://profiles.wordpress.org/mdviralsampat/\">mdviralsampat</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/leeseoftbc/\">MelissaH</a> · <a href=\"https://profiles.wordpress.org/metropolis_john/\">metropolis_john</a> · <a href=\"https://profiles.wordpress.org/mdawaffe/\">Michael Adams (mdawaffe)</a> · <a href=\"https://profiles.wordpress.org/mburridge/\">Michael Burridge</a> · <a href=\"https://profiles.wordpress.org/websiteredev/\">Michael Willman</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/michelleames/\">Michelle Frechette</a> · <a href=\"https://profiles.wordpress.org/marktimemedia/\">Michelle Schulp Hunt</a> · <a href=\"https://profiles.wordpress.org/micromadness/\">micromadness</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/mmtr86/\">Miguel Torres</a> · <a href=\"https://profiles.wordpress.org/mijotj/\">Mijo T J</a> · <a href=\"https://profiles.wordpress.org/simison/\">Mikael Korpela</a> · <a href=\"https://profiles.wordpress.org/mbijon/\">Mike Bijon</a> · <a href=\"https://profiles.wordpress.org/ritterml/\">Mike Ritter</a> · <a href=\"https://profiles.wordpress.org/mikinc860/\">Mikin Chauhan</a> · <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a> · <a href=\"https://profiles.wordpress.org/milindmore22/\">Milind More</a> · <a href=\"https://profiles.wordpress.org/mimitips/\">mimi</a> · <a href=\"https://profiles.wordpress.org/369work/\">miroku</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">Mitchell Austin</a> · <a href=\"https://profiles.wordpress.org/modi2918/\">Modi Sahil</a> · <a href=\"https://profiles.wordpress.org/antwortzeit/\">modulbuero</a> · <a href=\"https://profiles.wordpress.org/aboelfotoh/\">Mohamed Aboelfotoh Mohamed</a> · <a href=\"https://profiles.wordpress.org/mohitdadhich10/\">Mohit Dadhich</a> · <a href=\"https://profiles.wordpress.org/mojorob/\">mojorob</a> · <a href=\"https://profiles.wordpress.org/jucaduca/\">Morais Junior</a> · <a href=\"https://profiles.wordpress.org/mosescursor/\">Moses Cursor Ssebunya</a> · <a href=\"https://profiles.wordpress.org/mosne/\">Mosne / Paolo Tesei</a> · <a href=\"https://profiles.wordpress.org/mr660/\">mr660</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/mrunalkulkarni/\">mrunalkulkarni</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/mtdkei/\">mt</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/mukulsingh27/\">Mukul Singh</a> · <a href=\"https://profiles.wordpress.org/my1xt/\">My1</a> · <a href=\"https://profiles.wordpress.org/n8finch/\">n8finch</a> · <a href=\"https://profiles.wordpress.org/assassinateur/\">Nadir Seghir</a> · <a href=\"https://profiles.wordpress.org/nandow/\">nandow</a> · <a href=\"https://profiles.wordpress.org/nanisamireddy/\">NANI SAMIREDDY</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/muddassirnasim/\">Nasim Miah</a> · <a href=\"https://profiles.wordpress.org/nataliat2004/\">Natalia T</a> · <a href=\"https://profiles.wordpress.org/nathanatmoz/\">Nathan Johnson</a> · <a href=\"https://profiles.wordpress.org/navneet/\">navneet</a> · <a href=\"https://profiles.wordpress.org/navi161/\">Navneet Kaur</a> · <a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a> · <a href=\"https://profiles.wordpress.org/greatislander/\">Ned Zimmerman</a> · <a href=\"https://profiles.wordpress.org/neotrope/\">neotrope</a> · <a href=\"https://profiles.wordpress.org/mcqueen22/\">NerQuiles</a> · <a href=\"https://profiles.wordpress.org/krstarica/\">net</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/nickgalvez/\">nickgalvez</a> · <a href=\"https://profiles.wordpress.org/nickwilmot/\">nickwilmot</a> · <a href=\"https://profiles.wordpress.org/undefinedfr/\">Nicolas RIVIERE</a> · <a href=\"https://profiles.wordpress.org/nicolasleroy/\">nicolasleroy</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/smushytaco/\">Nikan Radan</a> · <a href=\"https://profiles.wordpress.org/nikitasolanki1812/\">Nikita Solanki</a> · <a href=\"https://profiles.wordpress.org/nikunj8866/\">Nikunj Hatkar</a> · <a href=\"https://profiles.wordpress.org/snilesh/\">Nilesh Shiragave</a> · <a href=\"https://profiles.wordpress.org/nirajgirixd/\">Niraj Giri</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/mrtortai/\">Noam Eppel</a> · <a href=\"https://profiles.wordpress.org/othernoel/\">Noel Santos</a> · <a href=\"https://profiles.wordpress.org/noruzzaman/\">Noruzzaman</a> · <a href=\"https://profiles.wordpress.org/nosilver4u/\">nosilver4u</a> · <a href=\"https://profiles.wordpress.org/oceantober/\">oceantober</a> · <a href=\"https://profiles.wordpress.org/finalwebsites/\">Olaf Lederer</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a> · <a href=\"https://profiles.wordpress.org/jbkkd/\">Omer Korner</a> · <a href=\"https://profiles.wordpress.org/arzola/\">Oscar Arzola</a> · <a href=\"https://profiles.wordpress.org/groenroos/\">Oskari Groenroos</a> · <a href=\"https://profiles.wordpress.org/ov3rfly/\">Ov3rfly</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pampfelimetten/\">pampfelimetten</a> · <a href=\"https://profiles.wordpress.org/parinpanjari/\">Parin Panjari</a> · <a href=\"https://profiles.wordpress.org/dparthj/\">Parth Dodiya</a> · <a href=\"https://profiles.wordpress.org/parthvataliya/\">Parth vataliya</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/casiepa/\">Pascal Casier</a> · <a href=\"https://profiles.wordpress.org/pateljaymin/\">Patel Jaymin</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/eartboard/\">Paul</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/bbpaule/\">Paul English</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/paullb/\">paullb</a> · <a href=\"https://profiles.wordpress.org/psrpinto/\">Paulo Pinto</a> · <a href=\"https://profiles.wordpress.org/paulopmt1/\">Paulo Trentin</a> · <a href=\"https://profiles.wordpress.org/pavanpatil1/\">Pavan Patil</a> · <a href=\"https://profiles.wordpress.org/creadordev/\">Pawan Kumar</a> · <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendon&#231;a</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/peter8nss/\">peter8nss</a> · <a href=\"https://profiles.wordpress.org/peterdavehello/\">peterdavehello</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/philliproth/\">philliproth</a> · <a href=\"https://profiles.wordpress.org/philwebs/\">philwebs</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pixlpirate/\">pixlpirate</a> · <a href=\"https://profiles.wordpress.org/podpirate/\">podpirate</a> · <a href=\"https://profiles.wordpress.org/poojabhimani/\">Pooja Bhimani</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja Killekar (Muchandikar)</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/praful2111/\">Praful Patel</a> · <a href=\"https://profiles.wordpress.org/prasadkarmalkar/\">Prasad Karmalkar</a> · <a href=\"https://profiles.wordpress.org/prashant/\">prashant</a> · <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a> · <a href=\"https://profiles.wordpress.org/contactprashantpp/\">Prashant Patil</a> · <a href=\"https://profiles.wordpress.org/prathamesh24/\">Prathamesh Shirke</a> · <a href=\"https://profiles.wordpress.org/prathameshbhagat1511/\">prathameshbhagat1511</a> · <a href=\"https://profiles.wordpress.org/pkbhatt/\">Pratik Bhatt</a> · <a href=\"https://profiles.wordpress.org/pratikgandhi/\">Pratik Gandhi</a> · <a href=\"https://profiles.wordpress.org/pratiklondhe/\">Pratik Londhe</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/digitalpritam/\">Pritam Sonone</a> · <a href=\"https://profiles.wordpress.org/priyank9033/\">Priyank Vadhavana</a> · <a href=\"https://profiles.wordpress.org/pushpenderindia/\">Pushpender Singh</a> · <a href=\"https://profiles.wordpress.org/itsjonq/\">Q</a> · <a href=\"https://profiles.wordpress.org/qhaensler/\">qhaensler</a> · <a href=\"https://profiles.wordpress.org/rfischmann/\">Rafael Fischmann</a> · <a href=\"https://profiles.wordpress.org/rahulsprajapati/\">Rahul Prajapati</a> · <a href=\"https://profiles.wordpress.org/imrraaj/\">Raj Patel</a> · <a href=\"https://profiles.wordpress.org/rajat1192/\">Rajat Patel</a> · <a href=\"https://profiles.wordpress.org/raj198/\">Rajendra Patel</a> · <a href=\"https://profiles.wordpress.org/rajendrapatilraj/\">Rajendra Patil</a> · <a href=\"https://profiles.wordpress.org/rkradadiya/\">Rajesh Radadiya</a> · <a href=\"https://profiles.wordpress.org/rajeshrathodwp/\">Rajesh Rathod</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/ravigadhiyawp/\">Ravi Gadhiya</a> · <a href=\"https://profiles.wordpress.org/redkite/\">redkite</a> · <a href=\"https://profiles.wordpress.org/rehanali/\">Rehan Ali</a> · <a href=\"https://profiles.wordpress.org/rejaulalomkhan/\">Rejaul Alom Khan</a> · <a href=\"https://profiles.wordpress.org/rembem/\">Remco</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho</a> · <a href=\"https://profiles.wordpress.org/ooraiser69/\">Renz Jay Sanchez</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/riddhidave/\">Riddhi Dave</a> · <a href=\"https://profiles.wordpress.org/rinkalpagdar/\">Rinkal Pagdar</a> · <a href=\"https://profiles.wordpress.org/rishavdutta/\">Rishav Dutta</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/rishit30g/\">Rishit Gupta</a> · <a href=\"https://profiles.wordpress.org/rkyburz/\">rkyburz</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/miqrogroove/\">Robert Chapin</a> · <a href=\"https://profiles.wordpress.org/robertghetau/\">Robert Ghetau</a> · <a href=\"https://profiles.wordpress.org/harmr/\">Robert Seyfriedsberger</a> · <a href=\"https://profiles.wordpress.org/robertstaddon/\">robertstaddon</a> · <a href=\"https://profiles.wordpress.org/robinmartijn/\">Robin Martijn</a> · <a href=\"https://profiles.wordpress.org/kreppar/\">Rodrigo Arias</a> · <a href=\"https://profiles.wordpress.org/rodrigosprimo/\">Rodrigo Primo</a> · <a href=\"https://profiles.wordpress.org/rogierlankhorst/\">Rogier Lankhorst</a> · <a href=\"https://profiles.wordpress.org/geekofshire/\">Rohan Jha</a> · <a href=\"https://profiles.wordpress.org/rohitmathur7/\">rohitmathur7</a> · <a href=\"https://profiles.wordpress.org/rohjay/\">rohjay</a> · <a href=\"https://profiles.wordpress.org/room34/\">room34</a> · <a href=\"https://profiles.wordpress.org/rotemg/\">Rotem Gelbart</a> · <a href=\"https://profiles.wordpress.org/lev0/\">Roy Orbitson</a> · <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a> · <a href=\"https://profiles.wordpress.org/roybellingan/\">roybellingan</a> · <a href=\"https://profiles.wordpress.org/ruchirj/\">Ruchir Goswami</a> · <a href=\"https://profiles.wordpress.org/rudrakshigupta/\">Rudrakshi Gupta</a> · <a href=\"https://profiles.wordpress.org/rupesh5438/\">Rupesh Patil</a> · <a href=\"https://profiles.wordpress.org/rupw/\">rupw</a> · <a href=\"https://profiles.wordpress.org/ruturajraval2305/\">Ruturaj Raval</a> · <a href=\"https://profiles.wordpress.org/rvoigt/\">rvoigt</a> · <a href=\"https://profiles.wordpress.org/bookdude13/\">Ryan Fredlund</a> · <a href=\"https://profiles.wordpress.org/ryanhellyer/\">Ryan Hellyer</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/looswebstudio/\">Ryo</a> · <a href=\"https://profiles.wordpress.org/sppramodh/\">S P Pramodh</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">S&#233;bastien SERRE</a> · <a href=\"https://profiles.wordpress.org/sergiomdgomes/\">S&#233;rgio Gomes</a> · <a href=\"https://profiles.wordpress.org/soean/\">S&#246;ren W&#252;nsch</a> · <a href=\"https://profiles.wordpress.org/sabbir1991/\">Sabbir Ahmed</a> · <a href=\"https://profiles.wordpress.org/sabrineg/\">sabrineg</a> · <a href=\"https://profiles.wordpress.org/isaeedam/\">Saeed Piri</a> · <a href=\"https://profiles.wordpress.org/sagarlakhani/\">Sagar Lakhani</a> · <a href=\"https://profiles.wordpress.org/sagarprajapati/\">Sagar Prajapati</a> · <a href=\"https://profiles.wordpress.org/mi5t4n/\">Sagar Tamang</a> · <a href=\"https://profiles.wordpress.org/sailpete/\">sailpete</a> · <a href=\"https://profiles.wordpress.org/sainathpoojary/\">Sainath Poojary</a> · <a href=\"https://profiles.wordpress.org/sajjad67/\">Sajjad Hossain Sagor</a> · <a href=\"https://profiles.wordpress.org/sallyruchman/\">sally</a> · <a href=\"https://profiles.wordpress.org/samiamnot/\">samiamnot</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/ranafge/\">Samsul Islam Rana</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/codexdemon/\">Sanyogg Shelar</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarathar/\">Sarath AR</a> · <a href=\"https://profiles.wordpress.org/sarthaknagoshe2002/\">Sarthak Nagoshe</a> · <a href=\"https://profiles.wordpress.org/sathyapulse/\">Sathiya Venkatesan</a> · <a href=\"https://profiles.wordpress.org/sfougnier/\">Saul Fougnier</a> · <a href=\"https://profiles.wordpress.org/saurabhdhariwal/\">saurabh.dhariwal</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/infosatech/\">Sayan Datta</a> · <a href=\"https://profiles.wordpress.org/sayedulsayem/\">Sayedul Sayem</a> · <a href=\"https://profiles.wordpress.org/sbathompson/\">sbathompson</a> · <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">Scott Arciszewski</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/sean212/\">Sean Fisher</a> · <a href=\"https://profiles.wordpress.org/seanlanglands/\">seanlanglands</a> · <a href=\"https://profiles.wordpress.org/sebastianpisula/\">Sebastian Pisula</a> · <a href=\"https://profiles.wordpress.org/seifradwane/\">Seif Radwane</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/sergiogutierrez/\">sergiogutierrez</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/severinepozzo/\">Severine Pozzo</a> · <a href=\"https://profiles.wordpress.org/shadialaghbari/\">Shadi G شادي جـ</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/sh4lin/\">Shalin Shah</a> · <a href=\"https://profiles.wordpress.org/shanemuir/\">Shane Muirhead</a> · <a href=\"https://profiles.wordpress.org/spdft/\">Shoe</a> · <a href=\"https://profiles.wordpress.org/shraddhagore/\">Shraddha Gore</a> · <a href=\"https://profiles.wordpress.org/shreyashd21/\">shreyashd21</a> · <a href=\"https://profiles.wordpress.org/shub07/\">Shubham Kumar Bansal</a> · <a href=\"https://profiles.wordpress.org/iamshubhamsp/\">Shubham Patil</a> · <a href=\"https://profiles.wordpress.org/shulard/\">shulard</a> · <a href=\"https://profiles.wordpress.org/shyamkariya/\">Shyam Kariya</a> · <a href=\"https://profiles.wordpress.org/nomnom99/\">Siddharth Thevaril</a> · <a href=\"https://profiles.wordpress.org/siliconforks/\">siliconforks</a> · <a href=\"https://profiles.wordpress.org/simo_m/\">Simone Maranzana</a> · <a href=\"https://profiles.wordpress.org/sirlouen/\">SirLouen</a> · <a href=\"https://profiles.wordpress.org/sjefen6/\">sjefen6</a> · <a href=\"https://profiles.wordpress.org/slaffik/\">Slava Abakumov</a> · <a href=\"https://profiles.wordpress.org/mslavco/\">Slavco Mihajloski</a> · <a href=\"https://profiles.wordpress.org/smerriman/\">smerriman</a> · <a href=\"https://profiles.wordpress.org/snehapatil02/\">Sneha Patil</a> · <a href=\"https://profiles.wordpress.org/snehal5774/\">snehal5774</a> · <a href=\"https://profiles.wordpress.org/sohamjoshi8275/\">Soham sham joshi</a> · <a href=\"https://profiles.wordpress.org/sourabhjain/\">Sourabh Jain</a> · <a href=\"https://profiles.wordpress.org/sourav08/\">Sourav Pahwa</a> · <a href=\"https://profiles.wordpress.org/soyebsalar/\">soyeb salar</a> · <a href=\"https://profiles.wordpress.org/spencerfinnell/\">Spencer Finnell</a> · <a href=\"https://profiles.wordpress.org/spenserhale/\">Spenser Hale</a> · <a href=\"https://profiles.wordpress.org/spmultidots/\">spmultidots</a> · <a href=\"https://profiles.wordpress.org/spncr/\">spncr</a> · <a href=\"https://profiles.wordpress.org/srikat/\">Sridhar Katakam</a> · <a href=\"https://profiles.wordpress.org/stefahn/\">Stefan Seidner-Britting</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/stein2nd/\">stein2nd</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/dufresnesteven/\">Steve Dufresne</a> · <a href=\"https://profiles.wordpress.org/stimul/\">stimul</a> · <a href=\"https://profiles.wordpress.org/strarsis/\">strarsis</a> · <a href=\"https://profiles.wordpress.org/stuartmcalpine/\">Stuart McAlpine</a> · <a href=\"https://profiles.wordpress.org/subodhrajpopat/\">Subodh Rajpopat</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sketchboy/\">SUHAS SUTAR</a> · <a href=\"https://profiles.wordpress.org/sukhendu2002/\">Sukhendu Sekhar Guria</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/csesumonpro/\">Sumon Sarker</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/surajswalstar/\">Suraj Sutar</a> · <a href=\"https://profiles.wordpress.org/swalkinshaw/\">swalkinshaw</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/tschwarz-1/\">t.schwarz</a> · <a href=\"https://profiles.wordpress.org/tacoverdo/\">Taco Verdonschot</a> · <a href=\"https://profiles.wordpress.org/gonom9/\">Taegon Kim</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a> · <a href=\"https://profiles.wordpress.org/takayukister/\">Takayuki Miyoshi</a> · <a href=\"https://profiles.wordpress.org/takuword/\">Takuro</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/devtanbir/\">Tanbir Ahmod</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/th23/\">th23</a> · <a href=\"https://profiles.wordpress.org/thakordarshil/\">Thakor Darshil</a> · <a href=\"https://profiles.wordpress.org/thelmachido/\">thelmachido a11n</a> · <a href=\"https://profiles.wordpress.org/themebeans/\">ThemeBeans</a> · <a href=\"https://profiles.wordpress.org/thomaswm/\">thomaswm</a> · <a href=\"https://profiles.wordpress.org/threadi/\">threadi</a> · <a href=\"https://profiles.wordpress.org/thrijith/\">Thrijith Thankachan</a> · <a href=\"https://profiles.wordpress.org/tiagogoncalves/\">tiago</a> · <a href=\"https://profiles.wordpress.org/tigriweb/\">TigriWeb</a> · <a href=\"https://profiles.wordpress.org/tillkruess/\">Till Kr&#252;ss</a> · <a href=\"https://profiles.wordpress.org/tb1909/\">Tim Brath&#228;rig</a> · <a href=\"https://profiles.wordpress.org/dontfeedthecode/\">Tim Sheehan</a> · <a href=\"https://profiles.wordpress.org/timwhitlock/\">Tim W</a> · <a href=\"https://profiles.wordpress.org/sippis/\">Timi Wahalahti</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timoth&#233;e Brosille</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tkama/\">Timur Kamaev</a> · <a href=\"https://profiles.wordpress.org/tirth03/\">Tirth Doshi</a> · <a href=\"https://profiles.wordpress.org/tjarrett/\">TJarrett</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">Tobias B&#228;thge</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn &#8220;Tobi&#8221; Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tgsrvrs/\">Tom Gugel</a> · <a href=\"https://profiles.wordpress.org/tommusrhodus/\">Tom Rhodes</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemer&#246;</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/areziaal/\">Troy Chaplin</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/trushaamin/\">Trusha</a> · <a href=\"https://profiles.wordpress.org/tunetheweb/\">tunetheweb</a> · <a href=\"https://profiles.wordpress.org/dinhtungdu/\">Tung Du</a> · <a href=\"https://profiles.wordpress.org/tusharaddweb/\">Tushar Patel</a> · <a href=\"https://profiles.wordpress.org/tyb/\">TyB</a> · <a href=\"https://profiles.wordpress.org/tysonlmao/\">tysonlmao</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/umeshsinghin/\">Umesh Singh</a> · <a href=\"https://profiles.wordpress.org/unsalkorkmaz/\">Unsal Korkmaz</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">up1512001</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/utrenkner/\">utrenkner</a> · <a href=\"https://profiles.wordpress.org/eboxnet/\">Vagelis</a> · <a href=\"https://profiles.wordpress.org/vaibhavsweb/\">Vaibhav Singh Web</a> · <a href=\"https://profiles.wordpress.org/vaibhav2527/\">Vaibhav Tukaram Nawale</a> · <a href=\"https://profiles.wordpress.org/valer1e/\">Val&#233;rie Galassi</a> · <a href=\"https://profiles.wordpress.org/twvania/\">Vania</a> · <a href=\"https://profiles.wordpress.org/okvee/\">vee</a> · <a href=\"https://profiles.wordpress.org/vevas/\">Vegard S.</a> · <a href=\"https://profiles.wordpress.org/vgnavada/\">vgnavada</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/fylgjur/\">Victoria - a11n</a> · <a href=\"https://profiles.wordpress.org/gvgvgvijayan/\">Vijayan</a> · <a href=\"https://profiles.wordpress.org/vijaysinh9094/\">Vijaysinh Zala</a> · <a href=\"https://profiles.wordpress.org/vikrampm/\">Vikram</a> · <a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Sz&#233;pe</a> · <a href=\"https://profiles.wordpress.org/vineet2003/\">Vinit</a> · <a href=\"https://profiles.wordpress.org/vipulgupta003/\">Vipul Gupta</a> · <a href=\"https://profiles.wordpress.org/vipulpatil/\">Vipul Patil</a> · <a href=\"https://profiles.wordpress.org/virgildia/\">Virgildia</a> · <a href=\"https://profiles.wordpress.org/virgar/\">Virginie Garnier</a> · <a href=\"https://profiles.wordpress.org/virginienacci/\">virginienacci</a> · <a href=\"https://profiles.wordpress.org/vishy-moghan/\">Vishy Moghan</a> · <a href=\"https://profiles.wordpress.org/vivekawsm/\">vivekawsm</a> · <a href=\"https://profiles.wordpress.org/vrishabhsk/\">Vrishabh Jasani</a> · <a href=\"https://profiles.wordpress.org/vykesmac/\">vykesmac</a> · <a href=\"https://profiles.wordpress.org/wadowad/\">wadowad</a> · <a href=\"https://profiles.wordpress.org/pctevree/\">Web-Pepper</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design &#124; Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/west7/\">Wes Theron</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whaze/\">whaze</a> · <a href=\"https://profiles.wordpress.org/skorasaurus/\">Will Skora</a> · <a href=\"https://profiles.wordpress.org/williampatton/\">williampatton</a> · <a href=\"https://profiles.wordpress.org/wongjn/\">wongjn</a> · <a href=\"https://profiles.wordpress.org/worldweb/\">World Web Technology</a> · <a href=\"https://profiles.wordpress.org/wpgerd/\">wpgerd</a> · <a href=\"https://profiles.wordpress.org/wplmillet/\">wplmillet</a> · <a href=\"https://profiles.wordpress.org/wprockstar2/\">wprockstar2</a> · <a href=\"https://profiles.wordpress.org/wwdes/\">wwdes</a> · <a href=\"https://profiles.wordpress.org/xate/\">xate</a> · <a href=\"https://profiles.wordpress.org/xavilc/\">xavilc</a> · <a href=\"https://profiles.wordpress.org/xpurichan/\">xpurichan</a> · <a href=\"https://profiles.wordpress.org/yahil/\">Yahil Madakiya</a> · <a href=\"https://profiles.wordpress.org/yaniiliev/\">Yani</a> · <a href=\"https://profiles.wordpress.org/yashrocz/\">Yash Kukreja</a> · <a href=\"https://profiles.wordpress.org/yellowafterlife/\">yellowafterlife</a> · <a href=\"https://profiles.wordpress.org/yogeshbhutkar/\">Yogesh Bhutkar</a> · <a href=\"https://profiles.wordpress.org/yudhisthirnahar/\">yudhisthirnahar</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yuliyan/\">Yuliyan Slavchev</a> · <a href=\"https://profiles.wordpress.org/omaeyusuke/\">yuu</a> · <a href=\"https://profiles.wordpress.org/zaoyao/\">zaoyao</a> · <a href=\"https://profiles.wordpress.org/zargarov/\">Zargarov</a> · <a href=\"https://profiles.wordpress.org/zebulan/\">Zebulan Stanphill</a> · <a href=\"https://profiles.wordpress.org/zeelthakkar/\">zeelthakkar</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a> · <a href=\"https://profiles.wordpress.org/haozi/\">耗子</a></p>\n\n\n\n<p>More than <a href=\"https://translate.wordpress.org/stats/\">60 locales have fully translated</a> WordPress 6.8 into their language making this one of the most translated releases ever on day one.&nbsp; Community translators are working hard to ensure more translations are on their way.&nbsp; Thank you to everyone who helps make WordPress available in 200 languages.</p>\n\n\n\n<p>Last but not least, thanks to the volunteers who contribute to the <a href=\"https://wordpress.org/support/\">support forums</a> by answering questions from WordPress users worldwide.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Get involved</strong></h2>\n\n\n\n<p>Participation in WordPress goes far beyond coding. And learning more and getting involved is easy.&nbsp; Discover the teams that come together to <a href=\"https://make.wordpress.org/\">Make WordPress</a> and use <a href=\"https://make.wordpress.org/contribute/\">this interactive tool</a> to help you decide which is right for you.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18701\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:66:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordCamp Europe 2025: Sali, Basel!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2025/04/wordcamp-europe-2025-sali-basel/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 14 Apr 2025 19:16:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:4:\"WCEU\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:9:\"WordCamps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18683\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:411:\"WordCamp Europe 2025 will be held in gorgeous Basel, Switzerland, from June 5 to 7. It will bring together open source enthusiasts, developers, and WordPress professionals from across the region—and the world! This year’s event offers fresh perspectives, engaging conversations, and countless opportunities to connect with the WordPress community, agencies, and innovators over three action-packed [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6552:\"\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"390\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/04/473144529_985418666952827_8265761567676487048_n.png?resize=1024%2C390&#038;ssl=1\" alt=\"\" class=\"wp-image-18690\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/04/473144529_985418666952827_8265761567676487048_n.png?resize=1024%2C390&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/04/473144529_985418666952827_8265761567676487048_n.png?resize=300%2C114&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/04/473144529_985418666952827_8265761567676487048_n.png?resize=768%2C292&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/04/473144529_985418666952827_8265761567676487048_n.png?w=1230&amp;ssl=1 1230w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>WordCamp Europe 2025 will be held in gorgeous Basel, Switzerland, from June 5 to 7. It will bring together open source enthusiasts, developers, and WordPress professionals from across the region—and the world!</p>\n\n\n\n<p>This year’s event offers fresh perspectives, engaging conversations, and countless opportunities to connect with the WordPress community, agencies, and innovators over three action-packed days of learning, networking, and collaboration.</p>\n\n\n\n<div class=\"wp-block-group has-off-white-background-color has-background is-layout-constrained wp-container-core-group-is-layout-8503c47b wp-block-group-is-layout-constrained\">\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"has-text-align-center has-large-font-size\"><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Tickets are limited—secure yours today!</strong></p>\n\n\n\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-align-center wp-element-button\" href=\"https://europe.wordcamp.org/2025/tickets/\">Get your ticket now</a></div>\n</div>\n\n\n\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Keynotes, panels, and deep dives</h2>\n\n\n\n<p>The main conference, which will be held on June 6th and 7th, will feature <a href=\"https://europe.wordcamp.org/2025/schedule/\">a lineup of notable keynote sessions</a>, including diverse sessions on business strategy and building innovative modern features, open-source advocacy, accessibility, and more. For those looking to sharpen their skills, presentations will dive deep into topics like SEO for WordPress, performance optimization, speed-builds, and leveraging AI.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Q&amp;A Fireside Chat</h2>\n\n\n\n<p>You can join Mary Hubbard, the WordPress Executive Director, and Matt Mullenweg, co-founder of the WordPress project on June 7th to discuss WordPress and its community, followed by an in-person Q&amp;A session here in Basel.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Explore Basel</h2>\n\n\n\n<p>Basel, the third-largest city in Switzerland, <a href=\"https://europe.wordcamp.org/2025/location/\">is filled with historical buildings, a cathedral, museums, and hidden gems</a>! You can get around Basel and experience it yourself using your BaselCard, which allows you to hop on and off all public transportation without a worry. A walk down Basel’s river Rhine could be the perfect evening during your visit to WordCamp Europe!</p>\n\n\n\n<p><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f6cf.png\" alt=\"🛏\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><a href=\"https://europe.wordcamp.org/2025/location/accommodation/\"> Find accommodations in Basel<br></a><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f68c.png\" alt=\"🚌\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><a href=\"https://europe.wordcamp.org/2025/location/getting-around-in-basel/\"> Learn about BaselCard benefits<br></a><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f4c4.png\" alt=\"📄\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><a href=\"https://europe.wordcamp.org/2025/location/visa/\"> Need a visa? Apply by May 10, 2025</a></p>\n\n\n\n<p><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f4c5.png\" alt=\"📅\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Plan Your WordCamp Europe Experience</strong> See the <a href=\"https://europe.wordcamp.org/2025/schedule/\">full schedule</a>, plan your sessions, and maximize your time in Basel.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Get WordCamp-ready</h2>\n\n\n\n<p><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Make sure to secure your <a href=\"https://europe.wordcamp.org/2025/tickets/\">WordCamp Europe 2025 tickets</a></strong> (if you haven’t already!)</p>\n\n\n\n<p>Follow WordCamp Europe news on <a href=\"https://bsky.app/profile/wordpress.org\">Bluesky</a>, <a href=\"https://instagram.com/wordpress/\">Instagram</a>, <a href=\"https://www.facebook.com/WordPress\">Facebook</a>, <a href=\"https://www.linkedin.com/company/wordpress/\">LinkedIn</a>, <a href=\"https://www.threads.net/@wordpress\">Threads</a>, <a href=\"https://mastodon.world/@wordpress\">Mastodon</a>, and <a href=\"https://twitter.com/WordPress\">X/Twitter</a> for real-time updates!</p>\n\n\n\n<p>You can also help us spread the word about WordCamp Europe this year! Post about your attendance <a href=\"https://europe.wordcamp.org/2025/press/spread-the-word/\">using our ready-made texts</a> or we also encourage you to use your own voice – you know your community best.</p>\n\n\n\n<p>And as always, be part of the conversation! Whether you’re attending in-person in Basel or following along online, share your experiences using the tags #WCEU and #WordPress on all social media networks!</p>\n\n\n\n<p>Basel is calling—see you at WordCamp Europe 2025! <img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f1e8-1f1ed.png\" alt=\"🇨🇭\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p>Thank you to <a href=\"https://profiles.wordpress.org/dolgelukkig/\">@dolgelukkig</a> for drafting this copy.</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18683\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 6.8 Release Candidate 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2025/04/wordpress-6-8-release-candidate-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 08 Apr 2025 15:54:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6-8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18673\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:260:\"WordPress 6.8 RC 3 is ready for download and testing! The scheduled final release date for WordPress 6.8 is April 15, 2025. Your help testing over the next week is vital to ensuring the final release is everything it should be: stable, powerful, and intuitive.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Jeffrey Paul\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8765:\"\n<p>The third release candidate (“RC3”) for WordPress 6.8 is ready for download and testing!</p>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>.<strong>&nbsp; Please do not install, run, or test this version of WordPress on production or mission-critical websites.</strong>&nbsp; Instead, it’s recommended that you evaluate RC3 on a test server and site.</p>\n\n\n\n<p>Reaching this phase of the release cycle is an important milestone.&nbsp; While release candidates are considered ready for release, testing remains crucial to ensure that everything in WordPress 6.8 is the best it can be.</p>\n\n\n\n<p>You can test WordPress 6.8 RC3 in four ways:</p>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install.&nbsp; (Select the “Bleeding edge” channel and “Beta/RC Only” stream).</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href=\"https://wordpress.org/wordpress-6.8-RC3.zip\">RC3 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use the following <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command: <code>wp core update --version=6.8-RC3</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href=\"https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn\">6.8 RC3 WordPress Playground instance</a> (available within 35 minutes after the release is ready) to test the software directly in your browser without the need for a separate site or setup.</td></tr></tbody></table></figure>\n\n\n\n<p>The current target for the WordPress 6.8 release is <strong>April 15, 2025</strong>. Get an overview of the <a href=\"https://make.wordpress.org/core/6-8/\">6.8 release cycle</a>, and check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-8/\">6.8-related posts</a> leading up to next week’s release for further details.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What’s in WordPress 6.8 RC3?</h2>\n\n\n\n<p>Get a recap of WordPress 6.8’s highlighted features in the <a href=\"https://wordpress.org/news/2025/03/wordpress-6-8-beta-1/\">Beta 1 announcement</a>. For more technical information related to issues addressed since <a href=\"https://wordpress.org/news/2025/04/wordpress-6-8-release-candidate-2/\">RC2</a>, you can browse the following links:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.8?since=2025-04-02&amp;until=2025-04-08\">GitHub commits for 6.8</a> since April 1</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/log/branches/6.8?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=60145&amp;stop_rev=60125&amp;limit=100&amp;sfp_email=&amp;sfph_mail=\">Changes committed</a> since April 1</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">How you can contribute</h2>\n\n\n\n<p>WordPress is open source software made possible by a passionate community that collaborates and contributes to its development. The resources below outline various ways you can help the world’s most popular open source web platform, regardless of your technical expertise.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Get involved in testing</h3>\n\n\n\n<p>Testing for issues is critical to ensuring WordPress is performant and stable. It’s also a meaningful way for anyone to contribute. <a href=\"https://make.wordpress.org/test/2025/03/04/help-test-wordpress-6-8/\">This detailed guide</a> will walk you through testing features in WordPress 6.8.&nbsp; For those new to testing, follow <a href=\"https://make.wordpress.org/test/handbook/get-setup-for-testing/\">this general testing guide</a> for more details on getting set up.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> of the support forums or directly to <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general?&nbsp; Follow along with the <a href=\"https://make.wordpress.org/test/\">testing initiatives in Make Core</a> and join the <a href=\"https://wordpress.slack.com/messages/core-test/\">#core-test channel</a> on <a href=\"https://wordpress.slack.com/\">Making WordPress Slack</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Search for vulnerabilities</h3>\n\n\n\n<p>From now until the final release of WordPress 6.8 (scheduled for April 15, 2025), the <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/#enhanced-bounty-rewards-during-beta-and-release-candidate-phases\">monetary reward for reporting new, unreleased security vulnerabilities</a> is doubled.&nbsp; Please follow responsible disclosure practices as detailed in the project’s security practices and policies outlined on the <a href=\"https://hackerone.com/wordpress\">HackerOne page</a> and in the <a href=\"https://wordpress.org/about/security/\">security white paper</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Update your theme or plugin</h3>\n\n\n\n<p>For plugin and theme authors, your products play an integral role in extending the functionality and value of WordPress for all users.&nbsp; For more details on developer-related changes in 6.8, please review the <a href=\"https://make.wordpress.org/core/2025/03/28/wordpress-6-8-field-guide/\">WordPress 6.8 Field Guide</a>.</p>\n\n\n\n<p>Thanks for continuing to test your themes and plugins with the WordPress 6.8 beta releases.&nbsp; With RC3, you’ll want to conclude your testing and update the <em>“Tested up to”</em> version in your <a href=\"https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/\">plugin’s readme file</a> to 6.8.</p>\n\n\n\n<p>If you find compatibility issues, please post detailed information to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">support forum</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Help translate WordPress</h3>\n\n\n\n<p>Do you speak a language other than English?  <bdo lang=\"es\" dir=\"ltr\">¿Español?</bdo>  <bdo lang=\"fr\" dir=\"ltr\">Français?</bdo>  <bdo lang=\"ru\" dir=\"ltr\">Русский?</bdo>  <bdo lang=\"ja\" dir=\"ltr\">日本語?</bdo> <bdo lang=\"hi\" dir=\"ltr\">हिन्दी?</bdo> <bdo lang=\"mr\" dir=\"ltr\">मराठी?</bdo> <bdo lang=\"bn\" dir=\"ltr\">বাংলা?</bdo>  You can <a href=\"https://translate.wordpress.org/projects/wp/dev/\">help translate WordPress into more than 100 languages</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">An RC3 haiku</h2>\n\n\n\n<p><em>The launch draws closer,</em><em><br></em><em>Six-eight sings through RC3,</em><em><br></em><em>Almost time to shine.</em></p>\n\n\n\n<p class=\"has-text-align-right\"><em>Thank you to the following contributors for collaborating on this post: <a href=\'https://profiles.wordpress.org/audrasjb/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>audrasjb</a>, <a href=\'https://profiles.wordpress.org/mamaduka/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mamaduka</a>, <a href=\'https://profiles.wordpress.org/krupajnanda/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>krupajnanda</a>, <a href=\'https://profiles.wordpress.org/benjamin_zekavica/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>benjamin_zekavica</a>, <a href=\'https://profiles.wordpress.org/narenin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>narenin</a>, <a href=\'https://profiles.wordpress.org/joedolson/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joedolson</a>, <a href=\'https://profiles.wordpress.org/courane01/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>courane01</a>, <a href=\'https://profiles.wordpress.org/joemcgill/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joemcgill</a>, <a href=\'https://profiles.wordpress.org/marybaum/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>marybaum</a>, <a href=\'https://profiles.wordpress.org/kmgalanakis/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>kmgalanakis</a>, <a href=\'https://profiles.wordpress.org/umeshsinghin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>umeshsinghin</a>, <a href=\'https://profiles.wordpress.org/wildworks/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>wildworks</a>, <a href=\'https://profiles.wordpress.org/mkrndmane/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mkrndmane</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18673\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 6.8 Release Candidate 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2025/04/wordpress-6-8-release-candidate-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 01 Apr 2025 15:53:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18662\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:367:\"The second Release Candidate (“RC2”) for WordPress 6.8 is ready for download and testing! This version of the WordPress software is under development. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it’s recommended that you evaluate RC2 on a test server and site. Reaching this phase [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Jonathan Desrosiers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8741:\"\n<p>The second Release Candidate (“RC2”) for WordPress 6.8 is ready for download and testing!</p>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>.<strong> Please do not install, run, or test this version of WordPress on production or mission-critical websites.</strong> Instead, it’s recommended that you evaluate RC2 on a test server and site.</p>\n\n\n\n<p>Reaching this phase of the release cycle is an important milestone. While release candidates are considered ready for release, testing remains crucial to ensure that everything in WordPress 6.8 is the best it can be.</p>\n\n\n\n<p>You can test WordPress 6.8 RC2 in four ways:</p>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\"> WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream).</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the<a href=\"https://wordpress.org/wordpress-6.8-RC2.zip\"> RC2 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use the following<a href=\"https://make.wordpress.org/cli/\"> WP-CLI</a> command: wp core update &#8211;version=6.8-RC2</td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the<a href=\"https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn\"> 6.8 RC2 WordPress Playground instance</a> (available within 35 minutes after the release is ready) to test the software directly in your browser without the need for a separate site or setup.</td></tr></tbody></table></figure>\n\n\n\n<p>The current target for the WordPress 6.8 release is <strong>April 15, 2025</strong>.&nbsp; Get an overview of the<a href=\"https://make.wordpress.org/core/6-8/\"> 6.8 release cycle</a>, and check the<a href=\"https://make.wordpress.org/core/\"> Make WordPress Core blog</a> for<a href=\"https://make.wordpress.org/core/tag/6-8/\"> 6.8-related posts</a> in the coming weeks for further details.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What’s in WordPress 6.8 RC2?</h2>\n\n\n\n<p>Get a recap of WordPress 6.8’s highlighted features in the<a href=\"https://wordpress.org/news/2025/03/wordpress-6-8-beta-1/\"> Beta 1 announcement</a>. For more technical information related to issues addressed since RC1, you can browse the following links:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.8?since=2025-03-26&amp;until=2025-04-01\">GitHub commits for 6.8</a> since March 25</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?id=63175%2C62887%2C63193%2C61219&amp;milestone=6.8&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">Closed Trac tickets</a> since March 25</li>\n</ul>\n\n\n\n<p>Want to look deeper into the details and technical notes for this release? These recent posts cover some of the latest updates:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2025/03/06/speculative-loading-in-6-8/\">Speculative Loading in 6.8</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/02/17/wordpress-6-8-will-use-bcrypt-for-password-hashing/\">WordPress 6.8 will use bcrypt for password hashing</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/03/12/roster-of-design-tools-per-block-wordpress-6-8-edition/\">Roster of design tools per block (WordPress 6.8 edition)</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/03/13/more-efficient-block-type-registration-in-6-8/\">More efficient block type registration in 6.8</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/03/25/updates-to-user-interface-components-in-wordpress-6-8/\">Updates to user-interface components in WordPress 6.8</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/03/24/interactivity-api-best-practices-in-6-8/\">Interactivity API best practices in 6.8</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/03/12/i18n-improvements-6-8/\">Internationalization improvements in 6.8</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">How you can contribute</h2>\n\n\n\n<p>WordPress is open source software made possible by a passionate community of people collaborating on and contributing to its development. The resources below outline various ways you can help the world’s most popular open source web platform, regardless of your technical expertise.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Get involved in testing</h3>\n\n\n\n<p>Testing for issues is critical to ensuring WordPress is performant and stable.&nbsp; It’s also a meaningful way for anyone to contribute. <a href=\"https://make.wordpress.org/test/2025/03/04/help-test-wordpress-6-8/\">&nbsp;This detailed guide</a> will walk you through testing features in WordPress 6.8.&nbsp; For those new to testing, follow<a href=\"https://make.wordpress.org/test/handbook/get-setup-for-testing/\"> this general testing guide</a> for more details on getting set up.</p>\n\n\n\n<p>If you encounter an issue, please report it to the<a href=\"https://wordpress.org/support/forum/alphabeta/\"> Alpha/Beta area</a> of the support forums or directly to<a href=\"https://core.trac.wordpress.org/newticket\"> WordPress Trac</a> if you are comfortable writing a reproducible bug report.&nbsp; You can also check your issue against a list of<a href=\"https://core.trac.wordpress.org/tickets/major\"> known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general?&nbsp; Follow along with the<a href=\"https://make.wordpress.org/test/\"> testing initiatives in Make Core</a> and join the<a href=\"https://wordpress.slack.com/messages/core-test/\"> #core-test channel</a> on<a href=\"https://wordpress.slack.com/\"> Making WordPress Slack</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Search for vulnerabilities</h3>\n\n\n\n<p>From now until the final release of WordPress 6.8 (scheduled for April 15, 2025), the<a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/#enhanced-bounty-rewards-during-beta-and-release-candidate-phases\"> monetary reward for reporting new, unreleased security vulnerabilities</a> is doubled. Please follow responsible disclosure practices as detailed in the project’s security practices and policies outlined on the<a href=\"https://hackerone.com/wordpress\"> HackerOne page</a> and in the<a href=\"https://wordpress.org/about/security/\"> security white paper</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Update your theme or plugin</h3>\n\n\n\n<p>For plugin and theme authors, your products play an integral role in extending the functionality and value of WordPress for all users.</p>\n\n\n\n<p>Thanks for continuing to test your themes and plugins with the WordPress 6.8 beta releases. With RC2, you’ll want to conclude your testing and update the <em>“Tested up to”</em> version in your<a href=\"https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/\"> plugin’s readme file</a> to 6.8.</p>\n\n\n\n<p>If you find compatibility issues, please post detailed information to the<a href=\"https://wordpress.org/support/forum/alphabeta/\"> support forum</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Help translate WordPress</h3>\n\n\n\n<p>Do you speak a language other than English?  ¿Español?  Français? Русский? 日本語?  हिन्दी?  বাংলা?  मराठी?  ಕನ್ನಡ?  You can<a href=\"https://translate.wordpress.org/projects/wp/dev/\"> help translate WordPress into more than 100 languages</a>. This release milestone (RC2) also marks the<a href=\"https://make.wordpress.org/polyglots/handbook/glossary/#hard-freeze\"> hard string freeze</a> point of the 6.8 release cycle.</p>\n\n\n\n<h2 class=\"wp-block-heading\">An RC2 haiku</h2>\n\n\n\n<p><em>Testing, 1, 2, 3</em><br><em>It’s almost April fifteenth</em><br><em>Squashing all the bugs</em></p>\n\n\n\n<p><em>Thank you to the following contributors for collaborating on this post: <a href=\'https://profiles.wordpress.org/michelleames/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>michelleames</a>, <a href=\'https://profiles.wordpress.org/tacoverdo/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>tacoverdo</a>, <a href=\'https://profiles.wordpress.org/jopdop30/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jopdop30</a>, <a href=\'https://profiles.wordpress.org/vgnavada/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>vgnavada</a>, <a href=\'https://profiles.wordpress.org/jeffpaul/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jeffpaul</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18662\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 6.8 Release Candidate 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2025/03/wordpress-6-8-release-candidate-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 25 Mar 2025 16:19:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18639\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:267:\"WordPress 6.8 RC 1 is ready for download and testing! The scheduled final release date for WordPress 6.8 is April 15, 2025. Your help testing over the next three weeks is vital to ensuring the final release is everything it should be: stable, powerful, and intuitive.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Jeffrey Paul\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9475:\"\n<p>The first Release Candidate (“RC1”) for WordPress 6.8 is ready for download and testing!</p>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>.<strong>&nbsp; Please do not install, run, or test this version of WordPress on production or mission-critical websites.</strong>&nbsp; Instead, it’s recommended that you evaluate RC1 on a test server and site.</p>\n\n\n\n<p>Reaching this phase of the release cycle is an important milestone.&nbsp; While release candidates are considered ready for release, testing remains crucial to ensure that everything in WordPress 6.8 is the best it can be.</p>\n\n\n\n<p>You can test WordPress 6.8 RC1 in four ways:</p>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\"> WordPress Beta Tester</a> plugin on a WordPress install.&nbsp; (Select the “Bleeding edge” channel and “Beta/RC Only” stream).</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href=\"https://wordpress.org/wordpress-6.8-RC1.zip\">RC1 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use the following<a href=\"https://make.wordpress.org/cli/\"> WP-CLI</a> command: <code>wp core update --version=6.8-RC1</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href=\"https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn\">6.8 RC1 WordPress Playground instance</a> (available within 35 minutes after the release is ready) to test the software directly in your browser without the need for a separate site or setup.</td></tr></tbody></table></figure>\n\n\n\n<p>The current target for the WordPress 6.8 release is <strong>April 15, 2025</strong>.&nbsp; Get an overview of the <a href=\"https://make.wordpress.org/core/6-8/\">6.8 release cycle</a>, and check the<a href=\"https://make.wordpress.org/core/\"> Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-8/\">6.8-related posts</a> in the coming weeks for further details.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What’s in WordPress 6.8 RC1?</h2>\n\n\n\n<p>Get a recap of WordPress 6.8’s highlighted features in the <a href=\"https://wordpress.org/news/2025/03/wordpress-6-8-beta-1/\">Beta 1 announcement</a>.&nbsp; For more technical information related to issues addressed since Beta 3, you can browse the following links:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.8?since=2025-03-18&amp;until=2025-03-25\">GitHub commits for 6.8</a> since March 18</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=03%2F18%2F2025..03%2F25%2F2025&amp;milestone=6.8&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Closed Trac tickets</a> since March 18</li>\n</ul>\n\n\n\n<p>Want to look deeper into the details and technical notes for this release? These recent posts cover some of the latest updates:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2025/03/06/speculative-loading-in-6-8/\">Speculative Loading in 6.8</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/02/17/wordpress-6-8-will-use-bcrypt-for-password-hashing/\">WordPress 6.8 will use bcrypt for password hashing</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/03/12/roster-of-design-tools-per-block-wordpress-6-8-edition/\">Roster of design tools per block (WordPress 6.8 edition)</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/03/13/more-efficient-block-type-registration-in-6-8/\">More efficient block type registration in 6.8</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/03/25/updates-to-user-interface-components-in-wordpress-6-8/\">Updates to user-interface components in WordPress 6.8</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/03/24/interactivity-api-best-practices-in-6-8/\">Interactivity API best practices in 6.8</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/03/12/i18n-improvements-6-8/\">Internationalization improvements in 6.8</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">How you can contribute</h2>\n\n\n\n<p>WordPress is open source software made possible by a passionate community of people collaborating on and contributing to its development.&nbsp; The resources below outline various ways you can help the world’s most popular open source web platform, regardless of your technical expertise.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Get involved in testing</h3>\n\n\n\n<p>Testing for issues is critical to ensuring WordPress is performant and stable.&nbsp; It’s also a meaningful way for anyone to contribute.&nbsp; <a href=\"https://make.wordpress.org/test/2025/03/04/help-test-wordpress-6-8/\">This detailed guide</a> will walk you through testing features in WordPress 6.8.&nbsp; For those new to testing, follow <a href=\"https://make.wordpress.org/test/handbook/get-setup-for-testing/\">this general testing guide</a> for more details on getting set up.</p>\n\n\n\n<p>If you encounter an issue, please report it to the<a href=\"https://wordpress.org/support/forum/alphabeta/\"> Alpha/Beta area</a> of the support forums or directly to<a href=\"https://core.trac.wordpress.org/newticket\"> WordPress Trac</a> if you are comfortable writing a reproducible bug report.&nbsp; You can also check your issue against a list of<a href=\"https://core.trac.wordpress.org/tickets/major\"> known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general?&nbsp; Follow along with the<a href=\"https://make.wordpress.org/test/\"> testing initiatives in Make Core</a> and join the<a href=\"https://wordpress.slack.com/messages/core-test/\"> #core-test channel</a> on<a href=\"https://wordpress.slack.com/\"> Making WordPress Slack</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Search for vulnerabilities</h3>\n\n\n\n<p>From now until the final release of WordPress 6.8 (scheduled for April 15, 2025), the <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/#enhanced-bounty-rewards-during-beta-and-release-candidate-phases\">monetary reward for reporting new, unreleased security vulnerabilities</a> is doubled.&nbsp; Please follow responsible disclosure practices as detailed in the project’s security practices and policies outlined on the<a href=\"https://hackerone.com/wordpress\"> HackerOne page</a> and in the<a href=\"https://wordpress.org/about/security/\"> security white paper</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Update your theme or plugin</h3>\n\n\n\n<p>For plugin and theme authors, your products play an integral role in extending the functionality and value of WordPress for all users.</p>\n\n\n\n<p>Thanks for continuing to test your themes and plugins with the WordPress 6.8 beta releases.&nbsp; With RC1, you’ll want to conclude your testing and update the <em>“Tested up to”</em> version in your<a href=\"https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/\"> plugin’s readme file</a> to 6.8.</p>\n\n\n\n<p>If you find compatibility issues, please post detailed information to the<a href=\"https://wordpress.org/support/forum/alphabeta/\"> support forum</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Help translate WordPress</h3>\n\n\n\n<p>Do you speak a language other than English?  <bdo lang=\"es\" dir=\"ltr\">¿Español?</bdo>  <bdo lang=\"fr\" dir=\"ltr\">Français?</bdo>  <bdo lang=\"ru\" dir=\"ltr\">Русский?</bdo>  <bdo lang=\"jp\" dir=\"ltr\">日本語?</bdo> <bdo lang=\"hi\" dir=\"ltr\">हिन्दी?</bdo>  <bdo lang=\"bn\" dir=\"ltr\">বাংলা?</bdo>  <bdo lang=\"mr\" dir=\"ltr\">मराठी?</bdo>  You can<a href=\"https://translate.wordpress.org/projects/wp/dev/\"> help translate WordPress into more than 100 languages</a>.  This release milestone (RC1) also marks the<a href=\"https://make.wordpress.org/polyglots/handbook/glossary/#hard-freeze\"> hard string freeze</a> point of the 6.8 release cycle.</p>\n\n\n\n<h2 class=\"wp-block-heading\">An RC1 haiku</h2>\n\n\n\n<p>March fades, nearly there,<br>Six-eight hums—a steady beat,<br>RC greets the world.</p>\n\n\n\n<p class=\"has-text-align-right\"><em>Thank you to the following contributors for collaborating on this post: <a href=\'https://profiles.wordpress.org/joemcgill/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joemcgill</a> <a href=\'https://profiles.wordpress.org/benjamin_zekavica/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>benjamin_zekavica</a> <a href=\'https://profiles.wordpress.org/courane01/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>courane01</a> <a href=\'https://profiles.wordpress.org/mkrndmane/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mkrndmane</a> <a href=\'https://profiles.wordpress.org/audrasjb/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>audrasjb</a> <a href=\'https://profiles.wordpress.org/areziaal/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>areziaal</a> <a href=\'https://profiles.wordpress.org/ankit-k-gupta/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ankit-k-gupta</a> <a href=\'https://profiles.wordpress.org/krupajnanda/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>krupajnanda</a> <a href=\'https://profiles.wordpress.org/bph/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>bph</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18639\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 6.8 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2025/03/wordpress-6-8-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 18 Mar 2025 15:35:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18634\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:289:\"WordPress 6.8 Beta 3 is ready for download and testing! The scheduled final release date for WordPress 6.8 is April 15, 2025. Your help testing Beta and RC versions over the next four weeks is vital to ensuring the final release is everything it should be: stable, powerful, and intuitive.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Jeffrey Paul\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5627:\"\n<p>WordPress 6.8 Beta 3 is now ready for testing!</p>\n\n\n\n<p><strong>This beta version of the WordPress software is under development</strong>. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it is recommended you evaluate Beta 3 on a test server and site.</p>\n\n\n\n<p>You can test WordPress 6.8 Beta 3 in four ways:</p>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\"> WordPress Beta Tester</a> plugin on a WordPress install.&nbsp; (Select the “Bleeding edge” channel and “Beta/RC Only” stream).</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href=\"https://wordpress.org/wordpress-6.8-beta3.zip\">Beta 3 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use the following<a href=\"https://make.wordpress.org/cli/\"> WP-CLI</a> command: <code>wp core update --version=6.8-beta3</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href=\"https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn\">6.8 Beta 3 WordPress Playground instance</a> to test the software directly in your browser without the need for a separate site or setup.</td></tr></tbody></table></figure>\n\n\n\n<p>The current target date for the final release of WordPress 6.8 is <strong>April 15, 2025</strong>. Get an overview of the <a href=\"https://make.wordpress.org/core/6-8/\">6.8 release cycle</a>, and check the<a href=\"https://make.wordpress.org/core/\"> Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-8/\">6.8-related posts</a> in the coming weeks for more information.</p>\n\n\n\n<p><strong>Catch up on what’s new in WordPress 6.8</strong>: Read the <a href=\"https://wordpress.org/news/2025/03/wordpress-6-8-beta-1/\">Beta 1</a> and <a href=\"https://wordpress.org/news/2025/03/wordpress-6-8-beta-2/\">Beta 2</a> announcements for details and highlights.</p>\n\n\n\n<h2 class=\"wp-block-heading\">How to test this release</h2>\n\n\n\n<p>Your help testing the WordPress 6.8 Beta 3 version is key to ensuring everything in the release is the best it can be. While testing the upgrade process is essential, trying out new features is equally important. <a href=\"https://make.wordpress.org/test/2025/03/04/help-test-wordpress-6-8/\">This detailed guide</a> will walk you through testing features in WordPress 6.8.</p>\n\n\n\n<p>If you encounter an issue, please report it to the Alpha/Beta area of the support forums or directly to<a href=\"https://core.trac.wordpress.org/newticket\"> WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of<a href=\"https://core.trac.wordpress.org/tickets/major\"> known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general?&nbsp; Follow along with the<a href=\"https://make.wordpress.org/test/\"> testing initiatives in Make Core</a> and join the<a href=\"https://wordpress.slack.com/messages/core-test/\"> #core-test channel</a> on<a href=\"https://wordpress.slack.com/\"> Making WordPress Slack</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Vulnerability bounty doubles during Beta/RC</h2>\n\n\n\n<p>Between Beta 1, released on March 4, 2025, and the final Release Candidate (RC) scheduled for April 8, 2025, the <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/#enhanced-bounty-rewards-during-beta-and-release-candidate-phases\">monetary reward for reporting new, unreleased security vulnerabilities</a> is doubled. Please follow responsible disclosure practices as detailed in the project’s security practices and policies outlined on the<a href=\"https://hackerone.com/wordpress\"> HackerOne page</a> and in the<a href=\"https://wordpress.org/about/security/\"> security white paper</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Beta 3 updates and highlights</h2>\n\n\n\n<p>WordPress 6.8 Beta 3 contains more than 3 Editor updates and fixes since the Beta 2 release, including 16 tickets for WordPress core.</p>\n\n\n\n<p>Each beta cycle focuses on bug fixes; more are on the way with your help through testing. You can browse the technical details for all issues addressed since Beta 3 using these links:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.8?since=2025-03-12&amp;until=2025-03-17\">GitHub commits for 6.8</a> since March 12, 2025</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=03%2F12%2F2025..03%2F17%2F2025&amp;milestone=6.8&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Closed Trac tickets</a> since March 12, 2025</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">A Beta 3 haiku</h2>\n\n\n\n<p>Beta three refines,<br>WordPress shapes with steady hands,<br>Code grows into form.</p>\n\n\n\n<p class=\"has-text-align-right\"><em>Props to <a href=\'https://profiles.wordpress.org/benjamin_zekavica/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>benjamin_zekavica</a> <a href=\'https://profiles.wordpress.org/krupajnanda/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>krupajnanda</a> <a href=\'https://profiles.wordpress.org/ankit-k-gupta/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ankit-k-gupta</a> <a href=\'https://profiles.wordpress.org/joemcgill/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joemcgill</a> for proofreading and review.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18634\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:12:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Thu, 05 Jun 2025 10:39:18 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:37:\"Accept-Encoding, accept, content-type\";s:25:\"strict-transport-security\";s:12:\"max-age=3600\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Tue, 27 May 2025 16:59:07 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:4:\"gzip\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";i:1727736619;s:21:\"cache_expiration_time\";i:1749163158;s:23:\"__cache_expiration_time\";i:1749163158;}", "off");
INSERT INTO `wp_options` VALUES("143", "_transient_timeout_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3", "1749163158", "off");
INSERT INTO `wp_options` VALUES("144", "_transient_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3", "1749119958", "off");
INSERT INTO `wp_options` VALUES("145", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1749163159", "off");
INSERT INTO `wp_options` VALUES("146", "_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:112:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"Felix Arntz: Introducing the View Transitions Plugin for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://felix-arntz.me/?p=2122\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://felix-arntz.me/blog/introducing-view-transitions-wordpress-plugin/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:16276:\"<p>I&#8217;m thrilled to announce a new plugin from the WordPress Core Performance Team: <a href=\"http://wordpress.org/plugins/view-transitions/\" rel=\"noreferrer noopener\" target=\"_blank\">View Transitions</a>! This experimental plugin brings the power of the <a href=\"https://developer.chrome.com/docs/web-platform/view-transitions/cross-document\" rel=\"noreferrer noopener\" target=\"_blank\">cross-document View Transitions browser API</a> to your WordPress site, allowing for smoother, animated transitions between page navigations.</p>\n\n\n\n<h2 class=\"wp-block-heading\">View Transitions?</h2>\n\n\n\n<p>Traditionally, moving from one page (or, technically, URL) to another on the web has always involved an abrupt, &#8220;hard&#8221; reload. While this might seem completely natural to many of us on the web, user expectations have shifted drastically in the past (almost) two decades.</p>\n\n\n\n<p>Native mobile applications, with their seamless in-app navigations and smooth transitions, have set a new bar for user experience. This has led web developers to try to catch up with that experience, often turning to Single Page Applications (SPAs). While SPAs aim to mimic native app navigations by dynamically updating content without full page reloads, this often comes with increased development complexity and a shift in how you structure your entire website, often at the cost of accessibility or performance.</p>\n\n\n\n<p>Now, with <a href=\"https://developer.chrome.com/docs/web-platform/view-transitions/cross-document\">cross-document view transitions</a>, you can achieve that desired user experience through smooth transitions on the web without any extensive overhaul of your website. And the new <a href=\"http://wordpress.org/plugins/view-transitions/\">View Transitions</a> plugin makes it super simple in WordPress.</p>\n\n\n\n<span id=\"more-2122\"></span>\n\n\n\n<h2 class=\"wp-block-heading\">How Do View Transitions Work in WordPress?</h2>\n\n\n\n<p>As soon as you have activated the plugin on your WordPress site and navigate between a few pages of your site, you&#8217;ll notice that the plugin implements a gentle fade effect for the transition, creating a more graceful and visually engaging user experience. This is the default behavior not only for the plugin, but also for the View Transitions API in the browser.</p>\n\n\n\n<p>If you want to see a live demo &#8211; you&#8217;re on it! The plugin is active on my site, so for example you could click on the &#8220;Blog&#8221; link in the header navigation. You should see a smooth transition if your browser supports it (see further below). Just make sure to navigate back here afterwards to continue reading. 😁</p>\n\n\n\n<p>(If you want to test it more, you could navigate to the home page by clicking on the site title, scroll down to &#8220;Latest posts&#8221;, then click on the &#8220;View post&#8221; button for this post. When using a large enough viewport, that transition should expand/morph the small featured image from the post in the grid to the much larger featured image shown above. If the animation is too fast, try clicking the Back/Forward button in your browser a few times to get a better sense of what I&#8217;m referring to.)</p>\n\n\n\n<p>Because the nature and style of transitions can be heavily dependent on a theme&#8217;s specific layout and design, the long-term vision is for themes to opt in and customize this behavior. This is facilitated through the WordPress theme support API, for instance by calling <code>add_theme_support( \'view-transitions\' )</code>.</p>\n\n\n\n<p>For now, since this plugin&#8217;s explicit purpose is to enable and showcase view transitions, it automatically enables them across your site, regardless of the theme currently in use.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"customizing-view-transitions\">Customizing View Transitions</h2>\n\n\n\n<p>For this initial experimental phase, the plugin offers a user-friendly way to explore different configurations directly within the WordPress admin. You&#8217;ll find settings under <strong>Settings &gt; Reading</strong> that allow you to tweak the view transitions behavior. This UI is primarily for easy exploration and testing at this early stage. Should view transitions make their way into Core, customization would solely be managed through code via the theme support API. That said, even with this early plugin version, themes can already start using the theme support API.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Customizing with <code>add_theme_support()</code></h3>\n\n\n\n<p>To quickly enable view transitions with standard settings, add the following to your theme&#8217;s <code>functions.php</code> file (typically within the <code>after_setup_theme</code> action hook):</p>\n\n\n<pre class=\"wp-block-code\"><span><code class=\"hljs language-php\"><span class=\"hljs-function\"><span class=\"hljs-keyword\">function</span> <span class=\"hljs-title\">mytheme_setup</span><span class=\"hljs-params\">()</span> </span>{\n	add_theme_support( <span class=\"hljs-string\">\'view-transitions\'</span> );\n}\nadd_action( <span class=\"hljs-string\">\'after_setup_theme\'</span>, <span class=\"hljs-string\">\'mytheme_setup\'</span> );</code></span></pre>\n\n\n<p>For more control, you can pass an array of arguments to <code>add_theme_support( \'view-transitions\', $args )</code>. Here are the available arguments:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong><code>default-animation</code></strong>: Specifies the default animation style for transitions.</li>\n\n\n\n<li><strong><code>post-selector</code></strong>: CSS selector(s) to identify individual post containers, crucial for applying post-specific transitions from archive/listing pages.</li>\n\n\n\n<li><strong><code>global-transition-names</code></strong>: A map (associative array) defining CSS selectors for global elements (like headers or sidebars) and their view transition names that should have persistent <code>view-transition-name</code> values across the entire site.</li>\n\n\n\n<li><strong><code>post-transition-names</code></strong>: A map (associative array) defining CSS selectors for elements <em>within</em> post containers (like titles or featured images) and their view transition names that should animate during transitions to/from single views.</li>\n</ul>\n\n\n\n<p>To provide additional context on what the view transition names are for: Whenever an element has the same view transition name assigned between two URLs that the user navigates between, it will gently morph as part of the transition, maintaining a clear association. For example, a post title in a grid of posts in an archive might scale up in size and move to the top of the page when navigating to its single post URL.</p>\n\n\n\n<p>For the <code>default-animation</code>, a few animations are available by default. Additionally, the plugin provides an API to register additional animations, each of which encompasses a unique identifier, some configuration values, a CSS stylesheet, and optional aliases. I&#8217;m not going to cover this here for now since it&#8217;s a more advanced integration, but ideally in the long term there could be plugins or themes that register their own view transition animations that themes could use. For now, a few basic animations are available out of the box, mostly as an example of what can be done. The initial supported identifiers (and their aliases) are:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><code>fade</code></li>\n\n\n\n<li><code>slide</code>\n<ul class=\"wp-block-list\">\n<li><code>slide-from-right</code></li>\n\n\n\n<li><code>slide-from-bottom</code></li>\n\n\n\n<li><code>slide-from-left</code></li>\n\n\n\n<li><code>slide-from-top</code></li>\n</ul>\n</li>\n\n\n\n<li><code>swipe</code>\n<ul class=\"wp-block-list\">\n<li><code>swipe-from-right</code></li>\n\n\n\n<li><code>swipe-from-bottom</code></li>\n\n\n\n<li><code>swipe-from-left</code></li>\n\n\n\n<li><code>swipe-from-top</code></li>\n</ul>\n</li>\n\n\n\n<li><code>wipe</code>\n<ul class=\"wp-block-list\">\n<li><code>wipe-from-right</code></li>\n\n\n\n<li><code>wipe-from-bottom</code></li>\n\n\n\n<li><code>wipe-from-left</code></li>\n\n\n\n<li><code>wipe-from-top</code></li>\n</ul>\n</li>\n</ul>\n\n\n\n<p>You can customize any or all of the supported arguments by passing an array to <code>add_theme_support()</code>. Here’s an example modifying all available options:</p>\n\n\n<pre class=\"wp-block-code alignwide\"><span><code class=\"hljs language-php\"><span class=\"hljs-function\"><span class=\"hljs-keyword\">function</span> <span class=\"hljs-title\">mytheme_custom_view_transitions_setup</span><span class=\"hljs-params\">()</span> </span>{\n	add_theme_support( <span class=\"hljs-string\">\'view-transitions\'</span>, <span class=\"hljs-keyword\">array</span>(\n		<span class=\"hljs-string\">\'default-animation\'</span>       =&gt; <span class=\"hljs-string\">\'wipe-from-right\'</span>,\n		<span class=\"hljs-string\">\'post-selector\'</span>           =&gt; <span class=\"hljs-string\">\'.wp-block-post.post, article.post, article.entry\'</span>,\n		<span class=\"hljs-string\">\'global-transition-names\'</span> =&gt; <span class=\"hljs-keyword\">array</span>(\n			<span class=\"hljs-string\">\'.site-branding\'</span> =&gt; <span class=\"hljs-string\">\'logo\'</span>,\n			<span class=\"hljs-string\">\'.site-header\'</span>   =&gt; <span class=\"hljs-string\">\'header\'</span>,\n        	),\n        	<span class=\"hljs-string\">\'post-transition-names\'</span>   =&gt; <span class=\"hljs-keyword\">array</span>(\n			<span class=\"hljs-comment\">// These are mostly just the defaults, but there\'s one extra entry.</span>\n			<span class=\"hljs-string\">\'.wp-block-post-title, .entry-title\'</span>     =&gt; <span class=\"hljs-string\">\'post-title\'</span>,\n			<span class=\"hljs-string\">\'.wp-post-image\'</span>                         =&gt; <span class=\"hljs-string\">\'post-thumbnail\'</span>,\n			<span class=\"hljs-string\">\'.wp-block-post-content, .entry-content\'</span> =&gt; <span class=\"hljs-string\">\'post-content\'</span>,\n			<span class=\"hljs-string\">\'.post-meta\'</span>                             =&gt; <span class=\"hljs-string\">\'post-meta\'</span>, <span class=\"hljs-comment\">// Additional entry.</span>\n		),\n	) );\n}\nadd_action( <span class=\"hljs-string\">\'after_setup_theme\'</span>, <span class=\"hljs-string\">\'mytheme_custom_view_transitions_setup\'</span> );</code></span></pre>\n\n\n<p>As you can see in this example, which also indicates some of the default values, they aim to capture common patterns that work across block themes and classic themes alike. That said, block themes are likely a perfect fit for view transitions, given their more predictable nature in markup due to using exclusively blocks.</p>\n\n\n\n<p>The default values for all the supported arguments are based partly on WordPress-generated classes that should almost always be included in WordPress sites, and partly on very common conventions. The goal is that the defaults should work well for the majority of WordPress sites. That said, it is impossible to make it look perfect for every possible WordPress theme. That&#8217;s precisely why the theme support approach was chosen for making View Transitions available in WordPress.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Customizing via <em>Settings &gt; Reading</em></h3>\n\n\n\n<p>A limited subset of what can be customized via <code>add_theme_support</code> is made available via the &#8220;View Transitions&#8221; settings section under <em>Settings &gt; Reading</em>.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"Settings section of the View Transitions plugin for WordPress\" class=\"wp-image-2131\" height=\"576\" src=\"https://felix-arntz.me/wp-content/uploads/2025/05/view-transitions-wordpress-settings-1024x576.webp\" width=\"1024\" /></figure>\n\n\n\n<p>You can customize the default animation, and the selectors for the default view transition names for both global and post-specific elements. While this means the customization options are limited via the UI, it still allows you to play around with different configurations via UI, and likely for the majority of sites these are the most relevant parameters to customize anyways. Keep in mind that this UI is only supplemental, and it only exists for easy exploration in the plugin. The recommended way to customize is via <code>add_theme_support</code> in your site&#8217;s WordPress theme.</p>\n\n\n\n<h3 class=\"wp-block-heading\">A Note on Configuration Precedence</h3>\n\n\n\n<p>It&#8217;s important to be mindful that, for now, any configurations you make via the Settings UI will take precedence over what is defined in your theme&#8217;s code using <code>add_theme_support()</code>. This is something to keep in mind as you test and explore the plugin.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Browser Support</h2>\n\n\n\n<p>Cross-document view transitions are currently supported in a range of modern browsers, including Chrome, Edge, and Safari. For users on browsers that do not yet support this API, there should be no adverse effects; they will simply experience the traditional hard transitions between pages. You can always check the latest browser compatibility at <a href=\"https://caniuse.com/mdn-css_at-rules_view-transition\" rel=\"noreferrer noopener\" target=\"_blank\">caniuse.com</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Your Feedback is Needed!</h2>\n\n\n\n<p>If you&#8217;re a WordPress theme developer or maintainer, I strongly encourage you to install the <a href=\"http://wordpress.org/plugins/view-transitions/\" rel=\"noreferrer noopener\" target=\"_blank\">View Transitions plugin</a> and give it a spin. Better yet, consider experimenting with adding support directly into your theme using <code>add_theme_support( \'view-transitions\' )</code>.</p>\n\n\n\n<p>And if you&#8217;re simply curious about the feature and want to enable it on your WordPress site, I similarly encourage you to try out the plugin. The Core Performance Team would love to get your feedback.</p>\n\n\n\n<p>While this is a fresh first release and still experimental, like other plugins incubated within the <a href=\"https://wordpress.org/plugins/performance-lab/\" rel=\"noreferrer noopener\" target=\"_blank\">Performance Lab program</a>, it holds the potential to one day become a part of WordPress Core.</p>\n\n\n\n<p>Your early feedback and real-world use cases will be absolutely instrumental in refining this feature, addressing potential issues, and shaping its future.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Join Us at WordCamp Europe 2025 Contributor Day!</h3>\n\n\n\n<p>I&#8217;m publishing this post in a very timely manner &#8211; today is <a href=\"https://europe.wordcamp.org/2025/contributor-day/\">WordCamp Europe 2025 Contributor Day</a>! I&#8217;ll be at the Core Performance Team table, and a key part of our agenda will be testing, discussing, and gathering feedback on this new <a href=\"https://wordpress.org/plugins/view-transitions/\">View Transitions</a> plugin.</p>\n\n\n\n<p>If you&#8217;re attending and are curious to learn more, want to get involved, or have initial thoughts to share, I would love for you to join us. Your insights will be invaluable!</p>\n\n\n\n<h3 class=\"wp-block-heading\">Feedback and Contributions</h3>\n\n\n\n<p>As this plugin is in its early stages, your feedback is highly encouraged and deeply appreciated.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>If you have suggestions, ideas for new features, or encounter any bugs, please <a href=\"https://github.com/WordPress/performance/issues/new/choose\" rel=\"noreferrer noopener\" target=\"_blank\">submit them as an issue in the WordPress Core Performance Team&#8217;s GitHub repository</a>.</li>\n\n\n\n<li>If you need help with troubleshooting or have questions about the plugin, please <a href=\"https://wordpress.org/support/plugin/view-transitions/#new-topic-0\" rel=\"noreferrer noopener\" target=\"_blank\">create a new topic on our support forum</a>.</li>\n</ul>\n\n\n\n<p>And of course, contributions are always welcome! You can learn more about how to get involved by checking out the <a href=\"https://make.wordpress.org/performance/handbook/get-involved/\" rel=\"noreferrer noopener\" target=\"_blank\">Core Performance Team Handbook</a>.</p>\n\n\n\n<p>I&#8217;m really excited to see how the community uses and shapes this new feature!</p>\n<p>The post <a href=\"https://felix-arntz.me/blog/introducing-view-transitions-wordpress-plugin/\">Introducing the View Transitions Plugin for WordPress</a> appeared first on <a href=\"https://felix-arntz.me\">felix-arntz.me</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 05 Jun 2025 04:09:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"Felix\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tammie Lister: May in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://binatethoughts.com/?p=1853\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"https://binatethoughts.com/may-in-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4014:\"<p>This month was full of backlog management, prioritisation and clearing out queues. I focused on identifying where things were blocking and preparing for WordCamp Europe.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Areas of contribution</h3>\n\n\n\n<p>Whilst my focus was on backlog management, it split into two distinct areas:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Closing tickets:</strong> I focused on Trac and the Gutenberg repo for this. Make sure to go oldest first.</li>\n\n\n\n<li><strong>Focusing design: </strong>Ensuring the design queue was clear about what needed design and what required feedback. This was something that arose from contributor input as a point of confusion, and I have made considerable progress through this. I worked on issues, focusing on having only one of those states, and also addressed items in &#8216;needs design&#8217; that were truly ready for implementation, having an agreement in place. This work does need to continue.</li>\n</ul>\n\n\n\n<p>I also began thinking about how to optimise and make reporting easier for backlog management, and I want to bring those discussions to WordCamp Europe. </p>\n\n\n\n<p>Some stats across the backlog management of issues and tickets in Trac and Github.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Triaged: </strong>around 143</li>\n\n\n\n<li><strong>Closed:</strong> 60</li>\n\n\n\n<li><strong>Prioritised in design</strong>: around 49</li>\n</ul>\n\n\n\n<p>In other contributions, I worked on some designs and gave feedback across a range of tickets. I also began exploring how far DataViews can go and have a list of things to now report from this. It reminded me of the value of pushing the boundaries of our learning features.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Upcoming plans for contribution</h3>\n\n\n\n<p>The big event is WordCamp Europe, which is taking place this week. I will be attending Contribution Day. After that, the following are my objectives:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Extensibility:</strong> Continue my focus on work there and prioritise how to establish criteria for what gets in and what does not. Hopefully, unblocking a range of issues during WordCamp Europe.</li>\n\n\n\n<li><strong>Backlog management: </strong>My work is constant, but I want to explore how it can evolve smarter, potentially utilising systems to manage and enhance workflow.</li>\n\n\n\n<li><strong>Papercuts: </strong>After WordCamp, I will pick this up again with several issues to focus on.</li>\n</ul>\n\n\n\n<p>With WordCamp Europe, I am restricting my plans beyond what I have mentioned above, as things will likely emerge from it and change.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Sponsors this month</h3>\n\n\n\n<p>I now have three company sponsors: <a href=\"https://www.bigscoots.com/\" rel=\"noreferrer noopener\" target=\"_blank\">BigScoots</a>, <a href=\"https://greyd.io/\" rel=\"noreferrer noopener\" target=\"_blank\">Greyd</a> and <a href=\"https://kinsta.com/\" rel=\"noreferrer noopener\" target=\"_blank\">Kinsta</a>. I also have five sponsors through GitHub: <a href=\"https://github.com/aaronjorbin\" rel=\"noreferrer noopener\" target=\"_blank\">Aaron Jorbin</a>, <a href=\"https://github.com/timnashcouk\" rel=\"noreferrer noopener\" target=\"_blank\">Tim Nash</a>, <a href=\"https://github.com/jeffpaul\" rel=\"noreferrer noopener\" target=\"_blank\">Jeffrey Paul</a>, <a href=\"https://github.com/foosantos\" rel=\"noreferrer noopener\" target=\"_blank\">Felipe Santos</a> and <a href=\"https://github.com/scotrumery\">Scot Rumery</a>. To everyone who sponsored me and helped me secure a sponsorship, thank you.</p>\n\n\n\n<p><strong>Want to sponsor me? </strong>You can go through <a href=\"https://github.com/karmatosed\" rel=\"noreferrer noopener\" target=\"_blank\">GitHub</a> or also get in <a href=\"mailto:hello@tammielister.com\" rel=\"noreferrer noopener\" target=\"_blank\">touch</a>.</p>\n\n\n\n<p>There is always sponsorship, of course, that is volunteered, and I&#8217;ll do as much as possible whilst still keeping things flowing – let&#8217;s get contributing!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 04 Jun 2025 08:48:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"binatethoughts.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"Jonathan Desrosiers: WordPress Grab Bag: WCEU, WordPress turns 22, new AI team\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://jonathandesrosiers.com/?p=4833\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"https://jonathandesrosiers.com/2025/06/wordpress-grab-bag-wceu-wordpress-turns-22-new-ai-team/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5531:\"<p class=\"\">I haven&#8217;t been doing a great job blogging regularly so far this year. We&#8217;ve now passed the 40% mark of the calendar year, and I&#8217;m hoping to make up for that during the remaining 60% of the time. To get started, here are some thoughts on a few topics that have been on my mind over the course of the last week.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-attending-and-presenting-at-wordcamp-europe\">Attending and presenting at WordCamp Europe</h2>\n\n\n\n<p class=\"\">I&#8217;m currently sitting in Terminal A of <a href=\"https://www.massport.com/logan-airport\">Boston Logan International Airport</a> waiting for the first leg of my journey to <a href=\"https://jonathandesrosiers.com/2025/04/speaking-at-wordcamp-europe-2025/\">attend WordCamp Europe in Basel, Switzerland</a>. In addition to the obvious reasons to be excited (seeing friends, meeting new people, checking out what everyone in the community has been building), I&#8217;m also really happy with what my presentation has grown into and can’t wait to present it. It’s not just about the decision making frameworks Core Committers use, but also a reflection on the project&#8217;s foundational philosophies and how they&#8217;ve helped the project thrive.</p>\n\n\n\n<figure class=\"wp-block-image alignwide size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-4896 not-transparent\" height=\"576\" src=\"https://jonathandesrosiers.com/wp-content/uploads/2025/06/wceu-title-slide-1024x576.jpg\" width=\"1024\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n\n\n\n<p class=\"\">There are several points in my speaker notes that have stuck with me. I plan to write some additional posts to explore deeper in the coming weeks!</p>\n\n\n\n<p class=\"\">If you&#8217;re unable to join in person, I&#8217;m including the live stream below.</p>\n\n\n\n<figure class=\"wp-embed-aspect-4-3 wp-has-aspect-ratio wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\">WordPress reaches 22 years old</h2>\n\n\n\n<p class=\"\">Last week was the 22nd birthday for the WordPress project. The <a href=\"https://wordpress.org/news/2003/05/wordpress-now-available/\">first version of the software was released on May 27, 2003</a>. While 22 is not as exciting as 21, I always enjoy reading the reflections from the community and seeing how the software we all help maintain has changed lives.</p>\n\n\n\n<p class=\"\">I first used WordPress around 2007, and received my first credit for contributing in 2013. This means I’ve now been a user of WordPress for over 80%, and a contributor for over 55% of the project’s lifespan.</p>\n\n\n\n<p class=\"\">Happy Birthday WordPress! <img alt=\"🎉\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f389.png\" style=\"height: 1em;\" /><img alt=\"🎊\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f38a.png\" style=\"height: 1em;\" /><img alt=\"🍾\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f37e.png\" style=\"height: 1em;\" /><img alt=\"🥳\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f973.png\" style=\"height: 1em;\" /></p>\n\n\n\n<h2 class=\"wp-block-heading\">New WordPress AI team</h2>\n\n\n\n<p class=\"\">Also last week, a post was published to <a href=\"https://wordpress.org/news/2025/05/announcing-the-formation-of-the-wordpress-ai-team/\">announce the formation of a new AI team for the project</a>. I&#8217;m really looking forward to this team getting started. Initially, the <a href=\"https://make.wordpress.org/core/2023/05/02/lets-talk-wordpress-core-artificial-intelligence/\">stance of the Core team</a> was to observe and wait for the needs to become more clear. But the time has come to explore taking action in some important areas. Specifically extensibility of the block editor, documentation, and ensuring any necessary internal functionality is available through APIs.</p>\n\n\n\n<p class=\"\">Near term, I think once some of these items have a plan to be addressed, what could make the most sense is several canonical AI plugins that integrate with different models or services similar to how importing site content works (WordPress, Tumblr, Movable Type/TypePad, etc. each have their own plugin).</p>\n\n\n\n<p class=\"\">If you have thoughts about the place AI has in the project, join the conversation in the <a href=\"https://wordpress.slack.com/archives/C08TJ8BPULS\">#core-ai channel</a> of the <a href=\"https://make.wordpress.org/chat/\">WordPress.org Slack</a>!</p>\n\n\n\n<p class=\"has-text-align-right\"><em>Featured image credit: <a href=\"https://creativecommons.org/publicdomain/zero/1.0/\">CC0</a> licensed <a href=\"https://wordpress.org/photos/photo/8456505dd5/\">photo</a> by <a href=\"https://www.nilovelez.com/\">Nilo Velez</a> from the <a href=\"https://wordpress.org/photos/\">WordPress Photo Directory</a>.</em></p>\n<p>The post <a href=\"https://jonathandesrosiers.com/2025/06/wordpress-grab-bag-wceu-wordpress-turns-22-new-ai-team/\">WordPress Grab Bag: WCEU, WordPress turns 22, new AI team</a> appeared first on <a href=\"https://jonathandesrosiers.com\">Jonathan Desrosiers</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Jun 2025 11:32:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Jonathan Desrosiers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"Tammie Lister: Optimising Triage and Review Processes in WordPress Using AI\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://binatethoughts.com/?p=1826\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://binatethoughts.com/optimising-triage-and-review-processes-in-wordpress-using-ai/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7538:\"<p>Integrating advancements into open source processes makes sense. The friction often comes in the how and the usefulness. While AI holds immense potential for revolutionising triage and review processes, it&#8217;s crucial to acknowledge its current limitations and look to where it can evolve, learn, and grow to its full capacity. This post aims to explore this potential, offering a realistic perspective. It&#8217;s not a post that claims to solve everything; instead, it will show how we can get started and regain some hours to focus on other needed areas of the project.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img alt=\"\" class=\"wp-image-1827\" height=\"1024\" src=\"https://binatethoughts.com/wp-content/uploads/2025/06/openart-38ad7cab-43e0-4eed-be32-4d7835b68423.png\" width=\"1024\" /></figure>\n\n\n\n<p>Before we delve into this topic, it&#8217;s important to note that while AI can achieve a great deal, it also has its limitations. This post will focus on high-level inferences rather than direct proposals, starting with small steps. I don&#8217;t have all the answers, but together, we can find them. My perspective is informed by extensive theme reviews and ongoing triage work, so I won&#8217;t cover areas where I lack knowledge.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What can it do today</h2>\n\n\n\n<p>In simple terms, the things we likely shouldn&#8217;t be doing manually include reviews, first-pass triage, testing and routine checks. Historically, there have been areas where we have been slowly adding more processes over time before the term AI was widely used. That&#8217;s one of the key things: often, having a robust process, a path trodden and documented, means the parsing is simple to learn, and therefore you can hand it over more easily.</p>\n\n\n\n<p>Triage is already being done incredibly effectively in areas like healthcare. There it is improving accuracy and saving lives, as noted in an article by Reuters:</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>&#8220;Our study provides the first multinational evidence that artificial intelligence can help enhance accuracy&#8221; in determining HER2 clinical categories, &#8220;potentially closing critical diagnostic gaps and enabling more patients to have access to new therapies, said Dr. Marina De Brot of the A.C. Camargo Cancer Center in Sao Paulo, Brazil, who led the study.<br />&#8220;Until recently, most of these patients would have not been offered these options,&#8221; she said.&#8221;<br /><a href=\"https://www.reuters.com/business/healthcare-pharmaceuticals/health-rounds-amgen-blood-platelet-booster-helps-patients-who-need-chemotherapy-2025-05-30/?utm_source=chatgpt.com\">Link</a>: Reuters</p>\n</blockquote>\n\n\n\n<h2 class=\"wp-block-heading\">A triage first-pass</h2>\n\n\n\n<p>The first area is improving first-pass triages. What do I mean by this? In simple terms, doing a lot of the manual work like duplicate label removal, closing after a specific time, checking for details and even duplicate issue detection. Pattern-matching tasks are where these systems excel, and a lot of this is simply a matter of pointing to our learnings during triage and matching them accordingly.</p>\n\n\n\n<p>This is basic; it&#8217;s not AI as much as it&#8217;s processing. It&#8217;s one step above issue templates. The following piece is where it gets interesting: the model for triage needs to learn comprehension of the issue contents. We need to add features like dashboards to the flow because the first stage could be a catch-all that, over time, allows it to triage more to a buffer dashboard, recommending specific states. </p>\n\n\n\n<p>All of these approaches are an excellent way of training, as it provides the model with some freedom to make mistakes, be corrected, learn from them, and refine its patterns. We also collectively don&#8217;t have to worry about labels being added and things closed. Whilst those of us doing triage, get to benefit early on and help train.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The impact of triage processing</h2>\n\n\n\n<p>As far as triage goes, we will be far from achieving full automation of this for quite some time. My instinct is that this is more of a help in clearing a percentage and making it easier for those working on issues. It can do that in significant numbers, to the extent that over 50% of the time spent in triage could be recovered I&#8217;d suggest sooner over later. I do see this going up over time, but how much depends on the quality of the modelling and our trust as a project.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Theme review first-pass</h2>\n\n\n\n<p>Just as triage, I suggest adopting a similar model for theme reviews. In this case, too, if we are honest, reviewing what we do and don&#8217;t want in reviews would be beneficial. I will be bold here, but nearly 100% of theme reviewing could be done through a process without manual interaction fairly soon.</p>\n\n\n\n<p>How do we get there? We achieve this through a balance of reviewing the theme review guidelines and, similarly, triage training. These reviews are very formulaic and matching. This is what models thrive on. Suppose we gain trust in this approach and implement the process. In that case, we can then focus all our effort on manual reviewing in various areas, including raising the quality of the core product, documentation, education, and our theme offerings as a project.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Testing</h2>\n\n\n\n<p>We have, over the years, even before the recent AI tech wave, been leaning into less manual testing. Issues and tickets needed less manual testing. We require testing for regression across all areas in our project. That&#8217;s not AI, but we can take it even further, adopting a more updated approach to our testing.</p>\n\n\n\n<p>The reality of the world today is that you can share a screenshot with code editors and get an application mocked up that looks like that. We also need to evolve our systems to test for differences and minimise the need for multiple humans to be involved in each ticket.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What will we do if it does this?</h2>\n\n\n\n<figure class=\"wp-block-image size-full\"><img alt=\"\" class=\"wp-image-1829\" height=\"1024\" src=\"https://binatethoughts.com/wp-content/uploads/2025/06/openart-48c1cda1-444d-40e3-89b1-5d046bc4143f.png\" width=\"1024\" /></figure>\n\n\n\n<p>I share these perspectives as someone who performs triage and frequently engages in this manual work. Some may be sceptical or wonder how their sponsored time will be allocated. The point is that there is a great deal that needs to be done in this project. These systems to implement today&#8217;s technology need people. The models require training by experts. Then they need to be nurtured and grown by those same people. There will always be a need for contributors.</p>\n\n\n\n<p>At this time, with our capabilities in automation and AI in a world of agentic flows, we can do better than relying solely on manual processes. We must do so in order not to be left behind. It is also not resourceful to use humans this way. We can use our scarce human resources more sensibly. Our time is finite, and this project requires us to accomplish many tasks. There will be a balance between what we automate and utilise as resources and what we provide to a system. That, though, is something we need to start working out, and we do that by realising we need to find a balance in how we do things and measure the costs of our processes today and in the future.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 01 Jun 2025 12:42:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"binatethoughts.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"Do The Woo Community: Building Reliable WooCommerce Sites: Insights into Hosting, Scaling, and Workflow\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://openchannels.fm/?post_type=blog&p=97002\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"https://openchannels.fm/building-reliable-woocommerce-sites-insights-into-hosting-scaling-and-workflow/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:222:\"Shared strategies to ensure reliable WooCommerce performance during traffic spikes, emphasizing standardized processes, trusted hosting partnerships, and automated testing to foster client trust and ease agency operations.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 May 2025 12:38:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Bob Dunn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:126:\"Do The Woo Community: Launching Upload Worthy: Video Strategy, Brand Awareness, and Conversions for WordPress Product Creators\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://openchannels.fm/?p=97496\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:126:\"https://openchannels.fm/launching-upload-worthy-video-strategy-brand-awareness-and-conversions-for-wordpress-product-creators/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:229:\"The inaugural episode of \"Upload Worthy\" explores video marketing strategies with hosts Christian Taylor and Adam Weeks. They discuss timing for video investment, brand awareness versus conversions, and measuring content success.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 May 2025 09:57:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Bob Dunn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"WordPress Foundation: Thank You, Automattic: Announcing the Open Horizons Scholarship\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"https://wordpressfoundation.org/?p=1201015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"https://wordpressfoundation.org/news/2025/thank-you-automattic-announcing-the-open-horizons-scholarship/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1467:\"<p>We’re thrilled to announce the Open Horizons Scholarship, a new initiative to help contributors from underrepresented regions attend flagship WordCamp events, made possible through a generous $30,000 donation from Automattic to the WordPress Foundation.</p>\n\n\n\n<p>Thank you, Automattic, for funding this important work. Your support expands opportunities for contributors around the world to participate in person, starting with WordCamp US 2025.</p>\n\n\n\n<p>The scholarship will be managed by the WordPress Foundation, which will oversee the application and selection process and ensure that funds are distributed equitably. This new program joins the Kim Parsell Memorial Scholarship and the Diversity Scholarship by WordPress Community Support, reinforcing a shared commitment to a more inclusive and globally representative WordPress community.</p>\n\n\n\n<p>If your company believes in a more diverse, open, and accessible web, we invite you to join us. Support a scholarship. Sponsor a contributor. Help build the future of WordPress, together</p>\n\n\n\n<p><strong>Interested in applying?<br /></strong><a href=\"https://automattic.survey.fm/open-horizons-scholarship\">Apply for the Open Horizons Scholarship</a> and take your next step toward joining the flagship WordCamp experience. To learn more, you can read <a href=\"https://automattic.com/2025/05/28/automattic-open-horizons-scholarship/\">Automattic’s full announcement</a> about the program.</p>\n\n\n\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 28 May 2025 19:28:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Isotta Peira\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"WPTavern: #171 – Felix Arntz on How Speculative Loading Is Speeding Up Your WordPress Website\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=196101\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"https://wptavern.com/podcast/171-felix-arntz-on-how-speculative-loading-is-speeding-up-your-wordpress-website\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:60964:\"<details>Transcript<div>\n<p>[00:00:19] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress, the people, the events, the plugins, the blocks, the themes, and in this case, how speculative loading is speeding up your WordPress website.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured. On the show. Head to wptavern.com/contact/jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today we have Felix Arntz. Felix is a Senior Software Engineer at Google, and a WordPress Core contributor from Germany, currently residing in San Francisco, California. He helped establish the WordPress Core performance team, and has been heavily contributing to its efforts. He has been using WordPress for a decade and contributing back to the project since 2015. More recently, he has stepped into the role of the inaugural performance lead for the WordPress 6.2 release, and subsequently of the 6.3 and 6.8 releases. In the latter release, he spearheaded development, and launch, of the new speculative loading feature, which is the focus of the podcast today.</p>\n\n\n\n<p>Speculative loading is one of the most important, and yet, almost invisible performance enhancements of recent times. If you&#8217;re on WordPress 6.8, this new feature is already active on your site, working quietly in the background to make page navigation faster, but you might never know from the WordPress UI. There&#8217;s no menu, no toggle, and no obvious indicator to show it&#8217;s there.</p>\n\n\n\n<p>Felix explains exactly what speculative loading is and why it feels almost like browser magic. The Ability for WordPress, using the browser&#8217;s new Speculation Rules API to load the next page just as the user is about to visit it. It&#8217;s a clever use of browser signals like mouse clicks, and hovers, to anticipate navigation, shaving off precious milliseconds, sometimes even providing what feels like an instant page load.</p>\n\n\n\n<p>Felix clarifies the difference between conservative and more aggressive approaches to speculative loading. And why the WordPress core team opted for the safest, least wasteful, option by default, while still giving developers or advanced users the hooks and tools to customize, or even disable it, as needed.</p>\n\n\n\n<p>Felix discusses the origins of the feature as a plugin, the testing and data collection undertaking with tens of thousands of sites, and how this real world data gave the team confidence to ship speculative loading to all WordPress users. We talk about what those performance wins mean at scale, how a 2% improvement on 43% of the internet translates into saving users untold hours of waiting collectively.</p>\n\n\n\n<p>We also get into the weeds on measurement and methodology, how the team uses data from the Chrome user Experience Report and HTTP Archive to track web performance, prioritize features, and validate real world impact. Felix offers insights into how these global, anonymized data, sets allow the performance team to make truly data-driven decisions.</p>\n\n\n\n<p>Beyond the tech, Felix addresses practical considerations such as how to opt out or fine tune speculative loading if you have specific needs. How environmental concerns are balanced by default configurations. And how plugins or agencies might build on this foundation in the future.</p>\n\n\n\n<p>If you&#8217;ve ever wondered how large scale browser level improvements make their way into WordPress Core, or simply want to know if there&#8217;s a way to make your own WordPress site that much faster, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Felix Arntz. I am joined on the podcast by Felix Arntz. Hello, Felix.</p>\n\n\n\n<p>[00:04:46] <strong>Felix Arntz:</strong> Hey. Happy to be here.</p>\n\n\n\n<p>[00:04:47] <strong>Nathan Wrigley:</strong> Yeah, thank you. I appreciate you joining us. Felix is joining us all the way from California. I&#8217;m in the UK so there&#8217;s a big time gap. And I appreciate you getting up early and talking to me. That&#8217;s fantastic.</p>\n\n\n\n<p>Felix is going to be talking to us today about something which is now in WordPress, and you may not even know that it&#8217;s in there because there&#8217;s nothing to see here. But the endeavor of what Felix has built is to make all WordPress websites basically immediately better. More performant, so that the end users of your websites will be able to access your content more quickly.</p>\n\n\n\n<p>It is something that&#8217;s really fascinating. But before we begin digging into all that, I know it&#8217;s a dreadfully banal question, Felix, but would you just tell us who you are so that people understand your credentials in the WordPress space?</p>\n\n\n\n<p>[00:05:32] <strong>Felix Arntz:</strong> Sure. Thank you. I have been contributing to WordPress now for 10 years. So I started as a freelancer building websites using WordPress, and eventually got into contributing to WordPress Core after I went to my first WordCamp, which was a great way to get started.</p>\n\n\n\n<p>Yeah, ever since then I&#8217;ve been contributing to WordPress Core, and eventually became a Core Committer. And now, for over six years, I&#8217;ve been working at Google, the team where we focus on CMS projects for the most part. So I&#8217;ve been, especially in the last good three years or so, I&#8217;ve been sponsored by Google to contribute to WordPress with a specific focus on improving performance.</p>\n\n\n\n<p>So our team essentially co-founded the WordPress performance team, which is an official part of the wordpress.org project. And ever since that was founded in late 2021, we&#8217;ve been contributing to that effort, and the speculative loading feature is a big part of that.</p>\n\n\n\n<p>[00:06:25] <strong>Nathan Wrigley:</strong> That&#8217;s what we&#8217;re going to talk about today. Can I just rewind a little bit though, and talk about Google for a minute. So, are you employed by Google to commit to WordPress Core? Do you spend a hundred percent of your time working on WordPressy things, or do you have a proportion of your time which is devoted to more, and I&#8217;m doing air quotes, Google things?</p>\n\n\n\n<p>[00:06:46] <strong>Felix Arntz:</strong> Yeah, I mean, I wouldn&#8217;t say that I contribute a hundred percent of my time, but a good chunk, probably 70, 80 or something. Our focus is, when it&#8217;s not on WordPress, it&#8217;s still on other somewhat related open source projects. So we have been contributing, we&#8217;ve been also working with other CMSs here and there.</p>\n\n\n\n<p>[00:07:02] <strong>Nathan Wrigley:</strong> Yeah, that&#8217;s interesting because I know that Google have a big presence. If you go to the flagship WordPress events, you know, WordCamp Asia, WordCamp US, and so on, then Google very often have a huge advertising booth. You know, they&#8217;re a global partner if you like.</p>\n\n\n\n<p>But drawing the line between Google and Open Source CMS is a little bit hard to do. It&#8217;s almost like a philanthropic thing. Because I guess their job is to just try and make the internet better and part of it, if they can make 43% of the internet better by seconding somebody like you to commit to the project, that&#8217;s just good for everybody.</p>\n\n\n\n<p>So yeah, bravo to Google. I appreciate the fact that they&#8217;re sponsoring you and helping the project in that way.</p>\n\n\n\n<p>Also bravo to you and the team, the Performance Team. It is just a relentless good news story coming out of the Performance Team. So, I don&#8217;t know, when did you say, 2019 it was founded?</p>\n\n\n\n<p>[00:07:54] <strong>Felix Arntz:</strong> Late 2021, but things really kicked off like mid 2022 I feel.</p>\n\n\n\n<p>[00:07:58] <strong>Nathan Wrigley:</strong> Yeah, and I am habitual about the WordPress news, and it just never stops. The Performance Team do something profound, help everybody out, it just ships into Core. Most people don&#8217;t even know that things have happened because, you know, they&#8217;re not in the baseball in the same way that you and I probably are.</p>\n\n\n\n<p>A profound thanks. Maybe there was just this massive backlog of things that needed to be tackled. Maybe not. But it did seem that the minute the doors opened to the Performance Team, lots of dominoes fell really quickly.</p>\n\n\n\n<p>So thank you on behalf of me and everybody who uses WordPress for the work that, I don&#8217;t know whether you feel that you get the credit that&#8217;s due to you, but I&#8217;m giving you some credit now, so thank you.</p>\n\n\n\n<p>[00:08:37] <strong>Felix Arntz:</strong> Thank you. I appreciate it. That&#8217;s definitely great to hear.</p>\n\n\n\n<p>[00:08:39] <strong>Nathan Wrigley:</strong> I&#8217;m pleased you know, that there&#8217;s people as capable as you who are doing this kind of work and that you&#8217;re willing to do it in the background. And a big piece of that is what we&#8217;re going to talk about today.</p>\n\n\n\n<p>Landed in WordPress 6.8, but has a history prior to that as a plugin. It&#8217;s called speculative loading. It sounds impressive. But it also, I guess it is impressive and it&#8217;s a bit like voodoo. It&#8217;s kind of doing things that you wouldn&#8217;t imagine were possible. Do you want to just tell us what it is? What is speculative loading?</p>\n\n\n\n<p>[00:09:08] <strong>Felix Arntz:</strong> So essentially, speculative loading, the idea is that when you navigate to a new URL, when you are browsing through a website and you go to a URL, the moment that you land on the URL, it starts loading. And we probably know that the performance aspect of that is very important to the user experience.</p>\n\n\n\n<p>So if a page takes, I don&#8217;t know, three seconds to load, that&#8217;s not great. If it takes eight seconds to load, it&#8217;s probably horrible of a user experience. And so one of the performance team&#8217;s goals is to make that time that it takes a load shorter. So what then speculative loading does is load the URL, the idea is that it loads the URL before you even get there.</p>\n\n\n\n<p>[00:09:47] <strong>Nathan Wrigley:</strong> Yeah, that&#8217;s the bit that&#8217;s voodoo. That&#8217;s the bit that just sounds like you&#8217;ve basically hopped into Back to the Future and you&#8217;ve gone back in time a moment or something. It&#8217;s very counterintuitive. So you are going to have to explain, how on earth does it do that?</p>\n\n\n\n<p>[00:09:59] <strong>Felix Arntz:</strong> Right, right. Essentially, there are browser, there are heuristics which can be relied upon to hopefully assume correctly that a URL will be visited. So when you are on a page on the website, there is of course links to other pages on the website. So if you hover over the link with your mouse, if you&#8217;re on a computer for instance, and you hover over the link with your mouse, maybe you&#8217;ll click it. That&#8217;s like one level of signal. It&#8217;s not the strongest signal.</p>\n\n\n\n<p>But then an even stronger signal is when you actually click the link. When you click a link, you want to go to that URL. I think that&#8217;s a fair assumption in like 99 plus percent of cases. So when you click on the link, that&#8217;s technically still before you&#8217;re at the other URL though. We&#8217;re talking about milliseconds. You probably think when you click, you are already on the other URL, but that&#8217;s not the reality. There is like maybe, I don&#8217;t know, 200, 300, 500, however long it takes, there are some milliseconds in between the time you actually click and that the other URL opens.</p>\n\n\n\n<p>So by loading, for instance, by loading a URL, when you click on the link, you still gain those, whatever, maybe 500 milliseconds. I&#8217;m just going to make that up now, and reduce the actual load time by that.</p>\n\n\n\n<p>[00:11:07] <strong>Nathan Wrigley:</strong> Let me just prize that apart. So we are now going to talk about a tiny fraction of time. For the next few minutes, we&#8217;re going to be talking about literal milliseconds. So let me imagine that I&#8217;m on my computer, desktop computer, let&#8217;s start there. I&#8217;m on a webpage and there&#8217;s a bunch of links, buttons, what have you.</p>\n\n\n\n<p>I&#8217;m holding my mouse, my mouse approaches the button and it begins to slow down, you know, because at some point we have to rest on the button. So there&#8217;s this deceleration of the mouse and the cursor, and it eventually lands there. And then I click it.</p>\n\n\n\n<p>Now my intuition is that the click event is the moment, that&#8217;s when everything begins, if you know what I mean. But are you saying that you can go back in time prior to me actually hitting the button with my finger? Is it the mere fact that, okay, the mouse has come to a standstill, you haven&#8217;t engaged the finger yet. Maybe the finger is literally on the way down in the real world, in this slow motion universe we&#8217;re imagining. Is that kind of it? It&#8217;s taking heuristics about, where is the mouse now? How is it decelerating? Or is it literally he clicked? Because if it&#8217;s the click bit, then I don&#8217;t understand what&#8217;s different to how it usually was because it felt like the click was always the moment.</p>\n\n\n\n<p>[00:12:19] <strong>Felix Arntz:</strong> There are different ways to configure speculative loading. And one way, and that&#8217;s the way that WordPress Core does now, is to only speculatively load on the click. You say now that that feels like it&#8217;s always been like that, but it&#8217;s not quite always been like, that because of what I tried to mention with there&#8217;s still like 500, maybe 300, whatever, little milliseconds time between the click and the actual URL loading.</p>\n\n\n\n<p>So when you hit the other URL, then it starts fetching the HTML document and all the CSS and JavaScript and so on. By doing that already on the click, on the link, on the previous page that you are on, you still gain those, I&#8217;m going to say valuable milliseconds. And we&#8217;re probably talking about at the very least, a hundred milliseconds, maybe a few hundred milliseconds.</p>\n\n\n\n<p>[00:13:04] <strong>Nathan Wrigley:</strong> It doesn&#8217;t sound like a lot, but it&#8217;s, you&#8217;ve invented time out of nowhere. You&#8217;ve completely conjured up time that didn&#8217;t, well, actually you&#8217;ve removed time. You&#8217;ve gone in the opposite direction. But that time was needlessly spent before. Now that time has been saved.</p>\n\n\n\n<p>You also mentioned that the WordPress implementation, and we&#8217;ll get into how you might be able to configure that in a moment, but the default WordPress installation, so this is in every WordPress website from 6.8 onwards, it is set to, and I&#8217;m going to use the word conservative, but it&#8217;s set to a fairly dialed back approach to this Speculation Rules API.</p>\n\n\n\n<p>I&#8217;m curious, and we&#8217;ll get into how you do it in WordPress, but just in terms of the Speculation Rules API, what are some of the more aggressive things that you could do if you wanted to? And is things like the mouse slowing down, is that potentially part of it? Those kind of things.</p>\n\n\n\n<p>[00:13:55] <strong>Felix Arntz:</strong> Right. So maybe let me take a step back, first to clarify that there&#8217;s a speculative loading feature that is in WordPress Core, it&#8217;s built on a browser API that is called Speculation Rules API. We can talk about maybe two things. There&#8217;s like, well, how can you use the Speculation Rules API? There&#8217;s different ways to configure it, and that&#8217;s something that we could apply in WordPress. But then we could go beyond that, and I&#8217;m probably not the best person to speak about that, but we could also think, how can you actually, what could the Speculation Rules API possibly do, that it isn&#8217;t able to do today?</p>\n\n\n\n<p>So in terms of using the Speculation Rules API, it allows different configuration modes in for what is called eagerness. And you actually said it right. It&#8217;s called conservative, the mode that WordPress currently uses. And it just means, I think it is conservative in the sense that it is the safest measure if you want to make sure you only load URLs that the user actually goes to.</p>\n\n\n\n<p>But it&#8217;s also the least performance of all the options. It&#8217;s always a trade off because unfortunately we cannot predict the future, so there&#8217;s no real wizardry going on here. And because of that, there is always going to be a trade off. You can use signals that are very reliable on the user visiting the other URL, like clicking on the link. There is an scenario where you click a link and then you pull your mouse away before you let go of your finger. We probably all have done this, but we probably do this like 1% of our clicks, if even that. But people do this occasionally, very occasionally.</p>\n\n\n\n<p>So that&#8217;s the way where a click would not trigger the actual URL to the link to be, that wouldn&#8217;t result in the user visiting the other URL. This would be the one example where conservative speculative loading would still load the other URL and the user wouldn&#8217;t go to it. But I think that risk, that trade off is very, very little because of how rarely that happens.</p>\n\n\n\n<p>[00:15:46] <strong>Nathan Wrigley:</strong> Right, so the posture of the Performance Team was to go conservative. So although it&#8217;s not the most performant, it is the least likely to end up in, you know, needlessly downloading content that is perhaps never going to be looked at.</p>\n\n\n\n<p>But again, just moving ourselves away from WordPress for a minute, the Speculation Rules API, if we were to go on the more eager side, what kind of things could be brought to bear? And again, not in the WordPress setup at the moment, but I know that you can modify those things. But what can the Rules API do, if you go like full eager?</p>\n\n\n\n<p>[00:16:18] <strong>Felix Arntz:</strong> Right. So you can also use, the next after conservative is called moderate. That uses signals that are less explicit, like a hover. Again, I have to specify, on desktop it uses hovering, because on the phone you can&#8217;t hover, like you don&#8217;t have a mouse and it doesn&#8217;t know where your finger is if you don&#8217;t press the screen.</p>\n\n\n\n<p>So, essentially, moderate on desktop, it relies on the hover over a link to preload the URL that is behind that link. So that generally, yeah, of course if you hover over link and then you click it, there may be like a second, easily a second between this, or there may even be five seconds in between those two actions, right? And sometimes you hover and click immediately. Other times you hover and you get back there, and then you click, and in that case, the whole page can technically be already loaded.</p>\n\n\n\n<p>So that&#8217;s the part where speculative loading, if you configure it more eagerly, you can get to situations where you get instant page load. You go to the other page and it&#8217;s already completely loaded. There&#8217;s, for instance, there is also Core Web Vitals, metric Largest Contentful Paint, which measures the load time speed. So you can get to an LCP of zero. Like, literally. If you use it, for instance as moderate eagerness, let&#8217;s say your page normally takes two seconds to load completely, and you hover over a link, and then you get back there like three seconds later, you click, it&#8217;s already there, and your LCP is literally zero because you didn&#8217;t need to wait at all.</p>\n\n\n\n<p>That&#8217;s the performance power that it has. But of course, it does also come with a trade off to consider. Like, how do you configure this in a way that it&#8217;s the least wasteful? And wasteful in the sense of loading URLs that the user does not go to, ends up not navigating to. But you have to basically weigh off, what is the performance gain? How do users typically use your website?</p>\n\n\n\n<p>There&#8217;s also, there&#8217;s a lot of individual configurations that websites may want to do on their specific site. So going back to the conservative option that WordPress now uses, it&#8217;s just that, it&#8217;s simply that we want to give the bare minimum feature and we want to make the feature available in general to WordPress sites. But because WordPress is so massive, you need to go with a literally conservative default.</p>\n\n\n\n<p>[00:18:25] <strong>Nathan Wrigley:</strong> Okay. So that&#8217;s all really interesting, but it sounds like all of this is happening in the browser. So all of these events are being triggered by the browser. Again, forgive my ignorance, I&#8217;m presuming that Chromium, Chrome, Firefox, all of the other variants that there may be out there, I guess they&#8217;re all shipping some variant of this inside the browser because obviously it can&#8217;t be WordPress that&#8217;s doing this.</p>\n\n\n\n<p>If that&#8217;s the case, is there kind of like a broad consortium of people who are working on this initiative, maybe other similar related performance initiatives, and trying to make them all browser compatible?</p>\n\n\n\n<p>[00:19:03] <strong>Felix Arntz:</strong> So there is, the Speculation Rules API is currently, it&#8217;s available in Chrome, Edge and Opera, so in the Chromium based browsers, but it&#8217;s not available yet in Safari and Firefox. That means that people that use Safari or Firefox, they&#8217;re basically just not going to get the benefit.</p>\n\n\n\n<p>[00:19:18] <strong>Nathan Wrigley:</strong> So it&#8217;s like a progressive enhancement. There&#8217;s no downside, it&#8217;s just an upside.</p>\n\n\n\n<p>[00:19:22] <strong>Felix Arntz:</strong> Exactly. So because overall the browsers that support it are very widely used, plus the other browsers not having any negative effects of this feature being on a website, that&#8217;s why we thought it was a good time to roll it out.</p>\n\n\n\n<p>[00:19:36] <strong>Nathan Wrigley:</strong> Okay, that&#8217;s really interesting. It just suddenly, and completely unrelated to the conversation that we&#8217;ve had so far, it kind of makes me think that maybe in the future there&#8217;ll be a hardware layer to this. You know, imagine if my mouse had built into it some pressure sensation, or even proximity sensor where it could perceive that, you know, my finger is descending and it could fire the signal from the mouse to say, yeah, he&#8217;s about to click. Or even in a mobile phone, you know, you were mentioning earlier, we don&#8217;t know where your finger is. Maybe at some point in the future we will know where your finger is.</p>\n\n\n\n<p>[00:20:09] <strong>Felix Arntz:</strong> That would be really powerful, yeah.</p>\n\n\n\n<p>[00:20:10] <strong>Nathan Wrigley:</strong> It&#8217;d be kind of interesting. Okay, you heard it here first. But it&#8217;s not there yet. So, what has been the way that this has been implemented? My understanding is that you launched this as a plugin. I think you got a fairly high user account. I think 30,000, 50,000 or something websites.</p>\n\n\n\n<p>[00:20:27] <strong>Felix Arntz:</strong> I think it&#8217;s now at 50,000.</p>\n\n\n\n<p>[00:20:28] <strong>Nathan Wrigley:</strong> 50,000. So tons of data coming back. And presumably that data gave you the confidence to, yeah, let&#8217;s push this through. And I have a memory that, broadly speaking, you got fairly close to a 2% productivity gain. And obviously at 43% of the web, if we can do things 2% faster, doesn&#8217;t sound like a lot, 2%. But 2% of everything that WordPress gives up, that&#8217;s a lot.</p>\n\n\n\n<p>[00:20:53] <strong>Felix Arntz:</strong> Performance is really like, people say sometimes things are numbers games, but performance is a tiny numbers game. Like it&#8217;s very hard to make performance wins sound very appealing. It&#8217;s like, here is 2% win. We scratched off 80 milliseconds of this, and it&#8217;s like, what is this even, like.</p>\n\n\n\n<p>[00:21:08] <strong>Nathan Wrigley:</strong> But it literally is human years. It&#8217;s probably decades of time when you think about the internet as a whole. If you think about it in that sense, it&#8217;s really quite a lot of time.</p>\n\n\n\n<p>[00:21:18] <strong>Felix Arntz:</strong> Exactly, and I think it&#8217;s important to remind ourselves of that sometimes. I feel myself like announcing something where it&#8217;s like, oh, here we scratched 80 milliseconds off. It sounds like nothing. It is quite something, but it sounds like so little that, I don&#8217;t know, I feel self-consciously saying such a tiny number as a great win.</p>\n\n\n\n<p>But yeah, again, like I think it, you exactly mentioned it, the scale of rolling out performance enhancements like this, it really makes the number matter. And also, people browse so many webpages a day, like even for an individual person. If you go on one website, you easily might visit 10 URLs or more, and that&#8217;s just one website. So think about , again, I&#8217;m just continuing with that number, like if you had 80 milliseconds gain on all the webpages you visit in a day, I don&#8217;t know, it might come out at some seconds, maybe a minute, who knows. And if you do that every single day, like you gain time.</p>\n\n\n\n<p>[00:22:09] <strong>Nathan Wrigley:</strong> Yeah, I agree. It&#8217;s difficult to parse, isn&#8217;t it? The human brain doesn&#8217;t kind of work that microscopic level. That really tiny fraction of time is so difficult to become important. But there&#8217;s this compound interest effect to it. You know, the more that it adds up, the more time you spend on the internet every day clicking things. And I suppose the curious thing here is, nobody even knows that it&#8217;s happened. You would presumably just think, gosh, that is a very quick website. You know, I&#8217;m having a fabulous experience here. Everything&#8217;s loading amazingly. They must have an amazing server set up or, you know, they&#8217;ve got everything configured perfectly. And all the while it&#8217;s the Speculation Rules API working in the background.</p>\n\n\n\n<p>But I think we&#8217;ve got it, you know, it&#8217;s adding up to tons of time, probably years, maybe decades of time when you throw that across the whole footprint that WordPress have.</p>\n\n\n\n<p>However, most people who don&#8217;t follow the WordPress news really, really carefully probably won&#8217;t know about this. And there&#8217;s nowhere to know about it really, apart from WordPress journalism, and the blog posts that go out from the Performance Team. Because there&#8217;s no way in the WordPress UI, there&#8217;s no setting, there&#8217;s no menu item to go to, there&#8217;s no toggle, there&#8217;s none of that.</p>\n\n\n\n<p>So that then leads me to ask, is there a way to modify this? If you have a need for more eager. Or you just wish to, I don&#8217;t know, you&#8217;ve got a desire to turn it off for some reason. Can it be modified with code, with hooks, with whatever?</p>\n\n\n\n<p>[00:23:31] <strong>Felix Arntz:</strong> Yeah, certainly. Quick context on the reason that there is no UI in WordPress Core to control it, is that it&#8217;s considered a very technical feature, and the philosophy of WordPress Core says, decisions not options. That&#8217;s one of the Core philosophies. So try to use defaults that work for the majority, and most people won&#8217;t have to change. And then especially when it comes to very technical things, you don&#8217;t want to bother an end user that just wants to maintain, create their website with, here you need to learn now about this complex Speculation Rules API.</p>\n\n\n\n<p>Like, we already talk about this for like 30 minutes now, and there&#8217;s probably so much more to uncover. So you can imagine that certain site owners don&#8217;t want to deal with that. So that&#8217;s why there&#8217;s no UI in WordPress Core. But it can be modified through hooks like you&#8217;re saying. There are several filters and actions to modify the behavior programmatically.</p>\n\n\n\n<p>And in addition, the Speculative Loading plugin that existed prior to the Core launch, that still exists and it&#8217;s now, when you install it on top of 6.8, it still serves a purpose. While it doesn&#8217;t ship the whole API anymore, because that&#8217;s now part of WordPress Core, it&#8217;s still includes a UI where you can configure it via UI in different ways.</p>\n\n\n\n<p>And it also changes the default behavior of WordPress, for the speculative loading feature. And that&#8217;s essentially because when we started the plugin, we went with a more aggressive default, because we want to know, the plugin only launches at first at small scale, it&#8217;s meant to, especially in the case of a feature plugin, it&#8217;s meant to inform us about how well it&#8217;s working, are there potential issues, and so on.</p>\n\n\n\n<p>So we went with a more more performant configuration out of the box with the Speculative Loading plugin. So if you use the plugin, it will use the moderate eagerness that I mentioned before. And then in addition, it uses, and we haven&#8217;t covered that at all yet, so it pre-renders the URL. So I can explain that briefly.</p>\n\n\n\n<p>The WordPress Core implementation, the Speculation Rules API allows you two alternative modes for speculatively loading a URL. Either you can pre-fetch the URL, or you can pre-render the URL.</p>\n\n\n\n<p>Pre-fetching means you essentially just load the, you get the HTML content already, but then you don&#8217;t do anything else. Like, it doesn&#8217;t load any JavaScript or it doesn&#8217;t load any CSS or images, it still waits with all of that until you go to the other page.</p>\n\n\n\n<p>With pre-render, it does everything, like literally everything. It loads the HTML, it loads also all the JavaScripts, CSS, images and whatever else is on your page. And it even renders this in the browser, like it basically does everything as if you were already on the page in the browser. Let&#8217;s think about it as if you had the page open in another tab and you couldn&#8217;t see it.</p>\n\n\n\n<p>[00:26:08] <strong>Nathan Wrigley:</strong> Yeah, you&#8217;ve just like pulled back a curtain suddenly and there it is. It&#8217;s just, it always there. You just couldn&#8217;t see it and suddenly.</p>\n\n\n\n<p>[00:26:14] <strong>Felix Arntz:</strong> And the pre-rendering is the thing that can get you to those immediate page loads. Because when you use pre-fetching, it only loads the HTML, so then when you get to the page, it&#8217;ll be faster, but you still have to load all the other things, and render it. But pre-render is where, if you have pre-render and eagerness of moderate, and then we go back to our previous example, you hover over link, go back there, two seconds, three seconds later, then you might get this immediate page load with LCP zero.</p>\n\n\n\n<p>[00:26:43] <strong>Nathan Wrigley:</strong> Okay, that&#8217;s really interesting. So you&#8217;ve kind of got two options. The first option is just accept WordPress Core. That&#8217;s how it is. And then, maybe three options. The second option then might be you can modify things with hooks and what have you. And I&#8217;m going to link to the articles that Felix wrote in the blog post that goes with this. So go to wptavern.com and search for the episode and you&#8217;ll be able to find all the bits. It&#8217;s more easy for me to say that than it is to read out the blog titles and things.</p>\n\n\n\n<p>And then the other option, the third option would be to download the plugin, which gives you a UI, but just caveat emptor, beware, it will then automatically make things moderate. It&#8217;s going to be doing things in a more, a slightly more aggressive way.</p>\n\n\n\n<p>[00:27:21] <strong>Felix Arntz:</strong> It brings you better performance, but it might also have more trade offs on, it will load, certainly to some capacity, load URLs that may not be navigated to. If you install the plugin, just keep in mind that the UI that it provides also would allow you to go back to the WordPress Core default. If you just want a UI and you install the plugin, just go into the UI of the plugin immediately, change it back to conservative pre-fetch, and you&#8217;re back at what Core would do as well.</p>\n\n\n\n<p>[00:27:45] <strong>Nathan Wrigley:</strong> Great. Yeah, thank you. Now you mentioned LCP and things like that. And I think there&#8217;s been an obsession for the last, let&#8217;s go for four years, with speed and trying to get Lighthouse scores to be impressive for your website. I&#8217;m curious, is there a way that Google scraping the internet can perceive any of this?</p>\n\n\n\n<p>In other words, if you do this, are you doing it simply to make your visitors happy, because they&#8217;re the people who are doing the clicking or what have you? Or is there some like Core Web Vitals metric which can be improved by this? Because it feels like there couldn&#8217;t be, because I doubt that Google Bot has the capacity to kind of speculatively load anything, but maybe there&#8217;s some flag in the, I don&#8217;t know, I have no idea how that would work.</p>\n\n\n\n<p>[00:28:31] <strong>Felix Arntz:</strong> So, that&#8217;s a great question. I think you&#8217;d, certainly when you apply performance enhancements like this, the goal is that they benefit your website&#8217;s end users. Google, of course, would love to know how well these features work, right? And also the people that work on the actual Speculation Rules API would love to see how the features are used in production, on production sites. And we, as a Performance Team, would also like to know that, how it goes with WordPress specifically.</p>\n\n\n\n<p>So there is a public data set called Chrome User Experience Report, which is sourced from anonymous data from users that use Chrome and have opted into this anonymous data tracking. So there is essentially a data set that collects the performance data of people visiting websites. And that is made publicly available, you can literally, if you know how to use BigQuery, which is this kind of advanced version of MySQL, where you can query gigantic amounts of data, you can query the Chrome User Experience Report data set, and you could be checking like, I don&#8217;t know, as long as sites that appear, it basically aggregates all the page, all the data by origin, so the domain.</p>\n\n\n\n<p>Any site that is relatively popular is in there. I don&#8217;t know exactly what the threshold is, but something like, maybe like at least 50 monthly users or something like that. So then your site will appear in there and you could query this for your own site to see how your site is doing. And you could do this every single month. And you get like a chart, how the performance of your site is doing over time.</p>\n\n\n\n<p>Of course, neither Google nor we as a Performance Team cares about one specific site. We&#8217;re doing things like in our team, we were building things for WordPress, for the WordPress ecosystem, try to improve the performance of the ecosystem as a whole. So I have been working a lot in the past years and learning a lot about this stuff. How to query the Crux, that&#8217;s a short version of it, Crux, the Crux Report, to gain insights on, how do you possibly measure the impact a certain feature has on these metrics?</p>\n\n\n\n<p>There&#8217;s another data set called HTTP Archive, which is the domains that are in this are also sourced from the Crux Report. But what HTTP Archive is, it basically scrapes all of these URLs every single month, one time, and gets all sorts of public information from these URLs, like which technologies it uses, does it use WordPress? Does it use, I don&#8217;t know, React or whatever, all these things. It also stores, from this one momentary point, it also stores the actual HTML body, and it&#8217;s a gigantic data set. And also that is public as well. You can look it up on httparchive.org and how to use it.</p>\n\n\n\n<p>So the goal of these efforts is to make these different performance data and to basically assess the health of the web ecosystem, publicly available, and then also these, especially HTTP Archive has a lot of charts on their own website based on their own data that essentially, yeah, makes it easily available without having to query BigQuery data.</p>\n\n\n\n<p>But when you actually can query BigQuery data, it becomes really powerful. So we can combine the data from HTTP Archive to see which origins are using WordPress. So then we get like a scaled down version of the whole web that is just the WordPress sites. And then we can combine it with the Crux data that has the performance results for all origins, but scope it down to only the origins that use WordPress.</p>\n\n\n\n<p>And that way we can see, for instance, the median LCP for a given month across all WordPress sites is this. Or the median INP and all the other metrics. More importantly, what we have been using as a more important metric though, is what&#8217;s called the passing rate. For every Core Web Vitals metric, there is a threshold where it&#8217;s, under this threshold is good, above this threshold, it&#8217;s not good. So for LCP for instance, that&#8217;s 2.5 seconds.</p>\n\n\n\n<p>And passing rate is essentially the number of, in this example, is the number of origins that have a median LCP that&#8217;s better than 2.5 seconds, the percentage of origins that have an LCP that&#8217;s better than 2.5 seconds. And that you can track over time to see how WordPress LCP is improving or decreasing over time. That&#8217;s how we essentially monitor performance for WordPress at a high level.</p>\n\n\n\n<p>And then we&#8217;ve been doing all sorts of experiments to try to get feature specific improvements. That&#8217;s really the difficult part because these data sets only gather data, the Archive data set only gathers data once a month, the Crux data set gave this data, it has all the data, but only the performance data. So it does not know, at what point did you activate a certain feature or deactivate another feature? That data doesn&#8217;t exist. So we can only make assumptions.</p>\n\n\n\n<p>Like, for instance, even when you want to measure the difference, and like an easy example, and that&#8217;s already complicated, is to measure the difference from one WordPress version to the next. HTTP Archive has data, whether a site is on, let&#8217;s say 6.8 or 6.7, but it&#8217;s from one specific moment in time. And we generally broaden these moments in time to the whole month because that&#8217;s the generally, like they do it once a month. If you see that a site is on 6.8, I think the HTTP Archive runs, like the actual queries usually run somewhere between 20th and 25th of the month.</p>\n\n\n\n<p>So if you see that the site is 6.8, you don&#8217;t know, is the site on 6.8 the entire month or did it just update to 6.8 a day before and most of the month data is actually the previous version? This is just unknowns that we have to deal with. And the data set being so huge, because WordPress is so popular, that helps a lot to sort of like make these unknowns maybe less impactful. Because if you&#8217;re at scale see that 6.8 has a big improvement, we can&#8217;t say that this value precisely is correct, but if it&#8217;s a clear improvement, we can assume that there is an actual improvement to a certain degree.</p>\n\n\n\n<p>And doing that for feature specific level is even more complex. I don&#8217;t think we have time to get into this too much right now, but I just want to say that this 1.9% value that is in the blog post is based on such an effort, where I try to look at all the sites that have speculation rules, and I looked at all the same sites before they activated speculation rules and get this median difference between all of them. And I don&#8217;t even know how to explain anymore because I don&#8217;t remember, because it was so complicated.</p>\n\n\n\n<p>[00:34:42] <strong>Nathan Wrigley:</strong> I am so glad that you are able to explain it though. I mean, firstly, really interesting, all of that, really interesting. Because you just sort of peeled back a whole curtain that I didn&#8217;t even know existed. So there&#8217;s just this aggregated, opted-in data coming out of the browser, dropping into this massive data set. I can only imagine what that is like to deal with.</p>\n\n\n\n<p>But it does mean that you&#8217;ve got anonymised data. You can make reasonable guesses, in the aggregate, about what&#8217;s happening. You know, you can refine it to WordPress, you can refine it to 6.7, 6.8, okay? And day by day, maybe it&#8217;s not meaningful. But if you spread it over one month, six months, what have you, more and more trends start to pop out.</p>\n\n\n\n<p>So you can see over time, you&#8217;ve got this 1.9%. And it, terribly complicated though it might be, I&#8217;m glad that you did that work for us. That&#8217;s amazing. Okay. And I didn&#8217;t know that whole thing was going on.</p>\n\n\n\n<p>And again, getting back to the point that you made at the beginning, the whole purpose of this is to make it better for your users. The purpose is not for the data that Google&#8217;s gathering, but it&#8217;s gathering it. And it&#8217;s helpful because people like you can then use it and make reasonable assumptions about what the rest of us ought to be doing with our WordPress websites. But the key metric there is, does it perform better for your users? And of course, we know the answer to that.</p>\n\n\n\n<p>[00:36:00] <strong>Felix Arntz:</strong> Just wanted to quickly add like we have been, these two data sets have been important source for us as a Performance Team from the very beginning in terms of even prioritising what we work on. There&#8217;s ways to get a high level idea. Like, out of all the 50 things that we could do to improve performance, which have shown to be the most impactful on the web so far outside of WordPress, or maybe even on the few WordPress sites that already use it through some other way. So it has helped a lot on the prioritisation, and personally a big advocate for data driven decision making. And in many parts of the WordPress project, we are not able to do that because we don&#8217;t have much data. But I&#8217;m really pleased that on the performance side, there is this big data set that can be used to see what is actually impactful.</p>\n\n\n\n<p>[00:36:46] <strong>Nathan Wrigley:</strong> Yeah, you can be really confident that your decisions are based upon fact, which is so nice. A lot of the WordPress project is, you know, intuition and design and things like that, and it&#8217;s hard to get agreement about that, and hard to get things right for everybody. But in this case, that&#8217;s slightly different.</p>\n\n\n\n<p>[00:37:00] <strong>Felix Arntz:</strong> For anybody that&#8217;s interested in this to learn more, I did write a blog post on makewordpress.org/core at some point about it. How to assess performance with HTTP Archive, something like that. That&#8217;s something that we can probably, that you can probably look at. There&#8217;s a whole collab. I worked out for a while on a collab to teach as a sort of like tutorial, how to get started with this for anybody that&#8217;s interested.</p>\n\n\n\n<p>[00:37:23] <strong>Nathan Wrigley:</strong> Okay, I&#8217;ve got a couple of pieces that I&#8217;ve got open over here, which are probably not the piece that you&#8217;ve just mentioned. So when I come back and edit this, I&#8217;ll make sure that I get in touch with you and we find that, and we&#8217;ll put that into the show notes. So there&#8217;ll be at least three things that you, dear listener, can go and check out.</p>\n\n\n\n<p>I&#8217;m just wondering if there are any situations, because we know what people are like. Performance experts, they love to configure their servers, they love to put things at the edge that, you know, all these clever things that are going on. Are there any scenarios where things like the speculative loading that that can conflict, or overlap or be something that you actually don&#8217;t want to do because you&#8217;ve already got something in place that might be handling, I don&#8217;t know, let&#8217;s say for example, you&#8217;re in team Cloudflare, and you&#8217;ve jumped in on all the different things that they&#8217;ve got? Perhaps they do this already. I don&#8217;t know. But I&#8217;m just wondering if there are any scenarios where, let&#8217;s say I&#8217;m a hosting company, or I&#8217;m just really into my performance. Are there any scenarios where I need to be mindful, maybe I want to switch this off?</p>\n\n\n\n<p>[00:38:22] <strong>Felix Arntz:</strong> I don&#8217;t think there&#8217;s a lot on the hosting side, but there can be on the whatever client side&#8217;s technologies you use. So because this speculative loading happens in the browser, so the, I don&#8217;t think there&#8217;s anything on the hosting side, or server side, that could do something similar. I think that wouldn&#8217;t work.</p>\n\n\n\n<p>But there are other ways that some similar things like this have already been done outside of a browser specification, outside of a browser API. Like there are certain JavaScript frameworks, for instance, that have something like speculative loading. Like, if you have a Next.js site, for instance, which I think is not very common to be used together with WordPress, but if you do have a Next.js site for instance, it might load URLs speculatively too, but through its own mechanism, like a completely separate approach. I&#8217;m not sure about specific JavaScript libraries right now that do exactly this, but there are definitely things like it that some sites were already using before the browser Speculation Rules API came around.</p>\n\n\n\n<p>[00:39:15] <strong>Nathan Wrigley:</strong> Okay, so broadly speaking, if you&#8217;re a WordPress, a typical WordPress user, you&#8217;ve got nothing to worry about. And you probably know that you&#8217;ve got something interesting and unusual going on with loading things in a different way, so you&#8217;re probably okay.</p>\n\n\n\n<p>One of the things that I did want to know, I just wondered if there were certain, I don&#8217;t know, let&#8217;s say I&#8217;ve got a WordPress website, maybe there are bits of that website that I don&#8217;t wish to be speculatively loading.</p>\n\n\n\n<p>I&#8217;m not really sure what that might be. An example that I think came out of one of your blog posts was you took the example of a Woo, well, I presume it was WooCommerce, you know, the end of the URL being cart or something like that, you know, so forward slash cart, forward slash whatever.</p>\n\n\n\n<p>That&#8217;s possible though. I presume, again, with hooks you could say, okay, this predetermined set of URLs, we don&#8217;t want to speculatively load anything. That kind of stuff can be done. The URL parameters can be configured into all this.</p>\n\n\n\n<p>[00:40:05] <strong>Felix Arntz:</strong> Yeah, exactly. So you can exclude certain URLs, or URL patterns from being applied to the speculative loading. And you can also configure whether you want to exclude them entirely or whether you want to exclude them only from pre-rendering, but not pre-fetching.</p>\n\n\n\n<p>So this is important to consider because the WordPress site, well, probably now 95% of the sites with 6.8 use pre-fetch because that&#8217;s a default. There are still sites that change it to pre-render. And then there are different implications for the site, for the URLs that are pre-rendered.</p>\n\n\n\n<p>And one of the considerations is, that&#8217;s actually another reason why we went with pre-fetch. because also pre-fetch, even though it&#8217;s less performant than pre-render, is also a safer option at the scale that we roll this out to all WordPress sites. Because the only risk with pre-fetch occurs if there is a URL that modifies something just by visiting that URL, which is an anti-pattern, like you should not do this, but there are plugins that do this occasionally. For instance, if you have like a URL that&#8217;s called empty cart, and just by visiting that URL you empty your shopping cart.</p>\n\n\n\n<p>That means, if you speculatively load the URL and you don&#8217;t visit it, your cart is emptied. You don&#8217;t want that. This is the only risk with pre-fetch. But, for what it&#8217;s worth, WordPress, the WordPress Core implementation also includes some default exclusions already. One of them is that it won&#8217;t speculatively load any URL with query parameters, like those question marks, something. And that&#8217;s because most WordPress sites by far are using pretty permalinks, and on those sites, having a query parameters is extremely unusual. And if there is, it&#8217;s usually from a plugin that does something specific.</p>\n\n\n\n<p>And so that&#8217;s why we exclude URLs because the chance that, like WordPress Core doesn&#8217;t have anything in the front end that will change something when you visit a URL, but plugins might. And plugins would usually handle this through query parameters if they do, and that&#8217;s why we exclude any query parameter URLs.</p>\n\n\n\n<p>[00:42:07] <strong>Nathan Wrigley:</strong> Yeah, I know that you will not have an answer to the next question, but I&#8217;m going to ask it anyway. But I&#8217;m just curious on your thoughts about it, because I know that anybody listening to this, there&#8217;s going to be a proportion of people thinking, wait, we want less bits traveling across the internet.</p>\n\n\n\n<p>And I&#8217;m thinking about the environmental impact of things now. You know, we don&#8217;t want pre-fetching anything, because that&#8217;s then potentially just wasted energy. Just carbon being burnt for stuff which may, or may not, be looked at. And obviously the WordPress approach that you&#8217;ve taken is to try and minimise that.</p>\n\n\n\n<p>But I just wondered if you had any thoughts, you know, around that and whether you could sort of calm people down about that or whether or not it, was that whole thing disregarded? Where does it fit into the thinking of all of this?</p>\n\n\n\n<p>[00:42:52] <strong>Felix Arntz:</strong> Yeah, like I said in the beginning, it is a trade off that you have to make, but it also depends like, which decision you take probably depends on how your site is being used, like what is the best configuration of speculative loading for your own site?</p>\n\n\n\n<p>If you go with a too eager configuration where there&#8217;s tons of URLs are eagerly loaded and then they might never be visited, then this definitely has a negative impact, like you&#8217;re saying. But obviously the ideal outcome is that the wasteful reloaded URLs are minimised and at the end of the day you, by speculatively loading, you improve the user experience.</p>\n\n\n\n<p>I can&#8217;t really answer where you draw the line in that. That being said, the adverse effects of URLs being loaded that you don&#8217;t navigate to with this conservative eagerness is so little. That&#8217;s why we chose that value to be the default. And you can go for more performant solutions, or configurations, but when you do so, please test how that works out.</p>\n\n\n\n<p>You can also, don&#8217;t want to get too deep into this, but you can also, if you have some kind of analytics provider for your site, you can gather like performance data or you can see which links users typically click on. And then you could configure speculation rules in the way that these links specifically may use like a more eager configuration. But the other ones don&#8217;t.</p>\n\n\n\n<p>This is where people really get, I&#8217;ve not personally done this but when, I&#8217;ve heard from other people when they work with enterprise clients, they really go in and look at, oh, when somebody has sent this URL, they usually click one of these four URLs, one of these four links, and then you can configure speculation rules to say, these four links should have moderate eagerness, but all other ones only conservative, for instance.</p>\n\n\n\n<p>[00:44:22] <strong>Nathan Wrigley:</strong> I can see a whole third party ecosystem of plugin developers kind of rubbing their hands together. You know, those that create performance plugins kind of leaning into exactly what you just said. Here&#8217;s your entire WordPress website, and here&#8217;s what we think, you know, in the same way that SEO plugins might give you a traffic light. Here&#8217;s a set of URLs, which we think you are not serving in the way that is going to be beneficial to your users or what have you. So, oh, that&#8217;s interesting as well.</p>\n\n\n\n<p>[00:44:46] <strong>Felix Arntz:</strong> The tough thing though is that it&#8217;s usually, I think it&#8217;s going to be very heavily dependent on the individual site. That&#8217;s where my hesitation is with that is that like, I&#8217;m not sure how much a plugin, a generally applied plugin, throughout the ecosystem could predict that. I think it&#8217;s often depending on the layout of the site. What is even the content of the site, right? What do people mostly click on? I think that makes it challenging from a general plugin perspective. Like to me, that&#8217;s mostly something that developers would do for their client&#8217;s websites, or agencies would do for a client&#8217;s website or at an individual level.</p>\n\n\n\n<p>[00:45:18] <strong>Nathan Wrigley:</strong> Yeah. Well, I mean, it&#8217;s just the beginning, isn&#8217;t it? It&#8217;s dropped in fairly recently. No doubt, the WordPress ecosystem will kind of figure out a posture on this. Maybe third party plugins will come along. Maybe developers will produce more documentation about how to wrangle it. How to surmise whether or not your website is using the Speculation Rules API in a way which is helping you, I don&#8217;t know, measuring the cost of your server infrastructure and what have you. But just the beginning.</p>\n\n\n\n<p>So there you go. Now, dear listener, you know a whole load of stuff about WordPress 6.8 that you didn&#8217;t. Before because probably, it was completely invisible to you. So, is there anything we missed, Felix? Is there any burning issue that you think we did not cover that and that was important?</p>\n\n\n\n<p>[00:45:58] <strong>Felix Arntz:</strong> No. I think we covered pretty much anything, everything. I just wanted to add that the new data from the Crux Report comes out, I think actually it came out yesterday, I believe. So it comes out every second Tuesday of the month. So I&#8217;m about to look at that. I want to take a look at that, definitely by the end of this week to see whether we can get any impact data now that speculative loading is out because, so the way that this works is the Crux data is released for the month before. That&#8217;s what happened, I think yesterday. So now we should have data on April where WordPress 6.8 came out. So now we can see how much did this feature launching in 6.8, and 6.8 in general, affect performance, hopefully in a good way.</p>\n\n\n\n<p>[00:46:39] <strong>Nathan Wrigley:</strong> Okay. Yeah, yeah. So this is actually for you, quite a big moment. You are suddenly going to get this data dump, which is going to actually cover this 43% of the web. It will be on all, well, most of the sites, and you are suddenly going to see what the impact is. Do you know, if you write that up, I will find it, if it&#8217;s out before I produce this post, then I will definitely link to that. And I&#8217;ll be fascinated to see if we can calculate how many decades, or weeks, or months, or years of time we have actually saved. That&#8217;s absolutely brilliant.</p>\n\n\n\n<p>Thank you so much for explaining it, helping to create it in the first place, and basically improving WordPress in a very, very demure way. You know, not shouting it from the rooftops, but doing a lot in the background to make everybody&#8217;s experience of the web a whole lot better. Felix Arntz, thank you so much for chatting to me today.</p>\n\n\n\n<p>[00:47:29] <strong>Felix Arntz:</strong> Yeah. Thank you.</p>\n</div></details>\n\n\n\n<p>On the podcast today we have <a href=\"https://felix-arntz.me/\">Felix Arntz</a>.</p>\n\n\n\n<p>Felix is a Senior Software Engineer at Google, and a WordPress Core committer from Germany, currently residing in San Francisco, California. He helped establish the WordPress Core Performance Team and has been heavily contributing to its efforts. He has been using WordPress for a decade and contributing back to the project since 2015. More recently, he has stepped into the role of the inaugural Performance Lead for the WordPress 6.2 release and subsequently of the 6.3 and 6.8 releases. In the latter release, he spearheaded development and launch of the new speculative loading feature, which is the focus of the podcast today.</p>\n\n\n\n<p>Speculative loading is one of the most important, and yet almost invisible, performance enhancements of recent times. If you’re on WordPress 6.8, this new feature is already active on your site, working quietly in the background to make page navigation faster. But you might never know from the WordPress UI, there’s no menu, no toggle, and no obvious indicator to show it’s there.</p>\n\n\n\n<p>Felix explains exactly what speculative loading is, and why it feels almost like browser magic. The ability for WordPress, using the browser’s new Speculation Rules API, to load the next page just as a user is about to visit it. It’s a clever use of browser signals like mouse clicks and hovers to anticipate navigation, shaving off precious milliseconds, sometimes even providing what feels like an instant page load.</p>\n\n\n\n<p>Felix clarifies the difference between conservative and more aggressive approaches to speculative loading, and why the WordPress Core team opted for the safest, least wasteful option by default, while still giving developers, or advanced users, the hooks and tools to customise or even disable it as needed.</p>\n\n\n\n<p>Felix discusses the origins of the feature as a plugin, the testing and data collection undertaken with tens of thousands of sites, and how this real-world data gave the team confidence to ship speculative loading to all WordPress users. We talk about what those performance wins mean at scale. How a 2% improvement on 43% of the internet translates into saving users untold hours of waiting collectively.</p>\n\n\n\n<p>We also get into the weeds on measurement and methodology. How the team uses data from the Chrome User Experience Report and HTTP Archive to track web performance, prioritise features, and validate real-world impact. Felix offers insight into how these global, anonymised data sets allow the Performance Team to make truly data-driven decisions.</p>\n\n\n\n<p>Beyond the tech, Felix addresses practical considerations, such as how to opt out, or fine-tune speculative loading if you have specific needs, how environmental concerns are balanced by default configurations, and how plugins or agencies might build on this foundation in the future.</p>\n\n\n\n<p>If you’ve ever wondered how large-scale, browser-level improvements make their way into WordPress Core, or simply want to know if there’s a way to make your own WordPress site that much faster, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://make.wordpress.org/performance/handbook/about-the-team/\"> WordPress Performance Team</a></p>\n\n\n\n<p><a href=\"https://codelabs.developers.google.com/speculation-rules\">Achieve instant navigations with the Speculation Rules API</a></p>\n\n\n\n<p><a href=\"https://developers.google.com/search/docs/appearance/core-web-vitals\">Understanding Core Web Vitals and Google search results</a></p>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/speculation-rules/\">Speculative Loading plugin</a></p>\n\n\n\n<p><a href=\"https://felix-arntz.me/blog/speculative-loading-history-performance-feature-in-wordpress-core/\">Speculative Loading, or A Brief History of Landing a Performance Feature in WordPress Core</a></p>\n\n\n\n<p><a href=\"https://developer.chrome.com/docs/crux\">Overview of CrUX</a></p>\n\n\n\n<p><a href=\"https://cloud.google.com/bigquery\">BigQuery</a></p>\n\n\n\n<p><a href=\"https://httparchive.org/\">HTTP Archive</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 28 May 2025 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"Do The Woo Community: Reinventing Careers and Building Resilience in Tech with Mendel Kurland\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://openchannels.fm/?p=97469\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://openchannels.fm/reinventing-careers-and-building-resilience-in-tech-with-mendel-kurland/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:155:\"Zach and Carl chat with Mendel Kurland, sharing stories of resilience, reinvention, and the human side of tech, wrapping it all in laughs and life lessons.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 28 May 2025 09:32:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Bob Dunn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"Matt: The Five Layers of Sharing Thoughts and Ideas\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=142705\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"https://ma.tt/2025/05/sharing-levels/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3920:\"<p>I&#8217;ve been thinking a lot about mimetic formation, how a thought becomes an idea, and how that idea gestates and evolves as it&#8217;s progressively shared in wider and wider circles.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"\" class=\"wp-image-142868\" height=\"198\" src=\"https://i0.wp.com/ma.tt/files/2025/05/five-layers-1024x335.png?resize=604%2C198&#038;quality=80&#038;ssl=1\" width=\"604\" /></figure>\n\n\n\n<p>During a recent product review of <a href=\"https://dayoneapp.com/\">Day One</a>, I was struck by how central the app is to my perspective on humans, relationships, and what we share. There are several layers to it, ranging from your innermost thoughts to what you share with the world. Each layer has its own context, challenges, and possibilities, and Automattic offers technology and products tailored to each.</p>\n\n\n\n<p>1. Layer one is your internal thoughts. Your consciousness, what exists only in your mind, or what I like to call meatspace. This space is yours and yours alone. This generative space is at the core of human creativity and existence.</p>\n\n\n\n<p>2. Layer two is triggered as soon as you put something into a medium, like writing it down. It’s everything that leaves your head, but is just reserved for you. In the past, we only had physical journals. Today, we have <a href=\"https://dayoneapp.com/\">Day One</a> as our strongest product in this space, but many people also have a private WordPress installation just for themselves. There are so many tools out there that help you create! Colors, brushes, canvases. Harper, for example, helps you write better — think of it as an open-source <a href=\"https://www.grammarly.com/\">Grammarly</a>, right now just in a few limited contexts, but in the future everywhere you write. </p>\n\n\n\n<p>3. Layer three is you and someone else. This is everything you share with one other person, which is an incredibly sacred act. <a href=\"https://dayoneapp.com/shared-journals/\">Shared journals</a> on Day One, messaging on <a href=\"https://www.beeper.com/\">Beeper</a>, DMs, private blogs with your best friend. A shared Google doc. This is its own special space. It has an intimacy and privacy that is core to the human experience. This is also phase 3 of Gutenberg, which is all about real-time co-editing and collaboration. This layer is the one I&#8217;m most excited about expanding in 2025 and 2026.</p>\n\n\n\n<p>4. Layer four is sharing within a finite group. N+1. It&#8217;s a space of collaboration and brainstorming with families, tribes, and teams. <a href=\"https://wordpress.com/p2/\">P2</a>, Linear, Github, group chats, and cozy communities. You lose some of the intimacy of layer three but gain more group intelligence.</p>\n\n\n\n<p>5. Finally, we have the fifth layer. This is the public layer, where I have spent a lot of my time at <a href=\"https://automattic.com/\">Automattic</a>. It is an extremely competitive space of social media and blogs: <a href=\"https://wordpress.org/\">WordPress</a>, <a href=\"http://wordpress.com\">WordPress.com</a>, and <a href=\"https://tumblr.com/\">Tumblr</a>. Once you publish publicly, you open yourself up to the beauty and chaos of the wider world. The best reason to blog is comments, the people who find you and add to your thoughts, who you never would have imagined. This is a crucible, but makes your own writing and thinking so much better, it&#8217;s worth the mishegoss. <img alt=\"🙂\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f642.png\" style=\"height: 1em;\" /></p>\n\n\n\n<p>This has been kicking around in my head and at layer four for a while. Thanks to <a href=\"https://kelly.blog/\">Kelly Hoffman</a> for helping me get this to layer five.</p>\n\n\n\n<p>P.S. Happy 22<sup>nd</sup> birthday to WordPress! <a href=\"https://wordpress.org/news/2025/05/announcing-the-formation-of-the-wordpress-ai-team/\">Very excited about the new AI team on .org</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 28 May 2025 00:55:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"Aaron Jorbin: Happy 22nd Birthday WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://aaron.jorb.in/?p=185698\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://aaron.jorb.in/happy-22nd-birthday-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:862:\"<p>I don&#8217;t know about you, but <a href=\"https://wordpress.org/news/2003/05/wordpress-now-available/\">WordPress is feeling 22.</a></p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-4-3 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n\n\n\n<p>I am celebrating by helping WordPress do what it has done nearly every day for 22 years: <a href=\"https://core.trac.wordpress.org/changeset/60258\">getting</a> a little better (and <a href=\"https://core.trac.wordpress.org/changeset/60257\">being ok</a> making <a href=\"https://core.trac.wordpress.org/changeset/60256\">mistakes</a> in the process).</p>\n<p>The post <a href=\"https://aaron.jorb.in/happy-22nd-birthday-wordpress/\">Happy 22nd Birthday WordPress</a> appeared first on <a href=\"https://aaron.jorb.in\">Aaron Jorbin</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 27 May 2025 23:37:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"jorbin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"WordPress.org blog: Announcing the Formation of the WordPress AI Team\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18769\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://wordpress.org/news/2025/05/announcing-the-formation-of-the-wordpress-ai-team/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2959:\"<p>Today, I’m pleased to announce the formation of a new <strong>WordPress AI Team,</strong> a dedicated group focused on accelerating and coordinating artificial intelligence projects across the WordPress ecosystem.</p>\n\n\n\n<p>AI is already transforming how people create and manage content online. As this technology evolves, it’s essential that WordPress remains at the forefront, ensuring innovation happens in the open, guided by community values, and built to core standards.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Why This Matters</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Strategic focus</strong>: A unified team stewards AI development thoughtfully, avoids fragmentation, and ensures alignment with the long-term goals of WordPress. </li>\n\n\n\n<li><strong>Shared innovation</strong>: Contributors and companies are actively exploring AI across the ecosystem. This team provides a central place to collaborate, share ideas, and build together.</li>\n\n\n\n<li><strong>Rapid iteration</strong>: Like the Performance Team, we’ll take a plugin-first approach. <a href=\"https://make.wordpress.org/core/2022/09/11/canonical-plugins-revisited/\">Canonical Plugins</a> will allow us to move quickly, gather feedback, and deliver real value without waiting on the Core release cycle.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">What to Expect</h2>\n\n\n\n<p>The AI Team will:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Coordinate cross-team efforts to explore AI-powered features responsibly and inclusively.</li>\n\n\n\n<li>Publish and maintain a public roadmap of AI initiatives and Canonical Plugins.</li>\n\n\n\n<li>Collaborate closely with Core, Design, Accessibility, and other teams to ensure strong integration and shared standards.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Meet the Team</h2>\n\n\n\n<p>The WordPress AI Team brings deep experience in open-source, performance, and product development and a strong commitment to building AI features the WordPress way. The team will launch with the following team contributors:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>James LePage</strong> – Automattic</li>\n\n\n\n<li><strong>Felix Arntz</strong> – Google</li>\n\n\n\n<li><strong>Pascal Birchler</strong> – Google</li>\n\n\n\n<li><strong>Jeff Paul</strong> – 10up</li>\n</ul>\n\n\n\n<p>To help get things started, James and Felix will serve as the initial <a href=\"https://make.wordpress.org/updates/team-reps/\">Team Reps</a> in supporting team organization, communication, and coordination with other Make WordPress teams.</p>\n\n\n\n<p>This is an exciting and important step in WordPress’s evolution. I look forward to seeing what we’ll create together and in the open.</p>\n\n\n\n<p>If you’re interested in contributing or following along, please join the conversations in <a href=\"https://wordpress.slack.com/archives/C08TJ8BPULS\">#core-ai</a> and watch for upcoming meeting announcements on <a href=\"https://make.wordpress.org/ai/\">https://make.wordpress.org/ai/</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 27 May 2025 16:28:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Mary Hubbard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"Do The Woo Community: How One Solo Agency Owner Manages Hundreds of WordPress Sites (Without Losing His Mind)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://openchannels.fm/?post_type=blog&p=97117\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"https://openchannels.fm/how-one-solo-agency-owner-manages-hundreds-of-wordpress-sites-without-losing-his-mind/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:191:\"Running a massive web design business solo, while focusing on one platform, automating wisely, networking locally, and keeping support simple can help with strategies to scale without stress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 27 May 2025 11:14:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Bob Dunn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"Do The Woo Community: Community Engagement Strategies for Successful WooCommerce and WordPress Plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://openchannels.fm/?p=97436\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"https://openchannels.fm/community-engagement-strategies-for-successful-woocommerce-and-wordpress-plugins/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:194:\"In this episode of Woo Product Chat, co-hosts discuss \"community thinking\" in WordPress and WooCommerce plugins, highlighting the importance of user feedback and effective engagement strategies.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 27 May 2025 08:44:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Bob Dunn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"Weston Ruter: Improve LCP by Deprioritizing  Script Modules from the Interactivity API\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://weston.ruter.net/?p=34457\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"https://weston.ruter.net/2025/05/26/improve-lcp-by-deprioritizing-interactivity-api-script-modules/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:42031:\"<p class=\"is-style-text-subtitle is-style-text-subtitle--2\">Adding a <code>fetchpriority</code> of <code>low</code> to script modules and moving them from the <code>head</code> to the footer can improve <abbr title=\"Largest Contentful Paint\">LCP</abbr> by &gt;9%! I&#8217;ve <a href=\"https://github.com/westonruter/script-fetchpriority-low\" title=\"Script Fetch Priority Low\">written</a> <a href=\"https://github.com/westonruter/script-modules-in-footer\" title=\"Script Modules in Footer\">plugins</a> you can use to implement this now while waiting for them to land in WordPress core.</p>\n\n\n\n<p>The past week I&#8217;ve been doing a deep dive into the performance impact of how WordPress loads script modules for the <a href=\"https://developer.wordpress.org/block-editor/reference-guides/interactivity-api/\">Interactivity API</a>. When the Interactivity API was first introduced, it used classic non-module scripts which were printed at the end of the <code>body</code> (i.e. in the footer, at <code>wp_footer</code>) so that they would not block the <a href=\"https://developer.mozilla.org/en-US/docs/Web/Performance/Guides/Critical_rendering_path\">critical rendering path</a>. With support for <a href=\"https://make.wordpress.org/core/2023/07/14/registering-scripts-with-async-and-defer-attributes-in-wordpress-6-3/\">script loading strategies</a> in core, I <a href=\"https://github.com/WordPress/gutenberg/pull/52536\">added</a> <code>defer</code> to these scripts and moved them to the <code>head</code> (i.e. at <code>wp_head</code>) in block themes, <a href=\"https://core.trac.wordpress.org/ticket/59115#:~:text=Leaving%20them%20in%20the%20head%20is%20advantageous%20because%20it%20means%20the%20browser%20will%20discover%20these%20scripts%20earlier%20and%20start%20loading%20them%20with%20other%20page%20resources%2C%20but%20the%20presence%20of%20defer%20means%20that%20they%20will%20no%20longer%20block%20page%20rendering.\">reasoning</a>:</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Leaving them in the <code>head</code> is advantageous because it means the browser will discover these scripts earlier and start loading them with other page resources, but the presence of <code>defer</code> means that they will no longer block page rendering.</p>\n</blockquote>\n\n\n\n<p>Ultimately, when the Interactivity API was <a href=\"https://make.wordpress.org/core/2024/03/04/interactivity-api-dev-note/\">fully launched</a> in WordPress 6.5, it had switched to using <a href=\"https://make.wordpress.org/core/2024/03/04/script-modules-in-6-5/\">script modules</a>. One great thing about script modules is that they don&#8217;t block rendering: they have the <code>defer</code> behavior <a href=\"https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Modules#:~:text=There%20is%20no%20need%20to%20use%20the%20defer%20attribute%20(see%20%3Cscript%3E%20attributes)%20when%20loading%20a%20module%20script%3B%20modules%20are%20deferred%20automatically.\">by default</a>. This means that they are safe to place in the <code>head</code>, and they continue to be printed there in block themes. (In classic themes, the block scripts are printed in the footer since blocks aren&#8217;t parsed before <code>wp_head</code> runs.) However, as I&#8217;ve been researching the past week, there can still be negative implications to the LCP metric when these script modules are discovered early, even though they don&#8217;t block rendering.</p>\n\n\n\n<p>I set up a vanilla test site with Local WP and the Twenty Twenty-Five default theme active. I configured the theme template and post content so that all block configurations which depend on the Interactivity API are present:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>The theme template has a <strong>Navigation</strong> block with the mobile overlay menu enabled (which is the default).</li>\n\n\n\n<li>A <strong>Search</strong> block is added to the header with the “Button only” configuration which depends on the Interactivity API.</li>\n\n\n\n<li>The <a href=\"https://gist.github.com/westonruter/9ef0dfa42e4237b8a823e4b6803d3d7a#file-post_content-html\">post content</a> starts with an <strong>Image</strong> block whose <code>IMG</code> is the LCP element. It is configured to “Enlarge on click”.<sup class=\"fn\"><a href=\"https://weston.ruter.net/category/wordpress/feed/#c7a2be25-eace-4671-8089-f9286a5703ea\" id=\"c7a2be25-eace-4671-8089-f9286a5703ea-link\">1</a></sup> This uses a <a href=\"https://en.wikipedia.org/wiki/File:American_bison_k5680-1.jpg\">photo</a> of a Bison of course. <img alt=\"🦬\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f9ac.png\" style=\"height: 1em;\" /></li>\n\n\n\n<li>After a few paragraphs of Lorem Ipsum, I added a <strong>File</strong> block for a PDF with “Show inline embed” enabled.</li>\n\n\n\n<li>The “More Posts” section of the template has a <strong>Query Loop</strong> which has its “Reload full page” advanced setting turned off.</li>\n</ul>\n\n\n\n<p>In the end, this results in the following markup being printed in the <code>head</code> (from the <a href=\"https://gist.github.com/westonruter/9ef0dfa42e4237b8a823e4b6803d3d7a#file-before-html\">full page source</a> with some prettying): </p>\n\n\n<pre class=\"wp-block-code\"><span><code class=\"hljs language-xml\"><span class=\"hljs-tag\">&lt;<span class=\"hljs-name\">script</span> <span class=\"hljs-attr\">type</span>=<span class=\"hljs-string\">\"importmap\"</span> <span class=\"hljs-attr\">id</span>=<span class=\"hljs-string\">\"wp-importmap\"</span>&gt;</span><span class=\"actionscript\">\n{\n	<span class=\"hljs-string\">\"imports\"</span>:{\n		<span class=\"hljs-string\">\"@wordpress/interactivity\"</span>: <span class=\"hljs-string\">\"/wp-includes/js/dist/script-modules/interactivity/index.min.js?ver=55aebb6e0a16726baffb\"</span>,\n		<span class=\"hljs-string\">\"@wordpress/interactivity-router\"</span>: <span class=\"hljs-string\">\"/wp-includes/js/dist/script-modules/interactivity-router/index.min.js?ver=dc4a227f142d2e68ef83\"</span>,\n		<span class=\"hljs-string\">\"@wordpress/a11y\"</span>: <span class=\"hljs-string\">\"/wp-includes/js/dist/script-modules/a11y/index.min.js?ver=b7d06936b8bc23cff2ad\"</span>\n	}\n}\n</span><span class=\"hljs-tag\">&lt;/<span class=\"hljs-name\">script</span>&gt;</span>\n<span class=\"hljs-tag\">&lt;<span class=\"hljs-name\">script</span> <span class=\"hljs-attr\">type</span>=<span class=\"hljs-string\">\"module\"</span> <span class=\"hljs-attr\">src</span>=<span class=\"hljs-string\">\"/wp-includes/js/dist/script-modules/block-library/file/view.min.js?ver=fdc2f6842e015af83140\"</span> <span class=\"hljs-attr\">id</span>=<span class=\"hljs-string\">\"@wordpress/block-library/file/view-js-module\"</span>&gt;</span><span class=\"hljs-tag\">&lt;/<span class=\"hljs-name\">script</span>&gt;</span>\n<span class=\"hljs-tag\">&lt;<span class=\"hljs-name\">script</span> <span class=\"hljs-attr\">type</span>=<span class=\"hljs-string\">\"module\"</span> <span class=\"hljs-attr\">src</span>=<span class=\"hljs-string\">\"/wp-includes/js/dist/script-modules/block-library/image/view.min.js?ver=e38a2f910342023b9d19\"</span> <span class=\"hljs-attr\">id</span>=<span class=\"hljs-string\">\"@wordpress/block-library/image/view-js-module\"</span>&gt;</span><span class=\"hljs-tag\">&lt;/<span class=\"hljs-name\">script</span>&gt;</span>\n<span class=\"hljs-tag\">&lt;<span class=\"hljs-name\">script</span> <span class=\"hljs-attr\">type</span>=<span class=\"hljs-string\">\"module\"</span> <span class=\"hljs-attr\">src</span>=<span class=\"hljs-string\">\"/wp-includes/js/dist/script-modules/block-library/navigation/view.min.js?ver=61572d447d60c0aa5240\"</span> <span class=\"hljs-attr\">id</span>=<span class=\"hljs-string\">\"@wordpress/block-library/navigation/view-js-module\"</span>&gt;</span><span class=\"hljs-tag\">&lt;/<span class=\"hljs-name\">script</span>&gt;</span>\n<span class=\"hljs-tag\">&lt;<span class=\"hljs-name\">script</span> <span class=\"hljs-attr\">type</span>=<span class=\"hljs-string\">\"module\"</span> <span class=\"hljs-attr\">src</span>=<span class=\"hljs-string\">\"/wp-includes/js/dist/script-modules/block-library/query/view.min.js?ver=f55e93a1ad4806e91785\"</span> <span class=\"hljs-attr\">id</span>=<span class=\"hljs-string\">\"@wordpress/block-library/query/view-js-module\"</span>&gt;</span><span class=\"hljs-tag\">&lt;/<span class=\"hljs-name\">script</span>&gt;</span>\n<span class=\"hljs-tag\">&lt;<span class=\"hljs-name\">script</span> <span class=\"hljs-attr\">type</span>=<span class=\"hljs-string\">\"module\"</span> <span class=\"hljs-attr\">src</span>=<span class=\"hljs-string\">\"/wp-includes/js/dist/script-modules/block-library/search/view.min.js?ver=208bf143e4074549fa89\"</span> <span class=\"hljs-attr\">id</span>=<span class=\"hljs-string\">\"@wordpress/block-library/search/view-js-module\"</span>&gt;</span><span class=\"hljs-tag\">&lt;/<span class=\"hljs-name\">script</span>&gt;</span>\n<span class=\"hljs-tag\">&lt;<span class=\"hljs-name\">link</span> <span class=\"hljs-attr\">rel</span>=<span class=\"hljs-string\">\"modulepreload\"</span> <span class=\"hljs-attr\">href</span>=<span class=\"hljs-string\">\"/wp-includes/js/dist/script-modules/interactivity/index.min.js?ver=55aebb6e0a16726baffb\"</span> <span class=\"hljs-attr\">id</span>=<span class=\"hljs-string\">\"@wordpress/interactivity-js-modulepreload\"</span>&gt;</span></code></span></pre>\n\n\n<p>When loading the page in Chrome, here&#8217;s the network panel in DevTools:</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large wp-lightbox-container\"><img alt=\"Screenshot of the Chrome DevTools network panel where the script module resources are being loaded with high priority before the Bison image (for the LCP element)\" class=\"wp-image-34758\" height=\"700\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/05/chrome-network-panel-script-modules-default-priority-two-columns.png?resize=501%2C700&#038;ssl=1\" width=\"501\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n\n\n\n<p>Notice how the script modules are being loaded with a <strong>high</strong> priority and <em>before</em> the all-important Bison image resource is loaded for the LCP element. This is bad. Here&#8217;s a view of the waterfall in the Performance panel, where you can see the script modules indeed start loading before the Bison image:</p>\n\n\n\n<figure class=\"wp-block-image alignwide size-large wp-lightbox-container\"><img alt=\"Network waterfall in Chrome DevTools showing script modules loading before the LCP image resource.\" class=\"wp-image-34739\" height=\"187\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/05/chrome-devtools-waterfall-script-modules-default-priority.png?resize=700%2C187&#038;ssl=1\" width=\"700\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n\n\n\n<p>In my tests, both Chrome and Safari set a default fetch priority of <strong>high</strong> for module scripts and <code>modulepreload</code> links. In Firefox, the default fetch priority for a <code>modulepreload</code> link is <strong>highest</strong>, while the script modules are loaded with <strong>normal</strong> fetch priority. In all these cases, the priorities are <em>incorrect</em>. They should all have a fetch priority of <strong>low</strong> because they are not in the critical rendering path. This is because the very first requirement/goal defined for the Interactivity API was for <a href=\"https://developer.wordpress.org/block-editor/reference-guides/interactivity-api/iapi-about/#:~:text=It%20must%20support%20server%2Dside%20rendering.%20Server%2Drendered%20HTML%20and%20client%2Dhydrated%20HTML%20must%20be%20exactly%20the%20same.%20This%20is%20important%20for%20SEO%20and%20the%20user%20experience.\">server-side rendering</a>:</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>It must support server-side rendering. Server-rendered HTML and client-hydrated HTML must be exactly the same. This is important for SEO and the user experience.</p>\n</blockquote>\n\n\n\n<p>Since blocks using the Interactivity API are intended to leverage server-side rendering, the script modules for these blocks<sup class=\"fn\"><a href=\"https://weston.ruter.net/category/wordpress/feed/#b77dfd89-ba79-47f9-b93a-b5825558c8a3\" id=\"b77dfd89-ba79-47f9-b93a-b5825558c8a3-link\">2</a></sup> by definition should not be prioritized over loading other resources which are in the critical rendering path, <em>especially</em> any image resource for the LCP element.</p>\n\n\n\n<p>I wanted to find out what the LCP performance impact would be if these script modules had their priorities changed to low from the default of high. The <code><a href=\"https://developer.mozilla.org/en-US/docs/Web/API/HTMLLinkElement/fetchPriority\">link</a></code> and <code><a href=\"https://developer.mozilla.org/en-US/docs/Web/API/HTMLScriptElement/fetchPriority\">script</a></code> tags both support the <code>fetchpriority</code> attribute, same as the <code>img</code> tag does. While WordPress now <a href=\"https://make.wordpress.org/core/2023/07/13/image-performance-enhancements-in-wordpress-6-3/\">facilitates</a> adding <code>fetchpriority</code> to <code>img</code> tags, it doesn&#8217;t do the same for registered scripts or script modules. This is what <a href=\"https://core.trac.wordpress.org/ticket/61734\" title=\"Add the ability to handle &quot;fetchpriority&quot; to ES Modules and Import Maps\">#61734</a> is about, and it is why I&#8217;m analyzing the performance impact. In the same way that WordPress facilitates adding <code>async</code> and <code>defer</code> to scripts, and does so by default for some scripts, there should perhaps be a way to declare the <code>fetchpriority</code> for a script or script module.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"performance-of-low-priority-script-modules\">Performance of Low Priority Script Modules</h2>\n\n\n\n<p>In order to benchmark the performance impact, I developed the <strong><a href=\"https://github.com/westonruter/script-fetchpriority-low\">Script Fetch Priority Low</a> plugin</strong> which automatically adds <code>fetchpriority=low</code> to the <code>module</code> scripts used by the Interactivity API, as well as any <code>modulepreload</code> links which are printed for static import dependencies. If a page is loaded with a specific query parameter, then the plugin short-circuits; this allows for doing before/after benchmarks.</p>\n\n\n\n<p>With this plugin active, this is the change to the network panel in Chrome DevTools:</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large wp-lightbox-container\"><img alt=\"Screenshot of the Chrome DevTools network panel where the script module resources are being loaded with low priority after the Bison image (for the LCP element)\" class=\"wp-image-34759\" height=\"700\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/05/chrome-network-panel-script-modules-low-priority-two-columns.png?resize=501%2C700&#038;ssl=1\" width=\"501\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n\n\n\n<p>Notice how the script modules are now being loaded with a <strong>low</strong> priority and <em>after</em> the Bison image. This can also be seen in the Performance panel waterfall:</p>\n\n\n\n<figure class=\"wp-block-image alignwide size-large wp-lightbox-container\"><img alt=\"Network waterfall in Chrome DevTools showing script modules loading after the LCP image resource.\" class=\"wp-image-34740\" height=\"190\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/05/chrome-devtools-waterfall-script-modules-low-priority.png?resize=700%2C190&#038;ssl=1\" width=\"700\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n\n\n\n<p>This looks much better. But what is the performance impact in terms of LCP? To analyze that I used the <a href=\"https://github.com/GoogleChromeLabs/wpp-research/tree/main/cli#benchmark-web-vitals\">benchmark-web-vitals</a> tool to obtain the median web vitals metrics for 100 requests with and without the reduction in fetch priority:</p>\n\n\n\n<details class=\"wp-block-details is-layout-flow wp-block-details-is-layout-flow\">Command<pre class=\"wp-block-code\"><span><code class=\"hljs language-bash\">npm run research -- benchmark-web-vitals --number=100 --output=<span class=\"hljs-string\">\"md\"</span> --network-conditions=<span class=\"hljs-string\">\"broadband\"</span> --diff \\\n  --url <span class=\"hljs-string\">\"http://localhost:10008/bison/?disable_print_script_modules_in_footer&amp;disable_script_fetchpriority_low\"</span> \\\n  --url <span class=\"hljs-string\">\"http://localhost:10008/bison/?disable_print_script_modules_in_footer\"</span></code></span></pre></details>\n\n\n\n<figure class=\"wp-block-table benchmark-web-vitals is-style-regular has-medium-font-size\"><table class=\"has-fixed-layout\"><thead><tr><th>Metric</th><th>Before</th><th>After</th><th>Diff (ms)</th><th>Diff (%)</th></tr></thead><tbody><tr><td><abbr title=\"First Contentful Paint\">FCP</abbr></td><td>142.6</td><td>141.7</td><td>-0.9</td><td>-0.6%</td></tr><tr><td><abbr title=\"Largest Contentful Paint\">LCP</abbr></td><td>409.4</td><td>382.4</td><td>-27.0</td><td>-6.6%</td></tr><tr><td><abbr title=\"Time To Fist Byte\">TTFB</abbr></td><td>34.7</td><td>35.3</td><td>+0.7</td><td>+1.9%</td></tr><tr><td><abbr title=\"LCP minus TTFB\">LCP-TTFB</abbr></td><td>374.2</td><td>347.0</td><td>-27.2</td><td>-7.3%</td></tr></tbody></table></figure>\n\n\n\n<p>This is a big improvement! (Each subsequent benchmark test shows the median metrics of 100 iterations, unless otherwise noted.)</p>\n\n\n\n<p>The above results were testing while emulating a broadband network connection. Here are the results testing a “Fast 3G” connection:</p>\n\n\n\n<details class=\"wp-block-details is-layout-flow wp-block-details-is-layout-flow\">Command<pre class=\"wp-block-code\"><span><code class=\"hljs language-bash\">npm run research -- benchmark-web-vitals --number=100 --output=<span class=\"hljs-string\">\"md\"</span> --network-conditions=<span class=\"hljs-string\">\"Fast 3G\"</span> --diff \\\n  --url <span class=\"hljs-string\">\"http://localhost:10008/bison/?disable_print_script_modules_in_footer&amp;disable_script_fetchpriority_low\"</span> \\\n  --url <span class=\"hljs-string\">\"http://localhost:10008/bison/?disable_print_script_modules_in_footer\"</span></code></span></pre></details>\n\n\n\n<figure class=\"wp-block-table benchmark-web-vitals is-style-regular has-medium-font-size\"><table class=\"has-fixed-layout\"><thead><tr><th>Metric</th><th>Before</th><th>After</th><th>Diff (ms)</th><th>Diff (%)</th></tr></thead><tbody><tr><td>FCP</td><td>1275.3</td><td>1275.4</td><td>+0.1</td><td>+0.0%</td></tr><tr><td>LCP</td><td>3377.1</td><td>3157.1</td><td>-220.0</td><td>-6.5%</td></tr><tr><td>TTFB</td><td>35.0</td><td>34.6</td><td>-0.4</td><td>-1.0%</td></tr><tr><td>LCP-TTFB</td><td>3341.1</td><td>3123.0</td><td>-218.1</td><td>-6.5%</td></tr></tbody></table></figure>\n\n\n\n<p>So there is roughly the same improvement regardless of the network conditions.</p>\n\n\n\n<p>I was also curious what the results would be when there was just a single block on the page using the Interactivity API, instead of attempting to add every single interactive block. This is the normal case for all block themes since the Navigation block is almost always present with the mobile overlay menu enabled. So I tested on a template with the Navigation block and a featured image as the LCP element, this time again emulating a broadband network connection:</p>\n\n\n\n<details class=\"wp-block-details is-layout-flow wp-block-details-is-layout-flow\">Command<pre class=\"wp-block-code\"><span><code class=\"hljs language-bash\">npm run research -- benchmark-web-vitals --number=100 --output=<span class=\"hljs-string\">\"md\"</span> --network-conditions=<span class=\"hljs-string\">\"broadband\"</span> --diff \\\n  --url <span class=\"hljs-string\">\"http://localhost:10008/bison-no-file-block/?disable_print_script_modules_in_footer&amp;disable_script_fetchpriority_low\"</span> \\\n  --url <span class=\"hljs-string\">\"http://localhost:10008/bison-no-file-block/?disable_print_script_modules_in_footer\"</span></code></span></pre></details>\n\n\n\n<figure class=\"wp-block-table benchmark-web-vitals has-medium-font-size\"><table class=\"has-fixed-layout\"><thead><tr><th>Metric</th><th>Before</th><th>After</th><th>Diff (ms)</th><th>Diff (%)</th></tr></thead><tbody><tr><td>FCP</td><td>140.7</td><td>142.6</td><td>+1.9</td><td>+1.4%</td></tr><tr><td>LCP</td><td>399.0</td><td>368.9</td><td>-30.1</td><td>-7.5%</td></tr><tr><td>TTFB</td><td>33.4</td><td>33.0</td><td>-0.4</td><td>-1.2%</td></tr><tr><td>LCP-TTFB</td><td>365.1</td><td>335.8</td><td>-29.3</td><td>-8.0%</td></tr></tbody></table></figure>\n\n\n\n<p>So even when there is just a single script module along with the <code>modulepreload</code> link, the performance improvement to LCP is consistent.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"printing-script-modules-in-the-footer\">Printing Script Modules in the Footer</h2>\n\n\n\n<p>As referred to above, the classic method WordPress has employed to deprioritize scripts is to load them in the footer by supplying <code>in_footer</code> as <code>true</code> when registering a script. What if instead of adding a <code>fetchpriority</code> of <code>low</code> to script modules, they were instead just printed in the footer for block themes in the same way they are already printed in the footer for classic themes? I created the <strong><a href=\"https://github.com/westonruter/script-modules-in-footer\">Script Modules in Footer</a> plugin</strong> to implement this and to facilitate benchmarking. Here are the results:</p>\n\n\n\n<details class=\"wp-block-details is-layout-flow wp-block-details-is-layout-flow\">Command<pre class=\"wp-block-code\"><span><code class=\"hljs language-bash\">npm run research -- benchmark-web-vitals --number=100 --output=<span class=\"hljs-string\">\"md\"</span> --network-conditions=<span class=\"hljs-string\">\"broadband\"</span> --diff \\\n  --url <span class=\"hljs-string\">\"http://localhost:10008/bison/?disable_print_script_modules_in_footer&amp;disable_script_fetchpriority_low\"</span> \\\n  --url <span class=\"hljs-string\">\"http://localhost:10008/bison/?disable_script_fetchpriority_low\"</span></code></span></pre></details>\n\n\n\n<figure class=\"wp-block-table benchmark-web-vitals has-medium-font-size\"><table class=\"has-fixed-layout\"><thead><tr><th>Metric</th><th>Before</th><th>After</th><th>Diff (ms)</th><th>Diff (%)</th></tr></thead><tbody><tr><td>FCP</td><td>141.8</td><td>143.7</td><td>+1.9</td><td>+1.3%</td></tr><tr><td>LCP</td><td>410.8</td><td>383.1</td><td>-27.8</td><td>-6.8%</td></tr><tr><td>TTFB</td><td>34.4</td><td>34.4</td><td>-0.1</td><td>-0.1%</td></tr><tr><td>LCP-TTFB</td><td>376.7</td><td>348.4</td><td>-28.4</td><td>-7.5%</td></tr></tbody></table></figure>\n\n\n\n<p>This shows almost the same improvement as adding <code>fetchpriority</code> of <code>low</code>. However, even when they are located at the end of the <code>body</code>, they are still loaded with a high fetch priority. When script modules are printed in the footer, adding <code>fetchpriority</code> as well yields an additional ~1% improvement to LCP on my test page:</p>\n\n\n\n<details class=\"wp-block-details is-layout-flow wp-block-details-is-layout-flow\">Command<pre class=\"wp-block-code\"><span><code class=\"hljs language-bash\">npm run research -- benchmark-web-vitals --number=100 --output=<span class=\"hljs-string\">\"md\"</span> --network-conditions=<span class=\"hljs-string\">\"broadband\"</span> --diff \\\n  --url <span class=\"hljs-string\">\"http://localhost:10008/bison/?disable_script_fetchpriority_low\"</span> \\\n  --url <span class=\"hljs-string\">\"http://localhost:10008/bison/\"</span></code></span></pre></details>\n\n\n\n<figure class=\"wp-block-table benchmark-web-vitals has-medium-font-size\"><table class=\"has-fixed-layout\"><thead><tr><th>Metric</th><th>Before</th><th>After</th><th>Diff (ms)</th><th>Diff (%)</th></tr></thead><tbody><tr><td>FCP</td><td>142.0</td><td>144.1</td><td>+2.1</td><td>+1.5%</td></tr><tr><td>LCP</td><td>377.5</td><td>374.7</td><td>-2.8</td><td>-0.7%</td></tr><tr><td>TTFB</td><td>34.7</td><td>35.1</td><td>+0.4</td><td>+1.2%</td></tr><tr><td>LCP-TTFB</td><td>342.9</td><td>338.9</td><td>-4.0</td><td>-1.2%</td></tr></tbody></table></figure>\n\n\n\n<p>If script modules are all printed with <code>fetchpriority=low</code>, here&#8217;s the difference when moving them from <code>wp_head</code> to <code>wp_footer</code>:</p>\n\n\n\n<details class=\"wp-block-details is-layout-flow wp-block-details-is-layout-flow\">Command<pre class=\"wp-block-code\"><span><code class=\"hljs language-bash\">npm run research -- benchmark-web-vitals --number=100 --output=<span class=\"hljs-string\">\"md\"</span> --network-conditions=<span class=\"hljs-string\">\"broadband\"</span> --diff \\\n  --url <span class=\"hljs-string\">\"http://localhost:10008/bison/?disable_print_script_modules_in_footer\"</span> \\\n  --url <span class=\"hljs-string\">\"http://localhost:10008/bison/\"</span></code></span></pre></details>\n\n\n\n<figure class=\"wp-block-table benchmark-web-vitals has-medium-font-size\"><table class=\"has-fixed-layout\"><thead><tr><th>Metric</th><th>Before</th><th>After</th><th>Diff (ms)</th><th>Diff (%)</th></tr></thead><tbody><tr><td>FCP</td><td>142.4</td><td>143.2</td><td>+0.8</td><td>+0.6%</td></tr><tr><td>LCP</td><td>383.9</td><td>372.7</td><td>-11.2</td><td>-2.9%</td></tr><tr><td>TTFB</td><td>35.0</td><td>35.2</td><td>+0.2</td><td>+0.6%</td></tr><tr><td>LCP-TTFB</td><td>348.1</td><td>337.8</td><td>-10.3</td><td>-3.0%</td></tr></tbody></table></figure>\n\n\n\n<p>So again, there&#8217;s an improvement but not as large as before/after adding <code>fetchpriority=low</code> or printing in the <code>head</code> versus the footer.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"deprioritizing-classic-scripts\">Bonus: Deprioritizing Classic Scripts</h2>\n\n\n\n<p>While classic scripts registered in WordPress already have the ability to be printed in the footer, they can&#8217;t be registered with a specific <code>fetchpriority</code> value. It doesn&#8217;t make a lot of sense to set a fetch priority for blocking classic scripts since they should always be loaded with the highest priority since they block rendering. However, what about a script that is using the <code>defer</code> or <code>async</code> loading strategies? Chrome automatically assigns such scripts as having a low priority, regardless of whether they are printed at the <code>head</code> or the footer. However, this is not the case for other browsers:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>An <code>async</code> script in the <code>head</code> gets a medium/normal priority in Safari/Firefox.</li>\n\n\n\n<li> A <code>defer</code> script in the <code>head</code> gets a high priority in Safari and a normal priority in Firefox.</li>\n\n\n\n<li>An <code>async</code> script in the footer gets a medium/normal priority in Safari/Firefox.</li>\n\n\n\n<li>A <code>defer</code> script in the footer gets a high priority in Safari and a normal priority in Firefox.</li>\n</ul>\n\n\n\n<p>So for the sake of non-Chromium browsers, it absolutely makes sense to be able to register classic scripts with a fetch priority. For example, the <code>comment-reply</code> script is registered as <code>async</code> and is printed in the footer. Explicitly marking this script as having a low fetch priority ensures that loading it will not compete with more critical resources in Firefox and Safari. My <strong><a href=\"https://github.com/westonruter/script-fetchpriority-low\">Script Fetch Priority Low</a></strong> plugin also implements this.</p>\n\n\n\n<p>As an extra bonus, check out my <a href=\"https://github.com/westonruter/google-site-kit-gtag-script-deprioritization\">Site Kit GTag Script Deprioritization</a> and <a href=\"https://github.com/westonruter/jetpack-stats-script-deprioritization\">Jetpack Stats Script Deprioritization</a> plugins which optimize the loading of analytics trackers by adding <code>fetchpriority=low</code> to the <code>script</code> tags, removing the <code>dns-prefetch</code>, and ensuring the external <code>script</code> tags are printed in the footer.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"conclusion\">Conclusion</h2>\n\n\n\n<p>There are essentially for different configurations for printing script modules on the page:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li>In <code>head</code> with default fetch priority. (This is the current behavior in WordPress core.)</li>\n\n\n\n<li>In <code>head</code> with <code>fetchpriority=low</code>.</li>\n\n\n\n<li>At end of <code>body</code> with default fetch priority.</li>\n\n\n\n<li>At end of <code>body</code> with <code>fetchpriority=low</code>.</li>\n</ol>\n\n\n\n<p>Here are the median metrics for benchmarking 1,000 iterations for each of the four configurations:</p>\n\n\n\n<details class=\"wp-block-details is-layout-flow wp-block-details-is-layout-flow\">Command<pre class=\"wp-block-code\"><span><code class=\"hljs language-bash\">npm run research -- benchmark-web-vitals --number=1000 --output=<span class=\"hljs-string\">\"md\"</span> --network-conditions=<span class=\"hljs-string\">\"broadband\"</span> \\\n  --url <span class=\"hljs-string\">\"http://localhost:10008/bison/?disable_print_script_modules_in_footer&amp;disable_script_fetchpriority_low\"</span> \\\n  --url <span class=\"hljs-string\">\"http://localhost:10008/bison/?disable_print_script_modules_in_footer\"</span> \\\n  --url <span class=\"hljs-string\">\"http://localhost:10008/bison/?disable_script_fetchpriority_low\"</span> \\\n  --url <span class=\"hljs-string\">\"http://localhost:10008/bison/\"</span></code></span></pre></details>\n\n\n\n<figure class=\"wp-block-table benchmark-web-vitals has-medium-font-size\"><table class=\"has-fixed-layout\"><thead><tr><th>Metric</th><th><code>head</code></th><th><code>head</code> + <code>low</code></th><th><code>body</code></th><th><code>body</code> + <code>low</code></th></tr></thead><tbody><tr><td>FCP</td><td>137.9</td><td>143.0</td><td>140.7</td><td>138.8</td></tr><tr><td>LCP</td><td>405.9</td><td>383.7</td><td>376.8</td><td>370.0</td></tr><tr><td>TTFB</td><td>33.7</td><td>34.5</td><td>33.6</td><td>33.7</td></tr><tr><td>LCP-TTFB</td><td>372.2</td><td>349.3</td><td>343.0</td><td>336.3</td></tr></tbody></table></figure>\n\n\n\n<p>When script modules are printed in the footer <em>and</em> they have <code>fetchpriority=low</code>, the result is a &gt;9% improvement to LCP on my test page:</p>\n\n\n\n<details class=\"wp-block-details is-layout-flow wp-block-details-is-layout-flow\">Command<pre class=\"wp-block-code\"><span><code class=\"hljs language-bash\">npm run research -- benchmark-web-vitals --number=100 --output=<span class=\"hljs-string\">\"md\"</span> --network-conditions=<span class=\"hljs-string\">\"broadband\"</span> --diff \\\n  --url <span class=\"hljs-string\">\"http://localhost:10008/bison/?disable_print_script_modules_in_footer&amp;disable_script_fetchpriority_low\"</span> \\\n  --url <span class=\"hljs-string\">\"http://localhost:10008/bison/\"</span></code></span></pre></details>\n\n\n\n<figure class=\"wp-block-table benchmark-web-vitals has-medium-font-size\"><table class=\"has-fixed-layout\"><thead><tr><th>Metric</th><th>Before</th><th>After</th><th>Diff (ms)</th><th>Diff (%)</th></tr></thead><tbody><tr><td>FCP</td><td>137.0</td><td>137.2</td><td>+0.2</td><td>+0.1%</td></tr><tr><td>LCP</td><td>406.0</td><td>368.8</td><td>-37.2</td><td>-9.2%</td></tr><tr><td>TTFB</td><td>33.7</td><td>33.6</td><td>-0.1</td><td>-0.1%</td></tr><tr><td>LCP-TTFB</td><td>371.7</td><td>336.0</td><td>-35.7</td><td>-9.6%</td></tr></tbody></table></figure>\n\n\n\n<p>Of course your mileage will vary. This will primarily benefit <strong>block themes</strong>. A vanilla WordPress install with the stock theme is very lightweight and a typical site will have a lot more going on which will lessen the impact of these optimizations. But still, with these findings I&#8217;ve been working on a <a href=\"https://github.com/WordPress/wordpress-develop/pull/8815\">pull request</a> for <a href=\"https://core.trac.wordpress.org/ticket/61734\" title=\"Add the ability to handle &quot;fetchpriority&quot; to ES Modules and Import Maps\">#61734</a> to implement <code>fetchpriority</code> support for scripts and script modules in WordPress core; it defaults the fetch priority to low for script modules related to the Interactivity API as well as the <code>comment-reply</code> classic script. This feature is a natural progression to follow script loading strategies (<code>async</code> &amp; <code>defer</code>); in fact, we could consider defaulting scripts to add <code>fetchpriority=low</code> if they use the a delayed loading strategy. </p>\n\n\n\n<p>I&#8217;ve filed <a href=\"https://core.trac.wordpress.org/ticket/63486\" title=\"Script modules should support being printed in the footer the same as classic scripts\n\">#63486</a> to implement support for printing script modules in the footer. This work can follow the <code>fetchpriority</code> support as it will be more involved due to the need to account for module dependencies.</p>\n\n\n\n<p>While waiting for these performance enhancements to land in core, you can install the <strong><a href=\"https://github.com/westonruter/script-fetchpriority-low\">Script Fetch Priority Low</a></strong> and <strong><a href=\"https://github.com/westonruter/script-modules-in-footer\">Script Modules in Footer</a></strong> plugins. Let me know if you measure any LCP improvements!</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-medium-font-size\">Where I&#8217;ve shared this:</p>\n\n\n\n<ul class=\"wp-block-social-links is-layout-flex wp-block-social-links-is-layout-flex\"><li class=\"wp-social-link wp-social-link-linkedin  wp-block-social-link\"><a class=\"wp-block-social-link-anchor\" href=\"https://www.linkedin.com/posts/westonruter_improve-lcp-by-deprioritizing-script-modules-activity-7332869961524092928-qv3g\"><svg height=\"24\" version=\"1.1\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M19.7,3H4.3C3.582,3,3,3.582,3,4.3v15.4C3,20.418,3.582,21,4.3,21h15.4c0.718,0,1.3-0.582,1.3-1.3V4.3 C21,3.582,20.418,3,19.7,3z M8.339,18.338H5.667v-8.59h2.672V18.338z M7.004,8.574c-0.857,0-1.549-0.694-1.549-1.548 c0-0.855,0.691-1.548,1.549-1.548c0.854,0,1.547,0.694,1.547,1.548C8.551,7.881,7.858,8.574,7.004,8.574z M18.339,18.338h-2.669 v-4.177c0-0.996-0.017-2.278-1.387-2.278c-1.389,0-1.601,1.086-1.601,2.206v4.249h-2.667v-8.59h2.559v1.174h0.037 c0.356-0.675,1.227-1.387,2.526-1.387c2.703,0,3.203,1.779,3.203,4.092V18.338z\"></path></svg><span class=\"wp-block-social-link-label screen-reader-text\">LinkedIn</span></a></li>\n\n<li class=\"wp-social-link wp-social-link-bluesky  wp-block-social-link\"><a class=\"wp-block-social-link-anchor\" href=\"https://bsky.app/profile/weston.ruter.net/post/3lq42d67nxc2b\"><svg height=\"24\" version=\"1.1\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M6.3,4.2c2.3,1.7,4.8,5.3,5.7,7.2.9-1.9,3.4-5.4,5.7-7.2,1.7-1.3,4.3-2.2,4.3.9s-.4,5.2-.6,5.9c-.7,2.6-3.3,3.2-5.6,2.8,4,.7,5.1,3,2.9,5.3-5,5.2-6.7-2.8-6.7-2.8,0,0-1.7,8-6.7,2.8-2.2-2.3-1.2-4.6,2.9-5.3-2.3.4-4.9-.3-5.6-2.8-.2-.7-.6-5.3-.6-5.9,0-3.1,2.7-2.1,4.3-.9h0Z\"></path></svg><span class=\"wp-block-social-link-label screen-reader-text\">Bluesky</span></a></li>\n\n<li class=\"wp-social-link wp-social-link-twitter  wp-block-social-link\"><a class=\"wp-block-social-link-anchor\" href=\"https://x.com/westonruter/status/1927104556170662353\"><svg height=\"24\" version=\"1.1\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M22.23,5.924c-0.736,0.326-1.527,0.547-2.357,0.646c0.847-0.508,1.498-1.312,1.804-2.27 c-0.793,0.47-1.671,0.812-2.606,0.996C18.324,4.498,17.257,4,16.077,4c-2.266,0-4.103,1.837-4.103,4.103 c0,0.322,0.036,0.635,0.106,0.935C8.67,8.867,5.647,7.234,3.623,4.751C3.27,5.357,3.067,6.062,3.067,6.814 c0,1.424,0.724,2.679,1.825,3.415c-0.673-0.021-1.305-0.206-1.859-0.513c0,0.017,0,0.034,0,0.052c0,1.988,1.414,3.647,3.292,4.023 c-0.344,0.094-0.707,0.144-1.081,0.144c-0.264,0-0.521-0.026-0.772-0.074c0.522,1.63,2.038,2.816,3.833,2.85 c-1.404,1.1-3.174,1.756-5.096,1.756c-0.331,0-0.658-0.019-0.979-0.057c1.816,1.164,3.973,1.843,6.29,1.843 c7.547,0,11.675-6.252,11.675-11.675c0-0.178-0.004-0.355-0.012-0.531C20.985,7.47,21.68,6.747,22.23,5.924z\"></path></svg><span class=\"wp-block-social-link-label screen-reader-text\">Twitter</span></a></li>\n\n<li class=\"wp-social-link wp-social-link-mastodon  wp-block-social-link\"><a class=\"wp-block-social-link-anchor\" href=\"https://mastodon.social/@westonruter/114576094434226318\"><svg height=\"24\" version=\"1.1\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M23.193 7.879c0-5.206-3.411-6.732-3.411-6.732C18.062.357 15.108.025 12.041 0h-.076c-3.068.025-6.02.357-7.74 1.147 0 0-3.411 1.526-3.411 6.732 0 1.192-.023 2.618.015 4.129.124 5.092.934 10.109 5.641 11.355 2.17.574 4.034.695 5.535.612 2.722-.15 4.25-.972 4.25-.972l-.09-1.975s-1.945.613-4.129.539c-2.165-.074-4.449-.233-4.799-2.891a5.499 5.499 0 0 1-.048-.745s2.125.52 4.817.643c1.646.075 3.19-.097 4.758-.283 3.007-.359 5.625-2.212 5.954-3.905.517-2.665.475-6.507.475-6.507zm-4.024 6.709h-2.497V8.469c0-1.29-.543-1.944-1.628-1.944-1.2 0-1.802.776-1.802 2.312v3.349h-2.483v-3.35c0-1.536-.602-2.312-1.802-2.312-1.085 0-1.628.655-1.628 1.944v6.119H4.832V8.284c0-1.289.328-2.313.987-3.07.68-.758 1.569-1.146 2.674-1.146 1.278 0 2.246.491 2.886 1.474L12 6.585l.622-1.043c.64-.983 1.608-1.474 2.886-1.474 1.104 0 1.994.388 2.674 1.146.658.757.986 1.781.986 3.07v6.304z\"></svg><span class=\"wp-block-social-link-label screen-reader-text\">Mastodon</span></a></li></ul>\n\n\n\n<p><strong>Shameless plug:</strong> I found out last month that my 6½-year position at Google was eliminated. I was <a href=\"https://weston.ruter.net/2018/09/19/becoming-a-googler/\">hired</a> to work on WordPress full time, and I&#8217;ve been <a href=\"https://weston.ruter.net/2025/05/14/a-decade-as-a-core-committer-my-wordpress-contribution-history/\">contributing to WordPress</a> as a core committer for over 10 years. Most recently I&#8217;ve worked heavily on the Core Performance team. I&#8217;m currently #opentowork, hoping to find a full time position as a sponsored contributor at another company that also cares about the health of the open web. Alternatively, I&#8217;m exploring the feasibility of being <a href=\"https://github.com/sponsors/westonruter\">sponsored</a> as an independent contributor. If you find my open source work valuable, maybe you can help sustain my contributions?</p>\n\n\n<ol class=\"wp-block-footnotes has-small-font-size\"><li id=\"c7a2be25-eace-4671-8089-f9286a5703ea\">I used an Image block as opposed to setting the featured image so that I could use the “Enlarge on click” setting which involves the interactivity, but see also <a href=\"https://weston.ruter.net/2025/05/17/adding-caption-and-lightbox-to-the-featured-image-block/\">my post</a> about how the Featured Image block can also be extended with a lightbox. <a href=\"https://weston.ruter.net/category/wordpress/feed/#c7a2be25-eace-4671-8089-f9286a5703ea-link\">↩︎</a></li><li id=\"b77dfd89-ba79-47f9-b93a-b5825558c8a3\">The one exception here is the <a href=\"https://wordpress.org/documentation/article/file-block/\">File block</a> when a PDF is selected and the “Show inline embed” <a href=\"https://wordpress.org/documentation/article/file-block/#:~:text=If%20you%20upload%20a%20PDF%20file%2C%20you%E2%80%99ll%20see%20a%20PDF%20settings%20section%20on%20the%20block%20settings.\">setting</a> is enabled. In this case, JavaScript runs when the block initializes to <a href=\"https://github.com/WordPress/gutenberg/blob/8889f82eda340ea66c83e945098423ed1ae3f5d3/packages/block-library/src/file/view.js#L13-L17\">populate the <code>hasPdfPreview</code> state</a>, and this then changes the element&#8217;s <code>hidden</code> state from <code>true</code> to <code>false</code> if the browser supports rendering PDFs. This is an exceptional case, however, and it would be rare for a File block to appear in the initial viewport and be the LCP element. The script module for the File block should only have a high fetch priority if (1) a PDF is selected, (2) the “Show inline embed” setting is enabled, and (3) the block appears in the initial viewport (on desktop or mobile). This is something that <a href=\"https://github.com/WordPress/performance/blob/trunk/plugins/optimization-detective/docs/introduction.md\">Optimization Detective</a> could facilitate. <a href=\"https://weston.ruter.net/category/wordpress/feed/#b77dfd89-ba79-47f9-b93a-b5825558c8a3-link\">↩︎</a></li></ol><p>The post <a href=\"https://weston.ruter.net/2025/05/26/improve-lcp-by-deprioritizing-interactivity-api-script-modules/\">Improve LCP by Deprioritizing  Script Modules from the Interactivity API</a> appeared first on <a href=\"https://weston.ruter.net\">Weston Ruter</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 26 May 2025 20:36:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Weston Ruter\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"Do The Woo Community: WordPress Multilingual, Translation and Community with Pascal Birchler and Robert Windisch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://openchannels.fm/?p=97013\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"https://openchannels.fm/wordpress-multilingual-translation-and-community-with-pascal-birchler-and-robert-windisch/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:246:\"In this episode of The WordPress Way, listen to shared insights on translating WordPress, performance boosts, community involvement, and future multilingual features. They emphasize the ongoing need for translators and collaboration in WordPress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 26 May 2025 09:01:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Bob Dunn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:115:\"Gutenberg Times: Feature API, Playground, Gutenberg 20.9, Interactivity API, #WCUS and moar — Weekend Edition 331\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=40505\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:117:\"https://gutenbergtimes.com/feature-api-playground-gutenberg-20-9-interactivity-api-wcus-and-moar-weekend-edition-331/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:19961:\"<p>Howdy,</p>\n\n\n\n<p></p>\n\n\n\n<p>This week, I continued to learn about more plugins for the block editor. They might be new to the WordPress repository or just new to me, haha.  Also, Playground came up in the last couple of weeks, and I share two tutorials and a video about my workshop at WordCamp Europe.  And via the Feature API you can prepare your plugins for AI Agents. </p>\n\n\n\n<p>As every year, WordCamp Europe will also have a Live stream for the talks and keynotes. Just check out the website on Jun 6th, 2025.  The next Weekend Edition will drop in your inbox after WordCamp Europe and I will share some cool talks from the live stream. </p>\n\n\n\n<p>Until have a great time! </p>\n\n\n\n<p>Yours, <img alt=\"💕\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f495.png\" style=\"height: 1em;\" /><br /><em>Birgit</em></p>\n\n\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p class=\"has-small-font-size\">WordCamp Europe is just around the corner! <img alt=\"🎉\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f389.png\" style=\"height: 1em;\" /> If you want to meet up in Basel (June 4–7), <a href=\"https://calendly.com/pauli-haack/wordcamp-europe\">grab a slot on my calendar</a> or send me your link. <a href=\"https://mastodon.social/tags/WCEU\">#WCEU</a></p>\n\n\n\n<figure class=\"wp-block-image size-full is-style-no-vertical-margin\"><a href=\"https://calendly.com/pauli-haack/wordcamp-europe\"><img alt=\"\" class=\"wp-image-40524\" height=\"367\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/05/Book-a-meeting-with-Birgit-Pauli-Haack.jpg?resize=652%2C367&#038;ssl=1\" width=\"652\" /></a></figure>\n</div></div>\n\n\n<section class=\"wp-block-newsletterglue-group\" style=\"padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;\"></section>\n\n\n<p>ICYMI: <a href=\"https://us.wordcamp.org/2025/call-for-speakers/\"><strong>WordCamp US Call for Speaker is now live</strong></a> the deadline is June 20, 2025. WordCamp US will take place from August 26 to 29th, 2025. Similar to last year, there are no lightening talks, only long form talks, workshops, or campfire sessions. August 26 will be Contributor Day. Sessions start on August 27 in three tracks. You need to have a WordPress.org account to enter the form. The <a href=\"https://us.wordcamp.org/2025/call-for-sponsors/\">Call for Sponsors</a> has also been published. </p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://us.wordcamp.org/2025/call-for-speakers-wordcamp-us-2025/\"><img alt=\"\" class=\"wp-image-40544\" height=\"343\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/05/WordCamp-US-2025-Call-For-Speakers-1.png?resize=652%2C343&#038;ssl=1\" width=\"652\" /></a></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p><strong>George Mamadashvili</strong> just dropped the <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v20.9.0-rc.1\">Gutenberg 20.9 RC1</a> for everyone to test out, and we’re expecting the final version to go live next week! After WordCamp Europe, I&#8217;ll catch up with Anne McCarthy to record our next Gutenberg Changelog, where we’ll chat about a bunch of stuff, including those two Gutenberg plugin releases, 20.9 and 21.0.</p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p><img alt=\"🎙\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f399.png\" style=\"height: 1em;\" /> The latest episode <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-117-woocommerce-starter-theme-and-blocks/\">Gutenberg Changelog 117 – WooCommerce Starter Theme and Blocks, WordCamp Europe, and Gutenberg 20.7 and 20.8</a> I sat down with Ellen Bauer, WooCommerce product lead and discussed what she is working on, WordCamp Europe, Create Block Theme, WP-CLI, Gutenberg 20.7 and Gutenberg 20.8 releases. </p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img alt=\"Ellen Bauer and Birgit Pauli-Haack recording Gutenberg Changelog 117\" class=\"wp-image-40375\" height=\"184\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2022/03/Screenshot-2025-05-10-at-12.16.57.png?resize=652%2C184&#038;ssl=1\" width=\"652\" /></figure>\n</div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p><strong>Johanne Courtright </strong>explains how <a href=\"https://groundworx.dev/gutenberg-is-a-game-changer-and-clients-actually-love-it-when-done-right/\"><strong>Gutenberg is a game-changer — and clients actually love it (when done right).</strong></a> When implemented thoughtfully, she found, the Gutenberg editor revolutionizes WordPress by empowering clients with intuitive, flexible content creation. In her experience, clients express genuine satisfaction, as Gutenberg’s block-based approach simplifies editing and design, making website management more accessible and enjoyable for non-technical users.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Kevin Batdorf</strong> <a href=\"https://x.com/kevinbatdorf/status/1924334824640451038\">updated</a> his plugin <a href=\"https://wordpress.org/plugins/pattern-css/\"><strong>Pattern CSS</strong></a> . It lets you add CSS scoped to a block, and recently added a floating editor as well as a global CSS editor, making it easy to add custom animations or anything. It&#8217;s parsed via Lightening CSS in WebAssembly as you type, and works well with synced patterns.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://bsky.app/profile/zodiac1978.bsky.social\">Thorsten Landsiedel</a></strong> published a plugin called &#8220;<a href=\"https://github.com/Zodiac1978/hide-in-feed\"><strong>Hide Block in RSS feed</strong>,</a>&#8221; which adds a toggle switch to block sidebars for suppressing content in RSS feeds. In his talk at WordCamp Leipzig, he noted that decorative icons/images may display differently in RSS readers. Using this block you can improve readability by suppressing specific blocks in the feeds. The <a href=\"https://github.com/Zodiac1978/hide-in-feed\">plugin is available</a> on GitHub.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Weston Ruter</strong>, a long-time WordPress Core committer, explains step-by step how he <a href=\"https://weston.ruter.net/2025/05/17/adding-caption-and-lightbox-to-the-featured-image-block/\"><strong>added caption and lightbox to the featured image block</strong></a>. When Weston Ruter rebuilt his site with the Twenty Twenty-Five theme, he noticed the Featured Image block lacked caption and lightbox features. Both features are available for the Image block. Ruter shared code examples on how he implemented these features in a plugin. Then he also suggested future improvements for WordPress core.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><a href=\"https://wordpress.org/plugins/wm-animations/\"><strong>WM Animations</strong></a> plugin by <strong>Widescreen Media</strong>, a company from Sweden, helps users to add entrance animations like fade-in and slide-in to core blocks. &#8220;You can select animation type and adjust duration/delay per block, directly in the block inspector. Works well with all core blocks and most custom blocks.&#8221; <a href=\"https://widescreen.media/\">Widescreen Media&#8217;s website</a> might be the best demo for this plugin.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Andy Fragen</strong>, core contributor and trauma surgeon, authored quite a few <a href=\"https://profiles.wordpress.org/afragen/#content-plugins\">plugins</a>. The <strong><a href=\"https://wordpress.org/plugins/oembed-gist-files/\">oEmbed for GitHub Gist</a> </strong>plugin enables writers to add code from  GitHub Gists via the Embed block to their posts. For classic editor users, you just put the URL on a new line. </p>\n\n\n<section class=\"wp-block-newsletterglue-callout undefined not-color-set\" style=\"border-color: #f9f9e5; border-radius: 22px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f9f9e5;\">\n<p><strong> <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" rel=\"noreferrer noopener\" target=\"_blank\">&#8220;Keeping up with Gutenberg &#8211; Index 2025&#8221;</a> </strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. The previous years are also available: <strong><strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">2020</a> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/\">2021</a></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/\">2022</a></strong></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023\">2023</a></strong> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2024/\"><strong>2024</strong></a></p>\n</section>\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor</h2>\n\n\n\n<p><a href=\"https://wordpress.tv/event/wordcamp-lisboa-2025/\">Video recordings from <strong>Lisboa&#8217;s WordCamp 2025</strong></a> are already available on WordPressTV </p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://wordpress.tv/2025/05/19/wordpress-gems-for-devs-interactivity-api/\"><strong>WordPress gems for devs: Interactivity API</strong></a> with Milana Cap</li>\n\n\n\n<li><a href=\"https://wordpress.tv/2025/05/19/connecting-custom-fields-from-meta-boxes-to-blocks-and-beyond/\"><strong>Connecting custom fields: From meta boxes to blocks and beyond</strong></a> with Ryan Welcher </li>\n\n\n\n<li><a href=\"https://wordpress.tv/2025/05/19/woocommerce-checkout-block-what-you-missed/\"><strong>WooCommerce Checkout block, what you missed!</strong></a> with Nadir Seghir<br /></li>\n</ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Seth Rubenstein</strong>, lead engineer at Pew Research Center, <a href=\"https://x.com/SethRubenstein/status/1923426022285799842\">decided</a> to take a break from regularly scheduled work to play around with an <a href=\"https://github.com/pewresearch/wp-interactivity-api-chrome-extension\"><strong>Interactivity API (iAPI) Inspector Chrome Extension</strong></a>. This tool offers dev tools to highlight iAPI directives and context associated with a block as well as map connections between iAPI stores on a page.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://github.com/pewresearch/wp-interactivity-api-chrome-extension\"><img alt=\"Screenshot of the Interactivity API Inspector Chrome Extension\" class=\"wp-image-40546\" height=\"264\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/05/Screenshot-2025-05-23-at-15.45.53.png?resize=652%2C264&#038;ssl=1\" width=\"652\" /></a></figure>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Jonathan Bossenger</strong> has spent some time the last couple of weeks learning more about <a href=\"https://github.com/Automattic/wp-feature-api\">Feature API</a>, the <a href=\"https://github.com/Automattic/wordpress-mcp\">WordPress MCP</a> plugin and the MCP WordPress remote package. In his latest video, <a href=\"https://www.youtube.com/watch?v=PsrrTZ6Ph3I\"><strong>Are your WordPress plugins and themes ready for AI?</strong></a> he puts it all together using one of his plugins and shows the various steps:  </p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Registering Features with the Feature API Plugin</li>\n\n\n\n<li>Converting Features into Tools with MCP Plugin</li>\n\n\n\n<li>Configuring AI Tools to Use MCP Features</li>\n</ul>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<p>Once you watched the video a couple of times, it might be helpful to also read <strong>Jamie Marsland</strong>&#8216;s post on LinkedIn again:  <a href=\"https://www.linkedin.com/pulse/wordpress-sitting-goldmine-feature-api-just-dug-first-jamie-marsland-3sije/?trackingId=qVLCTVZZSniPqxIiHZRpdQ%3D%3D\"><strong>WordPress Is Sitting on a Goldmine — And the Feature API Just Dug the First Tunnel</strong></a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In this week&#8217;s live stream, <strong>Ryan Welcher</strong> also took a <a href=\"https://www.youtube.com/watch?v=HqLXvOneHHw\" rel=\"noreferrer noopener\" target=\"_blank\"><strong>A first look at the new WordPress Feature API</strong></a>. He calls the Feature API &#8220;a powerful new way of exposing WordPress functionality in a standardized, discoverable way for both server and client-side use.&#8221;</p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<h2 class=\"wp-block-heading\" id=\"what-is-new-in-playground\">What is new in Playground?</h2>\n\n\n\n<p>Roger Williams and I spoke about my upcoming WordCamp EU workshop.&#8221; &#8220;<a href=\"https://europe.wordcamp.org/2025/session/from-zero-to-demo-mastering-wordpress-playground-blueprints/\"><em>From Zero to Demo: Mastering WordPress Playground Blueprints</em></a>&#8220;. The recording is available on YouTube <a href=\"https://www.youtube.com/watch?v=BDBZKjV3Js0\"><strong>WordPress Playground Workshop Preview with Birgit Pauli-Haack</strong></a></p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Karthick Murugan</strong>, from the Multidots team,  updated documentation with everything you want to know about the current web instance: <a href=\"https://wordpress.github.io/wordpress-playground/web-instance\"><strong>WordPress Playground web instance</strong></a>. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Earlier this week, I wrote about the early version of the <a href=\"https://www.npmjs.com/package/@wp-playground/cli\">Playground CLI</a> and how to use it to test your plugin and theme in development or your blueprints locally. <a href=\"https://icodeforapurpose.com/early-version-playground-cli-testing/\"><strong>Early version Playground CLI testing</strong></a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In <a href=\"https://icodeforapurpose.com/automating-wordpress-playground-screenshots-with-node-js-and-playwright/\"><strong>Automating WordPress Playground Screenshots with Node.js and Playwright</strong></a> I shared the context and code using the JavaScript API to call a with a playwright browser instance to take a screenshot of the Playground site configured with a blueprint.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n<section class=\"wp-block-newsletterglue-callout undefined not-color-set\" style=\"border-color: #eeeeee; border-radius: 26px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f3efe9;\">\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. </p>\n\n\n\n<p>Now also available via <a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href=\"mailto:pauli@gutenbergtimes.com\">Email me </a>with your experience</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n</section>\n\n\n<p class=\"has-text-align-center has-small-font-size\"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, <br />send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n<section class=\"wp-block-newsletterglue-group\" style=\"padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;\">\n<p>Featured Image: Photo by Ivan Bandura on Unsplash</p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n<form action=\"https://gutenbergtimes.com/feed/\" autocomplete=\"on\" class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\" style=\"margin-bottom: 25px;\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input autocomplete=\"email\" class=\"ngl-form-input-text\" id=\"ngl_email\" name=\"ngl_email\" required=\"required\" style=\"border-radius: 21px;\" type=\"email\" /></div></div><button class=\"ngl-form-button\" style=\"background-color: #005075; border-color: #005075; border-width: 1px; border-style: solid; color: #ffffff; border-radius: 21px;\" type=\"submit\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too, and won&#8217;t give your email address to anyone <br />except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"><svg fill=\"none\" height=\"24\" stroke=\"#fff\" stroke-width=\"2\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><polyline points=\"20 6 9 17 4 12\"></polyline></svg></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input id=\"ngl_list_id\" name=\"ngl_list_id\" type=\"hidden\" value=\"26f81bd8ae\" /><input id=\"ngl_double_optin\" name=\"ngl_double_optin\" type=\"hidden\" value=\"yes\" /></form>\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n</section>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 24 May 2025 09:15:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Gravatar: Proven Branding Methods for Professional Coaches\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://blog.gravatar.com/?p=3184\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://blog.gravatar.com/2025/05/23/branding-for-coaches/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:15736:\"<p>Are you looking for a way to differentiate your coaching services in a competitive online market? You&#8217;re not alone. Many coaches struggle to stand out among thousands of others offering similar services.</p>\n\n\n\n<p>Here&#8217;s the good news: <strong>Effective coach branding doesn&#8217;t require massive budgets or complex systems.</strong> Instead, success comes from focusing on a few foundational pillars: Optimizing your digital presence, promoting your services strategically, and tracking performance consistently.</p>\n\n\n\n<p>And no, you don&#8217;t need to hire expensive agencies or completely redesign your business. Small, targeted improvements to your branding can yield significant results in attracting your ideal clients.</p>\n\n\n\n<p>This guide cuts through the theory and provides practical, proven branding techniques specifically for coaches. Each strategy is designed to help you build a distinctive professional identity that resonates with potential clients and positions you as the obvious choice in your coaching niche.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Essential elements of a professional coaching brand</strong></h2>\n\n\n\n<p>The foundation of any successful coaching business isn&#8217;t flashy graphics or clever slogans – it&#8217;s a consistent multi-platform presence strategy. This means maintaining a unified professional identity across coaching directories, your website, social media profiles, and professional networks. Tools like <a href=\"https://gravatar.com\">Gravatar</a> can help automate this consistency, ensuring your professional image remains cohesive wherever potential clients encounter you online.</p>\n\n\n\n<p><strong>A big part of that consistency is demonstrating your expertise.</strong> Potential clients need clear evidence of your capabilities through certifications, testimonials, and client success stories prominently displayed in your professional bios and website. These serve as social proof that validates your coaching abilities to skeptical prospects.</p>\n\n\n\n<p>Video content has become a particularly powerful way to showcase expertise. According to <a href=\"https://wistia.com/learn/marketing/video-marketing-statistics\">Wistia&#8217;s 2025 State of Video Report</a>, short-form video content significantly outperforms other formats in engagement rates, with how-to videos under one minute achieving 82% viewer completion. <a href=\"https://www.instagram.com/\">Instagram</a> reels and <a href=\"https://www.tiktok.com/\">TikTok</a> tutorials offer perfect platforms to demonstrate your coaching approach in action.</p>\n\n\n\n<p>To truly stand out, develop proprietary frameworks or methodologies that distinguish your services from generic coaching approaches. This gives clients a concrete system to understand and helps position you as an innovative thinker in your field.</p>\n\n\n\n<p>On top of that, you need to take whatever time you need to identify what makes your coaching unique – your background, approach, client specialization, or results – and weave these elements into a compelling coaching story that resonates with your target audience.</p>\n\n\n\n<p>Now, let&#8217;s explore some practical ways to build these brand pillars.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>How Gravatar powers your coaching brand identity</strong></h2>\n\n\n\n<figure class=\"wp-block-image size-full\"><img alt=\"1 – Gravatar homepage\" class=\"wp-image-3187\" height=\"1298\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/04/1-gravatar-new-homepage.png\" width=\"2492\" /></figure>\n\n\n\n<p>Establishing a consistent online presence is one of the biggest challenges for coaches, but thankfully, this is where <a href=\"https://gravatar.com\">Gravatar</a> steps in as a powerful brand management tool. As a &#8220;Globally Recognized Avatar,&#8221; Gravatar can become like a central identity hub that automatically syncs across thousands of platforms, eliminating the frustration of managing multiple profiles.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img alt=\"2 – Ronnie Burt Gravatar profile\" class=\"wp-image-3188\" height=\"1323\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/04/2-ronnie-new-gravatar-profile.png\" width=\"1755\" /></figure>\n\n\n\n<p>Think of Gravatar as your <a href=\"https://blog.gravatar.com/2024/11/08/creating-a-digital-business-card/\">digital business card</a> on steroids. It connects your professional image, bio, and credentials across coaching directories, blog comments, professional forums, and social platforms. When potential clients encounter you across different channels, they&#8217;ll recognize your consistent presence immediately, crucial for building recognition in a crowded coaching marketplace.</p>\n\n\n\n<p>The trust factor gets a significant boost with Gravatar&#8217;s verification system. Each link on your profile can display a &#8220;verified&#8221; tick, signalling authenticity to sceptical prospects. In coaching, where trust is everything, these small trust signals make a substantial difference in conversion rates.</p>\n\n\n\n<p>Your Gravatar profile can even live as a <a href=\"https://docs.gravatar.com/2024/05/23/qr-me-this-qr-me-that/\">QR code</a> in your phone&#8217;s digital wallet, making <a href=\"https://blog.gravatar.com/2024/06/16/how-to-network-at-a-conference/\">in-person networking seamless</a>. </p>\n\n\n\n<figure class=\"wp-block-image\"><img alt=\"3 – Adding a Gravatar QR code to your phone wallet \" src=\"https://lh7-rt.googleusercontent.com/docsz/AD_4nXf5MKKCpsP1BhXvYsdilJmK9Ty2TOjDVzHqlY_ikPaU8fj3Y3Fc8LuLNxrpFfbeGzcGlHQj-HEJgYheCu0ssRwG3MOFvYdql30cIUEFHjfwCv0pg977B1coL7VtyIf_7em26gSXiQ?key=sqicWRy8nfW2FmPeb7oslwrq\" /></figure>\n\n\n\n<p>Update your credentials once, and the changes reflect everywhere – saving hours of profile management while maintaining brand consistency.</p>\n\n\n\n<p>Ready to strengthen your coaching brand? <a href=\"https://gravatar.com/\">Get your free Gravatar profile</a> today and bring cohesion to your digital presence.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://gravatar.com/connect/?gravatar_from=blog\"><img alt=\"\" class=\"wp-image-2616\" height=\"729\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/free_profile_cta.png\" width=\"3243\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Building trust through verified profiles and consistent presence</strong></h3>\n\n\n\n<p>Verification is no longer optional in the coaching industry – it&#8217;s essential. When potential clients research your services, they&#8217;re looking for trust signals that verify your authenticity and expertise. Social media verification acts as a powerful trust marker in a saturated market.</p>\n\n\n\n<p><a href=\"https://www.instagram.com/\">Instagram</a> deserves special attention in your verification strategy. According to <a href=\"https://luisazhou.com/blog/instagram-for-coaches/\">research from Luisa Zhou</a>, this platform is where many coaches successfully find their highest-quality clients, with 54% of Instagram users making purchases after discovering services there. So naturally, verifying your Instagram presence should be a priority.</p>\n\n\n\n<p>Similarly, establishing verified presence on X (formerly Twitter) creates additional credibility touchpoints in your professional ecosystem.</p>\n\n\n\n<p>For coaches using newer platforms like <a href=\"https://blog.gravatar.com/2024/12/03/new-free-domains-and-bluesky-integration/\">Bluesky</a>, Gravatar offers a unique advantage – you can get a <a href=\"https://blog.gravatar.com/2025/02/06/bluesky-handle/\">custom Bluesky domain name</a> and verify it directly through Gravatar, creating an additional layer of professional credibility.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"4 – Changing the Bluesky domain to a custom one through Gravatar\" class=\"wp-image-3189\" height=\"394\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/04/4-domain-updated-confirmation.png?w=660\" width=\"660\" /></figure>\n\n\n\n<p>Gravatar&#8217;s &#8220;update once, sync everywhere&#8221; system means your verified professional image automatically appears across hundreds of platforms – from WordPress blogs where you guest post to professional forums where you engage potential clients.</p>\n\n\n\n<p>Think of Gravatar as the foundation of your coaching trust architecture. It creates a central verification hub from which <a href=\"https://blog.gravatar.com/2024/12/02/how-can-you-manage-your-digital-footprint/\">all aspects of your digital footprint link back</a>, establishing a cohesive professional identity that builds client confidence at every digital touchpoint.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Practical strategies to promote your coaching brand</strong></h2>\n\n\n\n<p>Establishing credibility through a verified online presence remains the cornerstone of successful coach branding. Creating a verified professional presence using Gravatar across coaching platforms and professional networks provides the essential foundation upon which all other brand-building activities should build. This baseline credibility creates the trust necessary for potential clients to consider your services.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Position yourself as a thought leader</strong></h3>\n\n\n\n<p>To elevate beyond basic verification, position yourself as a thought leader through specialized content that directly addresses specific pain points in your coaching niche. This approach demonstrates your expertise while providing immediate value to potential clients.</p>\n\n\n\n<p>Effective thought leadership channels include:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://www.linkedin.com/\"><strong>LinkedIn</strong></a><strong> articles</strong> that dissect complex coaching challenges.</li>\n\n\n\n<li><a href=\"https://www.instagram.com/\"><strong>Instagram</strong></a><strong> carousels</strong> explaining your methodologies (these have 82% higher engagement for coaching content).</li>\n\n\n\n<li><strong>Blog posts</strong> on your website that showcase your unique perspective.</li>\n\n\n\n<li><strong>Email newsletters</strong> with actionable insights.</li>\n</ul>\n\n\n\n<p>The most successful coaches don&#8217;t create generic content – they develop material that speaks directly to their audience&#8217;s most pressing challenges, demonstrating both understanding and solution expertise.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Develop your signature framework</strong></h3>\n\n\n\n<p>Creating a distinctive &#8220;signature framework&#8221; dramatically separates your coaching brand from competitors while simplifying your marketing message. For example, a life coach specializing in work-life balance might develop &#8220;The Balance Blueprint&#8221; – a structured, step-by-step process clients follow to achieve harmony between career and personal priorities.</p>\n\n\n\n<p>Your signature framework accomplishes two critical objectives simultaneously:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>It clarifies your methodology for potential clients.</li>\n\n\n\n<li>It creates a memorable brand element that differentiates you from generic coaching approaches.</li>\n</ul>\n\n\n\n<p>This combination builds both trust and recognition – the twin pillars of effective coach branding.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Forge strategic partnerships</strong></h3>\n\n\n\n<p>Explore high-value coaching partnerships with complementary service providers and industry experts. A relationship coach might partner with a financial advisor to address money conflicts in relationships, creating a more comprehensive solution while accessing a new client base.</p>\n\n\n\n<p>Additionally, seek opportunities to speak at industry conferences and events. These platforms position you as an authority while creating valuable networking opportunities with potential clients and partners who already recognize your expertise.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Measure your brand&#8217;s impact and reach</strong></h3>\n\n\n\n<p>Without tracking key metrics, you&#8217;re essentially operating in the dark, making decisions based on gut feeling rather than data.</p>\n\n\n\n<p><strong>Start by monitoring these fundamental metrics that directly reflect your brand&#8217;s performance:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Track not just visitor numbers but engagement metrics like time-on-page and bounce rates.</li>\n\n\n\n<li>Measure shares, comments, and saves (not just likes).</li>\n\n\n\n<li>Monitor conversion rates from brand touchpoints to inquiries.</li>\n</ul>\n\n\n\n<p>Tools like <a href=\"https://marketingplatform.google.com/about/analytics/\">Google Analytics</a> provide comprehensive website insights, while platform-specific analytics like Instagram Insights and LinkedIn Analytics reveal how your content performs across different channels.</p>\n\n\n\n<p><strong>Still, data without action is useless.</strong> Use your metrics to continuously refine your approach:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Identify which topics generate the most engagement and double down.</li>\n\n\n\n<li>Spot underperforming channels and either optimize or reallocate resources.</li>\n\n\n\n<li>Test different content formats to determine what resonates best with your audience.</li>\n</ul>\n\n\n\n<p>When metrics show declining engagement, don&#8217;t just produce more content – produce better content that addresses the specific needs revealed in your data.</p>\n\n\n\n<p>And, once you do get the results you want, make sure you document your success stories – the most compelling brand assets are documented client transformations. Create systematic before-and-after assessments that quantify client progress:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Standardized assessment tools that measure baseline and improvement.</li>\n\n\n\n<li>Periodic progress check-ins that document incremental gains.</li>\n\n\n\n<li>Video testimonials that capture emotional and practical outcomes.</li>\n</ul>\n\n\n\n<h1 class=\"wp-block-heading\"><strong>Take your coaching brand to the next level</strong></h1>\n\n\n\n<p>Building a verified, consistent online presence using tools like Gravatar creates the essential foundation for your coaching brand. This strategic approach eliminates the fragmentation that undermines many coaches&#8217; digital presence while establishing the credibility necessary to convert prospects into clients.</p>\n\n\n\n<p>With Gravatar handling your consistent visual representation across platforms, you&#8217;re free to focus on what truly matters – delivering high-value client interactions through optimized touchpoints. Your social media engagement, website inquiries, and professional forum participation all benefit from the trust architecture you&#8217;ve established.</p>\n\n\n\n<p>To sum it up, here’s what you need for success: </p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>A proprietary methodology that becomes synonymous with your name.</li>\n\n\n\n<li>Diverse content formats that appeal to different learning styles.</li>\n\n\n\n<li>Strategic partnerships that expand your reach into complementary audiences.</li>\n</ul>\n\n\n\n<p>The coaches who succeed don&#8217;t try to implement everything at once. They start with fundamentals, like<a href=\"https://gravatar.com/\"> creating a free Gravatar profile</a>, and systematically build their brand presence over time.</p>\n\n\n\n<p>Remember that brand development is a gradual, ongoing process. Each small improvement compounds, creating a professional presence that stands out in a crowded marketplace. </p>\n\n\n\n<p>Happy branding!</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://gravatar.com/connect/?gravatar_from=blog\"><img alt=\"\" class=\"wp-image-2616\" height=\"729\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/free_profile_cta.png\" width=\"3243\" /></a></figure>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 23 May 2025 17:44:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Ronnie Burt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"Gravatar: What Makes a Digital Avatar Effective\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://blog.gravatar.com/?p=3289\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://blog.gravatar.com/2025/05/23/what-is-a-digital-avatar/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:19145:\"<p>Fun fact: The global digital avatar market is hurtling toward a whopping<a href=\"https://www.grandviewresearch.com/industry-analysis/digital-avatar-market-report\"> <strong>$270.61 billion</strong> by 2030</a>. That’s up from just $18.19 billion in 2023.</p>\n\n\n\n<p>What began as a simple, low-quality profile picture you might put on mIRC or MySpace can now become a full-blown brand asset. The kind that drives clicks, builds trust, and boosts conversions like a charm. </p>\n\n\n\n<p><em>But…</em> not all avatars are created equal. So what separates the forgettable from the phenomenal?</p>\n\n\n\n<p>Effective avatars are <em>engagement machines,</em> and brands that get it right are seeing:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Higher user engagement across channels.</li>\n\n\n\n<li>Sharper brand recall (because yep, that tiny image sticks).</li>\n\n\n\n<li>Better conversion rates on platforms with consistent avatar use.</li>\n\n\n\n<li>Warmer, more personal user experiences that actually build trust.</li>\n</ul>\n\n\n\n<p>This is more than some passing tech phase, it’s a fundamental shift in how digital identity is experienced. As AI-powered avatars and virtual reps get smarter, businesses are tapping into a new kind of connection – fast, human, and scalable.</p>\n\n\n\n<p>In this guide, we’ll walk you through how to build and deploy avatars that <em>work</em>, from brand consistency and personalization to next-gen tools like <a href=\"https://gravatar.com\">Gravatar</a> that simplify your digital identity across the web.</p>\n\n\n\n<p>No more juggling profile pics across platforms. No more brand dissonance. With a smart avatar strategy, you update once and show up everywhere, looking exactly how you want to.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://gravatar.com/connect/?gravatar_from=blog\"><img alt=\"\" class=\"wp-image-2616\" height=\"729\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/free_profile_cta.png\" width=\"3243\" /></a></figure>\n\n\n\n<h2 class=\"wp-block-heading\">What makes a digital avatar effective: Definition and importance</h2>\n\n\n\n<p>Digital avatars are not just sci-fi playthings anymore. These digital doppelgängers are the new face of brands and professionals online, popping up everywhere from sales decks to marketing assets and customer chats. </p>\n\n\n\n<p>Here’s the kicker: According to <a href=\"https://pmc.ncbi.nlm.nih.gov/articles/PMC9763494/\">research from the National Institutes of Health</a>, our brains respond to avatars <em>a lot</em> like we respond to real humans. Wild, right? But also incredibly useful. Because that means every time a customer sees your avatar, they’re not just spotting a fancy graphic – they’re building a sense of connection, trust, and familiarity, just like they would with a real-life person.</p>\n\n\n\n<p>Why does that matter? Well:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Avatars act as a consistent visual cue across all your brand’s touchpoints</li>\n\n\n\n<li>They turn dry, technical info into something surprisingly human</li>\n\n\n\n<li>They make your brand <em>stick</em> in people’s minds</li>\n\n\n\n<li>And most importantly, they help you build actual emotional resonance online</li>\n</ul>\n\n\n\n<p>And it’s not just big brands getting in on the avatar action. If you’re building a personal brand, a strong digital avatar can become your secret weapon, a visual shorthand people instantly recognize in comment threads, <a href=\"https://slack.com/\">Slack</a> groups, or <a href=\"https://linkedin.com/\">LinkedIn</a> scroll-athons. </p>\n\n\n\n<p>Of course, different use-cases will call for different strategies. A corporate avatar might need to channel “professional but warm,” while a personal brand might want something that screams “it’s me!” in the best way. Meanwhile, your social avatar? Feel free to let your creativity run wild (meme energy encouraged).</p>\n\n\n\n<p>The point is, the avatar you choose should match its mission. A customer support bot? Friendly and dependable. A sales rep avatar? Confident and persuasive. </p>\n\n\n\n<p>Over the rest of this post, we’ll break down how to tailor your avatar’s personality to fit the context, so you’re always putting your best digital face forward.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Types of digital avatars: From simple icons to interactive representations</h3>\n\n\n\n<p>Let’s start with the basics: The humble headshot avatar. This is your digital calling card. A clean, static image that tells the internet, <em>“Yep, it’s me.”</em> <a href=\"https://gravatar.com/\">Gravatar</a> is the OG here – a global avatar service that ensures your chosen pic pops up consistently across thousands of sites. </p>\n\n\n\n<p><a href=\"https://wordpress.org/\">WordPress</a> blogs, <a href=\"https://github.com/\">GitHub</a> repos, <a href=\"https://slack.com/\">Slack</a> chats, and plenty more. Set it once, and voilà: Instant recognizability, no matter where you roam online.</p>\n\n\n\n<p>In fact, setting up your Gravatar takes less than 5 minutes (likely the best ROI you&#8217;ll ever get in under a coffee break).</p>\n\n\n\n<p><a href=\"https://gravatar.com/profile\"><em>Set it up in five minutes</em></a><em> now, save yourself fifty profile edits later.</em></p>\n\n\n\n<p>Zooming out beyond headshots, the avatar scene gets pretty creative:</p>\n\n\n\n<p><strong>2D customizable avatars</strong> let you tweak everything from eye shape to shoe style (e.g., <a href=\"https://www.bitmoji.com/\">Bitmoji</a>). They’re quirky, fun, and surprisingly simple to build.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img alt=\"2D Customizable Avatars\" class=\"wp-image-3294\" height=\"639\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/05/bitmoji-avatars-1.png\" width=\"1500\" /></figure>\n\n\n\n<p><strong>3D static avatars</strong> offer depth, angles, shading, the works. They give your digital self some dimension and make your profile pic feel less…flat.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"3D Meta Avatars\" class=\"wp-image-3293\" height=\"404\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/05/3dmetaavatars-1.png?w=660\" width=\"660\" /></figure>\n\n\n\n<p><br />In 2022 Meta teamed up with the NFL to enable viewers to outfit their Avatars in the colors of the two Superbowl teams</p>\n\n\n\n<p><strong>3D animated avatars</strong>? Now we’re in Pixar territory. These avatars blink, smile, nod, and generally act like they’re about to ask you how your day’s going. Perfect for adding that human-ish warmth to virtual chats.</p>\n\n\n\n<p>At the frontier, we’ve got <strong>AI-powered avatars</strong>, and <em>this</em> is where things get spicy. Platforms like <a href=\"https://www.heygen.com/\">HeyGen</a> let you build avatars that don’t just look the part – they talk it too. Natural language processing means they can chat, answer questions, and generally hold their own in a conversation without sounding like a 2005 chatbot.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-rich is-provider-embed-handler wp-block-embed-embed-handler wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<div class=\"embed-youtube\"></div>\n</div></figure>\n\n\n\n<p>And the tech’s only getting better. Even <a href=\"https://blog.gravatar.com/2025/05/06/build-your-ai-identity-with-gravatars-new-tool/\">Gravatar is creating AI-generated avatar tools</a>, so anyone – yes, even the design-challenged – can whip up a slick, professional avatar without breaking a sweat.</p>\n\n\n\n<p>The gap between digital you and real you is closing fast. And with these evolving tools, your online presence can be as polished, personable, or playfully weird as you want it to be.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>AI-powered avatars: The future of digital identity is already here</strong></h4>\n\n\n\n<p>Gravatar’s shiny <a href=\"https://blog.gravatar.com/2025/05/06/build-your-ai-identity-with-gravatars-new-tool/\">new AI Profile Builder</a>, launched in May 2025, is leading the charge to become the new face (quite literally) of digital identity. And with users saying they feel <a href=\"https://www.emerald.com/insight/content/doi/10.1108/jrim-07-2024-0344/full/html\"><em>more emotionally connected</em> to brands using personalized avatar</a> interactions over the usual click-and-type interfaces, this <em>isn’t</em> just for show.</p>\n\n\n\n<p>Tools like Gravatar’s AI Profile Builder allow you to build smart, secure avatars that actually <em>do something</em>.</p>\n\n\n\n<p>These AI avatars adapt based on where you are and who you’re talking to. Drop into a professional thread? Your avatar turns on the polish. Chiming in on a casual forum? It relaxes the tone. All without you lifting a finger.</p>\n\n\n\n<p>For businesses, this opens up a goldmine: Deeper customer engagement, zero need for juggling multiple digital personas, and bulletproof brand consistency, without compromising on privacy.</p>\n\n\n\n<p>We’re not just putting an AI face on your profile. We’re building a secure, intelligent bridge between your real self and your digital one – one that works across thousands of platforms.</p>\n\n\n\n<p>This means you get to nail that tricky balance between personalization and privacy. </p>\n\n\n\n<p>End result: A smart, responsive avatar that feels genuinely “you”, without handing over your life story to the algorithm gods.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Digital avatars in business: Strategic applications that drive results</h2>\n\n\n\n<p>When businesses keep their avatars consistent across platforms, they create that magical “ah yes, I know you” moment. It&#8217;s instant visual recognition that cements brand identity and reassures your audience they&#8217;re in the right place, whether they’re browsing your website, stalking your socials, or firing off a support ticket.</p>\n\n\n\n<p>And it’s not just about looking slick. A <a href=\"https://centaur.reading.ac.uk/119012/\">2024 University of Reading study</a> showed a significant jump in user interactions when brands used culturally tuned digital avatars in international campaigns. </p>\n\n\n\n<p>Turns out people respond better when your brand feels familiar and relatable, and not like a tourist fumbling through Google Translate.</p>\n\n\n\n<p>But avatars aren’t just for marketing. They’re transforming customer service, too. Virtual assistants with avatar interfaces spark more engagement than plain old text bots. Turns out, people prefer chatting with a “someone” rather than a “something.”</p>\n\n\n\n<p>Case in point: <strong>Lemonade Insurance</strong>.</p>\n\n\n\n<p>Their claims assistant, Jim (an AI avatar), <a href=\"https://aimagazine.com/articles/lemonade-sets-world-record-with-2-second-ai-insurance-claim\">processes requests in <em>literal</em> seconds</a>. Customers now trust it more than traditional reps, and it’s not just about the speed – being presented with a friendly, familiar face turns a cold system into a warm interaction.</p>\n\n\n\n<p>The end result? Happier users who stick around longer and actually enjoy the convo.</p>\n\n\n\n<p>Now, for the pros in the room: Enter <a href=\"https://gravatar.com/\"><em>Gravatar</em></a>.</p>\n\n\n\n<p>Whether you’re replying to a blog comment, debugging on Stack Overflow, or posting in a Slack channel, <a href=\"https://gravatar.com/\">Gravatar</a> has you covered.</p>\n\n\n\n<p>Unlike avatars that change depending on the platform (and leave your brand scattered like confetti), Gravatar keeps everything tidy and cohesive. Set it up once, and your professional avatar just <em>shows up</em> across thousands of platforms without you lifting a finger. It’s recognition on autopilot.</p>\n\n\n\n<p>And for businesses building community platforms? The Gravatar API is your new best friend. It lets users show up with their avatars already in tow – no need for endless image uploads or awkward “who’s who” moments. Just seamless, identity-based connection right out of the box.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Implementation guide: Creating the right avatar solution for your needs</h2>\n\n\n\n<p>Before you go charging into avatar creation mode, pause. Breathe. Ask yourself: <strong>What do I actually need this avatar to </strong><strong><em>do</em></strong><strong>?</strong></p>\n\n\n\n<p>Because the best avatar isn’t just pretty, it’s <em>purpose-built</em>. And the right solution depends entirely on your goals:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Brand consistency</strong> – Need a single, recognizable face across all your digital turf?</li>\n\n\n\n<li><strong>Personal branding</strong> – Want to show up as a thought leader or expert, loud and clear?</li>\n\n\n\n<li><strong>Customer interaction</strong> – Planning to use avatars in live support or sales scenarios?</li>\n\n\n\n<li><strong>Immersive engagement</strong> – Building an experience that needs personality, emotion, and <em>connection</em>?</li>\n</ul>\n\n\n\n<p>Each goal unlocks a different avatar approach, so pick your strategy before picking your style.</p>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><td><strong>Type of avatar</strong></td><td><strong>Purpose </strong></td><td><strong>Examples</strong></td></tr><tr><td>Static</td><td>Consistent visual branding; establish familiarity and recognition.</td><td>Company logo icon, profile headshot, illustrated character used across web pages and email signatures</td></tr><tr><td>Interactive</td><td>Real-time, personalized customer interaction</td><td>AI chatbot with animated face, live avatar-based support agent</td></tr></tbody></table></figure>\n\n\n\n<p>No matter what your preferred avatar is, if you&#8217;re building a full-blown avatar ecosystem (i.e., membership platforms, technical communities, enterprise apps), then you’ll want to get serious about your tech stack.</p>\n\n\n\n<p>Here’s what to factor in:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Storage</strong> for high-res avatar files</li>\n\n\n\n<li><strong>Content delivery networks (CDNs)</strong> for global speed</li>\n\n\n\n<li><strong>Sync systems</strong> to keep identities aligned everywhere</li>\n\n\n\n<li><strong>API integrations</strong> with your user databases</li>\n</ul>\n\n\n\n<p>This is where Gravatar really shines: Its email-based ID system handles identity, and the REST API makes delivery dead simple. Just hash an email, hit the avatar or profile endpoint, and Gravatar returns consistent, customizable visuals – no storage, no syncing, no fuss. </p>\n\n\n\n<p>Developers get fast, cacheable responses, optional profile data, and fallback image controls – all without bloating your backend or reinventing the wheel.</p>\n\n\n\n<p>Bottom line: Your perfect avatar setup depends on what you&#8217;re building, how techy you&#8217;re feeling, and the kind of connection you want with your audience. Choose wisely, and let your digital self do the heavy lifting.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Digital avatar design best practices</h3>\n\n\n\n<p>When it comes to designing your digital avatar, you want it to be instantly recognizable, reliably familiar, and – above all – consistent wherever it shows up. That visual déjà vu is what builds trust. So, a few pointers:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Always, always go for crisp, high-quality visuals</strong>. If your avatar looks like it was snapped through a potato or cropped with garden shears, it sends a subtle message that details aren’t your strong suit. Not ideal when you&#8217;re aiming to be taken seriously.</li>\n\n\n\n<li><strong>Make sure your avatar scales like a pro</strong>. Whether it’s a teeny-tiny dot in a comment thread or proudly displayed on your profile, it should stay sharp and identifiable. So skip the intricacies – those fine details tend to vanish faster than free Wi-Fi at a cheap café.</li>\n\n\n\n<li><strong>Test everything</strong>. Your avatar might look stunning on your 27-inch monitor, but end up awkwardly cropped on someone’s smartphone. Preview it everywhere before you commit.</li>\n</ul>\n\n\n\n<p>One last pro tip: Set up a <a href=\"https://gravatar.com/\">Gravatar</a> profile. It’s the easy button for keeping your avatar synced across WordPress, Slack, and a ton of other platforms. Update it once, and your whole digital universe stays in step. Clean, consistent, and credible.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Transform your online presence with Gravatar: Start creating your professional digital identity today</h2>\n\n\n\n<p>Tired of uploading your headshot <em>again</em> for the millionth platform? Gravatar is the slick, savvy avatar service that makes you look polished across the internet without breaking a sweat (or opening Photoshop).</p>\n\n\n\n<p>Set up your Gravatar once, and that single image becomes your visual passport across the internet, including websites like <a href=\"https://wordpress.com/\"><strong>WordPress</strong><strong>, </strong></a><a href=\"https://github.com/\"><strong>GitHub</strong><strong>, </strong></a><a href=\"https://slack.com/\"><strong>Slack</strong><strong>, </strong></a><a href=\"https://www.figma.com/\"><strong>Figma</strong><strong>, </strong></a><a href=\"https://mailchimp.com/\"><strong>Mailchimp</strong><strong>, </strong></a><a href=\"https://stackoverflow.com/\"><strong>Stack Overflow</strong><strong>, </strong></a><a href=\"https://openai.com/\"><strong>OpenAI</strong><strong>, </strong></a><a href=\"https://www.atlassian.com/\"><strong>Atlassian</strong><strong>, </strong></a><a href=\"https://www.coinbase.com/\"><strong>Coinbase</strong></a>, and more! </p>\n\n\n\n<p>Whether you’re commenting, collaborating, or contributing, your avatar shows up instantly, building recognition and credibility with every interaction.</p>\n\n\n\n<p>And if you’re creating a platform where identity matters, Gravatar’s APIs are a goldmine:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://docs.gravatar.com/api/avatars/images/\"><strong>Avatar API</strong></a> – Automatically pulls user avatars so when they register on your website, they don&#8217;t have to upload a new profile pic – instant recognition and zero setup friction.<br /></li>\n\n\n\n<li><a href=\"https://blog.gravatar.com/2024/06/03/profiles-as-a-service/\"><strong>Profiles-as-a-Service API</strong></a> – Pulls bios, links, and other profile data <a href=\"https://blog.gravatar.com/2024/11/07/website-personalization-tools/\">directly from Gravatar</a>, streamlining onboarding and slashing form fatigue.</li>\n</ul>\n\n\n\n<p>Faster dev time, smoother UX, and more trust from day one.</p>\n\n\n\n<p>Oh, and did we mention? <strong>It’s totally free</strong>. No fees, no upsells, no “pro” plan with features locked behind a paywall. Gravatar is used by millions of professionals around the world, and you can join them without spending a penny.</p>\n\n\n\n<p>Just register and sit back as your avatar quietly does its thing, building trust, recognition, and brand alignment across the web.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://gravatar.com/connect/?gravatar_from=blog\"><img alt=\"\" class=\"wp-image-2616\" height=\"729\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/free_profile_cta.png\" width=\"3243\" /></a></figure>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 23 May 2025 17:42:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Ronnie Burt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"Do The Woo Community: Do the Woo is Sponsoring WordCamp Europe 2025\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://openchannels.fm/?post_type=blog&p=97385\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://openchannels.fm/do-the-woo-is-sponsoring-wordcamp-europe-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"We\'re exciting to sponsor WordCamp Europe 2025 again. Come by our booth and join the community conversatoin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 23 May 2025 10:02:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Bob Dunn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"Felix Arntz: Speculative Loading, or A Brief History of Landing a Performance Feature in WordPress Core\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://felix-arntz.me/?p=2094\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"https://felix-arntz.me/blog/speculative-loading-history-performance-feature-in-wordpress-core/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:23926:\"<p>Two years ago today, on May 22, 2023, I opened an <a href=\"https://github.com/WordPress/performance/pull/733\">experimental pull request</a> for a new module in the <a href=\"https://wordpress.org/plugins/performance-lab/\">Performance Lab plugin</a>. That little experiment was the very first step on a long road that ultimately led to the &#8220;Speculative Loading&#8221; feature landing in WordPress 6.8 last month (April 2025).</p>\n\n\n\n<p>For those unfamiliar, the Speculative Loading feature enhances performance by speculatively loading pages a user is likely to visit next, which can make navigation feel almost instantaneous. If you want to dive into the technical nitty-gritty, I recommend checking out the <a href=\"https://make.wordpress.org/core/2025/03/06/speculative-loading-in-6-8/\" rel=\"noreferrer noopener\" target=\"_blank\">&#8220;dev note&#8221; post on Make WordPress Core</a>.</p>\n\n\n\n<p>This post, however, isn&#8217;t about the <em>what</em> or <em>how</em> of the feature itself. Instead, I want to pull back the curtain and share the story <em>behind</em> the feature—the milestones, the discussions, and the collaborative effort that took it from a spark of an idea to a reality for millions of WordPress sites. The impact is considerable even for the entire web. Keep reading to the end for concrete numbers. 👇</p>\n\n\n\n<span id=\"more-2094\"></span>\n\n\n\n<h2 class=\"wp-block-heading\">The Spark: An Intriguing Browser API</h2>\n\n\n\n<p>It all began on April 20, 2023, when an internal Google email thread about preloading techniques landed in our team&#8217;s inbox. Part of that thread was a <a href=\"https://docs.google.com/presentation/d/1GK92nCORW5vKd7LgGtTsgy35eqTV7P71l05pHsni8ok/edit?authuser=1\" rel=\"noreferrer noopener\" target=\"_blank\">slide deck</a> for an upcoming <a href=\"https://www.w3.org/2023/09/TPAC/\">TPAC 2023</a> presentation by <a href=\"https://domenic.me/\">Domenic Denicola</a> and <a href=\"https://www.jeremyroman.com/\">Jeremy Roman</a>, who were deeply involved in a new browser-level API called Speculation Rules API.</p>\n\n\n\n<p>Learning about this API, I was immediately excited. The potential performance benefits for the web, including for WordPress, seemed enormous. What particularly caught my eye were &#8220;document-level rules&#8221;, which went beyond loading specific URLs to opting in to loading entire URL patterns (as detailed later in <a href=\"https://developer.chrome.com/blog/speculation-rules-improvements\" rel=\"noreferrer noopener\" target=\"_blank\">this Chrome developers blog post</a>). At that time, this aspect of the API was truly cutting-edge. It required Chrome 113 (which was just about to be released on April 26, 2023) and, crucially, opting into a <a href=\"https://developer.chrome.com/docs/web-platform/origin-trials\">Chrome origin trial</a> because it was such an early feature. Naturally, I signed up straight away.</p>\n\n\n\n<h2 class=\"wp-block-heading\">First Steps: Pull Request for an Experimental Module</h2>\n\n\n\n<p>A few weeks of mulling it over passed, and then on May 19, 2023, I finally decided to dive in and explore how this API could work within WordPress. This led to the creation of that first <a href=\"https://github.com/WordPress/performance/pull/733\" rel=\"noreferrer noopener\" target=\"_blank\">experimental pull request</a> three days later, on May 22nd.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"Screenshot of the initial GitHub pull request, showing the original description for when it had just been started as an experiment: &quot;The Speculation Rules API is in its early proposal stages and only available in Chrome 108 or newer. The full set of features however, which are needed for this module to work, are only available via origin trial in Chrome 113 or newer. [...]&quot;\" class=\"wp-image-2104\" height=\"593\" src=\"https://felix-arntz.me/wp-content/uploads/2025/05/original-speculation-rules-pull-request-1024x593.webp\" width=\"1024\" /><figcaption class=\"wp-element-caption\">Screenshot of the initial GitHub pull request, showing the original description for when it had just been started as an experiment</figcaption></figure>\n\n\n\n<p>I shared this initial exploration both with my colleagues at Google who were working on the browser API itself and with the broader WordPress Performance Team. The idea was met with a good deal of curiosity and excitement, though everyone acknowledged its experimental nature. The browser API was still very young, and its reliance on an origin trial meant it wasn&#8217;t something we could roll out widely.</p>\n\n\n\n<p>The feedback on the pull request was super helpful, coming from both the Google side and WordPress contributors. We got the pull request into a pretty decent shape so that it could in principle be added to Performance Lab, but it remained an exploration. The WordPress Performance Team had many other priorities, and as long as the core browser functionality was locked behind an origin trial, it didn&#8217;t make sense to push too hard on a plugin that very few could actually use.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Gaining Momentum: Browser API Maturation</h2>\n\n\n\n<p>Time marched on, and then in early November 2023, we received some exciting news: the document-level rules for the Speculation Rules API were slated to become publicly available, no origin trial needed, with the release of Chrome 121 on January 17, 2024.</p>\n\n\n\n<p>This was a significant development. Around the same time, Chrome had also <a href=\"https://developer.chrome.com/docs/devtools/application/debugging-speculation-rules\" rel=\"noreferrer noopener\" target=\"_blank\">introduced DevTools features</a> to help debug speculation rules, and more comprehensive documentation was starting to appear, including on <a href=\"https://developer.mozilla.org/en-US/docs/Web/API/Speculation_Rules_API\" rel=\"noreferrer noopener\" target=\"_blank\">MDN</a>.</p>\n\n\n\n<p>This news was the catalyst to get serious about the dormant pull request. I revisited it, updated it to align with the latest WordPress Core changes that had happened in the meantime, and began polishing it towards a Minimum Viable Product (MVP).</p>\n\n\n\n<p>On November 20, 2023, I created a new feature branch for the prospective &#8220;Speculation Rules&#8221; module within the Performance Lab plugin. We opted for a feature branch because:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li>We needed to ensure that even if the initial PR was merged, the module wouldn&#8217;t be released until the browser API was widely available without the origin trial.</li>\n\n\n\n<li>We anticipated a few follow-up pull requests to build out the full MVP.</li>\n</ol>\n\n\n\n<p>Following further discussions with fellow WordPress Performance Team contributors, I formalized the idea by opening a <a href=\"https://github.com/WordPress/performance/issues/897\" rel=\"noreferrer noopener\" target=\"_blank\">module proposal issue</a> on December 5, 2023. This provided a comprehensive overview of the feature and its intended scope.</p>\n\n\n\n<h2 class=\"wp-block-heading\">First Release of the Plugin</h2>\n\n\n\n<p>Things started moving quickly then. That <a href=\"https://github.com/WordPress/performance/pull/733\" rel=\"noreferrer noopener\" target=\"_blank\">initial pull request</a>, which had evolved from an experiment to a serious feature implementation, was finally merged on December 15, 2023! I immediately opened a <a href=\"https://github.com/WordPress/performance/issues/908\" rel=\"noreferrer noopener\" target=\"_blank\">follow-up issue</a> to track the remaining tasks before our first public release.</p>\n\n\n\n<p>A few relatively straightforward follow-up pull requests (<a href=\"https://github.com/WordPress/performance/pull/938\" rel=\"noreferrer noopener\" target=\"_blank\">#938</a>, <a href=\"https://github.com/WordPress/performance/pull/939\" rel=\"noreferrer noopener\" target=\"_blank\">#939</a>, <a href=\"https://github.com/WordPress/performance/pull/940\" rel=\"noreferrer noopener\" target=\"_blank\">#940</a>) were implemented and merged by mid-January 2024. Concurrently, the WordPress Performance Team was finalizing its annual roadmap, and &#8220;speculative prefetching and prerendering&#8221; (as we often called it then) earned its place as a priority project. You can see it listed on the <a href=\"https://make.wordpress.org/performance/roadmap-2024/#:~:text=Adding%20support%20for%20speculative%20prerendering%20and%20prefetching%20for%20near%2Dinstance%20page%20loads\" rel=\"noreferrer noopener\" target=\"_blank\">2024 roadmap here</a>.</p>\n\n\n\n<p>Meanwhile, a significant holistic discussion had unfolded regarding the structure of the Performance Lab plugin. The decision was made to decouple its modules into individual, standalone plugins. Performance Lab would continue as an optional central orchestrator, but users could also install specific performance features independently. This required a migration effort of the existing modules into plugin shape. I opened a <a href=\"https://github.com/WordPress/performance/pull/946\" rel=\"noreferrer noopener\" target=\"_blank\">pull request (#946)</a> on January 17, 2024, to transition the Speculation Rules module into its own plugin. On that very same day, we submitted this nearly complete plugin to the WordPress plugin directory.</p>\n\n\n\n<p>The review process by the WordPress plugin team was incredibly swift, and the plugin was approved a day later (a huge thank you to them!). While the migration <a href=\"https://github.com/WordPress/performance/pull/946\">pull request (#946)</a> hadn&#8217;t technically been merged yet, all the core code was complete and approved. Therefore we decided to push the release so users could start testing almost immediately after Chrome 121 had just made the browser API widely available. Another day later, on January 19, 2024, the <a href=\"https://wordpress.org/plugins/speculation-rules/#developers\" rel=\"noreferrer noopener\" target=\"_blank\">1.0.0 version of the Speculation Rules plugin launched on WordPress.org</a>. This was a major milestone. Despite that, we kept promotion low-key initially, as a few more enhancements were planned.</p>\n\n\n\n<p>On a personal note, just a few days later, on January 24, 2024, I experienced an even more significant milestone: I became a dad! 👶 As such, I went AFK for a while, enjoying this precious time with my new family. Thankfully, the Speculation Rules plugin was in the capable hands of my teammates at Google and the other WordPress Performance Team contributors – a special shoutout to <a href=\"https://weston.ruter.net/\">Weston Ruter</a>, who has been instrumental in polishing and helping shepherd the feature all the way until stable.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Introducing &#8220;Speculative Loading&#8221;: Promotion and Gaining Traction</h2>\n\n\n\n<p>On February 16, 2024, version 1.0.1 of the Speculation Rules plugin was released with some bug fixes. Perhaps more importantly, this coincided with the Performance Lab 2.9.0 release, which officially added our plugin to its list of associated plugins. This significantly broadened its promotion due to Performance Lab&#8217;s widespread adoption.</p>\n\n\n\n<p>When I returned from my initial parental leave about ten days later, the Speculation Rules plugin was already active on over 500 WordPress sites! Not a massive number in the grand scheme of WordPress, but impressive for a plugin barely a month old.</p>\n\n\n\n<p>Over the following months, we continued to polish the plugin, shipping further enhancements and bug fixes, and promoting it more widely. During this period, the WordPress Performance Team undertook a project to revise plugin names, aiming for clarity by focusing on user-facing benefits rather than underlying technologies. As part of this initiative, the &#8220;Speculation Rules&#8221; plugin was renamed to the &#8220;Speculative Loading&#8221; plugin (see the <a href=\"https://github.com/WordPress/performance/pull/1101\" rel=\"noreferrer noopener\" target=\"_blank\">renaming pull request #1101</a>).</p>\n\n\n\n<p>Following these enhancements, the new name, the maturation of the browser API, and encouraging feedback from other browser vendors (see Mozilla&#8217;s <a href=\"https://github.com/mozilla/standards-positions/issues/620\" rel=\"noreferrer noopener\" target=\"_blank\">standards position</a> and WebKit&#8217;s <a href=\"https://github.com/WebKit/standards-positions/issues/54\" rel=\"noreferrer noopener\" target=\"_blank\">standards position</a>), I collaborated with other contributors to publish a <a href=\"https://make.wordpress.org/core/2024/04/09/speculative-loading-in-wordpress/\" rel=\"noreferrer noopener\" target=\"_blank\">Make WordPress Core blog post</a> on April 9, 2024. This shared the project more broadly with the WordPress developer community.</p>\n\n\n\n<p>An important decision made early in the plugin’s development was to default to prerendering with &#8220;moderate&#8221; eagerness. This is a more &#8220;aggressive&#8221; setting (offering better performance but potentially more resource-intensive) than what we ultimately shipped in WordPress 6.8. It was a deliberate choice for the plugin, as it allowed us to gather feedback on a more impactful version of the feature from a performance perspective. For WordPress Core, however, we would later opt for a more conservative default (prefetching with &#8220;conservative&#8221; eagerness) to ensure resourcefulness at scale.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The Road to Core: Gathering Evidence and Formal Proposal</h2>\n\n\n\n<p>Both the Speculative Loading plugin and the underlying Speculation Rules browser API continued to gain traction. Six months after that Make Core post:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>The plugin had amassed over 40,000 active installations and maintained exclusively 5-star ratings on the WordPress plugin directory.</li>\n\n\n\n<li>Cloudflare <a href=\"https://blog.cloudflare.com/introducing-speed-brain/\" rel=\"noreferrer noopener\" target=\"_blank\">enabled speculative loading for their users</a>, reporting a &#8220;reduction in LCP of 45% on successful prefetches.&#8221;</li>\n\n\n\n<li>Further partnership experiments between Google and companies like Shopify continued to demonstrate the feature&#8217;s positive impact on load times and user experience.</li>\n\n\n\n<li>The Speculation Rules API itself was already being used on <a href=\"https://chromestatus.com/metrics/feature/timeline/popularity/3932\" rel=\"noreferrer noopener\" target=\"_blank\">over 8% of Chrome page loads</a>.</li>\n</ul>\n\n\n\n<p>With such positive signals, even at a considerable scale, it felt like the right time to formally propose the feature for inclusion in WordPress Core. On November 21, 2024, I opened a <a href=\"https://core.trac.wordpress.org/ticket/62503\" rel=\"noreferrer noopener\" target=\"_blank\">WordPress Trac ticket (#62503)</a> proposing the feature for WordPress 6.8. Alongside it, I submitted a <a href=\"https://github.com/WordPress/wordpress-develop/pull/7860\" rel=\"noreferrer noopener\" target=\"_blank\">WordPress Core pull request (#7860)</a> with the proposed code, which was largely a port of the existing plugin.</p>\n\n\n\n<p>As mentioned, while the plugin used &#8220;prerender&#8221; with &#8220;moderate&#8221; eagerness, we opted for a more conservative approach (literally!) for Core, using only &#8220;prefetch&#8221; with &#8220;conservative&#8221; eagerness. At the massive scale of WordPress (impacting over 40% of the web), this was a safer starting point. The implementation, however, was designed to potentially allow for adjustments in the future as the browser API evolves or as confidence in other configurations grows.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The Final Push: Community Feedback and Commitment</h2>\n\n\n\n<p>For the next two months, the Trac ticket and pull request primarily saw feedback from contributors already involved in the development. While valuable, a feature of this significance ideally receives broader input from the wider WordPress Core community, including experienced long-term contributors and committers. In mid-January 2025, we began to more actively solicit this feedback, raising the ticket during the weekly WordPress Core &#8220;dev chat&#8221; and eventually bumping its priority on Trac.</p>\n\n\n\n<p>Aside: It&#8217;s not uncommon for Trac tickets to only receive broader feedback later in the process. This isn&#8217;t ideal, but it&#8217;s often a reality given the limited resources and the sheer volume of ongoing development efforts. Reviewing a notable feature thoroughly takes time, which is a scarce commodity for many contributors. If you want to help, consider <a href=\"https://wordpress.org/five-for-the-future/\">sponsoring WordPress development</a>.</p>\n\n\n\n<p>By early February, we started seeing more engagement from other long-term contributors. This sparked some excellent discussions on the Trac ticket, the pull request, and synchronously on Slack. Some conversations worth highlighting include <a href=\"https://wordpress.slack.com/archives/C02RQBWTW/p1738344132077399\" rel=\"noreferrer noopener\" target=\"_blank\">this Slack discussion</a>, <a href=\"https://core.trac.wordpress.org/ticket/62503#comment:15\" rel=\"noreferrer noopener\" target=\"_blank\">this Trac ticket discussion</a>, and <a href=\"https://github.com/WordPress/wordpress-develop/pull/7860#issuecomment-2641175007\" rel=\"noreferrer noopener\" target=\"_blank\">this GitHub pull request discussion</a>.</p>\n\n\n\n<p>Both general considerations and specific technical details were debated, and much of the final fine-tuning of the implementation occurred during this &#8220;final sprint&#8221;, which took about three weeks. Eventually, the pull request garnered several approvals, and a consensus emerged that the feature was ready for WordPress Core.</p>\n\n\n\n<p>And so, on February 18, 2025, I <a href=\"https://core.trac.wordpress.org/changeset/59837\" rel=\"noreferrer noopener\" target=\"_blank\">committed the feature to WordPress Core</a>! This was a good two weeks before the WordPress 6.8 Beta 1 release was due – a critical deadline, as new features and enhancements must be committed before the first Beta of a release cycle.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Post-Commit and Launch</h2>\n\n\n\n<p>A small follow-up fix was committed a few days later, but overall, the period following the commit was quiet – exactly what you hope for! It indicated no significant issues with the feature, especially during the Beta and Release Candidate (RC) periods.</p>\n\n\n\n<p>While monitoring post-commit feedback, I began working on the &#8220;dev note&#8221; – the official Make WordPress Core blog post that describes a new Core feature for developers, explaining how it works and how it can be customized. Writing such a post is a crucial step to inform the WordPress developer ecosystem about upcoming changes, for example allowing plugin developers to prepare their plugins. Several other WordPress Core Performance Team members collaborated on it, and the <a href=\"https://make.wordpress.org/core/2025/03/06/speculative-loading-in-6-8/\" rel=\"noreferrer noopener\" target=\"_blank\">post was published on March 6, 2025</a>. This is likely the post many of you read if you were already familiar with Speculative Loading in WordPress 6.8.</p>\n\n\n\n<p>And that was it! Nearly two years after the work had started, the Speculative Loading feature officially launched as part of WordPress 6.8 on April 15, 2025.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"Speculative loading feature as highlighted on the About page of WordPress 6.8: &quot;Near-instant page loads, thanks to Speculative Loading&quot;\" class=\"wp-image-2105\" height=\"489\" src=\"https://felix-arntz.me/wp-content/uploads/2025/05/speculative-loading-feature-wordpress-6-8-1024x489.webp\" width=\"1024\" /><figcaption class=\"wp-element-caption\">Speculative loading feature as highlighted on the About page of WordPress 6.8</figcaption></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Post-Launch: Impact Metrics time!</h2>\n\n\n\n<p>Now that the feature is out there, the final step is to assess its real-world impact. It is great to see the adoption impact already:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>From March 2025 to May 2025, usage of the Speculation Rules API for all navigations (individual page loads) across the web grew from 8.47% to 10.81%, a relative increase of <strong>27.63%</strong>!</li>\n\n\n\n<li>From March 2025 to May 2025, usage of the Speculation Rules API for all origins (entire websites) across the web grew from 0.39% to 18.09%, a relative increase of <strong>4538.46%</strong>! 🤯</li>\n</ul>\n\n\n\n<p><em>Data based on public Chrome datasets. <a href=\"https://colab.research.google.com/drive/1krQWvjK2Zyl01vqcxTM9J1fOQN29gElq\">Please refer to this Colab for the full data.</a></em></p>\n\n\n\n<p>The data strongly suggests that the majority of the feature usage growth across the overall web comes from the WordPress 6.8 launch, because of WordPress&#8217;s large scale and the fact that in the preceding months the feature usage growth was more or less flat. So that&#8217;s an amazing win and goes to show once again the impact that WordPress has on the entire web!</p>\n\n\n\n<p>That said, usage is only a secondary metric. For a performance feature like speculative loading, we ideally want to get an idea on the <em>performance</em> impact of the feature, in particular on LCP. For this, we will need to wait for May data for the <a href=\"https://developer.chrome.com/docs/crux\">Chrome User Experience Report (CrUX)</a>, which is slated to become available in mind-June. I am looking forward to taking a closer look.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Looking Back</h2>\n\n\n\n<p>While the technical behavior of speculative loading is becoming more and more well-documented, with this article I wanted to share the story behind how it all came to be. If you have any questions, please feel free to ask them in the comments!</p>\n\n\n\n<p>If you are interested in the speculative loading feature&#8217;s technical aspects, I recently recorded a <a href=\"https://wptavern.com/podcast\">WP Tavern podcast</a> episode with a technical deep dive, which should air very soon.</p>\n\n\n\n<p>The journey of a WordPress Core feature can be a long and winding road. While the focused development time for the Core commit might appear to be just a couple of months, it&#8217;s often preceded by a much longer period of exploration, experimentation, plugin development, and community feedback.</p>\n\n\n\n<p>To recap the key milestones for Speculative Loading:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>April 2023:</strong> Initial &#8220;discovery&#8221; of the Speculation Rules API.</li>\n\n\n\n<li><strong>May 2023:</strong> First experimental Performance Lab module PR.</li>\n\n\n\n<li><strong>November 2023:</strong> News of broader browser API availability; serious development resumes.</li>\n\n\n\n<li><strong>January 2024:</strong> Standalone &#8220;Speculation Rules&#8221; plugin launched on WordPress.org.</li>\n\n\n\n<li><strong>Spring-Summer 2024:</strong> Plugin renaming to &#8220;Speculative Loading,&#8221; and broader promotion, community outreach, and usage growth.</li>\n\n\n\n<li><strong>November 2024:</strong> Formal proposal for WordPress Core inclusion.</li>\n\n\n\n<li><strong>February 2025:</strong> Feature committed to WordPress Core for version 6.8.</li>\n\n\n\n<li><strong>April 2025:</strong> WordPress 6.8 released with Speculative Loading.</li>\n</ul>\n\n\n\n<p>Today, exactly two years after that first tentative pull request, it’s incredibly rewarding to look back at this journey and celebrate the successful launch of a feature that I believe will make a real difference to WordPress performance.</p>\n<p>The post <a href=\"https://felix-arntz.me/blog/speculative-loading-history-performance-feature-in-wordpress-core/\">Speculative Loading, or A Brief History of Landing a Performance Feature in WordPress Core</a> appeared first on <a href=\"https://felix-arntz.me\">felix-arntz.me</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 May 2025 13:10:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"Felix\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"Do The Woo Community: WordCamp Europe 2025 Organizers Share Insights and Excitement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://openchannels.fm/?p=97345\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://openchannels.fm/wordcamp-europe-2025-organizers-share-insights-and-excitement/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:231:\"This special episode of WordPress Event Talk is all about WordCamp Europe 2025 in Basel, Switzerland, highlighting organizers\' insights on inclusivity, accessibility, childcare, workshops, and volunteer opportunities for attendees.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 May 2025 08:44:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Bob Dunn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"WPTavern: #170 – Chris Reynolds on WordPress and Drupal: Differences and Similarities\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=195929\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"https://wptavern.com/podcast/170-chris-reynolds-on-wordpress-and-drupal-differences-and-similarities\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:58645:\"<details>Transcript<div>\n<p>[00:00:19] Nathan Wrigley: Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, what WordPress and Drupal have in common.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you or your idea featured on the show. Head to wp tavern.com/contact/jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today we have Chris Reynolds. Chris is a developer advocate at Pantheon, where he brings nearly 20 years of experience in the WordPress community, as well as deep involvement with Drupal and open source technology at large. Prior to his advocacy role, he worked at some of the top WordPress agencies like Human Made and Web Dev Studios. He&#8217;s been active at events like DrupalCon, PressConf, and Word Camps.</p>\n\n\n\n<p>In this episode we set aside the usual WordPress only focus, and turn our attention to two CMSs, WordPress and Drupal. What makes them tick, where they excel and where they might have something to learn from each other.</p>\n\n\n\n<p>Chris draws on his unique perspective working closely with both platforms as Pantheon is one of the few hosts with a 50 50 split between WordPress and Drupal sites, and has a significant footprint in both ecosystems.</p>\n\n\n\n<p>We discuss the similarities and differences between the two open source CMS communities, from the mechanics of flagship events like WordCamps and DrupalCon, to the ways these projects organize their contributors and support community initiatives.</p>\n\n\n\n<p>Chris explains how Drupal&#8217;s model with its association run funding, and project governance, compares to WordPress&#8217;s approach, including how each community approaches plugin and module development, and what role agencies and companies play in contributing to Core and the broader ecosystem.</p>\n\n\n\n<p>If you&#8217;re curious about how open source projects organize themselves, how their communities navigate growth and challenge, and what WordPress can learn from Drupal, and vice versa, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wp tavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Chris Reynolds.</p>\n\n\n\n<p>I am joined on the podcast today by Chris Reynolds. Hello Chris.</p>\n\n\n\n<p>[00:03:20] Chris Reynolds: Hi. How&#8217;s it going?</p>\n\n\n\n<p>[00:03:22] Nathan Wrigley: You cannot see, dear listener, what I can see. Chris has the most amazing setup where he&#8217;s doing the recording. I guess it&#8217;s an attic or something like that, but it looks like the Starship Enterprise from where I&#8217;m sitting.</p>\n\n\n\n<p>[00:03:34] Chris Reynolds: I&#8217;m working on that.</p>\n\n\n\n<p>[00:03:34] Nathan Wrigley: Yeah, it&#8217;s really nice. Chris is joining us today and we&#8217;re going to have a conversation about the WordPress community. The things that we do well, and perhaps the things that we could improve. And we&#8217;re going to probably use Drupal as a comparison.</p>\n\n\n\n<p>Before we get into that, Chris, I know it&#8217;s a dreadfully banal question, but it&#8217;s always good to scope out where you are and where you stand with WordPress and Drupal and the companies that you work for. So just a moment really to give us your little potted bio of who you are and what have you.</p>\n\n\n\n<p>[00:04:04] Chris Reynolds: Sure. My name is Chris Reynolds, I am a developer advocate at Pantheon. I was formerly a senior software engineer for Pantheon for about three years, before joining the developer relations team around August, right before WordCamp US in September last year.</p>\n\n\n\n<p>I&#8217;ve been in the WordPress community for close to 20 years. I think I&#8217;ve gone back to my first blog posts and my first, like talking about technology that I was using. And I think that I&#8217;ve found references to using WordPress in some capacity back in 2005, so almost exactly 20 years.</p>\n\n\n\n<p>But even before that I was really interested, like as a side hobby in just open source software, playing with Linux and playing with other open source community projects that I found I was really a big fan of one called Ampache for a long time, which was a music sort of library app thing written in PHP. That was really cool. I think it still exists even.</p>\n\n\n\n<p>But yeah, so I&#8217;m a developer advocate at Pantheon. That means I do a lot of these sorts of things, talk about best practices, write a lot of blog posts, get in a lot of trouble, not really, and go to events and stuff like that. So I was at DrupalCon in March. I was at PressConf last month. Probably doing stuff this summer and in the fall.</p>\n\n\n\n<p>[00:05:14] Nathan Wrigley: Just to lean in a little bit on the Pantheon side of things. Pantheon, a hosting company, but very much aligned in two worlds, maybe more than two. But from my perspective, I used to use Drupal exclusively until about 2015. That was my CMS of choice for many, many years. I think Drupal 4, and then finally I jumped ship at Drupal 8 over to WordPress and have been that consistently.</p>\n\n\n\n<p>But Pantheon was around as what felt like at that time, so we are going back more than a decade, the only sort of managed Drupal host, but it definitely had a WordPress side to it as well. Can you just speak to that for us for a moment? That is Pantheon&#8217;s sort of MVP, isn&#8217;t it? It handles managed hosting for both of those platforms. And maybe there&#8217;s more, I don&#8217;t know.</p>\n\n\n\n<p>[00:05:57] Chris Reynolds: Yeah. I mean, I think that from a platform perspective, we obviously do host Drupal and WordPress. We also can host like Next.js and sort of front end sites. But the sort of hidden Pantheon magic is in the kind of DevOps, WebOps we like to call it, layer that happens like somewhere between pushing code and the code being a thing that like site managers and editors and things like work with, right? So automation tools, and we were one of the first providers that used Git by default. Now that&#8217;s not such a big deal anymore, but like that was a big thing within Pantheon for a really long time.</p>\n\n\n\n<p>When I was a developer, the first time that I used Pantheon as a developer when I was back at WebDevStudios was, the thing that was the killer feature for me was we have a thing called Multi Dev, which is, each site has a development, a test, and a live environment. So everybody gets those three things and we have a very specific sort of workflow. Code goes to dev, to test, to live in that order. But we have these Multi Devs, which are entirely separate containers where you can build, you can do all your feature development on a branch in a Multi Dev and see what that looks like before merging it into dev.</p>\n\n\n\n<p>It sounds like maybe not that much now, but I know when I was back in agency life and even when I was working at Human Made and we had built our own sort of stack that had this very similar kind of system, we didn&#8217;t have Multi Dev because spinning up new containers for sites that you&#8217;re just going to destroy at some point in the next couple weeks or days anyway is expensive and hard.</p>\n\n\n\n<p>And so what that meant was the master branch, or the development branch, of all of your code is always really messy and dirty, and you want to keep that away from the code that is going to production, right? Because that&#8217;s where your experimental code is. Maybe you didn&#8217;t back it out entirely. That&#8217;s where like a whole bunch of weird database stuff is going. That&#8217;s like the junk, right? So you want to keep that separate from like your staging branch and your production branch.</p>\n\n\n\n<p>And with Pantheon, the idea is your development branch is just where your finalised code goes, because you can do all that testing in a separate environment and then when you go from dev to test, it&#8217;s not a headache, it&#8217;s just this is production ready code, basically.</p>\n\n\n\n<p>[00:08:10] Nathan Wrigley: Yeah, I remember my recollection of Pantheon was that it was one of those platforms that, well, platform really, it felt more like a platform than a host, if you know what I mean? It just offered more as a layer on top of the typical host that you might find.</p>\n\n\n\n<p>However, you also do a whole bunch of stuff around the Drupal space, but also the WordPress space. I&#8217;m just curious, maybe you don&#8217;t have this information, but maybe as a developer advocate, you do. What would you say, as a percentage, does Drupal represent as opposed to WordPress? You know, is it like an 80, 20 split, a 90, 10, a 50, 50?</p>\n\n\n\n<p>[00:08:40] Chris Reynolds: We&#8217;re almost exactly 50, 50.</p>\n\n\n\n<p>[00:08:42] Nathan Wrigley: Interesting.</p>\n\n\n\n<p>[00:08:43] Chris Reynolds: And we&#8217;ve actually honestly been 50, 50 for about five-ish years, five or six years.</p>\n\n\n\n<p>[00:08:48] Nathan Wrigley: So does that mean that in the Drupal side of things, okay, dear listener, WordPress as a CMS is a giant, it&#8217;s a leviathan of a thing, you know. Occupies a massive amount of the market share. Drupal I think is somewhere in the region of, I think it&#8217;s like 1.2% or something like that.</p>\n\n\n\n<p>[00:09:05] Chris Reynolds: Yeah, we might be creeping up to two-ish, but yeah, it&#8217;s pretty low, yeah.</p>\n\n\n\n<p>[00:09:09] Nathan Wrigley: That then implies that you as a company have, you&#8217;ve got your foot on the pedal more on the Drupal side of things. Maybe the people who are building clever things on top of Drupal are using you much more. You&#8217;re a bigger player in that space than you are inside the WordPress space, even though it&#8217;s, you know, the same in terms of revenue. As a community endeavor, Drupal probably means a lot more to you than WordPress maybe.</p>\n\n\n\n<p>[00:09:32] Chris Reynolds: Yeah, I mean definitely going to DrupalCon for my first time this last March, it&#8217;s definitely, so there&#8217;s Acquia, which is essentially Drupal&#8217;s version of Automattic. Acquia is a company that was founded by Dries, who is the founder of Drupal, and very much like managed Drupal hosting the same kind of thing that Automattic is into, and a lot of the sort of same ideas, at least from a, where it sits in the ecosystem.</p>\n\n\n\n<p>But, you know, you go to a WordCamp and you see the big Automattic booth and you&#8217;ll see a couple other sort of bigger hosting booths. At a DrupalCon it&#8217;s like, there&#8217;s the Pantheon booth and there&#8217;s the Acquia booth, and then there&#8217;s a bunch of little things. We&#8217;re definitely the kind of headliners because between the two of us, I think probably we do own most of those Drupal sites that exist in the ecosystem. But we&#8217;re definitely a bigger fish in that pond, than perhaps the WordPress pond. There&#8217;s also a lot more fish in the WordPress pond.</p>\n\n\n\n<p>It&#8217;s an interesting thing, like for me coming to DrupalCon for the first time, to see just what Pantheon&#8217;s footprint is in contrast to when I go to WordCamps. And, you know, we were big in WordCamps for a long time, and then we kind of pulled back a little bit, and then the intervening time it&#8217;s I think felt by the community like, well, who are you? Where did you go? We&#8217;ve gotten sort of feedback from folks being like, I used to think about Pantheon, but like it&#8217;s been a long time, you laid a lot of people off. Why should I care anymore?</p>\n\n\n\n<p>And that&#8217;s, you know, part of my personal goal is to say, no, this is why you should care. That&#8217;s one of the things that excited me of joining the DevRel team was to go back to our roots and go back into the community, and we still have a really good product that I believed in when I was a developer and I still think is really good as, you know, obviously I think of it as a developer advocate. But like I&#8217;m here because I like the thing. I think we have a good thing.</p>\n\n\n\n<p>[00:11:19] Nathan Wrigley: Do you basically have the exact same platform for both of the CMSs? So I know there&#8217;s all the other stuff that you do, but let&#8217;s just concentrate on Drupal and concentrate on WordPress, those two things. Do you basically have the exact same platform? Or is there some nuance that you can do this on WordPress because of, I don&#8217;t know, WP-CLI or the REST API or whatever it is that you can&#8217;t do in the Drupal side? In other words, if I sign up for a Drupal account, do things look different, behave differently, or is it broadly the same?</p>\n\n\n\n<p>[00:11:45] Chris Reynolds: It is broadly the same. There is sort of individual differences but they&#8217;re very minor. And honestly like, in many ways, I think that when Pantheon, and this is before my time, obviously, but I think when Pantheon jumped into the WordPress boat, it was really more of a, well, we have this stack and we&#8217;re really good at this thing, and WordPress is also a PHP application that has a lot of the same requirements, surely we can just run the exact same stack for WordPress.</p>\n\n\n\n<p>And what&#8217;s sort of evolved over time is like, well, that&#8217;s like 80% true, but it&#8217;s the 20% that&#8217;s really important. And if you just go into building WordPress sites or hosting WordPress sites with the same mentality as you&#8217;re doing Drupal, well, you are going to run into a lot of the growing pains that we ran into, right? Drupal from like a database perspective is far more efficient. The queries are much shorter because the way that it&#8217;s structured is more efficient than WordPress. WordPress, you kind of have to do more sort of optimisation on top. So those are things that we needed to figure out.</p>\n\n\n\n<p>The Drupal space sort of moved toward Solr as their sort of search tool of choice, which is a project from the Apache project. WordPress went into Elasticsearch. So trying to convince a WordPress team to use Solr, in fact, a pretty old version of Solr, is kind of pulling teeth. Like, well, why would I do that when I&#8217;m doing Elasticsearch for everything else? I don&#8217;t know why you would do that, honestly. Like, you should probably use Elasticsearch.</p>\n\n\n\n<p>And so we&#8217;re like actually going in, that&#8217;s a project that&#8217;s on the roadmap as well finally, it&#8217;s something I&#8217;ve been talking about for like three years internally. There&#8217;s little nuances. Drupal obviously since version eight has been using Composer as a fundamental part of how the CMS just works. Whereas WordPress, you&#8217;ve got some people that are using Composer, in fact, last time I was here, two years ago, I was talking about Composer. And I don&#8217;t know that the adoption of Composer has really changed much in the WordPress ecosystem since that time.</p>\n\n\n\n<p>I would like to say that it has. I still think that you should be using Composer. Throwback to the last WP Tavern Jukebox podcast that I was on about Composer. But yeah, so there&#8217;s little differences and I think that that&#8217;s, there&#8217;s not anything from a platform level where your experience is going to be that much different.</p>\n\n\n\n<p>[00:14:00] Nathan Wrigley: Yeah. If you were to take a look at the Pantheon platform, I think quickly poking around on the site, maybe the pricing page or something would give you an intuition that really you are kind of more for the sort of enterprise level, I think would be fair to say. You know, you are trying to get the bleeding edge out of the websites that you&#8217;ve got, and so it&#8217;s, high traffic, that kind of thing.</p>\n\n\n\n<p>But the endeavor today really is to put all of that code stuff to one side and get into the community side of things. So just to reiterate, we threw around a couple of words there, and maybe the listener doesn&#8217;t really know that even there&#8217;s a WordPress community or a Drupal community.</p>\n\n\n\n<p>There really is. There&#8217;s just hundreds, maybe thousands of people who attend events, they might go to a local thing, which we might call them Meetup on the WordPress side of things. I don&#8217;t know if there&#8217;s similar things in Drupal. But then there&#8217;s these bigger events, which we&#8217;d call WordCamps, and then there are bigger ones of those which are kind of flagship WordCamps.</p>\n\n\n\n<p>There&#8217;s one in the US, there&#8217;s one in Asia, and there&#8217;s one in Europe. They happen each year. And thousands of people show up and inhabit the same space, listen to presentations, hang out in the hallway.</p>\n\n\n\n<p>And then you&#8217;ve got the same thing happening on the Drupal side. It&#8217;s called Drupal Con, but forgive my ignorance, I think the DrupalCon thing is a once a year thing and it moves around the globe. It&#8217;s not necessarily in the same space. Have I got that about right?</p>\n\n\n\n<p>[00:15:15] Chris Reynolds: It&#8217;s more than once a year. It&#8217;s actually the equivalent. So DrupalCon is the equivalent of flagship WordCamps. So there&#8217;s a DrupalCon, there was a DrupalCon US in Atlanta this last year. There is going to be a DrupalCon Europe in, where is it? Maybe Vienna, in the fall. There&#8217;s a DrupalCon Asia that&#8217;s just starting to get fired up. That&#8217;s happening I think in, the next one is like 2026, I believe. I think they just had their first one. So very similar, like the Cons in the Drupal space are equivalent to the flagship WordCamps. There&#8217;s also DrupalCamps in much the same way as there are local WordCamps.</p>\n\n\n\n<p>I feel like in the WordPress space, a lot of the local WordCamps kind of, they either blew up and got super big, or they kind of fizzled after Covid, right? I don&#8217;t have a lot of local camps. I don&#8217;t see a lot of local camps anymore. I do see those things happening a little bit in the Drupal space, or at least starting up again.</p>\n\n\n\n<p>[00:16:08] Nathan Wrigley: Yeah so, what we&#8217;re basically painting a picture of here is that we&#8217;ve got two bits of software which basically are trying to achieve the same thing. They&#8217;re a CMS. They&#8217;re trying to make it so that non-technical, as well as technical people, can run a project and put it online. Whether that&#8217;s a website or an e-commerce solution, whatever it may be, you&#8217;re trying to get your stuff out onto the internet. And both of those things will work.</p>\n\n\n\n<p>But also, behind the code is a bunch of people who are willing to go and hang out in the same place, the community, if you like, attend these events. And so there&#8217;s massive similarity. In fact, you know, if you&#8217;re an alien landing, I suspect that you wouldn&#8217;t really know that the two things were different. Okay, there&#8217;s different advertisers in the hall and there&#8217;s different logos and things, but broadly they would probably look really similar.</p>\n\n\n\n<p>However, in the more recent past, and if you don&#8217;t know the story, I&#8217;m not going to go into it too much here, but you can figure it out by looking at various news articles in the WordPress space and what have you. The WordPress community has really been pulled in different directions, let&#8217;s say that. And it&#8217;s curious because no sooner had this happened than some of the more prominent people, Dries Buytaert, who is the founder of Drupal, put out a piece, really as a way of kind of offering, look, this is what Drupal do. We know you&#8217;ve got on the WordPress side things that are not working out for you. Here&#8217;s our model.</p>\n\n\n\n<p>And far be it from me to say whether that is the perfect system. I don&#8217;t really know it, but I was just curious to get your thoughts on what that is. And that&#8217;s going to really occupy the majority of the rest of this podcast. What the Drupal community looks like. What you believe it does well. How it does things differently. So let&#8217;s start there. Let&#8217;s start with Dries&#8217;, what he was telling us about. How does Drupal, the community, how does it do things differently in terms of, I don&#8217;t know, events, the access to the code? So yeah, a conversation around that really. So I&#8217;m just going to throw it over to you, Chris. How is Drupal different than WordPress on that level?</p>\n\n\n\n<p>[00:18:05] Chris Reynolds: Well, I was saying before we got on that I kind of had a crash course in Drupal when I went leading up to, and then immediately following going to DrupalCon. Part of that crash course was at DrupalCon, they actually have a community summit. It&#8217;s similar to like, in WordPress we&#8217;ve had sort of community summits before. At DrupalCon it was really more of like a track, with like presenters and like also conversations. It&#8217;s like space for chatting and hanging out with people.</p>\n\n\n\n<p>But mostly, mostly it was like community related talks in a space, talking about what&#8217;s working, what&#8217;s not working, as well as a sort of a get to know you sort of thing. And that was really helpful. I also did homework before the event in watching a couple of Dries&#8217; last Dries Notes. So Matt has State of the Word, Dries has Dries Notes, which is just like keynote. It&#8217;s basically the same thing, like the same state of the CMS, right?</p>\n\n\n\n<p>I caught up on what was going on in Drupal before the Con. And one of the things that I learned about, and then I followed up and dug into the history a little bit, was we have the same problems, right? WordPress and Drupal have the same fundamental sort of issues from both a contribution standpoint as well as a just organisational, managerial management kind of standpoint.</p>\n\n\n\n<p>And Drupal, or Dries, just kind of got to a point sooner where he&#8217;s like, well, I can&#8217;t do all of these things. So the Drupal Association, and I&#8217;m sure there&#8217;s some Drupalistas that are going to correct me on my history, but as I understand it, the Drupal Association was initially formed to sort of manage events, because Dries knew that they needed to have events. They were having events, they started off just similar to WordPress, small camp things. And they started getting bigger and Dries is like, well, I can&#8217;t do all of the management stuff of this, so I need to like do something, create an organisation that can do that stuff.</p>\n\n\n\n<p>And that was where the Drupal Association first was founded, to sort of manage that thing. And then over time, that evolved into being able to fund, or kind of oversee, directions for where, more of like a community representative in the general sort of CMS development ecosystem, right?</p>\n\n\n\n<p>There is a board. They are elected by the community. They are paid. They manage events, but they also, all of the money that is made after expenses and stuff from DrupalCons and donations and whatever, they have the authority to direct into whatever projects they think would be most valuable for the evolution, or the fulfillment, of the ideals of the Drupal software, right?</p>\n\n\n\n<p>So Dries says, I want to do a thing, and he can go do that thing. The Drupal Association is like, well, I think that what we really need is this kind of thing, and we&#8217;re going to devote some of our resources that we have into hiring some folks to work on that thing.</p>\n\n\n\n<p>So, most recently, where you can kind of see this in action is there&#8217;s been a lot of hype about Drupal CMS. That is a thing that exists because of the Drupal Association, because the Drupal Association saw, okay, I mean, I assume, I&#8217;m reading between the lines. But I assume that you can&#8217;t ignore the sort of declining line of Drupal in the broader ecosystem of CMS usage. But also, there&#8217;s been a really big problem since Drupal seven of a lot of the sites on Drupal seven remain on Drupal seven.</p>\n\n\n\n<p>Drupal seven should be end of life by all accounts. Everything else up to the current version is end of life. Drupal seven isn&#8217;t, because there&#8217;s still, it&#8217;s now just under, but it&#8217;s still close to 50% of Drupal sites are running Drupal seven. It&#8217;s a version of Drupal that&#8217;s about 10 years old.</p>\n\n\n\n<p>And the reason why, there&#8217;s so many people. Drupal historically has always been a thing where, when a new version came along, you kind of killed your old site and rebuilt it in the new version, because it wasn&#8217;t sort of backwards compatible. WordPress has gotten around that by just remaining backwards compatible all throughout its history.</p>\n\n\n\n<p>Drupal seven to Drupal eight was the first version to introduce Composer. We talked about Composer and how a Composer&#8217;s been part of Drupal for a really long time. that was the cutoff. So that was a pretty big shift. And there&#8217;s a lot of people, teams, organizations that have not made, or have been reluctant to make that shift because it&#8217;s a, it&#8217;s a rebuild. It&#8217;s a full site rebuild.</p>\n\n\n\n<p>It&#8217;s not just, we can just migrate the thing over. You have to rebuild your site. You do need to migrate your stuff over, but also you need to rebuild your site. So in the intervening time, WordPress has gained adoption and acceptance and grown into 43%. And so now we&#8217;ve got these Drupal seven sites where it&#8217;s like, well, we need to rebuild anyway. Do we rebuild the site in Drupal 10, 11? Or do we rebuild the site in WordPress where I&#8217;m never going to have this problem ever again.</p>\n\n\n\n<p>And that&#8217;s where a lot of that like, bar graph, a lot of those sites have moved to WordPress. Some of them have stayed on Drupal, but it&#8217;s a declining number, right?</p>\n\n\n\n<p>So obviously, folks inside Drupal see this and know that it&#8217;s happening, and know that they need to do something about it. So Drupal CMS is basically like a layer on top of the latest version of Drupal, which is 11. It&#8217;s got a far nicer installation screen. I wrote a blog post about this on the Pantheon blog, I think. It&#8217;s got a far nicer installation screen, that actually walks you through, stepping through like what type of site, what type of content you want to have on your site. To actually get you thinking about the site that you&#8217;re building before you just hit install. Which I find to be amazingly refreshing.</p>\n\n\n\n<p>And then beyond that the admin interface is far less cluttered. I know one of my personal gripes about working with Drupal, even up until, up until now, like up until before Drupal CMS is that there&#8217;s too many buttons, there&#8217;s too many menus, there&#8217;s too much stuff. Like, I don&#8217;t know where stuff is.</p>\n\n\n\n<p>This feels a lot more familiar, partially because I think it kind of resembles the WordPress admin a little bit. You know, sidebar on the left, menus. And it feels just more, more familiar to me. And then also they have built in some new architectural things like, recipes are a thing where, a recipe, Drupal has modules, WordPress has plugins. Modules generally need a lot of configuration, to get them actually working.</p>\n\n\n\n<p>When you install a module, it&#8217;s not like it just works outta the box. A lot of WordPress plugins, you install a plugin, it just works outta the box. So a recipe is like, here is, maybe a collection of modules, maybe a specific module, but it&#8217;s probably a combination of a bunch of different modules, but also the configuration that goes along with them.</p>\n\n\n\n<p>So when you install a recipe, it&#8217;s like, here&#8217;s the stuff that you probably will need. You&#8217;re most likely to need this stuff in this order, configured with these settings, and then you can do whatever you need after that. But like, here&#8217;s the go bag and now you can move on. So, one of the really interesting recipes for Drupal CMS is the SEO recipe.</p>\n\n\n\n<p>And that is interesting because they&#8217;re using a Yoast module. The Yoast module is literally taking the JavaScript of Yoast SEO from the WordPress plugin and throwing it into Drupal. And what&#8217;s fascinating about that is it doesn&#8217;t have all of the other stuff that comes with the Yoast plugin, it&#8217;s just the traffic light system, and the scanning the text system and it&#8217;s, so it&#8217;s the best possible implementation of Yoast that I&#8217;ve seen because it&#8217;s all of the good stuff.</p>\n\n\n\n<p>They&#8217;ve also built an AI recipe. And that&#8217;s interesting because when that is configured, you can actually talk to an AI chat bot inside your Drupal instance and ask it questions about Drupal or about your site. You could say, hey, I need to create an event content type. I&#8217;m gonna be hosting events. They&#8217;re this type of thing. I need to have a, like a, date picker and whatever, and we are taking attendees and you can tell that the chat bot that that&#8217;s the thing that you need. And it will, to the best of its ability, build that content type inside Drupal for you.</p>\n\n\n\n<p>So the WordPress equivalent is, I have a podcast and I need an episode post type. I just talk to a chat bot, and it magically creates that episode post type for me with like the Gutenberg blocks I need. That makes it an audio format or whatever. And, it&#8217;s just there for you. It&#8217;s like, great, thank you chat bot. As a WordPress developer, I think that&#8217;s really cool. Because that&#8217;s kind of the thing that I want, is like I know how to do some things, but I really don&#8217;t know any of the buttons and gears and gizmos in the Drupal admin.</p>\n\n\n\n<p>But if I have a chat bot to sort of help guide me through, I know I can figure out the rest of the way, or I can see how it did the thing, and I can figure out, oh okay, so that&#8217;s what I need to do. And so all of these things are geared toward the idea of just getting more people using Drupal and lowering the barrier to entry.</p>\n\n\n\n<p>Because one of the big things with Drupal is it&#8217;s always been really developer centric, really highly technical, and you need sort of skilled individuals to even just manage the site. So if we lower that barrier to entry, you can target the people that are already using WordPress, the sort of content level people or the site administrators that don&#8217;t have a lot of technical experience.</p>\n\n\n\n<p>That&#8217;s all like basically because the Drupal Association put money, funding that they had into backing these very specific projects.</p>\n\n\n\n<p>[00:27:25] Nathan Wrigley: It is kind of a curious idea, isn&#8217;t it? It&#8217;s like a subset of the CMSs capabilities put into this one project, Drupal CMS. Which has like a target audience in mind. So it&#8217;s like a blogger, or a podcaster or something like that. You know, it&#8217;s for content creators. That was the message I got from when I read all of the, the marketing bits and pieces that came out.</p>\n\n\n\n<p>But also addressing the need for it to look nice. That was always an area I thought WordPress excelled at. When you logged into the WordPress admin, it was night and day looking at a Drupal admin. Everything was consistent. Everything looked modern and clean and easy to understand. On the Drupal side, it was, it was much more difficult to understand. But also things like updating plugins. Backwards compatibility on the WordPress side, always much more straightforward. On the Drupal side, much more difficult.</p>\n\n\n\n<p>And so this is such a curious experiment. Putting it into the hands of people who might want a blog, or whatever it may be, and hopefully making it more straightforward. And the website for it, I will link to it in the show notes, it&#8217;s just so kind of modern and appealing and friendly and, Drupal never, for me at least when I got to Drupal eight, for the exact reasons that you described, that&#8217;s all of my sites would have stayed on Drupal seven.</p>\n\n\n\n<p>It definitely wasn&#8217;t that kind of warm and fuzzy welcome to everybody kind of thing. But now it really look like it&#8217;s leaning into that. But getting back to your main point, that was funded from the inside by some, facets, some internal mechanisms, some body inside the Drupal Association that decided that&#8217;s what we need to do. This is where the money&#8217;s going. But are you saying that decision making was divorced from Dries?</p>\n\n\n\n<p>[00:29:02] Chris Reynolds: Dries leads the technical architecture. And Dries will like say we need to do a thing. And he may be personally involved in the leadership of doing that thing, but mostly he&#8217;s like at a director level. Like, go my people and go forth and do stuff. And the Drupal Association says, okay, well one of the things that Dries said we need to do is X. So how can we make X happen? And in the case of recipes, it meant getting agencies and people from agencies involved. Create like a coalition. Like there&#8217;s a bunch, it wasn&#8217;t just one agency. It was like a bunch of people from different agencies are working on this thing together. Which is another thing that I find really interesting about the Drupal ecosystem.</p>\n\n\n\n<p>I have thoughts about that too. But in this context, yeah, I get a bunch of different people to work on this thing. Um. Whether it&#8217;s the SEO recipe. Whether it&#8217;s the AI recipe, and they, I think the way that it sort of broke down is, and it might have been even Dries that conceptualized the idea of recipes and it&#8217;s like, okay, go out and implement this thing.</p>\n\n\n\n<p>But when they did, it was like, okay, if we&#8217;re gonna do this thing, we need these types of recipes from the get go, from day one. We need SEO, we need whatever. We need AI, we need content things, so that people have an idea of what a recipe is and can start building their own recipes.</p>\n\n\n\n<p>[00:30:15] Nathan Wrigley: So they&#8217;re bound into it? You can&#8217;t install Drupal CMS without those things. They&#8217;re just there.</p>\n\n\n\n<p>[00:30:20] Chris Reynolds: It supports the recipes, and in the installation process, when you&#8217;re doing the Drupal CMS installation, that screen that I was talking about, where it&#8217;s like asking you the type of site you want to build, those types of sites in quotations, correspond to sets of recipes that align with each of those things.</p>\n\n\n\n<p>It doesn&#8217;t ask you about AI in the installation screen, but it does sort of say like, oh, do you want this type of content or that type of content? And then we, based on your selection, it automatically installs those recipes for you.</p>\n\n\n\n<p>[00:30:48] Nathan Wrigley: So it&#8217;s installing things based upon a wizard at the beginning, but the principle being though that you the end user, not really interacting with anything apart from oh, I would like that. Yes, please. I would like that. And then you finally get to the end of the wizard, wait for a few moments. The modules get installed, activated, and they&#8217;re pre-configured to behave in a way which is likely to be the best that you can get.</p>\n\n\n\n<p>[00:31:08] Chris Reynolds: To get you as close to what you want as possible. And the goal, the roadmap, is Dries wants to actually take that one step further, and do sort of site templates where if a recipe is a collection of modules and configuration, a template would be like, I want to build a real estate site. So I download this template, or I install this template and then click a button or two and it gives me a real estate site with the configuration that I might need to have a real estate site.</p>\n\n\n\n<p>And obviously I can go in and customize things, but I have a starting point. One of the things that I heard a lot when I was talking to people within Drupal, among other things, there&#8217;s not really a marketplace as much for stuff, for software, for add-ons in the way that there is in WordPress. And there&#8217;s not really in particular, there&#8217;s not really the same sort of like theme or a repository, or a place to go for commonly used or shared themes in the way that we have the Themes Repository. Mostly you have like the default things and then you&#8217;re building your own.</p>\n\n\n\n<p>So, as a user, having a template that maybe comes with a theme that is specifically tuned for that type of site is a really big win, because there really isn&#8217;t an alternative in the current ecosystem within Drupal.</p>\n\n\n\n<p>[00:32:23] Nathan Wrigley: Yeah, that&#8217;s, really worth leaning into because again, please interrupt me if what I&#8217;m about to say doesn&#8217;t actually match reality anymore. But when I was using Drupal, there was basically no commercial plugin system. Everybody had kind of leaned into the same thing for the same problem.</p>\n\n\n\n<p>So if you wanted to put a form on your website, there were a few, but there was this one called Webform, and it was just the one everybody leaned into it. And so rather than in the WordPress space where you&#8217;ve got, you know, you&#8217;ve got a few repository ones that are free and easy to use, and then you&#8217;ve got the commercial ones that you can pay for and they add different features and support levels and all that kind of thing.</p>\n\n\n\n<p>In the Drupal space, it felt like there was just this one kind of community endeavor to do the thing. Yeah, so if you wanted something to display data, Views was the thing you used. The Views module, and I think that did actually get rolled into Core. So it&#8217;s there. My point being, there isn&#8217;t this sort of, shattering is the wrong word, but in the WordPress space, there&#8217;s often a dozen, more than a dozen, there&#8217;s multiple alternatives. So you have to go and find the right thing.</p>\n\n\n\n<p>In the Drupal space, it feels more like, okay, for that problem, we have this module, and everybody leans into it. So I&#8217;m presuming that all the people who contribute in the community to the code and what have you, they&#8217;ll all finesse that version. But that means therefore, that when you come to build the CMS, there&#8217;s basically this one way of doing it? Okay, if you want forms, we&#8217;re going to use that module. And if we&#8217;re going to add this feature for real estate or what have you, here&#8217;s the modules that we&#8217;re going to add in. And the jigsaw of those modules will make it work. And that&#8217;s different from WordPress. WordPress has much more leaned into commercial plugins and kind of figure out which ones you want for yourself.</p>\n\n\n\n<p>[00:34:04] Chris Reynolds: Yeah, that was one of the things that I didn&#8217;t know going into DrupalCon that I learned while I was there. It&#8217;s a really different approach, and I actually kind of appreciate the Drupal model because the community is built around more of an idea of, if I build a form plugin and you build a form plugin, and mine is the defacto form plugin or.</p>\n\n\n\n<p>In the Drupal space, it&#8217;s really more of a, well, let me talk to you and see what ideas you have that we can bring into the canonical one and just collectively like integrate those things. And that&#8217;s, that is a thing that happens more often than not in Drupal. That&#8217;s why you don&#8217;t see the competition, the competing modules for different things.</p>\n\n\n\n<p>Because if you had a competing thing, or you had a different idea, you would contribute it to the one module that does that thing. Or if you had a different thing, then you might be invited to do the same, right?</p>\n\n\n\n<p>In the WordPress space, it&#8217;s like I want to protect my form module or my form plugin because right now it&#8217;s free, but tomorrow I might want to sell it, and I want to keep my intellectual property to myself and not contribute because, you know, I might wanna make a buck on this later.</p>\n\n\n\n<p>And, I kind of like the other thing better because it&#8217;s more, it is more of a community. Like I get like wanting to make money and everybody wants to make money and have a form plug in. Like, that&#8217;s great. Like I&#8217;m not going to say Gravity Forms shouldn&#8217;t exist or anything like that. Gravity Forms is amazing. But I do think that building an ecosystem around contributing to a collective, or a community based solution for the thing, where everybody has a, a say or a seat at the table, is a really, I don&#8217;t know, possibly overly idealistic, but very optimistic sort of view of how we can contribute to software.</p>\n\n\n\n<p>I find it really nice. Like it feels good. Like it feels less like we&#8217;re all trying to grab our little piece of territory, you know?</p>\n\n\n\n<p>[00:35:53] Nathan Wrigley: It feels to me like that moment when you first install Linux. And you realize, wow, there&#8217;s a free OS that I can put on my computer. And there&#8217;s just something quite remarkable about that. That a bunch of people got together and, really pointed everything at this one solution. I suppose that is the choice that you&#8217;re going to make. Really, that there is something right in there.</p>\n\n\n\n<p>You know, the commercial side of WordPress has probably been its single biggest accelerator. The fact that people could build businesses on it. And they could have a living. They could obviously refine and finess and dedicate real time entire lifetimes, in many cases. Get staff on, support staff and what have you. Pay all of those people because they&#8217;ve cracked this nut and everybody wants a piece of it.</p>\n\n\n\n<p>Whereas on the Drupal side, it&#8217;s much more, let&#8217;s go for egalitarian, let&#8217;s say that. But it, also, I suppose, means that at the moment where something doesn&#8217;t work you probably have to either understand how to maintain that yourself or hire a developer.</p>\n\n\n\n<p>So there&#8217;s a bit of a trade off there. And I presume, like I said, I imagine that&#8217;s why there was this acceleration of WordPress&#8217;s popularity because the people who maybe were buying these plugins had that intention, I just want a website. I don&#8217;t want to learn how to code. I&#8217;m not interested in that.</p>\n\n\n\n<p>I can see over here, look, I can buy that. It&#8217;s $97 a year. That&#8217;s perfect. That&#8217;ll satisfy me perfectly. Whereas maybe more on the Drupal side, it&#8217;s okay, that kind of works, but not entirely. I now need to make it work and obviously the community can do that.</p>\n\n\n\n<p>So that leads me then to the next question, which is, who the heck builds Drupal? So in the WordPress space, if you&#8217;re listening to this, you probably have an understanding of that. There&#8217;s a lot of volunteers, but there&#8217;s also a lot of companies that will dedicate a proportion of their time. We have this idea of Five for the Future. And so 5% of whatever it is that you want to give, be that time or money, or what have you. And so there&#8217;s this idea of community massively, but also corporations, businesses, putting time in. Is it the same basically on the Drupal side? Is that how it works?</p>\n\n\n\n<p>[00:37:51] Chris Reynolds: Yeah, largely. One of the things that I think you&#8217;ll notice that is a little bit of a distinction between WordPress and Drupal, from the events again. Is going through like the showroom, the sponsors floor. And at a WordCamp you see the hosts obviously, but then you see a lot of like plugin development shops, and that&#8217;s pretty much what I would expect, right? Big plugin or theme development shops and WordPress hosts. And a lot of the WordPress hosts are doing plugin development, and like, that&#8217;s sort of the thing.</p>\n\n\n\n<p>In Drupal, and at DrupalCon, obviously we have the hosts. And we had a, I mean, CKE Editor was there. That was kind of weird to me. I don&#8217;t know, like it&#8217;s in Drupal. It was weird to have like a library have a booth space. That seemed weird to me. But like it&#8217;s a lot of agencies, because agencies are the ones that are doing the work, and I&#8217;ve never seen an agency or maybe not since very small, like local WordCamps, have I seen an agency with a sponsorship, a booth space at a WordCamp.</p>\n\n\n\n<p>But that is, that&#8217;s where it is. And it&#8217;s agencies that do a lot of that Core contribution, because they&#8217;re also in the weeds working with clients and building these things for their Drupal customers. And so like, the SEO recipe that I was talking about, like at DrupalCon we, Pantheon has booth demos. Acquia also has booth demos, which means we can talk about, like do demos of our platform, whatever. What we actually did was bring in guest speakers from like agencies and universities and whatever that are actually using Drupal and Pantheon and to talk about their implementation of the cool stuff that they&#8217;re doing, because that works better.</p>\n\n\n\n<p>And one of the people that I talked to was about the SEO recipe, and he is at an agency and he worked with other people at other agencies, competing agencies even, to make this SEO recipe. So it&#8217;s, that&#8217;s where the contribution comes from. But again, like it&#8217;s the same sort of thing.</p>\n\n\n\n<p>Dries said 10 years ago, wrote a blog post about the maker taker problem, as he defines it. And then again in September, in relation to the current state of things in the WordPress ecosystem, because that&#8217;s a thing that he&#8217;s been thinking about for a long time. It&#8217;s obviously a thing that Matt&#8217;s been thinking about for a long time.</p>\n\n\n\n<p>Like it&#8217;s not, again, we&#8217;re not that different. We have the same fundamental problems. At the Community Summit at DrupalCon, one of the topics of conversation was getting more people involved, a younger generation involved into Drupal development, which is the exact same conversation we&#8217;re having in WordPress as well.</p>\n\n\n\n<p>Like, how do we appeal to a younger audience? It&#8217;s all the same stuff, right? And there was at some point like a contribution like pie chart. Again, similar to the pie chart that could be displayed at a WordCamp. You know, Automattic does a big chunk of that pie chart.</p>\n\n\n\n<p>And then you&#8217;ve got, you know, maybe Google does a smaller part of that pie chart and maybe like Bluehost or whatever. Similar pie chart. Acquia does a lot of the big part of the, of that pie chart. And then like other agencies are noted around, and then there&#8217;s like an other category, right, of just like individual contributors. It&#8217;s a very similar breakdown.</p>\n\n\n\n<p>[00:40:47] Nathan Wrigley: It&#8217;s interesting because obviously you alluded to the fact that WordPress has been in a state of flux since September. But Dries, I presume prompted by the situation that arose out of WordCamp US. He wrote a piece very much timed after that. So I presume it was in, there was some sort of correlation in his head. And he was laying out how Drupal have, not solved, but how they just have a different approach to that. And I can&#8217;t remember every single detail, but there was some curious examples in the Drupal community, like this kind of, I&#8217;m going to say pay to play thing.</p>\n\n\n\n<p>In other words, if you as a company, let&#8217;s say Pantheon may fit into this perfectly, if Pantheon steps through certain hoops and can prove that they did this thing and this thing and this thing for the community, for the Drupal project. If you step through those hoops, you then get, kind of, merit on the other side.</p>\n\n\n\n<p>You can, for example, turn up to DrupalCon as a sponsor. My understanding is that maybe it&#8217;s only certain tiers, I&#8217;m not really sure. But you can&#8217;t sponsor DrupalCon unless you have jumped through those hoops. And we don&#8217;t really have anything on the WordPress side like that. We have Five for the Future, but it&#8217;s hard to pin down. It&#8217;s hard to figure out who did what and what have you, because there aren&#8217;t the same sort of goalposts, but it feels like the goalposts are a bit more nailed down on the Drupal side.</p>\n\n\n\n<p>[00:42:03] Chris Reynolds: There is a process of nailing things down. I don&#8217;t know that it goes to the level of, like you can&#8217;t actually sponsor, because obviously Pantheon does sponsor and we&#8217;ve been, on the other end of being told that we don&#8217;t contribute enough to both WordPress and Drupal. But that also depends on how you define contribution really. And I have thoughts about that. The merit thing, it&#8217;s just where you&#8217;re drawing the lines in the sand. And Drupal has, Dries has his particular lines and the things that make you a contributor to the ecosystem, and what that means in Drupal.</p>\n\n\n\n<p>And then, to a degree, I mean, yeah, like you said, Five for the Future is kind of, sort of that thing, but it&#8217;s also kind of amalgamous and like it&#8217;s honor based. There&#8217;s not really a real sense of tracking or, you could kind of, sort of track things, I guess. But it&#8217;s very wibbly wobbly.</p>\n\n\n\n<p>But my perspective on contribution always has always been, one of the things, I know we&#8217;re not supposed to talk about what was talked about at PressConf, but Brad Williams, who I, was my former boss said, he was talking about Five for the Future and was talking about how Web Dev was very early on an adopter of Five for the Future, and I was there at the time, so I remember this. So it&#8217;s not just Brad&#8217;s words that I&#8217;m repeating. And the way that he approached Five for the Future was very much in the umbrella of if you&#8217;re doing anything WordPress related that is open source, we are counting that as a Five for the Future project, right. And that was how I understood Five for the Future.</p>\n\n\n\n<p>That was kind of how it was presented back in 2014 or whatever when Matt first threw the idea out to the, out to the ecosystem. And since then it&#8217;s sort of become this thing where contribution to WordPress really means Core contributions, or contributions in very specific ways. And it doesn&#8217;t mean all of this other stuff over here, including an up to theme development, plugin development.</p>\n\n\n\n<p>Even if that stuff is on .org, even if that stuff is open source, that&#8217;s not included in contribution. But I&#8217;m very much in the side of the bucket where like, well, everything is kind of contribution. We wouldn&#8217;t know how good WordPress scales to like enterprise level sites that are running it today, that are driving the adoption of WordPress, and driving the bar in like the visibility of WordPress, if it wasn&#8217;t for just hosts that are running the thing and making sure that it operates properly. And the teams like 10up and Human Made, and whoever who are like then, oh, to get this working at its best, fastest, most optimized state we need to do some enhancements. Either through the plugin ecosystem or contributing back to Core, so that we can push this code to these hosts, or platforms, or softwares as a service or whatever so that they operate for these clients that we&#8217;re building.</p>\n\n\n\n<p>So like I kind of feel like everything should be, even if you are a taker, in the language of Dries, that doesn&#8217;t necessarily mean that you&#8217;re not pushing the ecosystem forward. And I have that critique for both of our BDFLs, right? Because they both have very similar ideas.</p>\n\n\n\n<p>Like I think that the contribution title could be applied and should be applied more broadly, because everything that we&#8217;re doing is driving the project forward. A lot of the stuff that I write is like GitHub actions, or like plugins or things that are still broadly available to, and publicly available, and they&#8217;re open source and they&#8217;re for the community, but they&#8217;re not technically contribution, because contribution is narrowed down into this very specific definition.</p>\n\n\n\n<p>[00:45:30] Nathan Wrigley: It&#8217;s kind of curious, you know, if you were to cast your mind back 20 years, the beginning of both Drupal and WordPress, just even the idea that they would still be around for one thing, you know, that that software wouldn&#8217;t have just come and eaten them up and there would be like a two year lifespan.</p>\n\n\n\n<p>[00:45:44] Chris Reynolds: And that there&#8217;s an open source solution for these things.</p>\n\n\n\n<p>[00:45:46] Nathan Wrigley: And it&#8217;s going and it&#8217;s kept rising and it&#8217;s kept being used. That&#8217;s just so curious. But also the teething pains of that. The idea that, you know, it started with Matt, and it started with Dries, and then people got on board and it grew. And then in the case of Drupal, and in the case of WordPress, it just grew to the point where these individuals can no longer handle everything.</p>\n\n\n\n<p>You know, you described how Dries needed to sort of say, can somebody handle the events please? Because that&#8217;s just not where I want to be. The same, presumably on the WordPress side. And now we&#8217;re into giant communities. Really, really complicated communities. A lot of differing opinions, a lot of different maybe even politics, but a lot of different backgrounds, geography, the whole thing.</p>\n\n\n\n<p>It&#8217;s this international thing. And it&#8217;s difficult. It&#8217;s really, really hard to get it right. But what I&#8217;m taking from this conversation. Is that maybe Drupal do things differently, but they have way more in common than we have as differences.</p>\n\n\n\n<p>But also maybe there are some things that WordPress does better. Maybe there are some things that Drupal does better. And it would be very, very interesting if the two communities could kind of collide more, and share those ideas and we pick the best of each of them. It&#8217;s never gonna be perfect, but maybe that&#8217;s something that in the future, given that really at a very core level we&#8217;re not in competition with each other, it would be very nice if those conversations could take place.</p>\n\n\n\n<p>And I think you&#8217;ve laid the groundwork for a lot of that and explained how one project is not that dissimilar to the other one. So, that&#8217;s it.</p>\n\n\n\n<p>Chris, thank you so much for chatting to me today. I really appreciate it. That was very enlightening.</p>\n\n\n\n<p>[00:47:22] Chris Reynolds: Thank you for having me. I always love chatting with you.</p>\n</div></details>\n\n\n\n<p>On the podcast today we have <a href=\"https://www.linkedin.com/in/chrissreynolds/\">Chris Reynolds</a>.</p>\n\n\n\n<p>Chris is a developer advocate at Pantheon, where he brings nearly 20 years of experience in the WordPress community, as well as deep involvement with Drupal and open source technology at large. Prior to his advocacy role, he worked at some of the top WordPress agencies like Human Made and WebDevStudios. He’s been active at events like DrupalCon, PressConf, and WordCamps.</p>\n\n\n\n<p>In this episode, we set aside the usual WordPress-only focus, and turn our attention to two CMSs, WordPress and Drupal, what makes them tick, where they excel, and where they might have something to learn from each other.</p>\n\n\n\n<p>Chris draws on his unique perspective working closely with both platforms, as Pantheon is one of the few hosts with a 50/50 split between WordPress and Drupal sites, and has a significant footprint in both ecosystems.</p>\n\n\n\n<p>We discuss the similarities and differences between the two open source CMS communities, from the mechanics of flagship events like WordCamps and DrupalCon, to the ways these projects organize their contributors and support community initiatives.</p>\n\n\n\n<p>Chris explains how Drupal’s model, with its association-run funding and project governance, compares to WordPress’s approach, including how each community approaches plugin and module development, and what role agencies and companies play in contributing to Core and the broader ecosystem.</p>\n\n\n\n<p>If you’re curious about how open source projects organise themselves, how their communities navigate growth and challenge, and what WordPress can learn from Drupal (and vice versa), this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://pantheon.io/\">Pantheon</a></p>\n\n\n\n<p><a href=\"https://ampache.org/\"> Ampache</a></p>\n\n\n\n<p><a href=\"https://www.drupal.org/association/drupalcon\"> DrupalCon</a></p>\n\n\n\n<p><a href=\"https://pressconf.events/\">PressConf</a></p>\n\n\n\n<p><a href=\"https://webdevstudios.com/\"> WebDevStudios</a></p>\n\n\n\n<p><a href=\"https://humanmade.com/\"> Human Made</a></p>\n\n\n\n<p><a href=\"https://www.acquia.com/\"> Acquia</a></p>\n\n\n\n<p><a href=\"https://dri.es/about\"> Dries Buytaert</a></p>\n\n\n\n<p><a href=\"https://automattic.com/\"> Automattic</a></p>\n\n\n\n<p><a href=\"https://solr.apache.org/\">Solr</a></p>\n\n\n\n<p><a href=\"https://www.elastic.co/elasticsearch\"> Elasticsearch</a></p>\n\n\n\n<p><a href=\"https://getcomposer.org/\"> Composer</a></p>\n\n\n\n<p><a href=\"https://wptavern.com/podcast/68-chris-reynolds-on-why-to-use-composer-with-wordpress\"> Chris on a previous episode of the WP Tavern Jukebox podcast talking about Composer</a></p>\n\n\n\n<p><a href=\"https://www.drupal.org/community/events?field_event_type_value=drupalcamp&amp;field_event_address_country=All\"> DrupalCamps</a></p>\n\n\n\n<p><a href=\"https://dri.es/solving-the-maker-taker-problem\">Solving the Maker-Taker problem</a></p>\n\n\n\n<p> Dries Notes &#8211; <a href=\"https://dri.es/state-of-drupal-presentation-september-2024\">State of Drupal presentation (September 2024)</a></p>\n\n\n\n<p><a href=\"https://www.drupal.org/association\"> Drupal Association</a></p>\n\n\n\n<p><a href=\"https://yoast.com/yoast-seo-for-drupal/\">Drupal  Yoast module</a></p>\n\n\n\n<p><a href=\"https://new.drupal.org/home\">Drupal CMS</a></p>\n\n\n\n<p><a href=\"https://www.drupal.org/docs/8/core/modules/views\">Drupal Views</a></p>\n\n\n\n<p><a href=\"https://www.gravityforms.com/\">Gravity Forms</a></p>\n\n\n\n<p><a href=\"https://wordpress.org/five-for-the-future/\">Five for the Future</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 May 2025 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"Do The Woo Community: From Functional to Scalable: WooCommerce Solutions with an Enterprise Mindset\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://openchannels.fm/?post_type=blog&p=96868\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"https://openchannels.fm/from-functional-to-scalable-woocommerce-solutions-with-an-enterprise-mindset/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:209:\"Some insight on agencies who focus on enterprise-level solutions for mid-market WooCommerce clients, emphasizing customized, scalable technologies and decoupled architectures to enhance reliability and growth.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 May 2025 09:11:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Bob Dunn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Do The Woo Community: One For the Road via PressConf with Adam and Emma\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://openchannels.fm/?p=97297\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://openchannels.fm/one-for-the-road-via-pressconf-with-adam-and-emma/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:262:\"During PressConf 2025, hosts and guests highlighted the significance of in-person connections within the WordPress community, emphasizing candid conversations, relationship-building, emotional moments, and the event\'s business focus, inspiring future gatherings.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 20 May 2025 13:06:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Bob Dunn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Do The Woo Community: How to Say No to Feature Requests Without Upsetting Your Customers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://openchannels.fm/?post_type=blog&p=96857\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://openchannels.fm/how-to-say-no-to-feature-requests-without-upsetting-your-customers/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:212:\"The challenges of declining customer feature requests while maintaining goodwill. Strategies include transparent communication, offering alternatives, and using data for prioritization, preserving product vision.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 20 May 2025 08:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Bob Dunn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"Do The Woo Community: Your Website Could Use a Changelog to Fuel Creativity\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://openchannels.fm/?post_type=blog&p=96643\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://openchannels.fm/why-every-website-needs-a-changelog-and-how-it-fuels-creativity/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:221:\"Website changelogs, often overlooked, document progress and small victories. They provide transparency, spark creativity, and offer audiences insight into a site\'s evolution—important for all creators, not just techies.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 19 May 2025 10:35:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Bob Dunn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"Weston Ruter: Adding Caption &amp;amp; Lightbox to the Featured Image Block\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://weston.ruter.net/?p=34581\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://weston.ruter.net/2025/05/17/adding-caption-and-lightbox-to-the-featured-image-block/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:21544:\"<p>Earlier this year I re-built this site using the <a href=\"https://wordpress.org/themes/twentytwentyfive/\">Twenty Twenty-Five</a> theme, finally adopting a <a href=\"https://wordpress.org/documentation/article/block-themes/\">block theme</a> over the veritable <a href=\"https://wordpress.org/themes/twentytwenty/\">Twenty Twenty</a> classic theme I had been using. In this rebuild, one thing that I had trouble with is the featured image. In the Twenty Twenty theme, a <a href=\"https://github.com/WordPress/wordpress-develop/blob/8b466fce082b5b8731cebca85469ae1978318504/src/wp-content/themes/twentytwenty/template-parts/featured-image.php#L27-L36\">caption is rendered</a> under the featured image if one is set on the underlying <code>attachment</code> post in the Media Library. In the Twenty Twenty-Five theme, however, no caption is shown by the <a href=\"https://wordpress.org/documentation/article/post-featured-image-block/\">Featured Image block</a>:</p>\n\n\n\n<div class=\"wp-block-columns is-not-stacked-on-mobile is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img alt=\"Single template of Twenty Twenty theme showing an article about the Bison with an image of the Bison as the featured image. A caption appears below the Bison image.\" class=\"has-border-color has-accent-4-border-color wp-image-34604\" height=\"700\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/05/twentytwenty-single-template.png?resize=394%2C700&#038;ssl=1\" style=\"border-width: 1px;\" width=\"394\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Caption shown with featured image in the Twenty Twenty theme.</figcaption></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img alt=\"Single template of Twenty Twenty-Five theme showing an article about the Bison with an image of the Bison as the featured image. A caption does not appear below the Bison image.\" class=\"has-border-color has-accent-4-border-color wp-image-34605\" height=\"700\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/05/twentytwentyfive-single-template.png?resize=394%2C700&#038;ssl=1\" style=\"border-width: 1px;\" width=\"394\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Caption for featured image omitted in the Twenty Twenty-Five theme.</figcaption></figure>\n</div>\n</div>\n\n\n\n<p>I was expecting the Featured Image block to have an &#8220;Add caption&#8221;/“Remove caption” button in the block toolbar. This is available in the regular Image block, but it is absent in the Featured Image block:</p>\n\n\n\n<div class=\"wp-block-columns is-not-stacked-on-mobile is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img alt=\"Block editor showing an Image block selected with the caption appearing below the image and the &quot;Remove Caption&quot; button being hovered over in the block toolbar.\" class=\"has-border-color has-accent-4-border-color wp-image-34606\" height=\"700\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/05/twentytwentyfive-block-editor-image-block.png?resize=624%2C700&#038;ssl=1\" style=\"border-width: 1px;\" width=\"624\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Image block in the block editor with “Remove caption” button hovered.</figcaption></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img alt=\"Site editor showing a Featured Image block selected with there not being any caption displayed and no block toolbar button for captions.\" class=\"has-border-color has-accent-4-border-color wp-image-34607\" height=\"700\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/05/twentytwentyfive-site-editor-featured-image-block.png?resize=638%2C700&#038;ssl=1\" style=\"border-width: 1px;\" width=\"638\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Featured Image block without any “Add caption” button shown in the block toolbar.</figcaption></figure>\n</div>\n</div>\n\n\n\n<p>It turns out there is a 3-year old Gutenberg issue (<a href=\"https://github.com/WordPress/gutenberg/issues/40946\" title=\"[Post Featured Image]: add option to display image caption/credit\">#40946</a>) about this missing capability in the Featured Image block. But this isn&#8217;t the only missing feature from the block. In addition to the caption, something else I was missing is the ability to open the featured image in a lightbox, something which the Image block exposes by selecting the link option to “Enlarge on click”. The Featured Image block does not have this Link button in the block toolbar but instead just has a “Link to Post” setting toggle in the block sidebar:</p>\n\n\n\n<div class=\"wp-block-columns is-not-stacked-on-mobile is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img alt=\"Block editor with the Link block toolbar button having been clicked, showing the Link options to &quot;Link to image file&quot;, &quot;Link to attachment page&quot;, and &quot;Enlarge on click&quot;. The last option is focused.\" class=\"has-border-color has-accent-4-border-color wp-image-34608\" height=\"700\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/05/image-block-enlarge-on-click.png?resize=625%2C700&#038;ssl=1\" style=\"border-width: 1px;\" width=\"625\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Link submenu showing “Enlarge on click” option for Image block.</figcaption></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img alt=\"Site editor showing showing the Featured Image block selected, bit without there being a Link button in the block toolbar. The block sidebar is expanded to show a single setting available: &quot;Link to Post&quot;.\" class=\"has-border-color has-accent-4-border-color wp-image-34609\" height=\"500\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/05/featured-image-block-block-sidebar.png?resize=700%2C500&#038;ssl=1\" style=\"border-width: 1px;\" width=\"700\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Block toolbar missing Link button but showing “Link to Post” setting in the block sidebar for the Featured Image block.</figcaption></figure>\n</div>\n</div>\n\n\n\n<p>There is also an open Gutenberg issue to add this lightbox capability to the Featured Image block (<a href=\"https://github.com/WordPress/gutenberg/issues/57849\" title=\"Featured Image block: Lightbox / Expand use case \">#57849</a>).</p>\n\n\n\n<p>Because I want these features now before they get implemented in Gutenberg, I&#8217;ve put together a couple plugins (on GitHub) that extend the Featured Image block with these missing capabilities:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/westonruter/featured-image-block-with-caption\">Featured Image Block with Caption</a></li>\n\n\n\n<li><a href=\"https://github.com/westonruter/featured-image-block-with-lightbox\">Featured Image Block with Lightbox</a></li>\n</ul>\n\n\n\n<p>These are active on this site, so you can see above how the featured image is enhanced with a caption and lightbox.</p>\n\n\n\n<p>While the Gutenberg issue for adding a caption has a <a href=\"https://github.com/WordPress/gutenberg/issues/40946#issuecomment-1682973710\">workaround</a> involving the registration of a new block variation, I wanted there to be the same &#8220;Add caption&#8221; block toolbar button which is available on the Image block, and I wanted to be able to see a placeholder for how the caption would look in the Site Editor. So this is what I implemented:</p>\n\n\n\n<div class=\"wp-block-columns alignwide is-not-stacked-on-mobile is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img alt=\"Site Editor showing the Featured Image block selected and a new &quot;Add caption&quot; button appearing in the toolbar.\" class=\"has-border-color has-accent-4-border-color wp-image-34613\" height=\"700\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/05/featured-image-block-with-add-caption-button.png?resize=636%2C700&#038;ssl=1\" style=\"border-width: 1px;\" width=\"636\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Featured Image block in the Site Editor with an “Add caption” button appearing in the block toolbar. </figcaption></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img alt=\"Site Editor showing the Featured Image block selected and the &quot;Add caption&quot; button being selected in the block toolbar. A placeholder caption appears below the image.\" class=\"has-border-color has-accent-4-border-color wp-image-34614\" height=\"700\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/05/featured-image-block-with-caption-placeholder-shown.png?resize=636%2C700&#038;ssl=1\" style=\"border-width: 1px;\" width=\"636\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Caption placeholder appearing in Featured Image block in the Site Editor.</figcaption></figure>\n</div>\n</div>\n\n\n\n<p>Selecting “Add caption” sets a new <code>showCaption</code> block attribute to <code>true</code>, without making any changes to the block markup. This means there won&#8217;t be any block validation errors when the plugin is deactivated. When the block attribute is present, a <code>render_block</code> filter in PHP injects the caption into the block&#8217;s markup on the frontend. On my site, I edited the Single template to show the caption in the Featured Image block, but I left the caption off for the block on the Home template in order to keep the blog index clean. Editing the text of a Featured Image block&#8217;s caption is not done inline in the block editor as is done with the Image block; instead, editing the featured image caption requires either selecting the image in the Media Library in the post editor, opening the image in the <a href=\"https://wordpress.org/documentation/article/media-library-screen/#attachment-details\">Media Library screen</a>, or opening it in the seldom-accessed <a href=\"https://wordpress.org/documentation/article/edit-media/\">Edit Media screen</a>.</p>\n\n\n\n<p>The plugin to implement a lightbox for the Featured Image block is much simpler, and there is no UI. There&#8217;s simply another <code>render_block</code> filter which checks to see if the “Link to Post” setting is enabled, and if not, then it enables the “enlarge on click” functionality. Normally the “Link to Post” setting is not enabled on the Single template, allowing the featured image to open in a lightbox the same as any other Image block which have lightbox enabled. The implementation was trivial because all it needed to do is enqueue the same script module and stylesheet as the Image block does, and then it passes the block content into the same <a href=\"https://github.com/WordPress/wordpress-develop/blob/6.8.1/src/wp-includes/blocks/image.php#L128-L248\">function</a> used by the Image block. In the end, the Featured Image block&#8217;s markup looks very similar to the Image block&#8217;s markup:</p>\n\n\n<pre class=\"wp-block-code alignwide has-small-font-size\"><span><code class=\"hljs language-diff\"><span class=\"hljs-comment\">--- image-block.html</span>\n<span class=\"hljs-comment\">+++ featured-image-block.html</span>\n<span class=\"hljs-meta\">@@ -1,11 +1,12 @@</span>\n &lt;figure\n 	data-wp-context=\'{\"imageId\":\"68293cf73baf0\"}\'\n 	data-wp-interactive=\"core/image\"\n<span class=\"hljs-deletion\">-	class=\"wp-block-image size-full wp-lightbox-container\"</span>\n<span class=\"hljs-addition\">+	style=\"aspect-ratio: auto\"</span>\n<span class=\"hljs-addition\">+	class=\"wp-block-post-featured-image wp-lightbox-container\"</span>\n &gt;\n 	&lt;img\n 		alt=\"\"\n<span class=\"hljs-deletion\">-		class=\"wp-image-8\"</span>\n<span class=\"hljs-addition\">+		class=\"attachment-post-thumbnail size-post-thumbnail wp-post-image\"</span>\n 		data-wp-class--hide=\"state.isContentHidden\"\n 		data-wp-class--show=\"state.isContentVisible\"\n 		data-wp-init=\"callbacks.setButtonStyles\"\n<span class=\"hljs-meta\">@@ -25,6 +26,7 @@</span>\n 			http://localhost:10013/wp-content/uploads/2025/05/American_bison_k5680-1-1536x1002.jpg 1536w,\n 			http://localhost:10013/wp-content/uploads/2025/05/American_bison_k5680-1-2048x1336.jpg 2048w\n 		\"\n<span class=\"hljs-addition\">+		style=\"width: 100%; height: 100%; object-fit: cover\"</span>\n 		width=\"2560\"\n 	/&gt;&lt;button\n 		class=\"lightbox-trigger\"</code></span></pre>\n\n\n<p>Ultimately, I <a href=\"https://github.com/WordPress/gutenberg/issues/57849#issuecomment-2704434044\">think</a> the Featured Image block could be deprecated in favor of adding a “Use featured image” source to the Image block. This would allow all of its features to be re-used in a featured image context. I suppose “Link to Post” would have to be added as one of the Link options when the featured image is used as the source.</p>\n\n\n\n<p>I hope this is helpful for you with building sites with block themes while waiting for these features to land in the core Featured Image block!</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p>Where I&#8217;ve shared this:</p>\n\n\n\n<ul class=\"wp-block-social-links is-layout-flex wp-block-social-links-is-layout-flex\"><li class=\"wp-social-link wp-social-link-bluesky  wp-block-social-link\"><a class=\"wp-block-social-link-anchor\" href=\"https://bsky.app/profile/weston.ruter.net/post/3lpg5cfpvj22d\"><svg height=\"24\" version=\"1.1\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M6.3,4.2c2.3,1.7,4.8,5.3,5.7,7.2.9-1.9,3.4-5.4,5.7-7.2,1.7-1.3,4.3-2.2,4.3.9s-.4,5.2-.6,5.9c-.7,2.6-3.3,3.2-5.6,2.8,4,.7,5.1,3,2.9,5.3-5,5.2-6.7-2.8-6.7-2.8,0,0-1.7,8-6.7,2.8-2.2-2.3-1.2-4.6,2.9-5.3-2.3.4-4.9-.3-5.6-2.8-.2-.7-.6-5.3-.6-5.9,0-3.1,2.7-2.1,4.3-.9h0Z\"></path></svg><span class=\"wp-block-social-link-label screen-reader-text\">Bluesky</span></a></li>\n\n<li class=\"wp-social-link wp-social-link-linkedin  wp-block-social-link\"><a class=\"wp-block-social-link-anchor\" href=\"https://www.linkedin.com/posts/westonruter_adding-caption-lightbox-to-the-featured-activity-7329712341493698561-3GQE\"><svg height=\"24\" version=\"1.1\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M19.7,3H4.3C3.582,3,3,3.582,3,4.3v15.4C3,20.418,3.582,21,4.3,21h15.4c0.718,0,1.3-0.582,1.3-1.3V4.3 C21,3.582,20.418,3,19.7,3z M8.339,18.338H5.667v-8.59h2.672V18.338z M7.004,8.574c-0.857,0-1.549-0.694-1.549-1.548 c0-0.855,0.691-1.548,1.549-1.548c0.854,0,1.547,0.694,1.547,1.548C8.551,7.881,7.858,8.574,7.004,8.574z M18.339,18.338h-2.669 v-4.177c0-0.996-0.017-2.278-1.387-2.278c-1.389,0-1.601,1.086-1.601,2.206v4.249h-2.667v-8.59h2.559v1.174h0.037 c0.356-0.675,1.227-1.387,2.526-1.387c2.703,0,3.203,1.779,3.203,4.092V18.338z\"></path></svg><span class=\"wp-block-social-link-label screen-reader-text\">LinkedIn</span></a></li>\n\n<li class=\"wp-social-link wp-social-link-twitter  wp-block-social-link\"><a class=\"wp-block-social-link-anchor\" href=\"https://x.com/westonruter/status/1923947578217071045\"><svg height=\"24\" version=\"1.1\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M22.23,5.924c-0.736,0.326-1.527,0.547-2.357,0.646c0.847-0.508,1.498-1.312,1.804-2.27 c-0.793,0.47-1.671,0.812-2.606,0.996C18.324,4.498,17.257,4,16.077,4c-2.266,0-4.103,1.837-4.103,4.103 c0,0.322,0.036,0.635,0.106,0.935C8.67,8.867,5.647,7.234,3.623,4.751C3.27,5.357,3.067,6.062,3.067,6.814 c0,1.424,0.724,2.679,1.825,3.415c-0.673-0.021-1.305-0.206-1.859-0.513c0,0.017,0,0.034,0,0.052c0,1.988,1.414,3.647,3.292,4.023 c-0.344,0.094-0.707,0.144-1.081,0.144c-0.264,0-0.521-0.026-0.772-0.074c0.522,1.63,2.038,2.816,3.833,2.85 c-1.404,1.1-3.174,1.756-5.096,1.756c-0.331,0-0.658-0.019-0.979-0.057c1.816,1.164,3.973,1.843,6.29,1.843 c7.547,0,11.675-6.252,11.675-11.675c0-0.178-0.004-0.355-0.012-0.531C20.985,7.47,21.68,6.747,22.23,5.924z\"></path></svg><span class=\"wp-block-social-link-label screen-reader-text\">Twitter</span></a></li>\n\n<li class=\"wp-social-link wp-social-link-mastodon  wp-block-social-link\"><a class=\"wp-block-social-link-anchor\" href=\"https://mastodon.social/@westonruter/114526760610405491\"><svg height=\"24\" version=\"1.1\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M23.193 7.879c0-5.206-3.411-6.732-3.411-6.732C18.062.357 15.108.025 12.041 0h-.076c-3.068.025-6.02.357-7.74 1.147 0 0-3.411 1.526-3.411 6.732 0 1.192-.023 2.618.015 4.129.124 5.092.934 10.109 5.641 11.355 2.17.574 4.034.695 5.535.612 2.722-.15 4.25-.972 4.25-.972l-.09-1.975s-1.945.613-4.129.539c-2.165-.074-4.449-.233-4.799-2.891a5.499 5.499 0 0 1-.048-.745s2.125.52 4.817.643c1.646.075 3.19-.097 4.758-.283 3.007-.359 5.625-2.212 5.954-3.905.517-2.665.475-6.507.475-6.507zm-4.024 6.709h-2.497V8.469c0-1.29-.543-1.944-1.628-1.944-1.2 0-1.802.776-1.802 2.312v3.349h-2.483v-3.35c0-1.536-.602-2.312-1.802-2.312-1.085 0-1.628.655-1.628 1.944v6.119H4.832V8.284c0-1.289.328-2.313.987-3.07.68-.758 1.569-1.146 2.674-1.146 1.278 0 2.246.491 2.886 1.474L12 6.585l.622-1.043c.64-.983 1.608-1.474 2.886-1.474 1.104 0 1.994.388 2.674 1.146.658.757.986 1.781.986 3.07v6.304z\"></svg><span class=\"wp-block-social-link-label screen-reader-text\">Mastodon</span></a></li></ul>\n<p>The post <a href=\"https://weston.ruter.net/2025/05/17/adding-caption-and-lightbox-to-the-featured-image-block/\">Adding Caption &amp; Lightbox to the Featured Image Block</a> appeared first on <a href=\"https://weston.ruter.net\">Weston Ruter</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 18 May 2025 03:28:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Weston Ruter\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"Gutenberg Times: 14 plugins for the block editor, Gutenberg 20.8, Studio 1.15.1, Woo 9.9 and more — Weekend Edition 330\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=40398\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"https://gutenbergtimes.com/14-plugins-for-the-block-editor-gutenberg-20-8-studio-1-15-1-woo-9-9-and-more-weekend-edition-330/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:27364:\"<p>Hi there,</p>\n\n\n\n<p>This weekend I am at WordCamp Leipzig and spent Friday night and Saturday with about 70 WordPressers from the German community. It&#8217;s my third year attending this small, low-key WordCamp. This year, it had way more session submissions than speaker slots, and it sold out tickets with a waiting list. Congratulations to the organizing team. <img alt=\"🎉\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f389.png\" style=\"height: 1em;\" /> </p>\n\n\n\n<p>With the European Accessibility Act (EAA) set to take effect on June 28, 2025, the selection of three talks focused on accessibility is both timely and highly relevant-making them especially interesting to me. I am also looking forward to Hans-Gerd Gerhard&#8217;s walk through practical examples for block theme implementations. Talks on site performance, e-commerce, error handling and UX for Gen Z round up the <a href=\"https://leipzig.wordcamp.org/2025/zeitplan/\">session schedule</a>. Although it&#8217;s a low-key WordCamp the video team is amazing. The sessions will be recorded and uploaded to WordPressTV the same or the following day. Session are in German, though. </p>\n\n\n\n<p>Save the Date for <a href=\"https://us.wordcamp.org/2025/\">WordCamp US</a>! It&#8217;ll take place from August 26 to August 29. 2025. The call for speakers and sponsors will come out on May 19, 2025, so keep an eye out. If all goes well, I will return to WordCamp US after three years, to finally see my WordPress friends from a previous life again. <img alt=\"🎉\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f389.png\" style=\"height: 1em;\" /> Will I  see you in Portland, OR, too? </p>\n\n\n\n<p>I could call today&#8217;s newsletter, <em>The Plugin Edition</em>, as it mentions 14 plugins that will help with content creation, making a visual impact and organizing your site. It&#8217;s actually 16 plugins if you count Gutenberg and WooCommerce as well. Have fun browsing, and please hit reply if you have any opinion or other plugins to mention. Listing those plugins here doesn&#8217;t mean I recommend them, you would need to test them for yourself. I just wanted to surface them as it&#8217;s a bit difficult to find new plugins in the WordPress repository.</p>\n\n\n\n<p>Have a lovely weekend! </p>\n\n\n\n<p>Yours, <img alt=\"💕\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f495.png\" style=\"height: 1em;\" /><br /><em>Birgit</em></p>\n\n\n\n\n<section class=\"wp-block-newsletterglue-group\" style=\"padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;\">\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<nav class=\"wp-block-table-of-contents\"><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/14-plugins-for-the-block-editor-gutenberg-20-8-studio-1-15-1-woo-9-9-and-more-weekend-edition-330/#0-word-press-release-information\">Developing Gutenberg and WordPress</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/14-plugins-for-the-block-editor-gutenberg-20-8-studio-1-15-1-woo-9-9-and-more-weekend-edition-330/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/14-plugins-for-the-block-editor-gutenberg-20-8-studio-1-15-1-woo-9-9-and-more-weekend-edition-330/#more-single-blocks-and-block-collections-from-the-wordpress-plugin-repository\">More single blocks and block collections from the WordPress plugin repository</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/14-plugins-for-the-block-editor-gutenberg-20-8-studio-1-15-1-woo-9-9-and-more-weekend-edition-330/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor.</a></li></ol></nav>\n</div></div>\n</section>\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p><strong>George Mamadashvili</strong> released <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v20.8.0\"><strong>Gutenberg 20.8</strong></a> on May 14, 2025. Here are the features, Ellen Bauer and I discussed on the podcast episode&#8221;</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Create block package: added flag for text domain during scaffolding. (<a href=\"https://github.com/WordPress/gutenberg/pull/69802\">69802</a>)</li>\n\n\n\n<li>Guide component customization: next and previous button text. (<a href=\"https://github.com/WordPress/gutenberg/pull/69907\">69907</a>)</li>\n\n\n\n<li>Search functionality for page templates and patterns. (<a href=\"https://github.com/WordPress/gutenberg/pull/69667\">69667</a>)</li>\n\n\n\n<li>Meta box fixes and widget editor locking. (<a href=\"https://github.com/WordPress/gutenberg/pull/69958\">69958</a>)(<a href=\"https://github.com/WordPress/gutenberg/pull/69984\">69984</a>)</li>\n\n\n\n<li>Ability to edit HTML for invalid blocks.(<a href=\"https://github.com/WordPress/gutenberg/pull/69902\">69902</a>)</li>\n\n\n\n<li>Spacer block update preventing negative width in row blocks.(<a href=\"https://github.com/WordPress/gutenberg/pull/68845\">68845</a>)</li>\n\n\n\n<li>Box sizing property updates to prevent design overflow.(<a href=\"https://github.com/WordPress/gutenberg/pull/70014\">70014</a>)</li>\n\n\n\n<li>Block bindings API documentation improvements and limitations.(<a href=\"https://github.com/WordPress/gutenberg/pull/68583\">68583</a>)</li>\n\n\n\n<li>Block Styles:  add copy and code for style_data to documentation (<a href=\"https://github.com/WordPress/gutenberg/pull/69920\">69920</a>)</li>\n</ul>\n\n\n\n<p>The changelog is <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v20.8.0\">available on the GitHub repo</a>. </p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p><img alt=\"🎙\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f399.png\" style=\"height: 1em;\" /> The latest episode <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-117-woocommerce-starter-theme-and-blocks/\">Gutenberg Changelog 117 – WooCommerce Starter Theme and Blocks, WordCamp Europe, and Gutenberg 20.7 and 20.8</a> I sat down with Ellen Bauer, WooCommerce product lead and discussed what she is working on, WordCamp Europe, Create Block Theme, WP-CLI, Gutenberg 20.7 and Gutenberg 20.8 releases. </p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img alt=\"Ellen Bauer and Birgit Pauli-Haack recording Gutenberg Changelog 117\" class=\"wp-image-40375\" height=\"184\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2022/03/Screenshot-2025-05-10-at-12.16.57.png?resize=652%2C184&#038;ssl=1\" width=\"652\" /></figure>\n</div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p><strong>Mike McAlister</strong> announced <a href=\"https://olliewp.com/the-future-of-wordpress-site-building-starts-with-ollie-pro-2-0/\"><strong>the release of Ollie Pro 2.0</strong></a>. The update introduces a redesigned dashboard, a setup wizard to streamline site configuration, and starter sites, with which users could launch a complete website fast. For developers, a child theme creator is included to enable safe code customizations. The release also expands the pattern library with hundreds of professionally designed layouts and styles, all accessible through an improved pattern browser. </p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"\" class=\"wp-image-40453\" height=\"373\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/05/Screenshot-2025-05-12-at-9.11.42%E2%80%AFAM-1536x879-1.webp?resize=652%2C373&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<p><strong>Michael Pretty</strong>, code wrangler at WooCommerce, recently shared some great news: <a href=\"https://developer.woocommerce.com/2025/05/13/woocommerce-9-9-will-deliver-massive-admin-performance-gains/\"><strong>WooCommerce 9.9 will bring significant admin performance improvements.</strong></a> In his post, he outlined the key factors and changes behind faster admin screen rendering and quicker action execution for Woo merchants. These updates promise a noticeably smoother and more efficient experience when managing your store. You can start testing the with the <a href=\"https://developer.woocommerce.com/2025/05/12/woocommerce-9-9-pre-release-updates/\">Woo 9.9 Beta version</a>. WooCommerce 9.9 is scheduled for release on June 2, 2025, just before WordCamp Europe. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>If you often write tutorials with code examples, you need to check out the <strong><a href=\"https://code-block-pro.com/\">Code</a><a href=\"https://wordpress.org/plugins/code-block-pro/\"> Block Pro</a></strong> plugin by <strong>Kevin Batdorf</strong>. You can make your code look as beautiful as the rest of your site. The plugin offers dozens of different themes, and specific syntax highlighting for hundreds of programming languages. If you feel the code section gets too long with the “Click to see more” feature, you can collapse code blocks at any line, letting visitors expand only what they need. Also, very handy are line highlighting and blurring of surrounding code, which helps readers to quickly recognize the code section that you want them to focus on. I’ve only scratched the surface of what Code Block Pro can do in my own posts. You can get the plugin <a href=\"https://wordpress.org/plugins/code-block-pro/\">from the WordPress repository</a>.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/#second-task-update-theme-json\"><img alt=\"\" class=\"wp-image-40456\" height=\"368\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/05/Screenshot-2025-05-15-at-15.03.42.png?resize=652%2C368&#038;ssl=1\" width=\"652\" /></a><figcaption class=\"wp-element-caption\"><a href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/#second-task-update-theme-json\">Screenshot from my post on Block Theme building.</a> </figcaption></figure>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In her latest tutorial, <strong>Anne Katzeff </strong>explored <a href=\"https://www.askdesign.biz/blog/2025/05/layout-and-design-with-row-and-stack-blocks/\"><strong>how the Row and Stack blocks expand the layout and design</strong></a> possibilities for your site. She discusses all the different settings, and styles options for these Group block variations.  </p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"Screenshot from Anne Katzeff\'s tutorial with her amazing art! \" class=\"wp-image-40481\" height=\"390\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/05/Screenshot-2025-05-16-at-14.10.48.png?resize=652%2C390&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Hans-Gerd Gerhards</strong> introduced his <strong><a href=\"https://haurand.com/plugin-shrinking-logo-sticky-header/\">&#8220;Plugin Shrinking Logo Sticky Header”</a></strong>. The plugin lets you &#8220;add a modern sticky header with smooth, animated shrinking effects for both the header and the site logo.&#8221; You have full control over the heights for default and shrunken states and also use your site&#8217;s colors for styling. The post also entails the link for downloads videos and screenshots. The plugin in in the approval queue for the WordPress directory. </p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"more-single-blocks-and-block-collections-from-the-wordpress-plugin-repository\">More single blocks and block collections from the WordPress plugin repository</h3>\n\n\n\n<p>I am amazed at the creativity of plugin authors to always find missing features to add to WordPress. Some even you didn&#8217;t know you were missing. <img alt=\"🧐\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f9d0.png\" style=\"height: 1em;\" /> Over the last few days,  I found several single blocks and block collections in my RSS Feeds.  I have not tested them.  Use at your own risk. If you do try some, please let me know how it went. <a href=\"mailto:pauli@gutenbergtimes.com\">Email me. </a></p>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/nasio-blocks/\"><strong>Nasio Blocks</strong></a>  by <strong>Nasio Themes</strong> &#8211; A newcomer on the WordPress repository. Welcome to the WordPress space! <img alt=\"👋\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f44b.png\" style=\"height: 1em;\" /> &#8220;Post slider, Content slider, Gallery slider, Accordion and Icon blocks. Features a template library with predefined demo content (block patterns) to speed up the page creation process.&#8221; so they say. </p>\n\n\n\n<p><strong><a href=\"https://wordpress.org/plugins/flipbox-block/\">Flipbox Block</a> by <a href=\"https://gutenbergkits.com/\">GutenbergKits</a></strong> &#8220;Flip box Block &#8211;  &#8220;A flip box is an interactive UI element that flips between two sections on hover or click.&#8221; and &#8220;You can create unlimited design possibilities&#8221;. I remember when I build such a flip box w/ vanilla JavaScript in a static HTML page for a memory game some time in the early 2000s. Now I just can install a block for it.</p>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/photo-block/\"><strong>Photo Block</strong></a> by <a href=\"https://x.com/ronaldhuereca\"><strong>Ronald Huereca</strong></a>, in his 20th year of his WordPress.org account. <img alt=\"🎉\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f389.png\" style=\"height: 1em;\" /> He built into it advanced image customization, full caption support, responsive styling, and global styles. Alone from the screenshots on the plugin page I feel a bit overwhelmed with the vast number of customizations.You&#8217;ll find a ton of filters, too. To see it in action, you can <a href=\"https://app.instawp.io/launch?t=photo-block&amp;d=v2\">spin up a demo site</a></p>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/pibe-parallax-image-block-and-effects/\"><strong>PIBE – Parallax Image Block and Effects</strong></a> by <strong>Emiliano Lorenzi,</strong> also a newcomer to the space! Welcome to you, too! <img alt=\"👋\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f44b.png\" style=\"height: 1em;\" /> His plugin &#8220;allows you to add modern, animated images to your site, whether you want to add depth with parallax, capture your visitors’ attention with hover transitions, or highlight content with stylish overlays.</p>\n\n\n\n<p><strong>Bhargav (Bunty) Bhandari,</strong> WordPress developer author of the <a href=\"https://wordpress.org/plugins/thread-block/\">Thread</a> and <a href=\"https://wordpress.org/plugins/polls-block/\">Polls</a> blocks, has released a new plugin called: <strong><a href=\"https://wordpress.org/plugins/explicit-media-block/\">Explicit Media Block</a></strong>. This block is an image/media block public likes and shareable links, turning your site into an interactive content hub, Instagram like as you so will.</p>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/primekit-blocks/\"><strong>Primekit Blocks</strong></a> by <strong>SupreoX Limited</strong> with contains three blocks. The most intriguing would be for me the Animated Text Block to show for animated text effects for your headings and content. The other two are Call to Action (CTA) block and a Copyright block. </p>\n\n\n\n<p><strong><a href=\"https://wordpress.org/plugins/groundworx-carousel/\">Groundworx Carousel</a></strong> by <a href=\"https://x.com/groundworxdev\"><strong>Johanne Courtright</strong></a>, a longtime WordPress developer and freelancer from the US, published her first plugin in the repository. With the carousel, built with native core blocks,  you can display slides with any inner blocks. Using the Splide.js library it supports responsive options, breakpoint-based layouts, and advanced design controls. On GitHub, Courtright also provides <a href=\"https://github.com/groundworx-dev/groundworx-carousel#example-variations\">instructions and code examples</a> on how to extend the plugin to fit any site&#8217;s needs. </p>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/better-navigation-block-styles/\"><strong>Better Navigation Block Styles</strong></a> by <a href=\"https://x.com/marctv\"><strong>Marc Tönsing</strong></a>. Tönsing aims to refine the native mobile menu with to ensure better spacing, alignment, and readability by injecting Additional CSS. </p>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/ghostlabs-cycle-block-lite/\"><strong>Cycle Block: Lite</strong></a> by <b>Ghos</b><strong>t Labs</strong>, also a newcomer to the WordPress repository, Welcome! <img alt=\"🎉\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f389.png\" style=\"height: 1em;\" /> The team&#8217;s first plugin enables user to display different content for each page load. You can rotate headlines, and create randomized call-to-actions. The description and screenshot offer more use cases where this plugin might be helpful.  On their website you find a few more plugins: City blocks for location-based content and Ghostwriter block, using AI for content creation. </p>\n\n\n\n<p><strong><a href=\"https://wordpress.org/plugins/wpmozo-blocks-and-addons/\">WPMozo Blocks and Addons</a></strong> by <a href=\"https://elicus.com/about-us/\"><strong>Elicus</strong></a> provides plenty of Custom blocks to use, a few sliders, a flip box, tilt image, before-and-after comparisons block. You can see it all in action on <a href=\"https://wpmozoblocks.com/\">the demo site.</a> I found the <a href=\"https://wpmozoblocks.com/interactive-image-card/\">interactive image card</a> to be quite interesting. The <a href=\"https://wpmozoblocks.com/separator/\">Separator block</a> is probably one I would use if I had to spruce up a wall of text or so. </p>\n\n\n\n<p>Which reminds me: On the WordPress Developer blog, <strong>Justin Tadlock</strong> wrote a tutorial about <a href=\"https://developer.wordpress.org/news/2023/07/beyond-block-styles-part-2-building-a-custom-style-for-the-separator-block/\"><strong>Building a custom style for the Separator block</strong></a>, just in case you are tempted to get into block style building without creating a Custom block. </p>\n\n\n\n<p>That&#8217;s it for now. Please keep in mind that I don&#8217;t have any aspiration to be comprehensive when curating plugins. I would also be delighted, if you want to <a href=\"mailto:pauli@gutenbergtimes.com\">email me</a> asking me to check out your plugin. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n<section class=\"wp-block-newsletterglue-callout undefined not-color-set\" style=\"border-color: #f9f9e5; border-radius: 22px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f9f9e5;\">\n<p><strong> <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" rel=\"noreferrer noopener\" target=\"_blank\">&#8220;Keeping up with Gutenberg &#8211; Index 2025&#8221;</a> </strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. The previous years are also available: <strong><strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">2020</a> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/\">2021</a></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/\">2022</a></strong></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023\">2023</a></strong> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2024/\"><strong>2024</strong></a></p>\n</section>\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor.</h2>\n\n\n\n<p><strong>Felix Arntz,</strong> a developer at Google and the author of the <a href=\"https://wordpress.org/plugins/ai-services/\">AI services plugin</a>, has authored a tutorial detailing the process by which individuals can utilize this plugin to create artificial intelligence tools, such as <a href=\"https://felix-arntz.me/blog/writing-a-wordpress-plugin-to-generate-image-alt-text-with-ai-services/#more-1987\">an image alt text generator</a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><a href=\"https://bsky.app/profile/2ndkauboy.bsky.social\"><strong>Bernhard Kau</strong></a> published a tutorial on <a href=\"https://kau-boys.com/4107/wordpress/adding-a-custom-panel-to-query-monitor\"><strong>how to add a custom panel to Query Monitor</strong></a>. Query Monitor should be in every WordPress developer toolbox, and how to customize it is a very useful skill to have. <br /></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p class=\"has-small-font-size\">In last week&#8217;s live stream, <strong>Jonathan Bossenger</strong> explored <a href=\"https://www.youtube.com/watch?v=AwxE-R7OsVU\"> how to use the Feature API</a>. He figured out how to hook up Woo&#8217;s LMS, Sensei and register its lessons as tools. Then he instructed an AI agent to create a lesson from a markdown file. </p>\n\n\n\n<p class=\"has-normal-font-size\">Automattic introduced a<a href=\"https://github.com/Automattic/wp-feature-api\"> new Feature API</a> for WordPress. It allows AI agent tools to interact with sites in more structured ways—unlocking new possibilities for plugins and automation.</p>\n\n\n\n<p class=\"has-small-font-size\"><strong>Jamie Marsland</strong> posted on LinkedIn, why that&#8217;s important: <a href=\"https://www.linkedin.com/pulse/wordpress-sitting-goldmine-feature-api-just-dug-first-jamie-marsland-3sije/?trackingId=qVLCTVZZSniPqxIiHZRpdQ%3D%3D\"><strong>WordPress Is Sitting on a Goldmine — And the Feature API Just Dug the First Tunnel</strong></a></p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Nick Diego</strong> has tested the latest Studio v 1.5.1, the new local development app by WordPress.com, release and wrote a tutorial on how to use the new features: <a href=\"https://wordpress.com/blog/2025/05/12/preferences-studio/\"><strong>Customize Your WordPress Development Workflow: New Preferences in Studio</strong></a>. I made Studio my only local development tool installed.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n<section class=\"wp-block-newsletterglue-callout undefined not-color-set\" style=\"border-color: #eeeeee; border-radius: 26px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f3efe9;\">\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. </p>\n\n\n\n<p>Now also available via <a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href=\"mailto:pauli@gutenbergtimes.com\">Email me </a>with your experience</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n</section>\n\n\n<p class=\"has-text-align-center has-small-font-size\"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, <br />send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n<section class=\"wp-block-newsletterglue-group\" style=\"padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;\">\n<p>Featured Image: Photo by Fran Jacquier on Unsplash</p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n<form action=\"https://gutenbergtimes.com/feed/\" autocomplete=\"on\" class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\" style=\"margin-bottom: 25px;\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input autocomplete=\"email\" class=\"ngl-form-input-text\" id=\"ngl_email\" name=\"ngl_email\" required=\"required\" style=\"border-radius: 21px;\" type=\"email\" /></div></div><button class=\"ngl-form-button\" style=\"background-color: #005075; border-color: #005075; border-width: 1px; border-style: solid; color: #ffffff; border-radius: 21px;\" type=\"submit\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too, and won&#8217;t give your email address to anyone <br />except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"><svg fill=\"none\" height=\"24\" stroke=\"#fff\" stroke-width=\"2\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><polyline points=\"20 6 9 17 4 12\"></polyline></svg></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input id=\"ngl_list_id\" name=\"ngl_list_id\" type=\"hidden\" value=\"26f81bd8ae\" /><input id=\"ngl_double_optin\" name=\"ngl_double_optin\" type=\"hidden\" value=\"yes\" /></form>\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n</section>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 17 May 2025 05:55:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"Do The Woo Community: Why Contributor Day in Basel is a Must-Do\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://openchannels.fm/?post_type=blog&p=96961\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://openchannels.fm/why-contributor-day-in-basel-is-a-must-do/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:168:\"Contributor Day at WordCamp Europe 2025 is a community event on June 5th in Basel, Switzerland, encouraging contributions to the WordPress project for all skill levels.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 16 May 2025 07:41:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Bob Dunn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"Matt: Jony Ive &amp;amp; Patrick Collison\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=142505\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://ma.tt/2025/05/jony-ive/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:233:\"<p>A really beautiful interview.</p>\n\n\n\n<figure class=\"wp-block-embed alignwide is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 16 May 2025 00:08:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"Do The Woo Community: Lessons Learned From 15 Years of Building Complex WooCommerce Sites with Matt Schwartz\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://openchannels.fm/?p=96975\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"https://openchannels.fm/lessons-learned-from-15-years-of-building-complex-woocommerce-sites-with-matt-schwartz/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:241:\"In Woo AgencyChat, host Robert Jacobi chats with Matt Schwartz from Inspry about their journeys in WordPress, WooCommerce insights, lessons in agency growth, and the importance of educating clients on Woo\'s capabilities and responsibilities.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 15 May 2025 08:57:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Bob Dunn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"Weston Ruter: A Decade as a Core Committer: My WordPress Contribution History\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://weston.ruter.net/?p=34264\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"https://weston.ruter.net/2025/05/14/a-decade-as-a-core-committer-my-wordpress-contribution-history/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:24390:\"<p><strong>Next Tuesday is my 10-year anniversary of <a href=\"https://make.wordpress.org/core/2015/05/20/new-committers-for-4-3/\">becoming a WordPress core committer</a> back on May 20, 2015.</strong></p>\n\n\n\n<p>This post is somewhat of a résumé for my contributions to the WordPress project. I <a href=\"https://weston.ruter.net/2018/09/19/becoming-a-googler/\">joined Google</a> in 2018 to work full time on WordPress. After 6½ years, my sponsored contributor position there has been eliminated. I&#8217;m hoping to continue contributing the majority of my time to WordPress at another company that also cares for the health of the open web and the democratization of publishing.</p>\n\n\n\n<p>Thanks to Peter Wilson for his useful <a href=\"https://peterwilson.cc/wordpress-contribution-history/\">WordPress Core Contribution History</a> tool, I used it to <a href=\"https://peterwilson.cc/wordpress-contribution-history/?wp-credit-history-username=westonruter\">look up my contribution history</a>:</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>@westonruter is a core contributor to 32 WordPress releases </p>\n</blockquote>\n\n\n\n<details class=\"wp-block-details is-layout-flow wp-block-details-is-layout-flow\">Full contribution history credits table\n<p class=\"has-small-font-size\">Note that Peter told me that the Credits API only goes back to WordPress 3.2, so that&#8217;s why it&#8217;s the first release listed. I&#8217;ve omitted the empty rows from 3.2 to 3.6 in which I wasn&#8217;t listed in the credits.</p>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><thead><tr><th class=\"has-text-align-left\">Version</th><th class=\"has-text-align-left\">Title</th></tr></thead><tbody><tr><td class=\"has-text-align-left\">3.7</td><td class=\"has-text-align-left\">Core Contributor</td></tr><tr><td class=\"has-text-align-left\">3.8</td><td class=\"has-text-align-left\">Core Contributor</td></tr><tr><td class=\"has-text-align-left\">3.9</td><td class=\"has-text-align-left\">Contributing Developer</td></tr><tr><td class=\"has-text-align-left\">4.0</td><td class=\"has-text-align-left\">Contributing Developer</td></tr><tr><td class=\"has-text-align-left\">4.1</td><td class=\"has-text-align-left\">Contributing Developer</td></tr><tr><td class=\"has-text-align-left\">4.2</td><td class=\"has-text-align-left\">Contributing Developer</td></tr><tr><td class=\"has-text-align-left\">4.3</td><td class=\"has-text-align-left\">Contributing Developer</td></tr><tr><td class=\"has-text-align-left\">4.4</td><td class=\"has-text-align-left\">Contributing Developer</td></tr><tr><td class=\"has-text-align-left\">4.5</td><td class=\"has-text-align-left\">Contributing Developer</td></tr><tr><td class=\"has-text-align-left\">4.6</td><td class=\"has-text-align-left\">Core Developer</td></tr><tr><td class=\"has-text-align-left\">4.7</td><td class=\"has-text-align-left\">Core Developer</td></tr><tr><td class=\"has-text-align-left\">4.8</td><td class=\"has-text-align-left\">Core Developer</td></tr><tr><td class=\"has-text-align-left\">4.9</td><td class=\"has-text-align-left\">Release Lead</td></tr><tr><td class=\"has-text-align-left\">5.0</td><td class=\"has-text-align-left\">Core Contributor</td></tr><tr><td class=\"has-text-align-left\">5.1</td><td class=\"has-text-align-left\">Core Contributor</td></tr><tr><td class=\"has-text-align-left\">5.2</td><td class=\"has-text-align-left\">Core Contributor</td></tr><tr><td class=\"has-text-align-left\">5.3</td><td class=\"has-text-align-left\">Core Contributor</td></tr><tr><td class=\"has-text-align-left\">5.4</td><td class=\"has-text-align-left\">Core Contributor</td></tr><tr><td class=\"has-text-align-left\">5.5</td><td class=\"has-text-align-left\">Core Contributor</td></tr><tr><td class=\"has-text-align-left\">5.6</td><td class=\"has-text-align-left\">Core Contributor</td></tr><tr><td class=\"has-text-align-left\">5.7</td><td class=\"has-text-align-left\">Core Contributor</td></tr><tr><td class=\"has-text-align-left\">5.8</td><td class=\"has-text-align-left\">Core Contributor</td></tr><tr><td class=\"has-text-align-left\">5.9</td><td class=\"has-text-align-left\">Core Contributor</td></tr><tr><td class=\"has-text-align-left\">6.0</td><td class=\"has-text-align-left\">Core Contributor</td></tr><tr><td class=\"has-text-align-left\">6.1</td><td class=\"has-text-align-left\">Core Contributor</td></tr><tr><td class=\"has-text-align-left\">6.2</td><td class=\"has-text-align-left\">Core Contributor</td></tr><tr><td class=\"has-text-align-left\">6.3</td><td class=\"has-text-align-left\">Noteworthy Contributor</td></tr><tr><td class=\"has-text-align-left\">6.4</td><td class=\"has-text-align-left\">Noteworthy Contributor</td></tr><tr><td class=\"has-text-align-left\">6.5</td><td class=\"has-text-align-left\">Core Contributor</td></tr><tr><td class=\"has-text-align-left\">6.6</td><td class=\"has-text-align-left\">Core Contributor</td></tr><tr><td class=\"has-text-align-left\">6.7</td><td class=\"has-text-align-left\">Core Contributor</td></tr><tr><td class=\"has-text-align-left\">6.8</td><td class=\"has-text-align-left\">Noteworthy Contributor</td></tr></tbody></table></figure>\n</details>\n\n\n\n<p>My first credited release was <a href=\"https://wordpress.org/news/2013/10/basie/\">WordPress 3.7</a>. However, I grepped core commits to find that my very first prop in changeset <a href=\"https://core.trac.wordpress.org/changeset/11567\">r11567</a> (on June 14, 2009) came before that as part of the <a href=\"https://wordpress.org/news/2009/07/wordpress-2-8-1/\">2.8.1 minor release</a>. While I had been building sites with WordPress since around 2006 (and even had a blog years earlier), this was a drive-by contribution, years before I started contributing heavily in 2013. My next prop came four years later in <a href=\"https://core.trac.wordpress.org/changeset/25580\">r25580</a> which is when I started contributing heavily. I&#8217;ve had credits in every major release since 3.7: thirty-two in all!</p>\n\n\n\n<p>Credits I&#8217;ve had include:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Core Contributor (18⨉)</li>\n\n\n\n<li>Contributing Developer (7⨉)</li>\n\n\n\n<li>Core Developer (3⨉)</li>\n\n\n\n<li>Noteworthy Contributor (3⨉)</li>\n\n\n\n<li>(co-)Release Lead (1⨉)</li>\n</ul>\n\n\n\n<p>I&#8217;ve made <a href=\"https://github.com/WordPress/wordpress-develop/commits?author=westonruter\">662 commits</a> to <code>trunk</code> and I&#8217;ve had props on <a href=\"https://github.com/search?q=repo%3AWordPress%2Fwordpress-develop+%2F%5Eprops.%2Bwestonruter%2F&amp;type=commits\">465 commits</a>:</p>\n\n\n\n<figure class=\"wp-block-image size-full wp-lightbox-container\"><img alt=\"Weston Ruter\'s WordPress Core Commit Contributions\" class=\"wp-image-34502\" height=\"848\" src=\"https://weston.ruter.net/wp-content/uploads/2025/05/weston-ruter-wordpress-core-commit-contributions.svg\" width=\"600\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n\n\n\n<p>I&#8217;ve also opened <a href=\"https://core.trac.wordpress.org/query?reporter=westonruter&amp;col=id&amp;col=summary&amp;col=status&amp;col=owner&amp;col=type&amp;col=priority&amp;col=milestone&amp;order=priority\">324 Trac tickets</a> and made <a href=\"https://wordpress.org/support/users/westonruter/\">4,935 topic replies</a> in the WordPress support forum.</p>\n\n\n\n<p>It all began in 2013 when I started contributing heavily to the <a href=\"https://make.wordpress.org/core/components/customize/\">Customize</a> component. My first major feature was <a href=\"https://make.wordpress.org/core/2014/01/28/widget-customizer-feature-as-plugin-merge-proposal/\">adding widgets to the Customizer</a>, and I continued contributing heavily to the Customizer through the end of 2017, around when <a href=\"https://wordpress.org/news/2017/11/tipton/\">WordPress 4.9</a> was released. Here are a few of my Make/Core posts (out of the <a href=\"https://make.wordpress.org/core/author/westonruter/\">35 posts</a> I&#8217;ve published) that highlight some of my work during this time:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2014/01/28/widget-customizer-feature-as-plugin-merge-proposal/\">Widget Customizer Feature-as-Plugin Merge Proposal</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2015/01/26/customizer-transactions-proposal/\">Proposal: Customizer Transactions</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2016/02/16/selective-refresh-in-the-customizer/\">Selective Refresh in the Customizer</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2016/05/04/improving-setting-validation-in-the-customizer/\">Improving Setting Validation in the Customizer</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2016/10/12/customize-changesets-formerly-transactions-merge-proposal/\">Customize Changesets (formerly Transactions) Merge Proposal</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2016/10/12/customize-changesets-technical-design-decisions/\">Customize Changesets Technical Design Decisions</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2017/10/22/code-editing-improvements-in-wordpress-4-9/\">Code Editing Improvements in WordPress 4.9</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2017/11/03/new-features-and-enhancements-with-customizer-changesets-in-4-9/\">New Features and Enhancements with Customizer Changesets in 4.9</a></li>\n</ul>\n\n\n\n<p>I also blogged a <a href=\"https://weston.ruter.net/2017/11/03/wordpress-4-9/\">recap</a> of co-leading the 4.9 release, and I <a href=\"https://weston.ruter.net/2017/12/06/presenting-wordpress-releases-at-state-of-the-word-2017/\">presented highlights from the 4.8 &amp; 4.9 releases</a> during <abbr title=\"State of the Word\">SotW</abbr> at WordCamp US 2017. My time working on the Customizer and the 4.9 release was sponsored by <a href=\"https://xwp.co/\">XWP</a>, where I was <abbr title=\"Chief Technology Officer\">CTO</abbr>.</p>\n\n\n\n<p>In that year, development on the Gutenberg project took off, and this coincided with a decline in direct contributions to WordPress core. Over that summer I also <a href=\"https://github.com/WordPress/gutenberg/graphs/contributors?from=5%2F20%2F2017&amp;to=7%2F30%2F2017#:~:text=westonruter-,westonruter,-%27s%20Commits\">started ramping up</a> on Gutenberg, but then I got the call to lead the 4.9 release and I had to leave Gutenberg behind. I focused instead on continuing to improve the Customizer among other aspects of WordPress core. However, once 4.9 was out the door, it became clear that the Customizer was not going to be a priority focus for the WordPress project going forward, with all efforts being put into Gutenberg. In fact, there was no major release of WordPress for more than a year until the Gutenberg project was ready for inclusion in <a href=\"https://wordpress.org/news/2018/12/bebo/\">WordPress 5.0</a>.</p>\n\n\n\n<p>Since I somewhat missed the boat on Gutenberg, and since new Customizer feature development was at an end, I pivoted in 2018 to work on something new: the <a href=\"https://github.com/ampproject/amp-wp/\">AMP plugin for WordPress</a>. (I also joined Google in Q4 2018.) This was largely my focus until I joined the <a href=\"https://make.wordpress.org/performance/\">WordPress Core Performance Team</a> in 2023. This was an interesting challenge to democratize performance for WordPress sites by leveraging the open source <a href=\"https://amp.dev/\">AMP web component framework</a>. Since AMP is a declarative framework, I implemented some interesting things like CSS tree shaking for all stylesheets used on a page and print them inline to eliminate a large source of render blocking. Ultimately, a lot of what I learned while working on the AMP plugin I could apply directly to our initiatives on the WordPress Core Performance Team. AMP was developed before Core Web Vitals (CWV), and <a href=\"https://blog.amp.dev/2019/05/21/contributing-back-lessons-learned-part-1/\">it contributed toward the development</a> of <abbr title=\"Largest Contentful Paint\">LCP</abbr>, <abbr title=\"Cumulative Layout Shift\">CLS</abbr>, and <abbr title=\"First Input Delay\">FID</abbr>. So now as opposed to working on ecosystem compatibility with the <a href=\"https://amp.dev/documentation/guides-and-tutorials/learn/spec/amphtml\">AMP HTML specification</a>, my performance work transitioned to improving CWV metrics.</p>\n\n\n\n<p>Some highlights from my work on the Core Performance Team:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Architected and led engineering of the <a href=\"https://github.com/WordPress/performance/blob/trunk/plugins/optimization-detective/docs/introduction.md\">Optimization Detective</a> plugin, including the dependent <a href=\"https://wordpress.org/plugins/image-prioritizer/\">Image Prioritizer</a> and <a href=\"https://wordpress.org/plugins/embed-optimizer/\">Embed Optimizer</a> plugins. By far this was (and is) my primary focus on the team. See my talk <a href=\"https://weston.ruter.net/2025/02/21/boosting-performance-with-optimization-detective/\">Boosting Performance with Optimization Detective</a> which I gave at WordCamp Asia 2025. More on this below.</li>\n\n\n\n<li>Identified and fixed an emoji loader performance problem (<a href=\"https://core.trac.wordpress.org/ticket/58472\">#58472</a>) that caused a long task during page load for lower-powered devices, which could cause a 100-200 ms delay in LCP for every page load.</li>\n\n\n\n<li>Collaborated on <a href=\"https://make.wordpress.org/core/2023/07/14/registering-scripts-with-async-and-defer-attributes-in-wordpress-6-3/\">launching script loading strategies</a> (<code>async</code> &amp; <code>defer</code>).</li>\n\n\n\n<li>Collaborated on developing the <a href=\"https://make.wordpress.org/core/2024/04/09/speculative-loading-in-wordpress/\">Speculative Loading feature plugin</a> and <a href=\"https://make.wordpress.org/core/2025/03/06/speculative-loading-in-6-8/\">landing in WordPress 6.8</a>.</li>\n\n\n\n<li>Managed <a href=\"https://github.com/WordPress/performance/releases\">Performance Lab releases</a> and led development of the plugin.</li>\n\n\n\n<li>Improved Interactivity API to <a href=\"https://github.com/WordPress/gutenberg/issues/58225\">prevent causing a long task</a> at hydration.</li>\n\n\n\n<li><a href=\"https://github.com/GoogleChromeLabs/wpp-research/issues?q=author%3Awestonruter\">Contributed to wpp-research</a> to improve benchmarking performance changes in WordPress and analyzing data from WP pages indexed by HTTP Archive.</li>\n</ul>\n\n\n\n<p>Note that, on the Core Performance Team, my core commit contributions didn&#8217;t more significantly increase in 2023 in the chart above since my <a href=\"https://github.com/WordPress/performance/graphs/contributors#:~:text=westonruter-,westonruter,-%27s%20Commits\">commit activity</a> was focused on the WordPress/performance repo: </p>\n\n\n\n<figure class=\"wp-block-image size-full wp-lightbox-container\"><img alt=\"Weston Ruter\'s Commits to the WordPress/performance repo\" class=\"wp-image-34505\" height=\"491\" src=\"https://weston.ruter.net/wp-content/uploads/2025/05/westonruter-wordpress-performance-commits.svg\" width=\"793\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n\n\n\n<p>The loss of my sponsorship from Google to work on WordPress performance at this moment hits the hardest because the Optimization Detective project is just starting to show real fruit. The plugin now has 40,000+ active installs with the dependent plugins Image Prioritizer and Embed Optimizer each having 40,000+ and 30,000+ active installs, respectively. As of March 2025, there were almost 18,000 URLs in HTTP Archive which had Image Prioritizer active at the time of crawling. The week I lost my position, I was <a href=\"https://github.com/GoogleChromeLabs/wpp-research/pull/178\">analyzing</a> those URLs to see how accurate Image Prioritizer was at applying optimizations. I still intend to publish a post with all of the data, but the accuracy of the optimizations was looking quite promising.</p>\n\n\n\n<p>When WordPress core adds <code>fetchpriority=high</code> to an <code>IMG</code>, I found that this was the LCP element only ~23% of the time. With Image Prioritizer&#8217;s use of client-side detection and <code>fetchpriority=high</code> preload links with media queries, the prioritization accuracy more than doubled to ~50%. Furthermore, when WordPress core adds <code>fetchpriority=high</code> to an <code>IMG</code>, this element is only in the viewport ~60% of the time, but with Image Prioritizer this increases to ~78%. I also found large improvements (&gt;10%) to the accuracy of adding <code>loading=lazy</code> to images that only appear outside the viewport. Here is some of the provisional accuracy data:</p>\n\n\n\n<figure class=\"wp-block-table alignwide is-style-stripes\"><table><thead><tr><th><strong>Optimization</strong></th><th><strong>Original Mobile</strong></th><th><strong>Optimized Mobile</strong></th><th><strong>Original Desktop</strong></th><th><strong>Optimized Desktop</strong></th></tr></thead><tbody><tr><td>LCP image prioritized</td><td>24.2%</td><td>50.3%</td><td>22.4%</td><td>49.1%</td></tr><tr><td><code>IMG</code> with <code>high</code> fetch priority only in viewport</td><td>53.9%</td><td>75.2%</td><td>66.4%</td><td>81.5%</td></tr><tr><td><abbr title=\"Image Prioritizer\">IP</abbr>-prioritized image in viewport</td><td>n/a</td><td>90.9%</td><td>n/a</td><td>93.3%</td></tr><tr><td>Lazy loaded <code>IMG</code> not in viewport</td><td>79.8%</td><td>91.1%</td><td>71.5%</td><td>86.1%</td></tr></tbody></table></figure>\n\n\n\n<p>In terms of the performance impact of this improved accuracy in applying image prioritization optimizations, I looked at the difference in LCP with and without the optimizations applied while also subtracting the TTFB (i.e. &#8220;LCP-TTFB&#8221;) since my analysis script intentionally busts any page caching. When the LCP element is an image, the LCP-TTFB results were as follows:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Average diff time for mobile: -1157.6ms (-7.7%)</li>\n\n\n\n<li><strong>Median diff time for mobile: -138.7ms (-2.7%)</strong></li>\n\n\n\n<li>Average diff time for desktop: -174.0ms (-2.3%)</li>\n\n\n\n<li><strong>Median diff time for desktop: -65.9ms (-4.9%)</strong></li>\n</ul>\n\n\n\n<p>I was beginning to analyze cases for why Image Prioritizer was “only” prioritizing the LCP image with ~50% accuracy, and I was finding some bugs and low-hanging fruit to increase the accuracy yet higher. When the LCP element was an image that was prioritized correctly, the LCP-TTFB results were as follows:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Average diff time for mobile: -1949.2ms (-17.3%)</li>\n\n\n\n<li><strong>Median diff time for mobile: -654.1ms (-11.1%)</strong></li>\n\n\n\n<li>Average diff time for desktop: -298.5ms (-8.3%)</li>\n\n\n\n<li><strong>Median diff time for desktop: -136.8ms (-10.4%)</strong></li>\n</ul>\n\n\n\n<p>These are significant improvements. </p>\n\n\n\n<p>Now as the WordPress project is facing a sharp drop-off in corporate contributions, I&#8217;m hoping to find a sustainable way for me to continue devoting a significant amount of my time to WordPress, perhaps in part via <a href=\"https://github.com/sponsors/westonruter\">GitHub sponsorship</a> (which I&#8217;m new to). I&#8217;ll be open to starting a new position after the June 15th termination date for my job at Google, as I&#8217;m currently on “garden leave”.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p>Where I&#8217;ve posted about this:</p>\n\n\n\n<ul class=\"wp-block-social-links is-layout-flex wp-block-social-links-is-layout-flex\"><li class=\"wp-social-link wp-social-link-bluesky  wp-block-social-link\"><a class=\"wp-block-social-link-anchor\" href=\"https://bsky.app/profile/weston.ruter.net/post/3lp6qguatyc25\"><svg height=\"24\" version=\"1.1\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M6.3,4.2c2.3,1.7,4.8,5.3,5.7,7.2.9-1.9,3.4-5.4,5.7-7.2,1.7-1.3,4.3-2.2,4.3.9s-.4,5.2-.6,5.9c-.7,2.6-3.3,3.2-5.6,2.8,4,.7,5.1,3,2.9,5.3-5,5.2-6.7-2.8-6.7-2.8,0,0-1.7,8-6.7,2.8-2.2-2.3-1.2-4.6,2.9-5.3-2.3.4-4.9-.3-5.6-2.8-.2-.7-.6-5.3-.6-5.9,0-3.1,2.7-2.1,4.3-.9h0Z\"></path></svg><span class=\"wp-block-social-link-label screen-reader-text\">Bluesky</span></a></li>\n\n<li class=\"wp-social-link wp-social-link-linkedin  wp-block-social-link\"><a class=\"wp-block-social-link-anchor\" href=\"https://www.linkedin.com/posts/westonruter_a-decade-as-a-core-committer-my-wordpress-activity-7328646530603634688-dIBE/\"><svg height=\"24\" version=\"1.1\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M19.7,3H4.3C3.582,3,3,3.582,3,4.3v15.4C3,20.418,3.582,21,4.3,21h15.4c0.718,0,1.3-0.582,1.3-1.3V4.3 C21,3.582,20.418,3,19.7,3z M8.339,18.338H5.667v-8.59h2.672V18.338z M7.004,8.574c-0.857,0-1.549-0.694-1.549-1.548 c0-0.855,0.691-1.548,1.549-1.548c0.854,0,1.547,0.694,1.547,1.548C8.551,7.881,7.858,8.574,7.004,8.574z M18.339,18.338h-2.669 v-4.177c0-0.996-0.017-2.278-1.387-2.278c-1.389,0-1.601,1.086-1.601,2.206v4.249h-2.667v-8.59h2.559v1.174h0.037 c0.356-0.675,1.227-1.387,2.526-1.387c2.703,0,3.203,1.779,3.203,4.092V18.338z\"></path></svg><span class=\"wp-block-social-link-label screen-reader-text\">LinkedIn</span></a></li>\n\n<li class=\"wp-social-link wp-social-link-twitter  wp-block-social-link\"><a class=\"wp-block-social-link-anchor\" href=\"https://x.com/westonruter/status/1922880900351582713\"><svg height=\"24\" version=\"1.1\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M22.23,5.924c-0.736,0.326-1.527,0.547-2.357,0.646c0.847-0.508,1.498-1.312,1.804-2.27 c-0.793,0.47-1.671,0.812-2.606,0.996C18.324,4.498,17.257,4,16.077,4c-2.266,0-4.103,1.837-4.103,4.103 c0,0.322,0.036,0.635,0.106,0.935C8.67,8.867,5.647,7.234,3.623,4.751C3.27,5.357,3.067,6.062,3.067,6.814 c0,1.424,0.724,2.679,1.825,3.415c-0.673-0.021-1.305-0.206-1.859-0.513c0,0.017,0,0.034,0,0.052c0,1.988,1.414,3.647,3.292,4.023 c-0.344,0.094-0.707,0.144-1.081,0.144c-0.264,0-0.521-0.026-0.772-0.074c0.522,1.63,2.038,2.816,3.833,2.85 c-1.404,1.1-3.174,1.756-5.096,1.756c-0.331,0-0.658-0.019-0.979-0.057c1.816,1.164,3.973,1.843,6.29,1.843 c7.547,0,11.675-6.252,11.675-11.675c0-0.178-0.004-0.355-0.012-0.531C20.985,7.47,21.68,6.747,22.23,5.924z\"></path></svg><span class=\"wp-block-social-link-label screen-reader-text\">Twitter</span></a></li>\n\n<li class=\"wp-social-link wp-social-link-mastodon  wp-block-social-link\"><a class=\"wp-block-social-link-anchor\" href=\"https://mastodon.social/@westonruter/114510103143042471\"><svg height=\"24\" version=\"1.1\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M23.193 7.879c0-5.206-3.411-6.732-3.411-6.732C18.062.357 15.108.025 12.041 0h-.076c-3.068.025-6.02.357-7.74 1.147 0 0-3.411 1.526-3.411 6.732 0 1.192-.023 2.618.015 4.129.124 5.092.934 10.109 5.641 11.355 2.17.574 4.034.695 5.535.612 2.722-.15 4.25-.972 4.25-.972l-.09-1.975s-1.945.613-4.129.539c-2.165-.074-4.449-.233-4.799-2.891a5.499 5.499 0 0 1-.048-.745s2.125.52 4.817.643c1.646.075 3.19-.097 4.758-.283 3.007-.359 5.625-2.212 5.954-3.905.517-2.665.475-6.507.475-6.507zm-4.024 6.709h-2.497V8.469c0-1.29-.543-1.944-1.628-1.944-1.2 0-1.802.776-1.802 2.312v3.349h-2.483v-3.35c0-1.536-.602-2.312-1.802-2.312-1.085 0-1.628.655-1.628 1.944v6.119H4.832V8.284c0-1.289.328-2.313.987-3.07.68-.758 1.569-1.146 2.674-1.146 1.278 0 2.246.491 2.886 1.474L12 6.585l.622-1.043c.64-.983 1.608-1.474 2.886-1.474 1.104 0 1.994.388 2.674 1.146.658.757.986 1.781.986 3.07v6.304z\"></svg><span class=\"wp-block-social-link-label screen-reader-text\">Mastodon</span></a></li></ul>\n<p>The post <a href=\"https://weston.ruter.net/2025/05/14/a-decade-as-a-core-committer-my-wordpress-contribution-history/\">A Decade as a Core Committer: My WordPress Contribution History</a> appeared first on <a href=\"https://weston.ruter.net\">Weston Ruter</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 15 May 2025 00:38:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Weston Ruter\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WPTavern: #169 – Wes Tatters on the Evolution of Internet Communities and WordPress Open Source\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=195791\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"https://wptavern.com/podcast/169-wes-tatters-on-the-evolution-of-internet-communities-and-wordpress-open-source\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:49601:\"<details>Transcript<div>\n<p>[00:00:19] Nathan Wrigley: Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case a personal journey through the history of the internet from start to now.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to wp tavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wp tavern.com/contact/jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Wes Tatters. Wes has been immersed in the tech space for close to four decades, starting his journey with early computers like the Commodore 64 and TRS 80. He&#8217;s been an author, with multiple books on internet technologies to his name, has worked across AV and media, and today he&#8217;s the driving force behind Rapyd Cloud, a globally distributed hosting company. Wes&#8217; perspective is shaped as much by his hands-on experience building communities on CompuServe, AOL and MSN, as by his deep involvement with modern open source platforms like WordPress.</p>\n\n\n\n<p>Wes starts off by sharing some of the fascinating stories from the early web, when getting online meant stringing together modems and bulletin boards, and long distance communication felt nothing short of miraculous. He talks about the evolution of the internet as a space for community, and how chance encounters in early online forums led to opportunities like writing for Netscape and shaping the very first JavaScript Developer Guides.</p>\n\n\n\n<p>We then discuss the changing meaning of community across different eras of the internet, touching on the shift from closed walled gardens, like AOL, to the open source ethos that powers projects like WordPress, and much else that we take for granted online. Wes describes how WordPress&#8217; flexibility and openness allowed anyone, anywhere, to claim their own piece of the web without technical barriers, and how this has contributed to its rise as a cornerstone of global digital freedom and self-expression.</p>\n\n\n\n<p>Our conversation also examines the challenges, and potential missteps, of the modern internet from social loneliness, to the commercial world of social media. And reflects on WordPress&#8217;s role in helping steer a path back to more positive, open, and empowering online experiences.</p>\n\n\n\n<p>If you&#8217;re interested in how the history of the internet directly shaped WordPress, the Open Web, and the communities we build today, this episode is for you.</p>\n\n\n\n<p>If you&#8217;d like to find out more, you can find all of the links in the show notes by heading to wp tavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Wes Tatters.</p>\n\n\n\n<p>I am joined on the podcast today by Wes Tatters. Hello, Wes.</p>\n\n\n\n<p>[00:03:50] Wes Tatters: Nathan, good to be talking together again.</p>\n\n\n\n<p>[00:03:53] Nathan Wrigley: I&#8217;ve got to be very, very, accommodating of Wes&#8217; time, because for me it&#8217;s about four in the afternoon, something like that. Wes, on the other side of the planet, is giving up his time at about one in the morning. I have no idea why you are here, but I appreciate it. Thank you.</p>\n\n\n\n<p>[00:04:07] Wes Tatters: Oh look, my day tends to be largely focused on talking to people in Europe, and in the United States. Half my employees are in those parts of the world as well. So I tend to work midnight to midnight. And we&#8217;re in the middle of a big product launch, for Rapyd, which has meant we&#8217;re just talking, and being visible, and I&#8217;m awake and happy to chat.</p>\n\n\n\n<p>[00:04:25] Nathan Wrigley: So you literally pivot your day, your Australian day, you pivot it so that you are available for North American and European customers. So we should probably say you work for a hosting company called Rapyd Cloud, And that&#8217;s where the thrust of your marketing endeavors go. So you pivot your day?</p>\n\n\n\n<p>[00:04:41] Wes Tatters: Yeah, like about, I think about 60% of our customers are in the United States, and about 30, 45, 35 are in Europe, and 5% or something in Asia, Which is pretty generic for the WordPress space. Our focus is around obviously those markets, but also because we&#8217;re a global company, we don&#8217;t have a head office.</p>\n\n\n\n<p>Everyone who works in our team is doing it remotely. It might be Dubai, or Chicago or the Philippines or Pakistan, India. So we choose times of the day, we have this great calendar and for every meeting we post up a list of all the times, and then there&#8217;s happy faces, red faces and smiley faces. And someone will go, all right, I&#8217;ll take the red face. That&#8217;s the nature of WordPress though.</p>\n\n\n\n<p>[00:05:21] Nathan Wrigley: Yeah, madness though, when you think about it. If you were to rewind the clock 30 years none of this was possible. I mean here, I am talking you through a web browser, as if it&#8217;s nothing, and it is utterly remarkable. And actually that&#8217;s going to be the thrust of this conversation, I think. We&#8217;re going to trace the WordPress community in particular, not just the community, the software and what have you, over the period of time it&#8217;s been in existence, 21 years odd.</p>\n\n\n\n<p>So, do you want just give us your backstory, specifically I guess around WordPress, but just generally in tech? Because I know you&#8217;ve done quite a lot of other AV related things as well.</p>\n\n\n\n<p>[00:05:54] Wes Tatters: I&#8217;ve, been in the tech space for close to 40 years. I was trying to work it out a little while ago, and it&#8217;s like, I remember my first computer. It was a Commodore 64 or something, or a TRS 80, or something like that. And I would&#8217;ve been 16 or 17, and even then it was like, I was programming them, not playing games on them. I enjoyed programming and coding.</p>\n\n\n\n<p>So I started very early in the tech space, but as a result of which, even modems didn&#8217;t really exist when I first started in the IT space. Laptops and PCs and computers and certainly iPhones and all that wonderful technology we have today didn&#8217;t exist.</p>\n\n\n\n<p>But there was already people in the space at places like DARPA, that were going, how do we connect the world? It was a government military strategy. How do we connect the world in the event of a nuclear war? That was the driving mentality behind what they were planning. It was originally going to be a network of radio towers sending, a bit like we had with the old modems, the buzzing noises.</p>\n\n\n\n<p>But it was this whole concept of, how do we build a disconnected system that can survive massive breakdowns in the structure of communication? And a part of what they build, ironically, is what makes the internet so powerful these days. It&#8217;s that ability to interconnect disparate technologies, disparate systems, all different types of capabilities and devices and all those sorts of things, in ways that are transparent.</p>\n\n\n\n<p>As you just said, we&#8217;re in two parts of the world and we are talking together in real time. I grew up in the, as a part of my life, in the media world, and film and television and primarily television. In a point in time where if we wanted to conduct a live interview with someone on the other side of the world, firstly, we had to book satellite space in the thousands of dollars per minute almost. And then we would go, Nathan, are you there?</p>\n\n\n\n<p>And Nathan would come back four seconds later, and we would conduct these really bizarre interviews, with delays on this crazy technology. So much so that when live television was first starting, obviously there was a big fear that someone would say naughty words, or swear on television for the want of a better word. And one of the early ways that they originally managed, we have what&#8217;s called, a lot of television stations had this big red button called a dump button.</p>\n\n\n\n<p>The whole idea was someone said f, someone had to slam the big dump button. But the way they we&#8217;re actually handling it was they were actually sending the entire signal up to a satellite and back down to the ground station before they transmitted it. Because that gave them roughly two or three seconds of delay, which gave them the ability for that big red button to stop the transmission point. But the signal had gone up and down through a satellite just to even achieve that craziness.</p>\n\n\n\n<p>I came into that world, and started in that world. I was incredibly lucky that I lucked into an IT firm, here in Australia, that was at that stage of company that doesn&#8217;t even exist anymore. It&#8217;s a company called Wang Microsystems. Dr. Wang was the guy that invented the first memory ship, so he, he&#8217;s reasonably well healed, but that entire platform doesn&#8217;t exist. But Wang was one of the first it companies to release a processor with a box. There was this three racks that was a modem.</p>\n\n\n\n<p>300 characters per second. It was bleedingly fast. But for, its time, and I was one of the first people that got to play with one of those things in Australia. And I&#8217;ll tell you what, I was hooked. I just went, even then I could go, oh my goodness. There were dreams of we can make it faster.</p>\n\n\n\n<p>And we got 1200 baud, and then we got 1600 baud, and then we got 3,200 baud and 56 k. And every bit was exciting. Because what it was allowing me as a person to do, especially a person in Australia, was to reach out and communicate with people that weren&#8217;t in my part of the world. And we had things like America Online, well CompuServe first, I guess prior to America Online.</p>\n\n\n\n<p>We had bulletin boards and local BBS software and things like that. And all of them were creating communities. All of them were starting to build communities around this same space. It was something that I really engaged with.</p>\n\n\n\n<p>When I got into CompuServe though, it for me changed a lot of things. Because until that stage it was hard to communicate with anyone outside Australia. But with CompuServe, all of a sudden, I was connected to people around the world.</p>\n\n\n\n<p>[00:10:37] Nathan Wrigley: What did that connection actually feel like though? Was it literally, you&#8217;d type something, and was it you&#8217;d leave the computer, like the email sort of exchange?</p>\n\n\n\n<p>[00:10:46] Wes Tatters: They were really very, very similar to an early sort of discussion board. People would leave comments, and people would make comments back and respond, and people built relationships and discussions were built. And in my early life I was an author. I&#8217;ve written a number of books on internet technologies.</p>\n\n\n\n<p>This is the guy in Brisbane, Australia, who happened to luck into a forum on CompuServe with a guy named Mark Tabor, who was the head of publishing acquisitions for Schuster and Schuster, which is McMillan, and sams.net, the biggest publisher on the planet.</p>\n\n\n\n<p>And Mark was going, we are looking for authors to write in this space. They were releasing a new imprint at the time called sams.net, which was going to be like. Theirs was Teach Yourself series.</p>\n\n\n\n<p>They were building it at McMillan, and their biggest problem was respectfully that IT people don&#8217;t make good writers. Love us, or like us, we don&#8217;t even like writing comments in code, let alone knocking out 4 or 500 pages of a book, to tell someone how to do something.</p>\n\n\n\n<p>But that ability to be in a community outside of my own space, this is me in Brisbane, Australia, talking to the head of acquisitions for Macmillan, going, yeah, I can write a book. I&#8217;d already been doing some writing. I had, as I said from, because I have a media background, I&#8217;d been writing for magazine articles in Australia, and I&#8217;d been involved in communications and had some journalism experience, so I was kind of already in the space.</p>\n\n\n\n<p>And yeah, the book got written. We actually wrote a book that told people how to connect CompuServe to the internet, because previously CompuServe couldn&#8217;t be connected to the internet.</p>\n\n\n\n<p>[00:12:21] Nathan Wrigley: Do you remember those times like halcyon day&#8217;s, rose tinted spectacles. Because that was real pioneering stuff. The idea that, okay, so dear listener, if you are under the age of 30, your world was entirely connected from the moment you could conceive a thought. In some respect you could turn the tele on and be live tele from around the globe. You may not have had internet access.</p>\n\n\n\n<p>[00:12:44] Wes Tatters: I remember trying to explain to my parents what I was doing, and they were looking at me going, you&#8217;re doing what? And it wasn&#8217;t until the first book, 500 pages, 50 copies arrived in a box from McMillan, that the lights went on in parents&#8217; head who went, okay.</p>\n\n\n\n<p>[00:13:04] Nathan Wrigley: There&#8217;s something in this.</p>\n\n\n\n<p>[00:13:05] Wes Tatters: This is odd. And we sold hundreds of thousands of copies of edition of these books. I wrote the same book for America Online.</p>\n\n\n\n<p>The joke was America Online actually wasn&#8217;t even in Australia at that stage, which was interesting. But it gave me lots of opportunities, and this was about communities. This was about getting into communities. While I was in that community, talking, working with the a AOL team on how they were going to connect to this thing called the internet. There was a little crowd called Netscape banging around, going hey, love what you did, Tim. Love that original browser. We&#8217;re going to build a better one.</p>\n\n\n\n<p>[00:13:37] Nathan Wrigley: An open one.</p>\n\n\n\n<p>[00:13:38] Wes Tatters: An open one. And the Netscape guys had seen my books, came to my publisher and said, hey, could we do a book with Wes on how to write, how to build websites for Netscape? So we wrote six books for Netscape over the next five years, going teach yourself HTML development for Netscape. So community was the whole basis of it.</p>\n\n\n\n<p>[00:14:03] Nathan Wrigley: It&#8217;s so curious that for people that are born in the last, like I said, 20 years or so, the internet has just been a feature of their life, almost like a utility. Almost in certain parts of the world, like a human right. You might even describe it on that level.</p>\n\n\n\n<p>This conduit of information that can come in. This capacity to talk to people, any point on the globe almost immediately with almost zero cost. And in the time that you are describing just the merest foundations of that were beginning. Little glimmers of that would beginning to emerge.</p>\n\n\n\n<p>[00:14:34] Wes Tatters: Really edge.</p>\n\n\n\n<p>[00:14:35] Nathan Wrigley: Really interesting though. I can imagine your passion and interest and all of that must have been. The curiosity that was spiked by that.</p>\n\n\n\n<p>[00:14:42] Wes Tatters: It was. I loved it. But even then, we still didn&#8217;t truly understand where it was going.</p>\n\n\n\n<p>I remember a call from the team at Netscape going, it was around, I think it was around version three of the Netscape. Going we&#8217;ve got this idea we&#8217;re going to, we&#8217;re going to put a scripting thing in Netscape. What do you think? And I&#8217;m going, yeah. What do you mean? What do you think? We need you to include it in the next book. It&#8217;s this little thing called JavaScript.</p>\n\n\n\n<p>[00:15:04] Nathan Wrigley: Just little thing.</p>\n\n\n\n<p>[00:15:06] Wes Tatters: And I remember sitting there going, interesting idea. Can you tell me more about what it can do? And they went, we don&#8217;t really know yet. We&#8217;re still working on those bits. So we ended up writing the first JavaScript development guide, me and my technical writer, who was my technical editor for my Netscape books. And I wrote the first JavaScript Developers Guide for Netscape.</p>\n\n\n\n<p>So we were there in the middle of it, but all the way through, we still didn&#8217;t truly get it. It was still such this small thing. I was talking with Bud.</p>\n\n\n\n<p>[00:15:37] Nathan Wrigley: Bud Kraus.</p>\n\n\n\n<p>[00:15:38] Wes Tatters: Yeah, I was talking with Bud at PressConf, and we were chatting about just the way the internet&#8217;s evolved. I had the opportunity to meet Tim Burnes Lee.</p>\n\n\n\n<p>[00:15:46] Nathan Wrigley: Nice, the Godfather.</p>\n\n\n\n<p>[00:15:48] Wes Tatters: The Godfather of the internet. And listening to Tim talking about his dream of the internet and the worldwide web, this was a worldwide web conference seven, which was back before WordCamps. It was, that was what a WordCamp looked like before it was WordPress. And I look back and I was thinking, and I&#8217;m going, there were some serious names at that event. Tim Burnes Lee was there. James Gosling, the founder of Java, was there.</p>\n\n\n\n<p>And these were guys doing for the want of a better WordCamp style sessions, chatting about these ideas they&#8217;ve had. Seeing even then that what the worldwide web, and what we&#8217;ve grown into with WordPress had the potential to be, was entirely different to the way the world thought before that.</p>\n\n\n\n<p>I remember there was like, I think it was the Friday night. I actually ran the media for that particular conference, that was held in Australia. It was the first time being held out of the northern hemisphere. But no fully explained reason, it was being held in Australia, in my hometown, and I ran all the media for it.</p>\n\n\n\n<p>And I remember some guys, they had this sort, they were going to create this shoe library, it was like, this is the early web. Who knows what we&#8217;re going to do with it? We want a shoe library.</p>\n\n\n\n<p>[00:17:00] Nathan Wrigley: A shoe library, yeah.</p>\n\n\n\n<p>[00:17:01] Wes Tatters: They taking photographs of people&#8217;s shoes, and I remember it was like 7:30 on a Friday night, and Tim&#8217;s in a pair of slacks and a t-shirt. Taking his shoes off so that they could photograph his shoes, so that his photograph of his shoes could go into the shoe library.</p>\n\n\n\n<p>[00:17:19] Nathan Wrigley: Of course.</p>\n\n\n\n<p>[00:17:20] Wes Tatters: And this is the guy that invented the thing that we all live on. This is the father of everything we do today. But even then, he was this amazingly humble person, that was happy to have a chat with a bunch of kids and take photos of his shoes. It&#8217;s a different world.</p>\n\n\n\n<p>[00:17:38] Nathan Wrigley: When you are where you&#8217;re at. So in the year 2025, we&#8217;re concerned about the internet now. And so the way it ended up is how it now is. And honestly, it&#8217;s not one of those things that you pick apart, as like what is the history? What were the dominoes that fell to make the internet, what it now is?</p>\n\n\n\n<p>Like, history, politics and warfare, and all of those kind of things get dealt with by historians. The migration of people over great land masses, all of the kings, queens, all of that.</p>\n\n\n\n<p>But this, this kind of doesn&#8217;t, and it&#8217;s fascinating to listen to you there, because it feels like it could have gone in so many different directions. Maybe would&#8217;ve been a more AOL type thing, where everything was closed and you had to buy into AOL, and everything was handled by AOL. It didn&#8217;t turn out that way. Open won. I&#8217;m not entirely sure that we didn&#8217;t swing back to closed with things social media?</p>\n\n\n\n<p>[00:18:29] Wes Tatters: One of the things that caused that was the people who started using the technology that DARPA invented first, and it was universities.</p>\n\n\n\n<p>[00:18:41] Nathan Wrigley: Oh, interesting. That was the client base, wasn&#8217;t it? It was the academics.</p>\n\n\n\n<p>[00:18:44] Wes Tatters: It was the academics. So Tim&#8217;s original agenda was to obviously create a way to communicate with all the scientists in Cern what was happening in the accelerator that was sitting under three countries. Even then it was about community and communication. But as it&#8217;s walked forward, I look at the whole journey of the internet and at every point community has been a part of that.</p>\n\n\n\n<p>The ability to share things. The whole basis of what we have today in open source, moving towards WordPress, is about communication. So you can&#8217;t have open source without a group of people coming together to collaborate on a project as large as WordPress, or as large as, Linux or as large as Drupal, or as large as all of these other projects. And they&#8217;re not being paid for the most part.</p>\n\n\n\n<p>They&#8217;re doing it because of community, and the underlying technology behind that obviously is the internet. And more insignificantly since then this thing called the World Wide Web that Tim originally envisaged as a tool for sharing.</p>\n\n\n\n<p>[00:19:56] Nathan Wrigley: Yeah. But just tool for sharing with a handful of academics, and then it just grew exponentially. Do you remember the first time that the internet became more social. No, let me rephrase that. Do you remember when the internet shifted from something which a few people did? To something where, not the majority, but it was like hard to ignore at that point. Because definitely as a child have a of no internet.</p>\n\n\n\n<p>[00:20:20] Wes Tatters: Done badly, but Microsoft MSN. Windows 95 was the watershed. So Windows 95 launched, and for the first time, anyone, in inverted commas, with a modem didn&#8217;t need to know someone at a university. Didn&#8217;t need to know how to hard wire AOL to connect to something else. They could literally go get me on the internet, and it happened. So that was the watershed moment.</p>\n\n\n\n<p>Now, MSN as a platform also was heavily driven by community. And again, like it or love them, the original version of Messenger, an embarrassing mess, but it started the concept of community. The original version of MSN was a place where you could go and chat. Their design philosophies around. I remember, in Australia, 9 MSN was, the branding of it. 9 here is our major television network, and they partnered with MSN, in Microsoft and Australia and our major telco to bring MSN to Australia. But it was heavily geared around building communities. And I was quite active in that MSN community in Australia.</p>\n\n\n\n<p>We used to do things like popular TV shows would go to air, and then we would host forums where the actor, or the presenter, or someone from the show would hop literally straight off, the show would end at 9:30, and they would be in a forum going, and hey, tonight we&#8217;ve got insert name of whoever it is.</p>\n\n\n\n<p>And people could ask them questions. And we curated it. I was a part of the curations team at 9 MSN at that stage. And, again, it was using this crazy technology to build community, and to expand communities.</p>\n\n\n\n<p>Now for that network they were using as just obviously a marketing tool, but what it was doing underneath it was again, building this ethos of communities and spaces.</p>\n\n\n\n<p>We then have obviously Facebook that took that and ran with it in crazy directions, and commercialized it. But underneath it we&#8217;re still this open source thing. There&#8217;s still whole open source community.</p>\n\n\n\n<p>[00:22:31] Nathan Wrigley: Do you remember the moment as well when the internet went more from a consumption kind of thing? So you know, you would log onto somebody else&#8217;s property, MSNs Messenger or whatever it may be. I do remember that, by the way. To I can own a bit of the web, a bit of that whole thing can be something that I am in control of. And now we move towards CMSs I guess.</p>\n\n\n\n<p>[00:22:51] Wes Tatters: So this is probably 98 initially. So we were still writing books and Netscape was still trying to work out what they were doing in the world. And, Tim was, Tim was out telling people how big the internet could be. And I remember lots and lots of people, as I said, James Gosling&#8217;s come down, Tim Berners Lee&#8217;s come. The BBC had flown two camera teams, journalists, The Times had flown out people. NBC and CBS had flown out camera crews and to be at this event. Because Sir Tim was becoming Professor Tim at that stage. He was being reordered, a honorary doctorate from an Australian university. It was a big event.</p>\n\n\n\n<p>Could not get a single Australian broadcaster to even show up. Now, put this in perspective. I knew them all. I was actually in that industry. I knew the people. I literally was on the phone to news directors going, dude, just send me one cameraman. Oh, what&#8217;s this thing? What&#8217;s this thing? It was the internet.</p>\n\n\n\n<p>So 95 to 98, it was still a bit hokey. I think where it really started to change though is when things like WordPress started to arrive. Because before that my books on how to build a website, I love meeting people and go, I think I&#8217;ve got your book on a shelf somewhere. It was, and it was always either mine or Laura Lemay&#8217;s.</p>\n\n\n\n<p>Laura and I were both writing in parallel for the same publisher. And some of her chapters are in my books, my chapters in her books. But then it was, we were still hacking HTML. If you wanted to use JavaScript, it wasn&#8217;t jQuery or anything like that. You were writing lines of code and hoping it worked.</p>\n\n\n\n<p>And there were some predecessors and other things. Microsoft had to go at the same thing. Microsoft released a product called ASP, a little thing that.</p>\n\n\n\n<p>[00:24:32] Nathan Wrigley: Oh yeah, that&#8217;s right. Active Server Pages.</p>\n\n\n\n<p>[00:24:35] Wes Tatters: Yeah, and then they released a thing called asp.net, and this wonderful new programming language called C#. And that was their push into this community space. They released open source product with it. They released a product which was called I Buy Spy Portal, which was eventually then forked into a product by a guy named Sean Walker to become a product called DotNetNuke, which was literally their version of WordPress.</p>\n\n\n\n<p>I was there, I know Sean. I was in that space, and we were building communities again, coming outta the Microsoft space on DotNetNuke. At the same time, this little thing called WordPress was happening in parallel. At that stage, ironically, at that stage, I think DotNetNuke was actually more a CMS than WordPress was. Because WordPress was still really a blogging tool. It was still really MySpace for people who actually had a desire to code a bit.</p>\n\n\n\n<p>But I think it was then, that WordPress journey, the arrival of a mechanism that did two things. It allowed you to create a website without knowing how to code, and it allowed you to become a part of something, a community online, where you could all of a sudden reach out of your local neighborhood, your local city, your country, into the rest of the world. And take things to the rest of the world. Sell products to the rest of the world. Communicate to the rest of the world. Share your opinions and thoughts. In the past, you could do that on CompuServe. You could do that on America Online. But in all those places, you didn&#8217;t own your content.</p>\n\n\n\n<p>[00:26:16] Nathan Wrigley: Right, exactly that.</p>\n\n\n\n<p>[00:26:18] Wes Tatters: Even MySpace, sort of like the predecessor to almost Facebook. Facebook groups and forums. None of these spaces you owned your content. And so I think WordPress in its initial incarnation, a blog, was a way for people to start expressing their feelings. And the concept of blogging. And then we started to grow that how do we get our blog to the world? Well, RSS feeds, and then aggregators, and then this wonderful thing called Google came along.</p>\n\n\n\n<p>[00:26:45] Nathan Wrigley: Discoverability.</p>\n\n\n\n<p>[00:26:47] Wes Tatters: Discoverability, and visibility. And all along that journey, there&#8217;s this guy in the states beavering away, we&#8217;re talking about Matt, with a vision of what WordPress could be in that space. And he was creating that in parallel to these communities starting to emerge, to these other companies like Google, and Facebook building closed enclaves.</p>\n\n\n\n<p>Where Matt, obviously very passionate about open source, had a philosophy to build this space that people could use, that people could communicate and share. It was incredibly open. Anyone could write a plugin. Anyone could write a theme. Anyone could decide that they wanted to commercialize that space by selling their theme or selling their plugin.</p>\n\n\n\n<p>Hosting companies could host that platform. So the fact that was such an open product, tweaked something in the consciousness of the time. It tweaked something in that desire to communicate, but also I guess a concept of freedom to communicate.</p>\n\n\n\n<p>Freedom of speech is a passionate position of a lot of countries. The right to freedom of speech, and to a certain extent the right to express an opinion, safely. Or in some cases the rights to communicate in communities.</p>\n\n\n\n<p>I discovered during Covid that the platform that Rapyd grew out of Buddy Boss, which is a social media platform creation tool for WordPress. Install Buddy Boss and you&#8217;ve got your own private Facebook.</p>\n\n\n\n<p>We discovered that there were communities using Buddy Boss to communicate things to their people that they were terrified to communicate on private spaces, like social media or Facebooks. I know people specifically in some of those communities, doctors, other frontline groups and organizations that were facing the real challenges of what was happening in Covid and impacts of those things. They were able to use that gift of community, freely given, freely shared, where you own your raw data in ways that I hadn&#8217;t even considered.</p>\n\n\n\n<p>And for reasons that I hadn&#8217;t even considered. And each time I look at it, people find ways to use community creatively and in incredible ways. And we find that at the core of WordPress.</p>\n\n\n\n<p>[00:29:14] Nathan Wrigley: Yeah, we really do. I remember the first time I ever produced anything online, and it wasn&#8217;t with a CMS, it was just HTML. There was no CSS at the time, it was just tables and things. But I remember publishing that, a friend of mine knew more than I did, and he said, okay, here&#8217;s the environment. Here&#8217;s the text file. Just write it in there and, I&#8217;ll click a button and it&#8217;ll go to some server.</p>\n\n\n\n<p>And then I saw it, saw it on his computer. And then I said to him, but it&#8217;s on your computer. And he said, no, no, no, if you go home, it&#8217;ll be on that computer well.</p>\n\n\n\n<p>[00:29:44] Wes Tatters: And if, you go down the library, or you go up the road, and all you needed to know was where it was.</p>\n\n\n\n<p>[00:29:50] Nathan Wrigley: And I remembered this profound feeling of, what the heck. That&#8217;s so amazing. What, I just put something on your computer, and now anybody in the world should they, discoverability is the big problem, but they could find it. He&#8217;s yeah, that&#8217;s it. That&#8217;s what the internet basically is. And I remember thinking, gosh, what a force for good.</p>\n\n\n\n<p>[00:30:10] Wes Tatters: Huge force for good. Unfortunately, it&#8217;s also been a force for other things. I had a conversation with Tim, as a part of a set of interviews that the BBC were doing, this was in 1998. And at that stage, Tim was just exploring the idea of what he called the semantic web, which was zaml, and underlying metadata. And what Tim always envisaged the worldwide web should be, he always envisaged that every page, because he&#8217;s a data scientist, he envisaged that every page would have a beautiful set of metadata and structures, so that it could be searched and indexed.</p>\n\n\n\n<p>Of course that&#8217;s everything the worldwide web didn&#8217;t become, respectfully. We have enough trouble in the WordPress space remembering to put a, an alt text on a photo that we upload. But his envision was of this beautiful semantic web. So it hasn&#8217;t gone exactly the same way as he envisaged.</p>\n\n\n\n<p>But even without that semantic web, the additions and add-ons of things like Google, and Google search, and the ability to create an index, a massive index of the web. And now in 2025 going, hey, ChatGPT, can you just tell me the answer to this question please? And then can you write me a presentation?</p>\n\n\n\n<p>I was having a meeting with an associate of mine. I haven&#8217;t caught up with each other for about six years, and he&#8217;s deeply involved in the concept of human centered design, which is, a business practice where you, look at the customer to identify the problem. Not look at the business and try to solve a problem.</p>\n\n\n\n<p>He wanted to know about what I was doing in AI and that sort of stuff. And I said, did you know that I could write you a business plan? And they used to spend a lot of money creating business plans for people, and creating sessions and seminars. And I went, I can write you a seminar structure and plan in two minutes, on any topic.</p>\n\n\n\n<p>I said, no, we&#8217;ll do better. Hey, ChatGPT, tell me what you know about human-centered design and why it&#8217;s good. And of course it printed out 20 paragraphs. And then I went, can you summarize that for a presentation seminar? And of course it did that. And then I said, now can you give me the structure of the seminar?</p>\n\n\n\n<p>And it did that. And this guy sitting there going, are you kidding? And I said, that&#8217;s where we&#8217;ve come. But underlying all that is data and information. And none of that&#8217;s of any relevance unless you&#8217;ve got a community to share it with.</p>\n\n\n\n<p>[00:32:23] Nathan Wrigley: Do you have a sense that the internet has gone in a, I&#8217;m going to use the word bad or poor direction over the last decade? Do you have a sense that mistakes have been made? If you could rewind the clock, were there any moments in time where you think, I wish it hadn&#8217;t have gone in that direction?</p>\n\n\n\n<p>Because I often think things like proprietary platforms that kind of want to put a wall around the conversations that we have. They seem like, maybe in 50 years time when we look back, maybe they&#8217;ll seem like missteps. I don&#8217;t know. Maybe they&#8217;ll carry on and it&#8217;ll all be, as it is now.</p>\n\n\n\n<p>But it does feel like there&#8217;s a resurgence more to owning your own conversation. So obviously we do that in WordPress, but it does feel like there&#8217;s a bit of a groundswell towards more federated protocols. Things like the AT protocol that Bluesky are doing, but Mastodon and an ActivityPub and those kind of things.</p>\n\n\n\n<p>[00:33:12] Wes Tatters: I think again, if you harken back to Tim&#8217;s semantic web and, he wrote a document, 2022 I think, which was 30 years on. And he talked about where things had gone. I can tell you right now that the way I read Tim&#8217;s take on the worldwide web is that e-commerce was not a part of it. That was not a part of his idea of.</p>\n\n\n\n<p>[00:33:36] Nathan Wrigley: Yeah, how would you even have conceived that?</p>\n\n\n\n<p>[00:33:38] Wes Tatters: Yeah, e-commerce wasn&#8217;t a thing. I don&#8217;t truly think, Snapchatting or no fully explained reason, 15 second videos in TikTok were anywhere on the radar, because there was this whole deal of philosophy. But each of these things actually has the same underlying traits.</p>\n\n\n\n<p>It&#8217;s all about communities, it&#8217;s all about relationships and building relationships with people. Where I think personally we have made a misstep is in how our younger generations consume that community.</p>\n\n\n\n<p>[00:34:12] Nathan Wrigley: It&#8217;s a lot.</p>\n\n\n\n<p>[00:34:12] Wes Tatters: Well, it&#8217;s more than a lot. There was a survey done and I haven&#8217;t got the figures in front of me, because I wasn&#8217;t planning on discussing where we were here. That&#8217;s looked at the level of loneliness of people in 2025, compared to the level of loneliness of 20 and 30 years ago. And it directly related this online community thing. The, unfortunately, what do we call false community sometimes. The people we have never met that we talk to in a Snapchat or something like that, that are not community, and they&#8217;re not really our friends.</p>\n\n\n\n<p>And there is an increase in loneliness. And I think if there&#8217;s any misstep that we as a society have maybe taken out of this thing, is a lack of understanding of the impacts of loneliness. And I think the internet&#8217;s to blame for that.</p>\n\n\n\n<p>[00:35:13] Nathan Wrigley: The internet is so beguiling, isn&#8217;t it? Because there&#8217;s so much interesting stuff there. I think throw the mobile phone into that equation as well. This always on device, which is available 24 7. But it&#8217;s that capacity, incapacity, to put it down. You start doing something with it and then five minutes later you realize, often, in many cases, five minutes is not even the benchmark. More like an hour or something.</p>\n\n\n\n<p>[00:35:36] Wes Tatters: And, there are clinical reasons for that. We&#8217;re actually getting out of these devices the same dopamine hits that lead to depression. The same dopamine hits that lead to mood swings and to a certain extent mental health issues.</p>\n\n\n\n<p>We now have this whole, go on the internet and you&#8217;ll get, especially when you&#8217;re hitting my age, are you dopamine deprived? Join this, get on this dopamine detox. And it&#8217;s real. It&#8217;s a real problem. And the five minutes bursts, the swiping, the scrolling, the doom, scrolling, they&#8217;re not things that you could have even comprehended. We have all this data, massive amounts of data available to it, but we prefer to consume a, TikTok video, or look at photos of funny dogs or kittens, or dogs and kittens or whatever it is. The internet and the things that have grown out of that, have all contributed to that.</p>\n\n\n\n<p>[00:36:32] Nathan Wrigley: It really is interesting. Bit of a double-edged sword, really. Like on the one hand, the internet is probably the greatest innovation, maybe of all time. Or the electric light or, you know, what did the Romans us kind of thing.</p>\n\n\n\n<p>But also, curiously, it also has aspects of it which are really deleterious to humanity, and can really bring out the worst. It allows us to consume the worst to, I don&#8217;t know, to spend hours where we probably got other things that we should be doing, but for some reason we can&#8217;t let go of the phone, and things like that. So it is really curious.</p>\n\n\n\n<p>[00:37:06] Wes Tatters: It&#8217;s the speed that it&#8217;s happened.</p>\n\n\n\n<p>[00:37:08] Nathan Wrigley: And continues to happen. I don&#8217;t see any slowing down.</p>\n\n\n\n<p>[00:37:12] Wes Tatters: At PressConf the other day, one of the sessions was an AI session. Of course there&#8217;s going to be an AI session. Seriously, if you go to the opening of a restaurant in the town center, there&#8217;s some guy doing a presentation, and we&#8217;ve got Barry to talk about AI for 15 minutes. It feels like that anyway.</p>\n\n\n\n<p>One of the demonstrations was about two paragraph script, and it said effectively, hey, insert name of AI tool. I want you to create me a five second video, and I want the five second video to be of a dinosaur running out of a valley with a volcano erupting in the background. And as the dinosaur runs towards the camera, the ground shakes and the dinosaur&#8217;s then going to pass to the right hand side. And I&#8217;d like it to look a bit like Jurassic Park. That was literally the wording, and you hit enter not that long later, here&#8217;s a 15 second video that looks lifelike, realistic.</p>\n\n\n\n<p>[00:38:05] Nathan Wrigley: Jurassic Park.</p>\n\n\n\n<p>[00:38:06] Wes Tatters: It literally was, you may as well have been in the feature film. 10 years ago, 20 years ago, that would&#8217;ve cost couple of million dollars for that five seconds of animation. Now it&#8217;s literally something you can get on your mobile phone.</p>\n\n\n\n<p>[00:38:20] Nathan Wrigley: Anybody can get on their mobile phone.</p>\n\n\n\n<p>[00:38:22] Wes Tatters: I was looking at a video thing today. I was like, some AI tool where you can go, hey, can you, put me in a video of me flying? Yeah, sure. I just need 10 photos of you please. And, now what would you like to fly over? Yeah, technology&#8217;s changed.</p>\n\n\n\n<p>[00:38:35] Nathan Wrigley: Madness though, when you think about it, if you were to rewind the clock 30 years none of this was possible. I mean here I am talking you through a web browser as if it&#8217;s nothing. And it is utterly remarkable.</p>\n\n\n\n<p>[00:38:48] Wes Tatters: So we live in a society where we&#8217;ve moved from the first time anyone heard of a deep fake, but now it&#8217;s just what you do when you&#8217;re at lunch break.</p>\n\n\n\n<p>Things are changing. Forget about the ethics, the morals, and all those things, but our technology has changed. So yeah, to answer the question, are there missteps? Probably. But the interesting thing about the internet, and it&#8217;s something that was built into it at the beginning at DARPA, it&#8217;s actually got this amazing ability in technology to recorrect itself.</p>\n\n\n\n<p>And that was how DARPA was built. The whole idea was, if you can&#8217;t get it this way, it&#8217;ll go this way. And if you can&#8217;t get it this way, you&#8217;ll find a carrier pigeon, and you&#8217;ll keep the communications going. What we&#8217;ve discovered with communities, and with groups, is that they seem to have an inordinate way of self-correcting as well, through moderation, through conversations.</p>\n\n\n\n<p>When you get critical mass, and you pull enough people together, there is this inordinate ability to self-correct. I don&#8217;t fully understand the psychological basis behind it, but it&#8217;s fascinating how the internet has this ability to self-correct itself. So maybe over time it will, who knows?</p>\n\n\n\n<p>[00:40:02] Nathan Wrigley: Certainly in the world at large at the moment, we do seem to be in need of some sort of self-correction in all sorts of walks of life. And the WordPress community that we are both a part of definitely has had its schism over the last six months or so.</p>\n\n\n\n<p>[00:40:17] Wes Tatters: Look, and it&#8217;s been, and that&#8217;s happened before. And even those things self-correct, because there are communities that are passionate in this space. Yes, there&#8217;s been some drama. and there&#8217;s no point in having conversation about that. But one of the outputs of that has been interesting new conversations in communities. Not looking at things like how we destroy WordPress, or how we, what we do next, but actually going, how do we build our community? How do we assist our community?</p>\n\n\n\n<p>So even in those sort of challenges that every big ecosystem has, the community itself can self-correct. The community itself, can develop new relationships. And people grow out of those things.</p>\n\n\n\n<p>PressConf was an amazing example of that. Obviously it had happened before in a slightly different form a number of years ago, but this was, let&#8217;s put 150 odd in a space for a weekend, and let &#8217;em all chat and have conversations. And actually have intelligent dialogues and a whole heap of things grew out of it.</p>\n\n\n\n<p>When we have WordPress events, we have WordCamps. We have Word Camp Europe coming up. Groups creating new vision. We talk about things like contribution and what contribution looks like. There&#8217;s been some negatives about contribution in the recent space, but there&#8217;s also been some huge positives about contribution. Out of the drama we&#8217;ve had, actually created a new conversation. Many people who didn&#8217;t even understand the concept. Oh yeah, I just assumed WordPress was this thing. I never thought that there was actually people giving up their weekends to go to a day in Hyderabad to fix bugs in wordPress. But that&#8217;s what people do.</p>\n\n\n\n<p>And it actually helped us have a new conversation with a lot of people in the WordPress space that actually hadn&#8217;t even comprehended. Because they just assumed that they were, oh yeah, I just downloaded this WordPress thing.</p>\n\n\n\n<p>[00:42:13] Nathan Wrigley: Yeah, I do wonder if some things will come out of the year 2025 that would&#8217;ve been in the year 2024 unimaginable.</p>\n\n\n\n<p>[00:42:21] Wes Tatters: I would say I&#8217;m quietly positive. There are lots of conversations, at many layers. I do think, and this is my own personal opinion, that there is a time for speaking and a time for listening. And I think that right now there is a need for a lot of listening from disparate part of the community, and by listening I think a lot of people need to listen to what other people have to say. And then as a community, look at what all those things are. What&#8217;s being said, and look at what we do to self correct. I think it&#8217;s important to listen.</p>\n\n\n\n<p>[00:43:00] Nathan Wrigley: Yeah, a conversation which drifted through what the internet even was and is. Then finally landing on CMSs and WordPress and the community built up around that. So Wes, what a pool of knowledge you are. You&#8217;ve really done the entire internet circuit and I&#8217;m really glad that we got a chance to speak today. Thank you.</p>\n\n\n\n<p>[00:43:19] Wes Tatters: Nathan, it&#8217;s been a pleasure. Always happy to chat. It&#8217;s about conversation and communities. That&#8217;s what matters at the end of the day.</p>\n</div></details>\n\n\n\n<p>On the podcast today we have <a href=\"https://profiles.wordpress.org/wesrapyd/\">Wes Tatters</a>.</p>\n\n\n\n<p>Wes has been immersed in the tech space for close to four decades, starting his journey with early computers like the Commodore 64 and TRS-80. He’s been an author, with multiple books on internet technologies to his name, has worked across AV and media, and today, he’s the driving force behind Rapyd Cloud, a globally distributed hosting company. Wes’s perspective is shaped as much by his hands-on experience building communities on CompuServe, AOL, and MSN as by his deep involvement with modern open source platforms, like WordPress.</p>\n\n\n\n<p>Wes starts off by sharing some of the fascinating stories from the early web, when getting online meant stringing together modems and bulletin boards, and long-distance communication felt nothing short of miraculous. He talks about the evolution of the internet as a space for community, and how chance encounters in early online forums led to opportunities like writing for Netscape and shaping the very first JavaScript Developer Guides.</p>\n\n\n\n<p>We then discuss the changing meaning of “community” across different eras of the internet, touching on the shift from closed, walled gardens like AOL, to the open source ethos that powers projects like WordPress and much else that we take for granted online. Wes describes how WordPress’s flexibility and openness allowed anyone, anywhere, to claim their own piece of the web without technical barriers, and how this has contributed to its rise as a cornerstone of global digital freedom and self-expression.</p>\n\n\n\n<p>Our conversation also examines the challenges and potential missteps of the modern internet, from social loneliness to the commercial world of social media, and reflects on WordPress’s role in helping steer a path back to more positive, open, and empowering online experiences.</p>\n\n\n\n<p>If you’re interested in how the history of the internet directly shaped WordPress, the open web, and the communities we build today, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://rapyd.cloud/\">Rapyd Cloud</a></p>\n\n\n\n<p><a href=\"https://en.wikipedia.org/wiki/DARPA\">DARPA</a></p>\n\n\n\n<p><a href=\"https://en.wikipedia.org/wiki/AOL\">AOL</a></p>\n\n\n\n<p><a href=\"https://en.wikipedia.org/wiki/CompuServe\">CompuServe</a></p>\n\n\n\n<p><a href=\"https://www.amazon.co.uk/JavaScript-Developers-Guide-Wes-Tatters/dp/1575210843\">JavaScript Developers Guide</a> written by Wes</p>\n\n\n\n<p><a href=\"https://pressconf.events/\">PressConf</a></p>\n\n\n\n<p><a href=\"https://www2025.thewebconf.org/\">Worldwide Web Conference</a></p>\n\n\n\n<p><a href=\"https://en.wikipedia.org/wiki/Tim_Berners-Lee\"> Tim Burnes Lee</a></p>\n\n\n\n<p><a href=\"https://en.wikipedia.org/wiki/James_Gosling\">James Gosling</a></p>\n\n\n\n<p><a href=\"https://en.wikipedia.org/wiki/Laura_Lemay\">Laura Lemay</a></p>\n\n\n\n<p><a href=\"https://en.wikipedia.org/wiki/ASP.NET\">ASP</a></p>\n\n\n\n<p><a href=\"https://dotnet.microsoft.com/en-us/apps/aspnet\">asp.net</a></p>\n\n\n\n<p><a href=\"https://en.wikipedia.org/wiki/DNN_(software)\">DotNetNuke</a></p>\n\n\n\n<p><a href=\"https://en.wikipedia.org/wiki/Myspace\">MySpace</a></p>\n\n\n\n<p><a href=\"https://www.buddyboss.com/\">BuddyBoss</a></p>\n\n\n\n<p><a href=\"https://bsky.app/\">Bluesky</a></p>\n\n\n\n<p><a href=\"https://en.wikipedia.org/wiki/AT_Protocol\">AT Protocol</a></p>\n\n\n\n<p><a href=\"https://mastodon.social/\">Mastodon</a></p>\n\n\n\n<p><a href=\"https://en.wikipedia.org/wiki/ActivityPub\">ActivityPub protocol</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 14 May 2025 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"Do The Woo Community: Why Agency Maturity Matters When Choosing WooCommerce (or Any Ecommerce Platform)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://openchannels.fm/?post_type=blog&p=96863\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"https://openchannels.fm/why-agency-maturity-matters-when-choosing-woocommerce-or-any-e-commerce-platform/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:197:\"This post highlights the significance of assessing business maturity when recommending WooCommerce to clients, ensuring they understand long-term commitments for successful online store management.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 14 May 2025 11:45:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Bob Dunn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"Matt: Upcoming Talks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=142414\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"https://ma.tt/2025/05/upcoming-talks/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:233:\"<p>It’s a busy speaking season! I just spoke at the Intelligent Change summit, and will be at SaaStock in Austin on May 14, SXSW London, on June 4, Brilliant Minds in Stockholm, and WordCamp EU in Basel, Switzerland, on June 7.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 13 May 2025 16:29:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"Do The Woo Community: A Recap of PressConf 2025\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://openchannels.fm/?p=96913\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://openchannels.fm/a-recap-of-pressconf-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:253:\"The episode of WordPress Event Talk discusses PressConf, led by new host Michelle Frechette. Our hosts share insights on networking, event structure, participant feedback, and the unique atmosphere of the event, emphasizing community and business focus.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 13 May 2025 11:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Bob Dunn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"Do The Woo Community: WordPress 6.8 Moved to bcrypt: A Quiet Revolution in Password Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://openchannels.fm/?post_type=blog&p=96876\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"https://openchannels.fm/wordpress-6-8-moved-to-bcrypt-a-quiet-revolution-in-password-security/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:178:\"WordPress 6.8 upgrades password security by transitioning to bcrypt, enhancing protection against attacks without disrupting users, while setting new industry security standards.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 12 May 2025 09:31:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Bob Dunn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"Gutenberg Times: Gutenberg Changelog 117 – WooCommerce Starter Theme and Blocks, WordCamp Europe, and Gutenberg 20.7 and 20.8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://gutenbergtimes.com/?post_type=podcast&p=40406\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://gutenbergtimes.com/podcast/gutenberg-changelog-117-woocommerce-starter-theme-and-blocks/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:48204:\"<p>Welcome to episode 117 of the Gutenberg Changelog podcast! In this jam-packed episode, host Birgit Pauli-Haack is joined by Ellen Bauer, product lead at WooCommerce for an insightful conversation covering all the latest developments in the WordPress ecosystem.</p>\n\n\n\n<p>Together, they dive into the progress on the new WooCommerce Starter Theme, its underlying “workhorse” philosophy, and the ongoing efforts to improve block theme adoption for e-commerce. Ellen shares behind-the-scenes challenges and a sneak peek into the team’s priorities—plus, learn how you can get involved and provide feedback as WooCommerce gears up for a first release in early June.</p>\n\n\n\n<p>The episode also offers a preview of what to expect at WordCamp Europe, from Ellen’s session (spoiler: it’s all about WooCommerce and block themes) to hands-on workshops like Birgit’s upcoming walkthrough of using WordPress Playground for product demos. They tackle a listener question on overriding block styles, highlight recent updates to WP-CLI, WordPress 6.8, and the Create Block Theme plugin, and break down the newest features in Gutenberg 20.7 and the upcoming 20.8 release.</p>\n\n\n\n<p>Whether you’re a theme builder, plugin developer, or a curious WordPress enthusiast, this episode is packed with actionable insights, pro tips, and friendly encouragement to explore the full potential of the block editor—especially for e-commerce sites. Tune in, and stay up-to-date with the fast-moving world of WordPress!</p>\n\n\n\n<p><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-117-woocommerce-starter-theme-and-blocks/#shownotes\">Show Notes</a> / <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-117-woocommerce-starter-theme-and-blocks/#transcript\">Transcript</a></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Music: <a href=\"https://soundcloud.com/xirclebox\">Homer Gaines</a></li>\n\n\n\n<li>Editor: <a href=\"https://www.linkedin.com/in/sandy-reed/\">Sandy Reed</a></li>\n\n\n\n<li>Logo: <a href=\"https://markuraine.com/\">Mark Uraine</a></li>\n\n\n\n<li>Production: <a href=\"https://icodeforapurpose.com\">Birgit Pauli-Haack</a></li>\n</ul>\n\n\n\n<p class=\"has-larger-font-size\" id=\"shownotes\"><strong>Show Notes</strong></p>\n\n\n\n<h2 class=\"wp-block-heading\">Ellen Bauer</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://x.com/ellenbauer\">On X (former Twitter) @ellenbauer</a></li>\n\n\n\n<li><a href=\"https://www.elmastudio.de/en/\">ElmaStudio</a></li>\n\n\n\n<li><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-105-gutenberg-18-9-block-themes-and-woocommerce/\">Gutenberg Changelog #105 – Gutenberg 18.9, Block Themes and WooCommerce</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">WooCommerce </h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/woocommerce/woo-themes/tree/trunk/woostarter\">Woo Starter Theme on GitHub</a> (MVP not for production) </li>\n\n\n\n<li><a href=\"https://developer.woocommerce.com/\">Woo Developer Blog</a></li>\n\n\n\n<li><a href=\"https://woocommerce.com/de/community-slack/\">Woo Dev Slack</a> </li>\n\n\n\n<li><a href=\"https://woocommerce.com/documentation/woocommerce/\">Woo Commerce Documentation</a></li>\n</ul>\n\n\n\n<p><strong>Listener Question</strong> on block styles and block themes</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://gutenbergtimes.com/wp-admin/post.php?post=40172&amp;action=edit\">How to overwrite or remove core block styles</a></li>\n\n\n\n<li><a href=\"https://wordpress.com/blog/2025/05/07/custom-block-styles/\">Mastering Custom Block Styles in WordPress: 6 Methods for Theme and Plugin Developers</a></li>\n\n\n\n<li><a href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/\">Seven Tasks to a Custom Block Theme: Anders Norén’s Weekend Workflow</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">What&#8217;s released: </h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/cli/2025/05/07/wp-cli-v2-12-0-release-notes/\">WP-CLI v2.12.0 Release Notes</a></li>\n\n\n\n<li><a href=\"https://wordpress.org/news/2025/04/wordpress-6-8-1-maintenance-release/\">WordPress 6.8.1 Maintenance Release</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/create-block-theme/releases/tag/v2.7.0\">Create Block Theme 2.7.0</a></li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Gutenberg Plugin releases </h3>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/WordPress/gutenberg/releases/tag/v20.7.0\">Gutenberg 20.7</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/releases/tag/v20.8.0-rc.1\">Gutenberg 20.8 RC 1</a></li>\n</ul>\n\n\n\n<p></p>\n\n\n\n<p class=\"has-large-font-size\">Stay in Touch</p>\n\n\n\n<div class=\"wp-block-group\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<ul class=\"wp-block-list\">\n<li>Did you like this episode? <a href=\"https://lovethepodcast.com/gutenbergchangelog\"><strong>Please write us a review </strong></a></li>\n\n\n\n<li>Ping us on X (formerly known as Twitter) or send DMs with questions. <a href=\"https://twitter.com/gutenbergtimes\">@gutenbergtimes </a>and <a href=\"https://twitter.com/bph\">@bph</a>.</li>\n\n\n\n<li><em>If you have questions or suggestions, or news you want us to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. </em></li>\n\n\n\n<li><em>Please write us a review on iTunes! <a href=\"https://gutenbergtimes.com/itunes/\">(Click here to learn how)</a></em></li>\n</ul>\n</div></div>\n\n\n\n<p class=\"has-large-font-size\" id=\"transcript\"><strong>Transcript</strong></p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Hello, and welcome to our 117th episode of the Gutenberg Changelog podcast. In today&#8217;s episode, we will talk about WooCommerce Starter Theme and Blocks, WordCamp Europe, Gutenberg 20.7 and 20.8. I&#8217;m your host, Birgit Pauli-Haack, curator at the Gutenberg Times, core contributor for the WordPress open source project, and I work for Automattic as a developer advocate. And I have with me Ellen Bauer, who is the Woo product lead and my resident theme wizard. So how are you today, Ellen? It&#8217;s so great that you can join me again.</p>\n\n\n\n<p><em>Ellen Bauer:</em> Thank you very much, Birgit. I&#8217;m great and I&#8217;m very excited to be on your podcast again. It has been a while and it&#8217;s always exciting for me to catch up with everything going on with the Gutenberg updates or like surrounding things like create block theme and yeah, I&#8217;m excited. I&#8217;m on my way to like halfway on the way to Europe for WordCamp Europe, which is exciting. I&#8217;m in Thailand right now in Bangkok, and there&#8217;s actually a thunderstorm just rolling in, so I hope that won&#8217;t add to any noise in our podcast today. But yeah, I&#8217;m great. Thanks for having me.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Oh, you&#8217;re welcome. You&#8217;re welcome. Yeah, well, it&#8217;s always good when we have some sudden movements on our podcast. It kind of gets us excited, but it&#8217;s not so good when you have a lightning strike and this. The power goes out. So that happens America quite often..</p>\n\n\n\n<p><em>Ellen Bauer:</em> In New Zealand as well, where we live. I hope it doesn&#8217;t happen. Yeah, I don&#8217;t think so.</p>\n\n\n\n<h3 class=\"wp-block-heading\">WooCommerce Starter Theme and Block</h3>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> I don&#8217;t think so either. So. Yeah, but you mentioned the last time that was the longer time that you&#8217;re on the show. So the last time it&#8217;s about 10 months ago, and you just had started at WooCommerce and you went on a quest to increase block theme adoption for WooCommerce. So how is it going?</p>\n\n\n\n<p><em>Ellen Bauer:</em> I&#8217;m still on the same quest and yeah, we are doing a lot of work and obviously there are a lot of complicated topics to solve because Ecommerce is just another level of complexity compared to just WordPress and blogs like Core WordPress. So the first thing we had to tackle and still like, really, I feel more or less still in the beginnings of it is improving the Woo blocks and, and then like, as a next layer we are building a pattern library. But we really needed to dig into the Woo blocks and we wanted to align them more with core blocks, make it like one experience for users and there were quite a lot of discrepancies and there still are. And we are about to release the first edition of new default Woo starter theme. Not replacing but kind of as an update to the classic theme storefront. Because yeah, it is the last default Woo theme that was there that people recommended or that that was released from WooCommerce. So we are updating that and there will be a first version. It&#8217;s really just a starter. I call it the Working Horse because it&#8217;s not meant to be a pretty like shiny theme, but really a starter point and also a reference for us to. To kind of test our own blocks to make them practical to see like what can we build and what can we not, and what do we want to build for the front end of Ecommerce stores with. With WooCommerce and what is just not possible at the moment to kind of set priorities on our work on blocks for WooCommerce. And I think that has really helped us to prioritize things that this kind of prioritization hasn&#8217;t really happened before. Yeah, you really need to use your own product to kind of see the shortcomings and what you want to fix. So that is the thing. That&#8217;s why I call it the Working Horse. And then as a next step once we have this released, we want to improve documentation. We want to help theme builders use this theme as a starting point to see how we think theme builders should work with Ecommerce and like similar to the default WordPress theme Twenty Twenty-Four, Twenty Twenty-Five just as a good reference point. And we are kind of concentrating on one theme because we want to leverage styles and yeah make it more like a mix and match of styles of font sets and a pattern library. Like use the components and make them mix and match rather than having it be one kind of stiff default theme that can&#8217;t be changed. So it will become quite creative I feel. And yeah, there&#8217;s still lots to do but it&#8217;s exciting and I think it really helps us to improve what is possible in a block WooCommerce WordPress world.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Well, there was a lot to unpack. So yes.</p>\n\n\n\n<p><em>Ellen Bauer:</em> It&#8217;s a big project that kind of occupied me for the last 10 months.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> No, no kidding. And others before you. So. So you mentioned first that the work on a theme is also based on the core blocks that are in Woo and that they need to be refined. If I remember correctly. Do you have a call for input or for feedback out for WooCommerce developers? Is that still ongoing or is that already closed? I wasn&#8217;t really up to that.</p>\n\n\n\n<p><em>Ellen Bauer:</em> No, definitely we have a call out at any time for we need especially also extension builders. We need their feedback on what they want in our blocks. We need feedback from theme builders what they want the Woo blocks to be able to do. We are also working quite a lot with what we want to bring into core WordPress, and there&#8217;s a lot of changes happening to bring more of the default things that users expect from ECommerce into core. So that is happening and it does affect the blocks as well. So yeah, we can add some links to requests for feedback and I&#8217;m also always available for any kind of feedback and I think once the theme is out we haven&#8217;t promoted it really because it&#8217;s still in the works, but it will kind of come out with the next WooCommerce release which is beginning of June. And then we are going to really say hey, we need people to test it and extension builders to test it out and give us feedback.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Is there a GitHub repo where people can do a sneak peek?</p>\n\n\n\n<p><em>Ellen Bauer:</em> Yes, there is a public GitHub repo where people can add the link to the podcast as well. And it&#8217;s yeah, we&#8217;re still doing a lot of changes, it&#8217;s being worked on. But yeah, we definitely need any kind of feedback we can get. And I think one of the disclaimers, and I put it in the readme file as well is that it&#8217;s a real work in progress, it&#8217;s not prettified or so. And I do like that. I think it&#8217;s good to show the sweat that goes into the work. And we also kind of still talk about a lot of changes like the patterns, where do we want to put the patterns and kind of looking in. For instance, what Rich Table has built on WordPress.com with a pattern library and if we can do something like that for Woo that they are just available outside of themes and really the next step I want to work on is also what kind of default patterns are shipped with WooCommerce. They will get a complete overhaul and kind of make everything more compatible. The starter theme is also based on the same theme JSON setting the assembler Rich Table’s assembler theme uses so it&#8217;s practically based on the same theme foundation. And I remember Nick Diego said to all his themes he kind of replaced to work on the basis of assembler because then we can really mix and match patterns across themes, and I think that&#8217;s a little bit limitation of block themes that in theory it&#8217;s possible, but it&#8217;s not really usable to do that. So that&#8217;s one of the things we want to improve.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, the standardizations is a little bit harder to do with block themes because people can mesh and mash the patterns from all kinds of different sources. Yeah. So timeline wise, the first sneak peek or the first version comes out of the starter theme in beginning of June. But the block work is ongoing but it needs to come to a certain place so you can release that theme and it&#8217;s actually a working example. And then it depends on the feedback that you get and also the integration with other extensions, what the next updates on the theme are going to be.</p>\n\n\n\n<p><em>Ellen Bauer:</em> Yeah, my goal for the next step after this initial release is look at the top 10 extensions and work with all of them to make it comfortable with this theme. And I think this will help all block themes to be more streamlined. And we are also really looking at all the cart and checkout pages and order confirmation. My account page is still not blockified. That&#8217;s on my wish list. It has been a little bit on the backlog, and I want to change that and kind of everything. Post purchase still needs a lot of work all the page templates there and yeah we will redo the whole default WooCommerce patterns that are shipped. Redo work on the default page templates that are that are in WooCommerce and kind of have a deep look into them and really make sure that this default starter theme just out of the box really works with everything that kind of WooCommerce recommends. That is the goal and yeah that it&#8217;s still a lot of work to be able to do that but it&#8217;s good to have a theme like a product that we can test it on. I think that was missing the WooCommerce that a lot of times we really didn&#8217;t know where to test and I think we have done it with Twenty Twenty-Four, Twenty Twenty-Five. But these themes are not meant to be ECommerce first themes, and I think that&#8217;s what we want to change with that project that we just felt we needed an E Commerce first theme to.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, absolutely.</p>\n\n\n\n<p><em>Ellen Bauer:</em> To really test all our product range and our core plugin with makes total sense.</p>\n\n\n\n<h3 class=\"wp-block-heading\">WordCamp Europe</h3>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> So beginning of June, I&#8217;m coming back to that because that&#8217;s also the week of WordCamp Europe and I know.</p>\n\n\n\n<p><em>Ellen Bauer:</em> So exciting.</p>\n\n\n\n<p>Birgit Pauli-Haack: It&#8217;s so exciting that we finally are to that place again that we meet up and at WordCamp Europe and if our listeners come. When you see us at the WordCamp Europe and we&#8217;re talking to somebody, it&#8217;s all just come up to us, introduce yourself and then be included in any conversation. That&#8217;s what the WordCamp is all about. It&#8217;s not that people who know each other can click together. It&#8217;s meet new people, meet new discussions, have a deeper discussion on certain WordPress topics in a face-to-face settings. So. So what&#8217;s your talk about then Ellen?</p>\n\n\n\n<p>Ellen Bauer: It&#8217;s about WooCommerce and block themes.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Oh no, you&#8217;re just kidding.</p>\n\n\n\n<p><em>Ellen Bauer:</em> Yes. Yay. So yeah, I&#8217;m available to talk about these topics actually. Anything I love to be able to meet in person. I loved last year&#8217;s being there at interim and I&#8217;m really excited to be able to to be there and getting myself up on stage. I&#8217;m a little bit frightened and my talk is going to be the last ones on the second day. So yeah, I&#8217;m not sure. I hope I won&#8217;t be nervous through the whole WordCamp two days or three days with contributor day having the talk kind of on the end. But yeah, please say hi and reach out to me as well if you see me around. </p>\n\n\n\n<p>Yeah, it&#8217;s so it I will talk about the benefits of block themes for Ecommerce because a lot of people I think kind of have the idea that block themes are great for blogs or for websites, for WordPress sites, but don&#8217;t use a block theme for Ecommerce. And I think that&#8217;s just a little bit of a perception that people put this in this box in this drawer, and it&#8217;s difficult to take WooCommerce out of that. I think once people have that kind of thought in their head that it&#8217;s not a great idea or not ready yet or so yeah, I want to give some examples to why I think that is not true. For instance the blog checkout, how much better the performance is and what kind of benefits people get. Because I think a lot of times users really don&#8217;t know about the benefits and benefits of customizing your single product page and just getting creative on what you can do in regards to maybe even different product pages. And just mainly I really want to show examples to make it just really visually appealing that you can drop in patterns and get a really customized WooCommerce experience with block themes and also way better performance and just the flexibility of it, and the ease and the speed and just all the benefits that are there. And also not forget to mention some limitations obviously that are still there that mainly come from plugin extensions WooCommerce extensions not being compatible and we are really hardly working on it. But there are a lot of extensions. Obviously some Ecommerce WooCommerce sites have limitations but I think it&#8217;s just good to highlight that and that we are working on it and remind people that maybe it&#8217;s a good idea to switch to a block theme with your Ecommerce site.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. Even if not to switch to definitely try it out and kind of see.</p>\n\n\n\n<p><em>Ellen Bauer:</em> Where that is or build a road map.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, no, I&#8217;m. I&#8217;m excited about that. I&#8217;m gonna, I will be able to come to kind of learn about all that and bring it back to our listeners later on or in the Gutenberg Times Weekend Edition kind of thing.</p>\n\n\n\n<p>Ellen Bauer: So what is the topic of your talk or workshop?</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> I&#8217;m doing a workshop and from zero to demo how to use WordPress playground to put a demo for your product together and we are probably looking at. So it&#8217;s a 75-minute workshop and we do it hands-on. We use the Playground built in Blueprint builder. We talk about the steps and the settings and how you get the different landing pages that you could do for your demo. You don&#8217;t have to start with the front end. You can go deep into it. So if you have a plugin that shows something in the, that works in the editor that you have a landing page that drops the person who wants to test it out right into the block editor of the Playground instance and have all the settings in there that your plugin needs or your theme needs to be to show off the better part of it and have that ready for one click. And you don&#8217;t have to think about a server, you don&#8217;t have to think about a database, you don&#8217;t have to think about hosting it somewhere. You just use Playground Instance and have can demo your product. So I think the workshop is going to be hands-on. It&#8217;s. It&#8217;s going really from zero. Okay, what&#8217;s this JSON file and all that and then we will build a little demo out. What are the pitfalls for content imports? How the content import needs to kind of be structured so the pictures that you need are actually showing and all these little things that sometimes trip up people who try it out.</p>\n\n\n\n<p><em>Ellen Bauer:</em> That&#8217;s exciting. I&#8217;m just wondering, do people have to register beforehand for the workshops?</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yes.</p>\n\n\n\n<p><em>Ellen Bauer:</em> How does it work?</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Registration for workshops on the website has just opened a couple of days ago or even just a couple of days ago, and you need to register and you also Registration is not all. It&#8217;s a free registration. Of course. If you already have your WordCamp ticket, you need to use the same email with which you bought your ticket and then they can match up the two tickets there. It&#8217;s also necessary that you are at the workshop 10 minutes before because if there&#8217;s a waiting list and you are not there to claim your seat, it will go to the waiting list members. Well, I&#8217;m not in. Workshops are all competing against all the rest of the talks in three tracks, so I don&#8217;t know how many people will show up. So it&#8217;s going to. It&#8217;s going to be on Friday after lunch at 2:30. No 1:30, sorry, at 1:30 in the Singapore Place, I think. Yeah. Workshops. There&#8217;s also a workshop with Milana Cap on the Interactivity API, and there is a workshop with the Block Development Cookbook with Ryan Welcher. It&#8217;s always great fun to do. And then Berislav also has a web playground workshop and that is a little bit going deeper into using it for automatic testing. So building automatic tests with WordPress Playground. And then those are the four workshops Interactivity API, automatic testing with Playground, demo site with Playground, and the Block Developer cookbook every day. Friday too and Saturday too. So it&#8217;s really cool. Well, thank you for asking.</p>\n\n\n\n<p><em>Ellen Bauer:</em> I have to register myself too.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Listener Questions</h3>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, absolutely. So we had a listener question since the previous Gutenberg Changelog podcast and one is how to override the block styles that come with the theme. </p>\n\n\n\n<p>So I did a little short post on the Gutenberg Times on how to do this. If they are registered correctly, then you can do it over the global styles in the site editor. If you can&#8217;t because they&#8217;re registered with an older version of the interface, you can definitely unregister them. So add your own block styles to it. I have the link to the how to in the show notes and they are also published on the or that particular post also published on the Gutenberg Times. It&#8217;s very short but it dives a little bit deeper into how to do that. You could also how you override it in theme JSON. This is also a it&#8217;s not a no code variation but it&#8217;s also the theme JSON is fairly human readable and it gives you an example on how the JSON needs to look so you can override it in the theme JSON. And then there&#8217;s also a resource and that&#8217;s a huge resource on custom block styles in WordPress where you get theme developers and plugin developers can learn if they haven&#8217;t yet developed six methods to do block styles. What are block styles? Block styles is a way to add CSS to a Gutenberg core block. So it&#8217;s available for the content creator in the sidebar to just switch it over to the style. So if you have an image style and you want a, you want a certain border, you want a certain radius on the border, you want a certain color on it and you want to also a shadow on it, if that&#8217;s a standard for you, the theme developer can put that into a block style, and then every time the content creator wants to create use that block, it will show it has a button to show that particular comp more complicated styling and doesn&#8217;t have to do it every time click by click by click. So it&#8217;s a one click replacing the style of the core block.</p>\n\n\n\n<p><em>Ellen Bauer:</em> One of my favorites is always the button block like outline button. I think that&#8217;s like the one of the best examples where we, where we kind of use that main button, a primary button, secondary button, outline button.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, yeah. And the core blocks come with rounded corners and that&#8217;s normally not everybody&#8217;s a fan of rounded corners, so you need to override that. But it&#8217;s relatively easy to do. You can certainly also do block styles very much more complicated than what&#8217;s in the examples there. I&#8217;ve seen some very interesting block styles for the separator or quotes and pull quotes. They can have some very intriguing designs, but you need to put them into the theme JSON so people can adopt them through the global styles, not theme JSON in the theme JSONs, or with WordPress 6.6 comes a very easy way to add block styles is to put it in a JSON file under your styles and then just have the naming conventions there in terms of which block they attribute to and what the styles are. So and then WordPress picks up that from that particular place and adds it automatically to it. So you don&#8217;t have to worry about your CSS files. You don&#8217;t have to worry about enqueuing it on the editor or enqueuing it on the front end. WordPress does that all for you. So box hunts have been in Gutenberg for or in the since the beginning but this is now the most streamlined way to get them into the theme.</p>\n\n\n\n<p><em>Ellen Bauer:</em> And I, I always love that because you can reuse it. It&#8217;s like a, just a snippet a component, and you can you reuse it on multiple projects. That is like such a game changer, I think.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Absolutely. Yeah. And you can build your own style kind of library. Yeah. And then just move in the ones that you need. Yeah. If you want to go really out, then you can actually put together your own webpack building process where you kind of pull depending on which parameters pull in the particular styles, the patterns and the templates for a new bespoke theme for a client. So yeah, I like that. It&#8217;s all now file based and with less code, even more power. Yeah, so it&#8217;s pretty cool. So the two articles will be in the show notes linked. </p>\n\n\n\n<h3 class=\"wp-block-heading\">What’s Released &#8211; WPCLI Update</h3>\n\n\n\n<p>Now we come to the what&#8217;s Released section and I just wanted to give a shout out to Alain Schlesser who has done a tremendous job in maintaining the WPCLI components or features, and he just released another update for the version 2.12. Of course the release notes will be linked in the show notes, but I just wanted to highlight a few things. </p>\n\n\n\n<p>Now it&#8217;s very developer focused. That&#8217;s why it probably doesn&#8217;t get so many shoutouts on all the WordPress news. But it&#8217;s so called plug and patch commands for caches and transients. That means it can directly manipulate those individual entries. Wired the WPCLI command. And then there are the post list. Can now handle complex query flags in a JSON notation, which just makes it much easier to build the commands out with a text underscore query, which means taxonomy query, meter query and posted date fields. Just to add those with a flag in your command. Post meta can now be forced to return a single value. Sometimes post meta has a certain key, has multiple values over the course of a site existence. So you can now flag WordPress to only return the latest one and you don&#8217;t have to deal with all the other entries for that particular key value. That&#8217;s a pretty good neat feature there. The make JSON command is part of the WPCLI International component and it&#8217;s more powerful now. You can set the custom text domain, and you can also define the file extensions to parse. So that&#8217;s a side note. WPI18N make-JSON is the command that is used for JavaScript internationalization on WordPress with Gutenberg. A lot of interfaces have been built through JavaScript and they also need to be translated. So this helps you with organizing those strings for translation. Yeah, and WPCLI is then also fully compatible with PHP 8.4. So if you found that exciting as I do, go and read the release notes because Alain has published quite a few example code and commands and what the output is from those commands. So you can improve your WPCLI knowledge right there from the release notes. Yeah, so that was one thing. Do you want to talk us through the WordPress 6.8 release?</p>\n\n\n\n<h3 class=\"wp-block-heading\">WordPress 6.1.8 Release</h3>\n\n\n\n<p><em>Ellen Bauer:</em> Yes. So the 6.81 was the maintenance release and there were a few, maybe you have to help me out, Birgit.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. So yeah, Aaron Jorbin mentioned that there are 15 bugs through core and Block editor that had been released on April 30th. So the most important one is the regression fix that the meta boxes area had unwanted size handles and it broke the auto scroll. So you couldn&#8217;t just scroll down in a post to your meta boxes and fill them out. You had to kind of grab the handle and push pull them up because they&#8217;re now in a separate iframe or were. And that didn&#8217;t work well for many sites. And that&#8217;s why we have a release two weeks after the main release that is going to be fixed. So there was a revert on that feature. Also a revert was the edit site link.</p>\n\n\n\n<p>Ellen Bauer: The edit site link?</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, in the top admin bar it had the behavior that when you click on it, you landed automatically on the template of the page that you were looking at. But in 6.8 it changed that. You always went back to the first page of the site editor, and somehow the muscle memory of a lot of people who were accustomed to the other one, it was very irritating for them, and they made their feedback known and it&#8217;s definitely a 50/50 split. And so they reverted that change and are now thinking of what could be a better solution. And maybe it needs to be an edit site menu. Yeah. With multiple different menu items in there like edit template and a pattern edit page kind of thing. But yeah, that&#8217;s out in discussion and I don&#8217;t know where it&#8217;s going to land. But at least we have the previous fix again in there. And then also. Oh, and the rest API handing out the sticky post was a little haphazardous and it&#8217;s now fixed. The full list is in the release note, and we put them in the show notes of course. But yeah, update definitely. Yeah. Because it will be a more streamlined experience. And yeah, a lot of releases today. So create Block theme was released with 2.7. Do you want to grab that?</p>\n\n\n\n<p><em>Ellen Bauer:</em> Yeah, I can, I can take over. So yeah, I love that plugin. I use it quite a lot and it had been. It&#8217;s really improved over the years. And so if you maybe haven&#8217;t checked it out yet or don&#8217;t even know that it exists, it&#8217;s really, really cool for quickly creating block themes or child themes or just kind of creating patterns, like building out your patterns. So some updates that were done in the latest release 2.7 was that there was a bug with the figcaptions not being translated and that was fixed for image and video blocks. The icons for the sidebar. I think there were problems with translations and right to left language. The icons weren&#8217;t on the right side or. And the help kind of the help button wasn&#8217;t aligned. So you can see the before and after screenshots of the changes. And I think the chevron. I&#8217;m not sure if I&#8217;m saying that word correctly. I think, correct me if I&#8217;m wrong, but I never know how to pronounce the chevron. Yeah, they weren&#8217;t switching on to the other side, so that was fixed. And I think also some sizing for the icons, and then php CS removed unused files and it just released files. I&#8217;m not 100% sure what was the problem there.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> I don&#8217;t know what the problem was, but it&#8217;s fixed.</p>\n\n\n\n<p><em>Ellen Bauer:</em> Just some unused files were deleted.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, there were some unused files that were not used in the composer when you were putting together a development environment for the plugin. So because yeah, contributors want to contribute but they want to make sure that the environment is in the right place. Then there were some. Yeah, also code quality fixes and the wp-env that&#8217;s the testing WordPress the configuration has been improved and offers now certain environment variables that you can set on the command.</p>\n\n\n\n<p><em>Ellen Bauer: </em>So the create block, the major. Say again that were the major updates for that release.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> There&#8217;s right now a discussion going on on GitHub and on the repo about what to do with the pattern management because the advantage of putting the patterns in there doesn&#8217;t offset the disadvantages while working with it in the site. So what it does right now is when you say okay, save the patterns, it will remove the patterns from the. From the database and put it all in the theme. But of course all the sync patterns will become normal patterns because in a theme you don&#8217;t have sync patterns. So it&#8217;s kind of that in between problem that sync patterns are not yet available for themes but you actually want them in your site. So it confuses people quite a bit. And that&#8217;s a discussion on how not to confuse people, which is actually a pretty good goal.</p>\n\n\n\n<p><em>Ellen Bauer:</em> It&#8217;s tough.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Totally tough. Yeah. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Gutenberg 20.7</h3>\n\n\n\n<p>So, and that brings us to the Gutenberg releases we have Gutenberg 20.7 came out with 22 contributors. Two of them were first timers. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Enhancements</h3>\n\n\n\n<p>And I&#8217;ll start with the format library. The format library is the library that controls the dropdown on the block toolbar with different formatting options. And now you can also set the alpha value for the highlight. So you could actually highlight some words in a paragraph and click on the format drop down, and then highlight that and it would give you a color theme. But now you can also set the alpha value for the highlight manually. That format features are now also available for the details block. Now you can highlight stuff in the details blocks in the summary or in the expansion thing.</p>\n\n\n\n<p><em>Ellen Bauer:</em> Yeah, I think there was some kind of hard coded things in there that you couldn&#8217;t do that. And now you can do all the formatting in the details block.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, what was hard coded was the allow list in the details block. So they removed that. So now the formatting, all the formatting is available for the details block.</p>\n\n\n\n<p><em>Ellen Bauer:</em> The next one was the navigation in the site view. Now it automatically the default is that it expanded. And before it was not expanded, you had to have an extra click to. To open the sub menus. And in the PR there&#8217;s a before and after. And it&#8217;s really an improvement because you can see right away the entire menu. I love the site view.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Oh, the it&#8217;s actually a list called List.</p>\n\n\n\n<p><em>Ellen Bauer:</em> View, the list view and also in the, the like in the page editor in the template on both sides, it&#8217;s. It&#8217;s now automatic by default expanded. Is that correct?</p>\n\n\n\n<p>Birgit Pauli-Haack: Oh yeah, right. Right now the navigation block, when you try to edit it, it has a nice sidebar as well. And it&#8217;s also there expanded. </p>\n\n\n\n<p>So next item I want to talk about is the table block. Table block doesn&#8217;t get a whole lot of love from Gutenberg developers, but it&#8217;s actually pretty cool. And what&#8217;s mostly cool about it is when you have a markdown table from GitHub or from any other. So even if you work with AIs, I had a list of posts with views, and all that and the AI created that, but I told them to give me a markdown table so when I do, I can copy paste it into a post. And that was really cool because it now also preserves the column alignment in the pasting. Before you had to just fiddle around with it quite a bit on certain things where it wouldn&#8217;t come over. But that&#8217;s actually a really good feature to be that it possible that you can paste markdown tables. Not only markdown that we knew, but you can also mark down tables and it&#8217;s pulling it into a table block. I think that was it for 20.7. Yep. Okay, that brings us to 20.8. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Gutenberg 20.8</h3>\n\n\n\n<p>And 20.8 hasn&#8217;t been released yet when we record the show, but the release candidate was out and that&#8217;s what our changelog is about. </p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Enhancements</strong></h3>\n\n\n\n<p>So the Create block package can now also have a text domain flag when you start out your scaffolding. So it will be repeated throughout the plugin your text domain for the translation as well. And you don&#8217;t have to manually put this all in.</p>\n\n\n\n<p><em>Ellen Bauer:</em> I think the next one was that the text is now customizable for the next and previous button text, which wasn&#8217;t possible before to customize the text. That was an improvement.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Absolutely. There are now two new properties for the component available where you can customize it by code when you use them in your plugins, and that&#8217;s for the guide component. The guide is what pops up but nobody reads is the guide that comes up with the block editor. If you first time install a site and go into the editor. That&#8217;s the guide. Yeah. You can use it also for your plugins, and you can use it also for your theme. If you want to add text in there you to guide your users to certain things and then also makes those buttons are now customizable.</p>\n\n\n\n<p><em>Ellen Bauer:</em> The next one was search functionality for page templates. When you want to change the page template or swap them out. There wasn&#8217;t a way to understand correctly to like a proper or easy way to search for your templates if you have a lot of them. And now that&#8217;s improved. Is that correct, Birgit?</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And it&#8217;s also for the pattern selection search.</p>\n\n\n\n<p><em>Ellen Bauer:</em> Oh, the same.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> It&#8217;s both. Yeah.</p>\n\n\n\n<p><em>Ellen Bauer:</em> I think that is really, really helpful.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. The testing instructions starts out, make sure you have at least 15 templates in there.</p>\n\n\n\n<p><em>Ellen Bauer:</em> Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> That cannot be applied to a page.</p>\n\n\n\n<p><em>Ellen Bauer:</em> Which can quickly happen. And that&#8217;s cool to have custom templates, right?</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. But that&#8217;s&#8230;</p>\n\n\n\n<p><em>Ellen Bauer:</em> You need a lot.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> You definitely need a search component in there. Yes.</p>\n\n\n\n<p><em>Ellen Bauer:</em> To roll through them.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. The next one mentions the reverse of the split view for the meta boxes that were in 28. It was released in Gutenberg, but it then was backported to the 6.8.1 release. So this is definitely already out and it&#8217;s also in the WordPress versions. Yeah, the widget editor. I don&#8217;t. I didn&#8217;t even know we had a widget editor.</p>\n\n\n\n<h3 class=\"wp-block-heading\">New API</h3>\n\n\n\n<p><em>Ellen Bauer: </em>Yeah, I was just saying I didn&#8217;t quite understand that one, to be honest.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. In the classic theme you have the widget menu and that is for a long time already a block based interface. So you need to lock the widget saving or the update button and all that. So now you can lock some of the functionality because not everybody should be able to do stuff there. Yeah. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Bug Fixes</h3>\n\n\n\n<p>And then there are some fixes on the block editor. Now that was actually always a pet peeve of mine that when you get invalid blocks that you can&#8217;t at least edit the HTML because you don&#8217;t know what needs to be fixed. And now you can edit the HTML for invalid blocks.</p>\n\n\n\n<p><em>Ellen Bauer: </em>I do like that a lot too because sometimes it happens and you have that code there and you like want to get in.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. The last time I think I had.</p>\n\n\n\n<p><em>Ellen Bauer:</em> It with the no you can chat.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Pack with Jetpack AI features. Yeah. Somehow when I mark two paragraphs and then the first paragraph becomes invalid when I hit on the AI feature and it was only because there&#8217;s one of the HTML wasn&#8217;t closed well enough. I need to figure that out. But do a bug report. But yeah, it would have been really helpful to. To just manipulate the HTML of that. The next one is that PR or update will prevent spacer block to have a negative width when it&#8217;s used in a row block. That offsets all kinds of different things and that can definitely ruins your design. You can have a spacer block with a negative margin or negative width. That&#8217;s no problem. Yeah, but it doesn&#8217;t.</p>\n\n\n\n<p><em>Ellen Bauer:</em> But not inside a roadblock.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, because that.</p>\n\n\n\n<p><em>Ellen Bauer:</em> So now it&#8217;s chooses to design the browser detects. Hey, I&#8217;m a spacer block inside a row block and the negative margin option is not available any longer. That is cool.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. And there&#8217;s a quality fix on that. Some of the block HTML now get box sizing property so that the overflow into the next block or into the next design element can be prevented. That&#8217;s definitely a good fix because some people are kind of getting really elaborate on those designs. And then how do you handle that? </p>\n\n\n\n<h3 class=\"wp-block-heading\">Documentation</h3>\n\n\n\n<p>We already mentioned the create block and the text domain flag. So that&#8217;s now in the create block readme. The block bindings API has a post meta limitation. This new update prevents protected post meta that are prefixed with underscore that cannot be used for block bindings. And the post meta also has to be available in the REST API. Those are the two limitations and they were not yet mentioned in the documentation. And also block bindings are only available for four blocks. So that&#8217;s the heading block, the paragraph block, the image block and the button block. All other blocks cannot yet handle block bindings. So those are all three limitations there. And now it&#8217;s in the documentation with working on those block style articles I found that the latest register block style parameter that came in with 6.6 called style underscore data hasn&#8217;t been documented which has been done now because that&#8217;s. That&#8217;s the most. That&#8217;s a great way to use it in a plugin to use the style underscore data because only the styled underscore data for the register block style function also puts the styles into the global styles for content creators to modify them. All the others you can do it on the page by page level. It&#8217;s in the styles but you cannot change them globally for a site. Yeah, that&#8217;s interesting. That was an interesting find there. So. Yeah, those are our Gutenberg releases. Wow, that&#8217;s. That&#8217;s cool. We are done with that. The release is either Friday May 9th for 20.8 or even today. We are recording this on May 8th. Well, we come to the end of things. So Ellen, I wish you safe travels to Europe.</p>\n\n\n\n<p><em>Ellen Bauer:</em> Thank you.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> When are you flying in? I don&#8217;t want to stalk you.</p>\n\n\n\n<p><em>Ellen Bauer:</em> Saturday night and arriving Sunday early morning and then heading actually to Berlin for a team meetup first. Then heading to Sweden for another meetup and then kind of taking a little family holiday break before arriving freshly rested in Basel.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. And with all the updates from the team. Freshly rested. So.</p>\n\n\n\n<p><em>Ellen Bauer:</em> Yes.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. You get the latest from WooCommerce for. From Ellen Bower at WordCamp Europe.</p>\n\n\n\n<p><em>Ellen Bauer:</em> Yeah, it&#8217;s going to be an exciting trip. I&#8217;m looking forward to coming to Europe. Should be fun. Is there any good weather I&#8217;ve seen the weather.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> It&#8217;s like quite coldish beginning of June. It&#8217;s normally pretty warm during the day. Yeah. Especially in that area that&#8217;s always a little bit ahead towards summer than the rest of Germany.</p>\n\n\n\n<p><em>Ellen Bauer:</em> The warmer.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, because it&#8217;s a little.</p>\n\n\n\n<p><em>Ellen Bauer:</em> Yeah, I know that&#8217;s. I didn&#8217;t bring any warm clothes though.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Well, I would get rid of.</p>\n\n\n\n<p><em>Ellen Bauer:</em> I think I have to buy one.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. Yeah. I&#8217;m. We are actually heading out for vacation at the end of June. So we have team meetup at the end of June. And then afterwards, right away, I&#8217;m going to be in Norway for our family vacation. So I don&#8217;t know when we have the next, I think between WordCamp Europe and end of June, we will have another Gutenberg Changelog episode. And until then, as always, the show notes will be published on gutenbergtimes.com forward slash podcast. This is episode 117. 117. And if you have questions or suggestions, as you know, we are gonna discuss them on the next episode or in a post on Gutenberg Times or both. And if you have any news that you want to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a> that&#8217;s <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a> or ping me on Twitter, Blue Sky, Mastodon. And that&#8217;s all. All the ends are open. So thank you for coming, Ellan, and thank you to our listeners. And this is goodbye for me until the next time.</p>\n\n\n\n<p><em>Ellen Bauer:</em> Yeah, take care, everyone. And yeah, please reach out to us. There&#8217;s any questions also for my side.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> All right.</p>\n\n\n\n<p><em>Ellen Bauer: </em>Thank you for having me, Birgit.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Oh, you&#8217;re welcome. </p>\n\n\n\n<p><em>Ellen Bauer:</em> Thank you.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> It is.</p>\n\n\n\n<p><em>Ellen Bauer:</em> Bye Bye.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 11 May 2025 09:00:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Gutenberg Times: Seven Tasks to a Custom Block Theme: Anders Norén’s Weekend Workflow\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=28477\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150274:\"<p>Have you ever wondered how a modern WordPress block theme comes together &#8211; from first sketches to a polished, production-ready design? Over a single weekend, Anders Norén built Pulitzer, a new block theme, from the ground up. In this post, I’ll walk you through Anders’ process. I&#8217;ll highlight the tools, decisions, and little tricks that helped him move quickly.</p>\n\n\n\n<blockquote class=\"wp-block-quote has-accent-color has-text-color has-link-color has-normal-font-size wp-elements-7e7c6e4a188deb9c1cff659965fc3217 is-layout-flow wp-block-quote-is-layout-flow\">\n<p>&#8220;I have the house to myself this weekend, so I thought I’d try something new. My goal is to build and submit a new free block theme to before Monday. While I work, I’ll describe my dev process in this thread.&#8221;</p>\n<cite>Anders Norén on X (formerly known as Twitter) </cite></blockquote>\n\n\n\n<p>About a year ago, <strong>Anders Norén</strong> posted an X (formerly known as Twitter) thread about his process. He gave me permission to collect the tweets into a blog post. Since then, he deleted his account and content on X. The valuable information is not lost. Here you go.</p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p class=\"has-normal-font-size\"><strong>Table of contents</strong></p>\n\n\n\n<nav class=\"wp-block-table-of-contents\"><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/#the-inspiration-and-seven-tools\">The inspiration and seven tools</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/#figma\">Figma</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/#jetpack-and-block-bindings\">Jetpack and Block Bindings </a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/#studio-app\">Studio app </a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/#wordpress-com-hosting\">WordPress.com hosting</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/#create-block-theme\">Create Block Theme</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/#twenty-twenty-four\">Twenty Twenty-Four</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/#first-task-remove-many-things\">First task: remove many things</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/#second-task-update-theme-json\">Second task: update theme.json</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/#spacing-and-colors\">Spacing and Colors</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/#typography\">Typography</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/#third-task-templates-and-patterns\">Third task: Templates and Patterns</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/#header-and-footer\">Header and Footer</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/#archives\">Archives</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/#alternative-post-layouts\">Alternative post layouts</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/#404-template-and-the-search-block\">404-template and the Search block</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/#fourth-task-handling-blocks\">Fourth task: handling blocks</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/#jetpack-blocks\">Jetpack blocks</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/#block-bindings-api-blocks\">Block Bindings API blocks</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/#the-copyright-year-in-the-footer\">The copyright year in the footer</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/#reading-time\">Reading Time </a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/#comments-count\">Comments count </a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/#fifth-task-patterns\">Fifth Task: Patterns</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/#the-newsletter-page-pattern\">The newsletter page pattern</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/#the-resume-page-pattern\">The resume page pattern</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/#contact-page-pattern\">Contact Page Pattern</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/#sixth-task-style-variations\">Sixth Task: Style Variations</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/#seventh-task-submit-to-the-repository\">Seventh Task: Submit to the Repository</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/#who-is-anders-noren\">Who is Anders Norén?</a></li></ol></nav>\n</div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"the-inspiration-and-seven-tools\">The inspiration and seven tools</h2>\n\n\n\n<p>The theme Norén set out to build that weekend is called Pulitzer. It is meant for long-form writing with a special consideration for writers with newsletters. </p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"figma\">Figma</h3>\n\n\n\n<p>You can find <a href=\"https://www.figma.com/proto/XGptBeSLNzlrw0hzeNnWdb/Pulitzer?page-id=50%3A1594&amp;type=design&amp;node-id=50-1595&amp;viewport=938%2C675%2C0.08&amp;t=jQKrUgZF0ItqgXzw-1&amp;scaling=scale-down-width\">a Figma presentation here</a>. The video walks you through the Pulitzer Figma space.</p>\n\n\n\n		<figure class=\"wp-block-jetpack-videopress jetpack-videopress-player\">\n			<div class=\"jetpack-videopress-player__wrapper\"> </div>\n			<figcaption></figcaption>\n			\n		</figure>\n		\n\n\n<h3 class=\"wp-block-heading\" id=\"jetpack-and-block-bindings\">Jetpack and Block Bindings </h3>\n\n\n\n<p>Some elements in the design stand out:  </p>\n\n\n\n<ol class=\"wp-block-list\">\n<li>Reading time </li>\n\n\n\n<li>Like button </li>\n\n\n\n<li>Share buttons </li>\n\n\n\n<li>Newsletter signup </li>\n</ol>\n\n\n\n<p>For a self-hosted WordPress site, those blocks are not available out of the box unless you install the <a href=\"https://wordpress.org/plugins/jetpack/\">Jetpack plugin</a>. For the reading time, comment count and copyright year in the footer, Norén experimented with the <a href=\"https://developer.wordpress.org/block-editor/reference-guides/block-api/block-bindings/\">Block Bindings API.</a></p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<figure class=\"wp-block-image size-full\"><img alt=\"Mockup of a single post representation in a list of post with red time, number of likes and number of comments \" class=\"wp-image-40085\" height=\"228\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/04/Screenshot-2025-04-22-at-17.30.23.png?resize=601%2C228&#038;ssl=1\" width=\"601\" /></figure>\n</div></div>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"studio-app\">Studio app </h3>\n\n\n\n<p>This was also the first time, Norén used the <a href=\"https://developer.wordpress.com/studio/\">Studio app by WordPress.com</a> for local development. It&#8217;s free and open-source. </p>\n\n\n\n<blockquote class=\"wp-block-quote has-accent-color has-text-color has-link-color wp-elements-c971a24caa690fbf8f4246ad45350563 is-layout-flow wp-block-quote-is-layout-flow\">\n<p>&#8220;First impressions are very good. It probably doesn’t tick all the boxes for people with more advanced needs, but for what I’m doing, it seems perfect.&#8221;</p>\n\n\n\n<p><em>Anders Norén</em></p>\n</blockquote>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"Screenshot of Studio, the free and open-source local development tool by WordPress.com\" class=\"wp-image-28483\" height=\"458\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/05/GMKJXquWoAAl50y.jpeg?resize=652%2C458&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"wordpress-com-hosting\">WordPress.com hosting</h3>\n\n\n\n<p>Norén hosts his sites on WordPress.com. Because of the <a href=\"https://developer.wordpress.com/docs/developer-tools/github-deployments/\">GitHub Deployment </a> feature, he found it easy to keep the Pulitzer demo site updated.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"create-block-theme\">Create Block Theme</h3>\n\n\n\n<p>Another tool he used is the community plugin <a href=\"https://wordpress.org/plugins/create-block-theme/\">Create Block theme</a>. Once installed, it helps you make design decisions in the Site Editor and save them back to your theme&#8217;s file.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"twenty-twenty-four\">Twenty Twenty-Four</h3>\n\n\n\n<blockquote class=\"wp-block-quote has-accent-color has-text-color has-link-color has-normal-font-size wp-elements-16a3247975630952417fec2a2e718fb0 is-layout-flow wp-block-quote-is-layout-flow\">\n<p>&#8220;Twenty Twenty-Four is my go-to starting point on most projects these days.&#8221; </p>\n<cite>Anders Norén</cite></blockquote>\n\n\n\n<p>He also found that it&#8217;s probably the best default theme ever. He gave a special shout-out to the theme leads <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> and <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a>.</p>\n\n\n\n<p>Both the demo and the GitHub repo are publicly accessible:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://t.co/bosfwXWjkU\" rel=\"noreferrer noopener\" target=\"_blank\">https://pulitzer.andersnoren.se</a></li>\n\n\n\n<li><a href=\"https://github.com/andersnoren/pulitzer\">https://github.com/andersnoren/pulitzer</a></li>\n</ul>\n\n\n\n<p>With all the tools in place, Anders Norén ventured to build the WordPress theme.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"first-task-remove-many-things\">First task: remove many things</h2>\n\n\n\n<p>Norén began by taking the <a href=\"https://wordpress.org/themes/twentytwentyfour/\">Twenty-Twenty-Four</a> default theme. He started with removing all the templates, template parts, patterns, fonts, images, and styles that won&#8217;t be needed. Then, he renamed the rest.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"Screenshot of the list of files \" class=\"wp-image-28485\" height=\"774\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/05/GMKVaZ8XkAENvj6.jpeg?resize=652%2C774&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"second-task-update-theme-json\">Second task: update theme.json</h2>\n\n\n\n<p>In a second step, Norén updated the theme settings with those from the design in the <code>theme.json</code> file</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>spacing sizes, </li>\n\n\n\n<li>colors, and </li>\n\n\n\n<li>typography</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"spacing-and-colors\">Spacing and Colors</h3>\n\n\n\n<div class=\"wp-block-columns alignwide is-layout-flex wp-container-core-columns-is-layout-9d6595d7 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<div class=\"wp-block-kevinbatdorf-code-block-pro cbp-has-line-numbers\"><span>HTML</span><span class=\"code-block-pro-copy-button\" style=\"color: #575279; display: none;\" tabindex=\"0\"><svg fill=\"none\" stroke=\"currentColor\" stroke-width=\"2\" viewBox=\"0 0 24 24\" xmlns=\"http://www.w3.org/2000/svg\"><path class=\"with-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path><path class=\"without-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path></svg></span><pre class=\"shiki rose-pine-dawn\" style=\"background-color: #faf4ed;\" tabindex=\"0\"><code><span class=\"line\"><span style=\"color: #575279;\">&quot;spacing&quot;: {</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">			&quot;spacingScale&quot;: {</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				&quot;steps&quot;: 0</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">			},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">			&quot;spacingSizes&quot;: [</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;name&quot;: &quot;4px&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;size&quot;: &quot;4px&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;slug&quot;: &quot;10&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;name&quot;: &quot;8px&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;size&quot;: &quot;8px&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;slug&quot;: &quot;20&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;name&quot;: &quot;12px&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;size&quot;: &quot;12px&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;slug&quot;: &quot;30&quot;</span></span>\n<span class=\"line cbp-see-more-line cbp-see-more-transition\"><span style=\"color: #575279;\">				},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;name&quot;: &quot;16px&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;size&quot;: &quot;16px&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;slug&quot;: &quot;40&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;name&quot;: &quot;24px&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;size&quot;: &quot;24px&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;slug&quot;: &quot;50&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;name&quot;: &quot;32px&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;size&quot;: &quot;32px&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;slug&quot;: &quot;60&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;name&quot;: &quot;48px&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;size&quot;: &quot;clamp(32px, 4.8vw, 48px)&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;slug&quot;: &quot;70&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;name&quot;: &quot;64px&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;size&quot;: &quot;clamp(48px, 6.4vw, 64px)&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;slug&quot;: &quot;80&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;name&quot;: &quot;96px&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;size&quot;: &quot;clamp(64px, 9.6vw, 96px)&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;slug&quot;: &quot;90&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;name&quot;: &quot;128px&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;size&quot;: &quot;clamp(64px, 12.8vw, 128px)&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;slug&quot;: &quot;100&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;name&quot;: &quot;Body Margin (24px)&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;size&quot;: &quot;24px&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;slug&quot;: &quot;body-margin&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				}</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">			],</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">			&quot;units&quot;: [</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				&quot;%&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				&quot;px&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				&quot;em&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				&quot;rem&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				&quot;vh&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				&quot;vw&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">			]</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">		}</span></span></code></pre><div class=\"cbp-see-more-container\"><div style=\"background-color: #faf4ed; height: 50%;\"></div><span class=\"cbp-see-more-simple-btn cbp-see-more-simple-btn-hover\" style=\"color: #36334b; background-color: #efdcc5; padding: 6px 14px; cursor: default; border-radius: 6px;\" tabindex=\"0\">Click to see more</span></div></div>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<div class=\"wp-block-kevinbatdorf-code-block-pro cbp-has-line-numbers\"><span>HTML</span><span class=\"code-block-pro-copy-button\" style=\"color: #575279; display: none;\" tabindex=\"0\"><svg fill=\"none\" stroke=\"currentColor\" stroke-width=\"2\" viewBox=\"0 0 24 24\" xmlns=\"http://www.w3.org/2000/svg\"><path class=\"with-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path><path class=\"without-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path></svg></span><pre class=\"shiki rose-pine-dawn\" style=\"background-color: #faf4ed;\" tabindex=\"0\"><code><span class=\"line\"><span style=\"color: #575279;\">&quot;color&quot;: {</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">			&quot;defaultPalette&quot;: false,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">			&quot;palette&quot;: [</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;color&quot;: &quot;#FFFFFF&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;name&quot;: &quot;Base&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;slug&quot;: &quot;base&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;color&quot;: &quot;#F9F9F9&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;name&quot;: &quot;Base / Two&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;slug&quot;: &quot;base-2&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;color&quot;: &quot;#191716&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;name&quot;: &quot;Contrast&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;slug&quot;: &quot;contrast&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				{</span></span>\n<span class=\"line cbp-see-more-line \"><span style=\"color: #575279;\">					&quot;color&quot;: &quot;#666666&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;name&quot;: &quot;Contrast / Two&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;slug&quot;: &quot;contrast-2&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;color&quot;: &quot;#767676&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;name&quot;: &quot;Contrast / Three&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;slug&quot;: &quot;contrast-3&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;color&quot;: &quot;#DADADA&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;name&quot;: &quot;Contrast / Four&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;slug&quot;: &quot;contrast-4&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;color&quot;: &quot;#EEEEEE&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;name&quot;: &quot;Contrast / Five&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;slug&quot;: &quot;contrast-5&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				}</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">			]</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">		}</span></span></code></pre><div class=\"cbp-see-more-container\"><div style=\"background-color: #faf4ed; height: 50%;\"></div><span class=\"cbp-see-more-simple-btn cbp-see-more-simple-btn-hover\" style=\"color: #36334b; background-color: #efdcc5; padding: 6px 14px; cursor: default; border-radius: 6px;\" tabindex=\"0\">Click to see more</span></div></div>\n</div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"typography\">Typography</h3>\n\n\n\n<div class=\"wp-block-columns alignwide is-layout-flex wp-container-core-columns-is-layout-9d6595d7 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<div class=\"wp-block-kevinbatdorf-code-block-pro cbp-has-line-numbers\"><span>HTML</span><span class=\"code-block-pro-copy-button\" style=\"color: #575279; display: none;\" tabindex=\"0\"><svg fill=\"none\" stroke=\"currentColor\" stroke-width=\"2\" viewBox=\"0 0 24 24\" xmlns=\"http://www.w3.org/2000/svg\"><path class=\"with-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path><path class=\"without-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path></svg></span><pre class=\"shiki rose-pine-dawn\" style=\"background-color: #faf4ed;\" tabindex=\"0\"><code><span class=\"line\"><span style=\"color: #575279;\">&quot;fontFamilies&quot;: [</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;fontFace&quot;: [</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">						{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">							&quot;fontFamily&quot;: &quot;Newsreader&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">							&quot;fontStretch&quot;: &quot;normal&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">							&quot;fontStyle&quot;: &quot;normal&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">							&quot;fontWeight&quot;: &quot;200 900&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">							&quot;src&quot;: [</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">								&quot;file:./assets/fonts/newsreader/newsreader-var.woff2&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">							]</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">						},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">						{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">							&quot;fontFamily&quot;: &quot;Newsreader&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">							&quot;fontStretch&quot;: &quot;normal&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">							&quot;fontStyle&quot;: &quot;italic&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">							&quot;fontWeight&quot;: &quot;200 900&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">							&quot;src&quot;: [</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">								&quot;file:./assets/fonts/newsreader/newsreader-var-italic.woff2&quot;</span></span>\n<span class=\"line cbp-see-more-line \"><span style=\"color: #575279;\">							]</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">						}</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					],</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;fontFamily&quot;: &quot;\\&quot;Newsreader\\&quot;, ui-serif, \\&quot;Times New Roman\\&quot;, serif&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;name&quot;: &quot;Newsreader&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;slug&quot;: &quot;body&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;fontFamily&quot;: &quot;ui-sans-serif, -apple-system, BlinkMacSystemFont, \\&quot;Segoe UI\\&quot;, Roboto, \\&quot;Helvetica Neue\\&quot;, sans-serif&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;name&quot;: &quot;System Sans-serif&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;slug&quot;: &quot;system-sans-serif&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;fontFamily&quot;: &quot;ui-serif, \\&quot;Times New Roman\\&quot;, serif&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;name&quot;: &quot;System Serif&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;slug&quot;: &quot;system-serif&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				}</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">			],</span></span></code></pre><div class=\"cbp-see-more-container\"><div style=\"background-color: #faf4ed; height: 50%;\"></div><span class=\"cbp-see-more-simple-btn cbp-see-more-simple-btn-hover\" style=\"color: #36334b; background-color: #efdcc5; padding: 6px 14px; cursor: default; border-radius: 6px;\" tabindex=\"0\">Click to see more</span></div></div>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<div class=\"wp-block-kevinbatdorf-code-block-pro cbp-has-line-numbers\"><span>HTML</span><span class=\"code-block-pro-copy-button\" style=\"color: #575279; display: none;\" tabindex=\"0\"><svg fill=\"none\" stroke=\"currentColor\" stroke-width=\"2\" viewBox=\"0 0 24 24\" xmlns=\"http://www.w3.org/2000/svg\"><path class=\"with-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path><path class=\"without-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path></svg></span><pre class=\"shiki rose-pine-dawn\" style=\"background-color: #faf4ed;\" tabindex=\"0\"><code><span class=\"line\"><span style=\"color: #575279;\">&quot;fontSizes&quot;: [</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;fluid&quot;: false,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;name&quot;: &quot;XXS&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;size&quot;: &quot;12px&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;slug&quot;: &quot;xx-small&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;fluid&quot;: false,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;name&quot;: &quot;XS&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;size&quot;: &quot;14px&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;slug&quot;: &quot;x-small&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;fluid&quot;: false,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;name&quot;: &quot;Small&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;size&quot;: &quot;16px&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;slug&quot;: &quot;small&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				},</span></span>\n<span class=\"line cbp-see-more-line \"><span style=\"color: #575279;\">				{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;fluid&quot;: false,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;name&quot;: &quot;Medium&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;size&quot;: &quot;18px&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;slug&quot;: &quot;medium&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;fluid&quot;: false,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;name&quot;: &quot;Large&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;size&quot;: &quot;21px&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;slug&quot;: &quot;large&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;fluid&quot;: {</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">						&quot;max&quot;: &quot;24px&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">						&quot;min&quot;: &quot;21px&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;name&quot;: &quot;XL&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;size&quot;: &quot;24px&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;slug&quot;: &quot;x-large&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;fluid&quot;: {</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">						&quot;max&quot;: &quot;32px&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">						&quot;min&quot;: &quot;24px&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;name&quot;: &quot;XXL&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;size&quot;: &quot;32px&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;slug&quot;: &quot;xx-large&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;fluid&quot;: false,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;name&quot;: &quot;Massive&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;size&quot;: &quot;clamp( 96px, 19.2vw, 128px )&quot;,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					&quot;slug&quot;: &quot;massive&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				}</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">			],</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">			&quot;writingMode&quot;: true</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">		}</span></span></code></pre><div class=\"cbp-see-more-container\"><div style=\"background-color: #faf4ed; height: 50%;\"></div><span class=\"cbp-see-more-simple-btn cbp-see-more-simple-btn-hover\" style=\"color: #36334b; background-color: #efdcc5; padding: 6px 14px; cursor: default; border-radius: 6px;\" tabindex=\"0\">Click to see more</span></div></div>\n</div>\n</div>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p class=\"has-accent-color has-text-color has-link-color wp-elements-3bf281a348d19a518076a91dab2b33d5\">&#8220;With the theme settings in place, it&#8217;s time to put them to use in block and element-specific styles. This is when the theme starts taking shape. You can do this in the site editor, but it&#8217;s faster to edit theme.json directly. Also, many styles can&#8217;t be changed in the interface,&#8221; Norén wrote.</p>\n</blockquote>\n\n\n\n<p>As the new theme, <em>Pulitzer</em> doesn&#8217;t have any working templates yet, Norén checked the <code>theme.json</code> styles in the Site editor Stylebook view. You get the vibe of the theme. You can also use it to make sure you haven&#8217;t forgotten any styling for core blocks.</p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped wp-block-gallery-1 is-layout-flex wp-block-gallery-is-layout-flex\">\n<figure class=\"wp-block-image size-large\"><img alt=\"Screenshot of the Pulitzer theme in the Stylebook \" class=\"wp-image-28488\" height=\"652\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/05/GMKuvwxWsAA1Ws4.jpeg?resize=652%2C652&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"Screenshot of the Pulitzer theme in the Stylebook \" class=\"wp-image-28489\" height=\"652\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/05/GMKu13MWcAAk1Lo.jpeg?resize=652%2C652&#038;ssl=1\" width=\"652\" /></figure>\n</figure>\n</div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"third-task-templates-and-patterns\">Third task: <strong>Templates and Patterns</strong></h2>\n\n\n\n<p>This is the moment to work on the theme layouts. Norén uses what he calls &#8220;the one indispensable tool in the Block Theming toolbox,&#8221; the <a href=\"https://wordpress.org/plugins/create-block-theme/\">Create Block Theme</a> (CBT) plugin.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Step 1: Make the changes in the site editor.</li>\n\n\n\n<li>Step 2: Save them to the theme with CBT.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-plugin-directory wp-block-embed-plugin-directory\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\"><a href=\"https://wordpress.org/plugins/create-block-theme/\">Create Block Theme</a></blockquote>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"header-and-footer\">Header and Footer</h3>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p class=\"has-accent-color has-text-color has-link-color wp-elements-88dce5c85c9093f5410ad70883aea48d\">&#8220;When I&#8217;m building a theme, I almost always start with the header and footer. It fools you into thinking the theme is nearly finished. I&#8217;ll wait with the newsletter form and the other Jetpack blocks until all the templates are in place.&#8221; &#8212; Norén shared in his thread.</p>\n</blockquote>\n\n\n\n<div class=\"wp-block-columns alignwide is-style-no-vertical-margin is-layout-flex wp-container-core-columns-is-layout-9d6595d7 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column has-light-background-background-color has-background is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large is-style-no-vertical-margin wp-lightbox-container\"><img alt=\"Screenshot of the Pulitzer theme in the editor\" class=\"wp-image-28492\" height=\"491\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/05/GMLDVwoXAAA3Q3T.jpeg?resize=652%2C491&#038;ssl=1\" width=\"652\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">Working in the Site Editor  </p>\n</div>\n\n\n\n<div class=\"wp-block-column has-light-background-background-color has-background is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large is-style-no-vertical-margin wp-lightbox-container\"><img alt=\"Screenshot of the Pulitzer template with the create-block-theme plugin\'s sidebar open\" class=\"wp-image-28491\" height=\"491\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/05/GMLDOr9XUAE-1ZE.jpeg?resize=652%2C491&#038;ssl=1\" width=\"652\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">Saving changes to the theme with CBT </p>\n</div>\n</div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>The header template part is only the container for the hidden-header pattern. The reason to use patterns is that you can add php code. The advantage is that the text wrapped in <code>esc_html_e()</code> function can be translated. See below an example of a group of Navigation links.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img alt=\"Screenshot of the code building the navigation links\" class=\"wp-image-40324\" height=\"68\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/05/Screenshot-2025-05-09-at-14.22.37.png?resize=652%2C68&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<div class=\"wp-block-group alignwide has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p class=\"has-text-align-left\"><strong>Template part: <a href=\"https://github.com/andersnoren/pulitzer/blob/main/parts/header.html\">header.html</a></strong></p>\n\n\n\n<div class=\"wp-block-kevinbatdorf-code-block-pro cbp-has-line-numbers\"><span>PHP</span><span class=\"code-block-pro-copy-button\" style=\"color: #000000; display: none;\" tabindex=\"0\"><svg fill=\"none\" stroke=\"currentColor\" stroke-width=\"2\" viewBox=\"0 0 24 24\" xmlns=\"http://www.w3.org/2000/svg\"><path class=\"with-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path><path class=\"without-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path></svg></span><pre class=\"shiki light-plus\" style=\"background-color: #FFFFFF;\" tabindex=\"0\"><code><span class=\"line\"><span style=\"color: #000000;\">&lt;!-- wp:pattern {</span><span style=\"color: #A31515;\">&quot;slug&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #A31515;\">&quot;pulitzer/hidden-header&quot;</span><span style=\"color: #000000;\">} /--&gt;</span></span></code></pre></div>\n\n\n\n<div class=\"wp-block-group has-border-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p class=\"has-text-align-center\"><a href=\"https://github.com/andersnoren/pulitzer/blob/97bd67c0b266fde8260e8993718bcdf8c657fb13/patterns/hidden-header.php\">hidden-header.php</a></p>\n\n\n\n<details class=\"wp-block-details is-layout-flow wp-block-details-is-layout-flow\">Click the arrow to see the Pattern code\n<div class=\"wp-block-kevinbatdorf-code-block-pro cbp-has-line-numbers\"><span>PHP</span><span class=\"code-block-pro-copy-button\" style=\"color: #000000; display: none;\" tabindex=\"0\"><svg fill=\"none\" stroke=\"currentColor\" stroke-width=\"2\" viewBox=\"0 0 24 24\" xmlns=\"http://www.w3.org/2000/svg\"><path class=\"with-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path><path class=\"without-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path></svg></span><pre class=\"shiki light-plus\" style=\"background-color: #FFFFFF;\" tabindex=\"0\"><code><span class=\"line\"><span style=\"color: #000000;\">&lt;?php</span></span>\n<span class=\"line\"><span style=\"color: #008000;\">/**</span></span>\n<span class=\"line\"><span style=\"color: #008000;\"> * Title: header</span></span>\n<span class=\"line\"><span style=\"color: #008000;\"> * Slug: pulitzer/hidden-header</span></span>\n<span class=\"line\"><span style=\"color: #008000;\"> * Inserter: no</span></span>\n<span class=\"line\"><span style=\"color: #008000;\"> */</span></span>\n<span class=\"line\"><span style=\"color: #000000;\">?&gt;</span></span>\n<span class=\"line\"><span style=\"color: #000000;\">&lt;!-- wp:group {</span><span style=\"color: #A31515;\">&quot;align&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #A31515;\">&quot;wide&quot;</span><span style=\"color: #000000;\">,</span><span style=\"color: #A31515;\">&quot;style&quot;</span><span style=\"color: #000000;\">:{</span><span style=\"color: #A31515;\">&quot;spacing&quot;</span><span style=\"color: #000000;\">:{</span><span style=\"color: #A31515;\">&quot;padding&quot;</span><span style=\"color: #000000;\">:{</span><span style=\"color: #A31515;\">&quot;top&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #A31515;\">&quot;var:preset|spacing|60&quot;</span><span style=\"color: #000000;\">,</span><span style=\"color: #A31515;\">&quot;bottom&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #A31515;\">&quot;var:preset|spacing|60&quot;</span><span style=\"color: #000000;\">}},</span><span style=\"color: #A31515;\">&quot;border&quot;</span><span style=\"color: #000000;\">:{</span><span style=\"color: #A31515;\">&quot;bottom&quot;</span><span style=\"color: #000000;\">:{</span><span style=\"color: #A31515;\">&quot;color&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #A31515;\">&quot;var:preset|color|contrast-5&quot;</span><span style=\"color: #000000;\">,</span><span style=\"color: #A31515;\">&quot;width&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #A31515;\">&quot;1px&quot;</span><span style=\"color: #000000;\">},</span><span style=\"color: #A31515;\">&quot;top&quot;</span><span style=\"color: #000000;\">:[],</span><span style=\"color: #A31515;\">&quot;right&quot;</span><span style=\"color: #000000;\">:[],</span><span style=\"color: #A31515;\">&quot;left&quot;</span><span style=\"color: #000000;\">:[]}},</span><span style=\"color: #A31515;\">&quot;layout&quot;</span><span style=\"color: #000000;\">:{</span><span style=\"color: #A31515;\">&quot;type&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #A31515;\">&quot;constrained&quot;</span><span style=\"color: #000000;\">}} --&gt;</span></span>\n<span class=\"line\"><span style=\"color: #000000;\">&lt;div </span><span style=\"color: #0000FF;\">class</span><span style=\"color: #000000;\">=</span><span style=\"color: #A31515;\">&quot;wp-block-group alignwide&quot;</span><span style=\"color: #000000;\"> style=</span><span style=\"color: #A31515;\">&quot;border-bottom-color:var(--wp--preset--color--contrast-5);border-bottom-width:1px;padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)&quot;</span><span style=\"color: #000000;\">&gt;</span></span>\n<span class=\"line\"></span>\n<span class=\"line\"><span style=\"color: #000000;\">	&lt;!-- wp:columns {</span><span style=\"color: #A31515;\">&quot;isStackedOnMobile&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #0000FF;\">false</span><span style=\"color: #000000;\">,</span><span style=\"color: #A31515;\">&quot;style&quot;</span><span style=\"color: #000000;\">:{</span><span style=\"color: #A31515;\">&quot;spacing&quot;</span><span style=\"color: #000000;\">:{</span><span style=\"color: #A31515;\">&quot;blockGap&quot;</span><span style=\"color: #000000;\">:{</span><span style=\"color: #A31515;\">&quot;left&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #A31515;\">&quot;var:preset|spacing|50&quot;</span><span style=\"color: #000000;\">}}}} --&gt;</span></span>\n<span class=\"line\"><span style=\"color: #000000;\">	&lt;div </span><span style=\"color: #0000FF;\">class</span><span style=\"color: #000000;\">=</span><span style=\"color: #A31515;\">&quot;wp-block-columns is-not-stacked-on-mobile&quot;</span><span style=\"color: #000000;\">&gt;</span></span>\n<span class=\"line\"><span style=\"color: #000000;\">		</span></span>\n<span class=\"line\"><span style=\"color: #000000;\">		&lt;!-- wp:column {</span><span style=\"color: #A31515;\">&quot;verticalAlignment&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #A31515;\">&quot;stretch&quot;</span><span style=\"color: #000000;\">} --&gt;</span></span>\n<span class=\"line\"><span style=\"color: #000000;\">		&lt;div </span><span style=\"color: #0000FF;\">class</span><span style=\"color: #000000;\">=</span><span style=\"color: #A31515;\">&quot;wp-block-column is-vertically-aligned-stretch&quot;</span><span style=\"color: #000000;\">&gt;</span></span>\n<span class=\"line\"><span style=\"color: #000000;\">			&lt;!-- wp:group {</span><span style=\"color: #A31515;\">&quot;style&quot;</span><span style=\"color: #000000;\">:{</span><span style=\"color: #A31515;\">&quot;dimensions&quot;</span><span style=\"color: #000000;\">:{</span><span style=\"color: #A31515;\">&quot;minHeight&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #A31515;\">&quot;100%&quot;</span><span style=\"color: #000000;\">},</span><span style=\"color: #A31515;\">&quot;spacing&quot;</span><span style=\"color: #000000;\">:{</span><span style=\"color: #A31515;\">&quot;blockGap&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #A31515;\">&quot;var:preset|spacing|40&quot;</span><span style=\"color: #000000;\">}},</span><span style=\"color: #A31515;\">&quot;layout&quot;</span><span style=\"color: #000000;\">:{</span><span style=\"color: #A31515;\">&quot;type&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #A31515;\">&quot;flex&quot;</span><span style=\"color: #000000;\">,</span><span style=\"color: #A31515;\">&quot;orientation&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #A31515;\">&quot;vertical&quot;</span><span style=\"color: #000000;\">,</span><span style=\"color: #A31515;\">&quot;verticalAlignment&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #A31515;\">&quot;space-between&quot;</span><span style=\"color: #000000;\">}} --&gt;</span></span>\n<span class=\"line\"><span style=\"color: #000000;\">			&lt;div </span><span style=\"color: #0000FF;\">class</span><span style=\"color: #000000;\">=</span><span style=\"color: #A31515;\">&quot;wp-block-group&quot;</span><span style=\"color: #000000;\"> style=</span><span style=\"color: #A31515;\">&quot;min-height:100%&quot;</span><span style=\"color: #000000;\">&gt;</span></span>\n<span class=\"line\"><span style=\"color: #000000;\">				&lt;!-- wp:group {</span><span style=\"color: #A31515;\">&quot;style&quot;</span><span style=\"color: #000000;\">:{</span><span style=\"color: #A31515;\">&quot;spacing&quot;</span><span style=\"color: #000000;\">:{</span><span style=\"color: #A31515;\">&quot;blockGap&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #A31515;\">&quot;var:preset|spacing|10&quot;</span><span style=\"color: #000000;\">},</span><span style=\"color: #A31515;\">&quot;layout&quot;</span><span style=\"color: #000000;\">:{</span><span style=\"color: #A31515;\">&quot;selfStretch&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #A31515;\">&quot;fit&quot;</span><span style=\"color: #000000;\">,</span><span style=\"color: #A31515;\">&quot;flexSize&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #0000FF;\">null</span><span style=\"color: #000000;\">}},</span><span style=\"color: #A31515;\">&quot;layout&quot;</span><span style=\"color: #000000;\">:{</span><span style=\"color: #A31515;\">&quot;type&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #A31515;\">&quot;flex&quot;</span><span style=\"color: #000000;\">,</span><span style=\"color: #A31515;\">&quot;orientation&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #A31515;\">&quot;vertical&quot;</span><span style=\"color: #000000;\">}} --&gt;</span></span>\n<span class=\"line\"><span style=\"color: #000000;\">				&lt;div </span><span style=\"color: #0000FF;\">class</span><span style=\"color: #000000;\">=</span><span style=\"color: #A31515;\">&quot;wp-block-group&quot;</span><span style=\"color: #000000;\">&gt;</span></span>\n<span class=\"line\"><span style=\"color: #000000;\">					&lt;!-- wp:site-title {</span><span style=\"color: #A31515;\">&quot;level&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #098658;\">0</span><span style=\"color: #000000;\">} /--&gt;</span></span>\n<span class=\"line\"><span style=\"color: #000000;\">					&lt;!-- wp:site-tagline /--&gt;</span></span>\n<span class=\"line\"><span style=\"color: #000000;\">				&lt;/div&gt;</span></span>\n<span class=\"line\"><span style=\"color: #000000;\">				&lt;!-- /wp:group --&gt;</span></span>\n<span class=\"line\"></span>\n<span class=\"line\"><span style=\"color: #000000;\">				&lt;!-- wp:navigation {</span><span style=\"color: #A31515;\">&quot;hasIcon&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #0000FF;\">false</span><span style=\"color: #000000;\">,</span><span style=\"color: #A31515;\">&quot;layout&quot;</span><span style=\"color: #000000;\">:{</span><span style=\"color: #A31515;\">&quot;type&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #A31515;\">&quot;flex&quot;</span><span style=\"color: #000000;\">,</span><span style=\"color: #A31515;\">&quot;orientation&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #A31515;\">&quot;horizontal&quot;</span><span style=\"color: #000000;\">}} --&gt;</span></span>\n<span class=\"line\"></span>\n<span class=\"line\"><span style=\"color: #000000;\">				&lt;!-- wp:navigation-link {</span><span style=\"color: #A31515;\">&quot;label&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #A31515;\">&quot;&lt;?php esc_html_e( \'Blog\', \'pulitzer\' ); ?&gt;&quot;</span><span style=\"color: #000000;\">,</span><span style=\"color: #A31515;\">&quot;url&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #A31515;\">&quot;#&quot;</span><span style=\"color: #000000;\">} /--&gt;</span></span>\n<span class=\"line\"><span style=\"color: #000000;\">				&lt;!-- wp:navigation-link {</span><span style=\"color: #A31515;\">&quot;label&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #A31515;\">&quot;&lt;?php esc_html_e( \'Profile\', \'pulitzer\' ); ?&gt;&quot;</span><span style=\"color: #000000;\">,</span><span style=\"color: #A31515;\">&quot;url&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #A31515;\">&quot;#&quot;</span><span style=\"color: #000000;\">} /--&gt;</span></span>\n<span class=\"line\"><span style=\"color: #000000;\">				&lt;!-- wp:navigation-link {</span><span style=\"color: #A31515;\">&quot;label&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #A31515;\">&quot;&lt;?php esc_html_e( \'Newsletter\', \'pulitzer\' ); ?&gt;&quot;</span><span style=\"color: #000000;\">,</span><span style=\"color: #A31515;\">&quot;url&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #A31515;\">&quot;#&quot;</span><span style=\"color: #000000;\">} /--&gt;</span></span>\n<span class=\"line\"></span>\n<span class=\"line\"><span style=\"color: #000000;\">				&lt;!-- /wp:navigation --&gt;</span></span>\n<span class=\"line\"></span>\n<span class=\"line\"><span style=\"color: #000000;\">			&lt;/div&gt;</span></span>\n<span class=\"line\"><span style=\"color: #000000;\">			&lt;!-- /wp:group --&gt;</span></span>\n<span class=\"line\"><span style=\"color: #000000;\">		&lt;/div&gt;</span></span>\n<span class=\"line\"><span style=\"color: #000000;\">		&lt;!-- /wp:column --&gt;</span></span>\n<span class=\"line\"></span>\n<span class=\"line\"><span style=\"color: #000000;\">		&lt;!-- wp:column {</span><span style=\"color: #A31515;\">&quot;width&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #A31515;\">&quot;1em&quot;</span><span style=\"color: #000000;\">,</span><span style=\"color: #A31515;\">&quot;layout&quot;</span><span style=\"color: #000000;\">:{</span><span style=\"color: #A31515;\">&quot;type&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #A31515;\">&quot;constrained&quot;</span><span style=\"color: #000000;\">,</span><span style=\"color: #A31515;\">&quot;justifyContent&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #A31515;\">&quot;right&quot;</span><span style=\"color: #000000;\">},</span><span style=\"color: #A31515;\">&quot;fontSize&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #A31515;\">&quot;massive&quot;</span><span style=\"color: #000000;\">} --&gt;</span></span>\n<span class=\"line\"><span style=\"color: #000000;\">		&lt;div </span><span style=\"color: #0000FF;\">class</span><span style=\"color: #000000;\">=</span><span style=\"color: #A31515;\">&quot;wp-block-column has-massive-font-size&quot;</span><span style=\"color: #000000;\"> style=</span><span style=\"color: #A31515;\">&quot;flex-basis:1em&quot;</span><span style=\"color: #000000;\">&gt;</span></span>\n<span class=\"line\"><span style=\"color: #000000;\">			&lt;!-- wp:site-logo {</span><span style=\"color: #A31515;\">&quot;width&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #098658;\">128</span><span style=\"color: #000000;\">,</span><span style=\"color: #A31515;\">&quot;shouldSyncIcon&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #0000FF;\">true</span><span style=\"color: #000000;\">,</span><span style=\"color: #A31515;\">&quot;className&quot;</span><span style=\"color: #000000;\">:</span><span style=\"color: #A31515;\">&quot;is-style-rounded&quot;</span><span style=\"color: #000000;\">} /--&gt;</span></span>\n<span class=\"line\"><span style=\"color: #000000;\">		&lt;/div&gt;</span></span>\n<span class=\"line\"><span style=\"color: #000000;\">		&lt;!-- /wp:column --&gt;</span></span>\n<span class=\"line\"></span>\n<span class=\"line\"><span style=\"color: #000000;\">	&lt;/div&gt;</span></span>\n<span class=\"line\"><span style=\"color: #000000;\">	&lt;!-- /wp:columns --&gt;</span></span>\n<span class=\"line\"></span>\n<span class=\"line\"><span style=\"color: #000000;\">&lt;/div&gt;</span></span>\n<span class=\"line\"><span style=\"color: #000000;\">&lt;!-- /wp:group --&gt;</span></span></code></pre></div>\n</details>\n</div></div>\n</div></div>\n\n\n\n<p>The same system applied to the template part <a href=\"https://github.com/andersnoren/pulitzer/blob/main/parts/footer.html\">footer.html</a> that includes the <a href=\"https://github.com/andersnoren/pulitzer/blob/main/patterns/hidden-footer.php\">hidden-footer.php</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"archives\">Archives</h3>\n\n\n\n<blockquote class=\"wp-block-quote has-accent-color has-text-color has-link-color has-normal-font-size wp-elements-c97cacc48369e31486ac97fb8d2b8b9c is-layout-flow wp-block-quote-is-layout-flow\">\n<p>&#8220;For the <a href=\"https://developer.mozilla.org/en-US/docs/Web/CSS/line-clamp\">line clamped</a> excerpts, I registered custom block styles for the &#8216;Excerpt&#8217; block and enqueues a CSS file when the block is in use on the page. You can do a lot with <code>theme.json</code> styles, but stuff like this still requires CSS,&#8221; Norén found.</p>\n</blockquote>\n\n\n\n<p><strong>Register_block_style</strong></p>\n\n\n\n<div class=\"wp-block-kevinbatdorf-code-block-pro cbp-has-line-numbers\"><span>HTML</span><span class=\"code-block-pro-copy-button\" style=\"color: #575279; display: none;\" tabindex=\"0\"><svg fill=\"none\" stroke=\"currentColor\" stroke-width=\"2\" viewBox=\"0 0 24 24\" xmlns=\"http://www.w3.org/2000/svg\"><path class=\"with-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path><path class=\"without-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path></svg></span><pre class=\"shiki rose-pine-dawn\" style=\"background-color: #faf4ed;\" tabindex=\"0\"><code><span class=\"line\"><span style=\"color: #575279;\">register_block_style(</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">			\'core/post-excerpt\',</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">			array(</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				\'name\'	=&gt; \'pulitzer-clamp-lines-2\',</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				\'label\'	=&gt; __( \'Clamp: 2 lines\', \'pulitzer\' )</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">			)</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">		);</span></span>\n<span class=\"line\"></span>\n<span class=\"line\"><span style=\"color: #575279;\">		register_block_style(</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">			\'core/post-excerpt\',</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">			array(</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				\'name\'	=&gt; \'pulitzer-clamp-lines-3\',</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				\'label\'	=&gt; __( \'Clamp: 3 lines\', \'pulitzer\' )</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">			)</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">		);</span></span></code></pre></div>\n\n\n\n<p><strong>CSS for post/excerpt clamp lines styles</strong></p>\n\n\n\n<div class=\"wp-block-kevinbatdorf-code-block-pro cbp-has-line-numbers\"><span>HTML</span><span class=\"code-block-pro-copy-button\" style=\"color: #575279; display: none;\" tabindex=\"0\"><svg fill=\"none\" stroke=\"currentColor\" stroke-width=\"2\" viewBox=\"0 0 24 24\" xmlns=\"http://www.w3.org/2000/svg\"><path class=\"with-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path><path class=\"without-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path></svg></span><pre class=\"shiki rose-pine-dawn\" style=\"background-color: #faf4ed;\" tabindex=\"0\"><code><span class=\"line\"><span style=\"color: #575279;\">[class*=&quot;is-style-pulitzer-clamp-lines-&quot;] p:first-child {</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">	display: -webkit-box;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">	-webkit-box-orient: vertical;  </span></span>\n<span class=\"line\"><span style=\"color: #575279;\">	overflow: hidden;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">}</span></span>\n<span class=\"line\"></span>\n<span class=\"line\"><span style=\"color: #575279;\">.is-style-pulitzer-clamp-lines-2 p:first-child {</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">	-webkit-line-clamp: 2;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">}</span></span>\n<span class=\"line\"></span>\n<span class=\"line\"><span style=\"color: #575279;\">.is-style-pulitzer-clamp-lines-3 p:first-child {</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">	-webkit-line-clamp: 3;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">}</span></span></code></pre></div>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<figure class=\"wp-block-image size-full\"><img alt=\"List of post with a read time block and a standardized excerpt block \" class=\"wp-image-40287\" height=\"370\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/05/posts.webp?resize=652%2C370&#038;ssl=1\" width=\"652\" /></figure>\n</div></div>\n\n\n\n<p>For basic steps on block styles, you should read my tutorial. It is titled <a href=\"https://wordpress.com/blog/2025/05/07/custom-block-styles/\">Mastering Custom Block Styles in WordPress: 6 Methods for Theme and Plugin Developers</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"alternative-post-layouts\">Alternative post layouts</h3>\n\n\n\n<p>Norén followed a tutorial on the WordPress Developer Blog: <a href=\"https://developer.wordpress.org/news/2023/06/upgrading-the-site-editing-experience-with-custom-template-part-areas/\">Upgrading the site-editing experience with custom template part areas</a> by Justin Tadlock. He added different post layouts as template parts. They are registered to a custom &#8220;posts&#8221; template parts area.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped wp-block-gallery-2 is-layout-flex wp-block-gallery-is-layout-flex\">\n<figure class=\"wp-block-image size-large\"><img alt=\"Screenshot of a post laytout with the featured image\" class=\"wp-image-28497\" height=\"509\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/05/GMLsJPuWIAAcsFf.jpeg?resize=652%2C509&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"Screenshot of the list of post with standardizes excerpt length\" class=\"wp-image-28498\" height=\"509\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/05/GMLtkwhWcAA-cIi.jpeg?resize=652%2C509&#038;ssl=1\" width=\"652\" /></figure>\n</figure>\n\n\n\n<blockquote class=\"wp-block-quote has-accent-color has-text-color has-link-color wp-elements-d8316e02f2209338b15810f2859d356d is-layout-flow wp-block-quote-is-layout-flow\">\n<p>&#8220;It&#8217;s a shame that you can&#8217;t use the &#8216;Choose a header/footer&#8217; modal for custom template part areas yet. It would make switching between template parts a lot more intuitive. There&#8217;s an open issue for it here: <a href=\"https://github.com/WordPress/gutenberg/issues/44689\">Add support for replacing &#8220;general&#8221; template parts</a>,&#8221; Norén discovered.</p>\n</blockquote>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"Examples of the modal to select a header pattern\" class=\"wp-image-28499\" height=\"322\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/05/GMLtPdrWoAA0DWK.jpeg?resize=652%2C322&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<p>The extra post layouts were created as patterns to be added into the respective template parts. </p>\n\n\n\n<p>The patterns are in separate files in <a href=\"https://github.com/andersnoren/pulitzer/tree/main/patterns\">the patterns folder</a> prefixed with <code>hidden-posts</code>&#8211; with the settings: <code>Categories: hidden</code> and <code>Inserter: no</code></p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped has-accent-background-color has-background wp-block-gallery-3 is-layout-flex wp-block-gallery-is-layout-flex\">\n<figure class=\"wp-block-image size-large\"><img alt=\"File list of alternative post layouts in the Pulitzer them\" class=\"wp-image-40288\" height=\"139\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/05/Screenshot-2025-05-08-at-15.49.38.png?resize=288%2C139&#038;ssl=1\" width=\"288\" /></figure>\n\n\n\n<figure class=\"wp-block-image size-full\"><img alt=\"Header example of a hidden pattern of the Pulitzer theme\" class=\"wp-image-40321\" height=\"164\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/05/Screenshot-2025-05-08-at-16.13.48.png?resize=282%2C164&#038;ssl=1\" width=\"282\" /></figure>\n</figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"404-template-and-the-search-block\">404-template and the Search block</h3>\n\n\n\n<p>For the 404-template, the search form is loaded as a hidden pattern, both here and in the search template. This ensures that styling and translatable strings stay consistent.</p>\n\n\n\n<p>This is a great example for nesting template parts and patterns.</p>\n\n\n\n<p>The Search pattern is the smallest unit. It is included in the 404 pattern. Then, with the header and footer template parts, it is included in the 404.html template.</p>\n\n\n\n<p><strong>The 404 Template schematic</strong></p>\n\n\n\n<div class=\"wp-block-group is-style-default has-border-background-color has-background is-layout-grid wp-container-core-group-is-layout-6be84c55 wp-block-group-is-layout-grid\">\n<p class=\"has-text-align-center is-style-no-vertical-margin has-body-background-color has-accent-background-color has-text-color has-background has-link-color wp-elements-f64a79b1c5ecf3cd21e63ba8087f9b44 wp-container-content-93ed1c69\">Header </p>\n\n\n\n<div class=\"wp-block-group is-style-no-vertical-margin has-light-background-background-color has-background wp-container-content-72181cf1\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p class=\"has-text-align-center is-style-default has-large-font-size\">404 Pattern</p>\n\n\n\n<div class=\"wp-block-group is-style-no-vertical-margin has-border-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p class=\"has-text-align-center is-style-no-vertical-margin\">Search Pattern </p>\n</div></div>\n</div></div>\n\n\n\n<p class=\"has-text-align-center is-style-no-vertical-margin has-body-background-color has-secondary-background-color has-text-color has-background has-link-color wp-elements-db4260759a82ec8ae131839137b18ea7 wp-container-content-93ed1c69\">Footer </p>\n</div>\n\n\n\n<p><strong>Search Pattern</strong></p>\n\n\n\n<div class=\"wp-block-kevinbatdorf-code-block-pro cbp-has-line-numbers\"><span>PHP</span><span class=\"code-block-pro-copy-button\" style=\"color: #575279; display: none;\" tabindex=\"0\"><svg fill=\"none\" stroke=\"currentColor\" stroke-width=\"2\" viewBox=\"0 0 24 24\" xmlns=\"http://www.w3.org/2000/svg\"><path class=\"with-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path><path class=\"without-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path></svg></span><pre class=\"shiki rose-pine-dawn\" style=\"background-color: #faf4ed;\" tabindex=\"0\"><code><span class=\"line\"><span style=\"color: #286983;\">&lt;?php</span></span>\n<span class=\"line\"><span style=\"color: #797593; font-style: italic;\">/**</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\"> * Title: Search</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\"> * Slug: pulitzer/hidden-search</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\"> * Inserter: no</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\"> </span><span style=\"color: #797593; font-style: italic;\">*/</span></span>\n<span class=\"line\"><span style=\"color: #286983;\">?&gt;</span></span>\n<span class=\"line\"><span style=\"color: #286983;\">&lt;!--</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">wp:search</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">							 </span><span style=\"color: #EA9D34;\">&quot;label&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #EA9D34;\">&quot;&lt;?php echo esc_attr_x( \'Search\', \'search form label\', \'pulitzer\' ); ?&gt;&quot;</span><span style=\"color: #797593;\">,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">               </span><span style=\"color: #EA9D34;\">&quot;showLabel&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #D7827E;\">false</span><span style=\"color: #797593;\">,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">               </span><span style=\"color: #EA9D34;\">&quot;placeholder&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #EA9D34;\">&quot;&lt;?php echo esc_attr_x( \'Search for...\', \'search form placeholder\', \'pulitzer\' ); ?&gt;&quot;</span><span style=\"color: #797593;\">,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">               </span><span style=\"color: #EA9D34;\">&quot;buttonText&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #EA9D34;\">&quot;&lt;?php echo esc_attr_x( \'Search\', \'search button text\', \'pulitzer\' ); ?&gt;&quot;</span><span style=\"color: #797593;\">,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">               </span><span style=\"color: #EA9D34;\">&quot;buttonPosition&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #EA9D34;\">&quot;button-inside&quot;</span><span style=\"color: #797593;\">,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">               </span><span style=\"color: #EA9D34;\">&quot;buttonUseIcon&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #D7827E;\">true</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">                </span><span style=\"color: #797593;\">}</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">/--&gt;</span></span></code></pre></div>\n\n\n\n<p><strong>404-Page Pattern</strong></p>\n\n\n\n<div class=\"wp-block-kevinbatdorf-code-block-pro cbp-has-line-numbers\"><span>PHP</span><span class=\"code-block-pro-copy-button\" style=\"color: #575279; display: none;\" tabindex=\"0\"><svg fill=\"none\" stroke=\"currentColor\" stroke-width=\"2\" viewBox=\"0 0 24 24\" xmlns=\"http://www.w3.org/2000/svg\"><path class=\"with-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path><path class=\"without-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path></svg></span><pre class=\"shiki rose-pine-dawn\" style=\"background-color: #faf4ed;\" tabindex=\"0\"><code><span class=\"line\"><span style=\"color: #286983;\">&lt;?php</span></span>\n<span class=\"line\"><span style=\"color: #797593; font-style: italic;\">/**</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\"> * Title: 404</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\"> * Slug: pulitzer/hidden-404</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\"> * Inserter: no</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\"> </span><span style=\"color: #797593; font-style: italic;\">*/</span></span>\n<span class=\"line\"><span style=\"color: #286983;\">?&gt;</span></span>\n<span class=\"line\"><span style=\"color: #286983;\">&lt;!--</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">wp:group</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">{</span><span style=\"color: #EA9D34;\">&quot;style&quot;</span><span style=\"color: #797593;\">:{</span><span style=\"color: #EA9D34;\">&quot;spacing&quot;</span><span style=\"color: #797593;\">:{</span><span style=\"color: #EA9D34;\">&quot;blockGap&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #EA9D34;\">&quot;var:preset|spacing|40&quot;</span><span style=\"color: #797593;\">}},</span><span style=\"color: #EA9D34;\">&quot;layout&quot;</span><span style=\"color: #797593;\">:{</span><span style=\"color: #EA9D34;\">&quot;type&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #EA9D34;\">&quot;constrained&quot;</span><span style=\"color: #797593;\">,</span><span style=\"color: #EA9D34;\">&quot;contentSize&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #EA9D34;\">&quot;21em&quot;</span><span style=\"color: #797593;\">}}</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">--&gt;</span></span>\n<span class=\"line\"><span style=\"color: #286983;\">&lt;div</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">class=</span><span style=\"color: #EA9D34;\">&quot;wp-block-group&quot;</span><span style=\"color: #286983;\">&gt;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">	</span><span style=\"color: #286983;\">&lt;!--</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">wp:heading</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">{</span><span style=\"color: #EA9D34;\">&quot;textAlign&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #EA9D34;\">&quot;center&quot;</span><span style=\"color: #797593;\">,</span><span style=\"color: #EA9D34;\">&quot;level&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #D7827E;\">1</span><span style=\"color: #797593;\">}</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">--&gt;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">	</span><span style=\"color: #286983;\">&lt;h1</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">class=</span><span style=\"color: #EA9D34;\">&quot;wp-block-heading has-text-align-center&quot;</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">id=</span><span style=\"color: #EA9D34;\">&quot;page-not-found&quot;</span><span style=\"color: #286983;\">&gt;&lt;?php</span><span style=\"color: #575279;\"> </span><span style=\"color: #B4637A; font-style: italic;\">echo</span><span style=\"color: #575279;\"> </span><span style=\"color: #D7827E;\">esc_html_x</span><span style=\"color: #797593;\">(</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">\'Error 404\'</span><span style=\"color: #797593;\">,</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">\'Heading for a webpage that is not found\'</span><span style=\"color: #797593;\">,</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">\'pulitzer\'</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">);</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">?&gt;&lt;/h1&gt;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">	</span><span style=\"color: #286983;\">&lt;!--</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">/wp:heading</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">--&gt;</span></span>\n<span class=\"line\"></span>\n<span class=\"line\"><span style=\"color: #575279;\">	</span><span style=\"color: #286983;\">&lt;!--</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">wp:paragraph</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">{</span><span style=\"color: #EA9D34;\">&quot;align&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #EA9D34;\">&quot;center&quot;</span><span style=\"color: #797593;\">}</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">--&gt;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">	</span><span style=\"color: #286983;\">&lt;p</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">class=</span><span style=\"color: #EA9D34;\">&quot;has-text-align-center&quot;</span><span style=\"color: #286983;\">&gt;&lt;?php</span><span style=\"color: #575279;\"> </span><span style=\"color: #B4637A; font-style: italic;\">echo</span><span style=\"color: #575279;\"> </span><span style=\"color: #D7827E;\">esc_html_x</span><span style=\"color: #797593;\">(</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">\'We can’t find the page you’re looking for. Go back to the front page, or try the search form below.\'</span><span style=\"color: #797593;\">,</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">\'Message to convey that a webpage could not be found\'</span><span style=\"color: #797593;\">,</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">\'pulitzer\'</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">);</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">?&gt;&lt;/p&gt;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">	</span><span style=\"color: #286983;\">&lt;!--</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">/wp:paragraph</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">--&gt;</span></span>\n<span class=\"line\"><span style=\"color: #286983;\">&lt;/div&gt;</span></span>\n<span class=\"line\"><span style=\"color: #286983;\">&lt;!--</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">/wp:group</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">--&gt;</span></span>\n<span class=\"line\"></span>\n<span class=\"line\"><span style=\"color: #286983;\">&lt;!--</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">wp</span><span style=\"color: #797593;\">:</span><span style=\"color: #286983;\">group</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">{</span><span style=\"color: #EA9D34;\">&quot;layout&quot;</span><span style=\"color: #797593;\">:{</span><span style=\"color: #EA9D34;\">&quot;type&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #EA9D34;\">&quot;constrained&quot;</span><span style=\"color: #797593;\">,</span><span style=\"color: #EA9D34;\">&quot;contentSize&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #EA9D34;\">&quot;240px&quot;</span><span style=\"color: #797593;\">}}</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">--&gt;</span></span>\n<span class=\"line cbp-line-highlight\"><span style=\"color: #286983;\">&lt;div</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">class=</span><span style=\"color: #EA9D34;\">&quot;wp-block-group&quot;</span><span style=\"color: #286983;\">&gt;</span></span>\n<span class=\"line cbp-line-highlight\"><span style=\"color: #575279;\">	</span><span style=\"color: #286983;\">&lt;!--</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">wp</span><span style=\"color: #797593;\">:</span><span style=\"color: #286983;\">pattern</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">{</span><span style=\"color: #EA9D34;\">&quot;slug&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #EA9D34;\">&quot;pulitzer/hidden-search&quot;</span><span style=\"color: #797593;\">}</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">/--&gt;</span></span>\n<span class=\"line cbp-line-highlight\"><span style=\"color: #286983;\">&lt;/div&gt;</span></span>\n<span class=\"line\"><span style=\"color: #286983;\">&lt;!--</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">/wp</span><span style=\"color: #797593;\">:</span><span style=\"color: #286983;\">group</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">--&gt;</span></span></code></pre></div>\n\n\n\n<p><strong>404-Page Template</strong></p>\n\n\n\n<div class=\"wp-block-kevinbatdorf-code-block-pro cbp-has-line-numbers\"><span>PHP</span><span class=\"code-block-pro-copy-button\" style=\"color: #575279; display: none;\" tabindex=\"0\"><svg fill=\"none\" stroke=\"currentColor\" stroke-width=\"2\" viewBox=\"0 0 24 24\" xmlns=\"http://www.w3.org/2000/svg\"><path class=\"with-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path><path class=\"without-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path></svg></span><pre class=\"shiki rose-pine-dawn\" style=\"background-color: #faf4ed;\" tabindex=\"0\"><code><span class=\"line\"><span style=\"color: #286983;\">&lt;!--</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">wp</span><span style=\"color: #797593;\">:</span><span style=\"color: #286983;\">template-part</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">{</span><span style=\"color: #EA9D34;\">&quot;slug&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #EA9D34;\">&quot;header&quot;</span><span style=\"color: #797593;\">,</span><span style=\"color: #EA9D34;\">&quot;area&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #EA9D34;\">&quot;header&quot;</span><span style=\"color: #797593;\">,</span><span style=\"color: #EA9D34;\">&quot;tagName&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #EA9D34;\">&quot;header&quot;</span><span style=\"color: #797593;\">}</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">/--&gt;</span></span>\n<span class=\"line\"></span>\n<span class=\"line\"><span style=\"color: #286983;\">&lt;!--</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">wp</span><span style=\"color: #797593;\">:</span><span style=\"color: #286983;\">group</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">{</span><span style=\"color: #EA9D34;\">&quot;tagName&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #EA9D34;\">&quot;main&quot;</span><span style=\"color: #797593;\">,</span><span style=\"color: #EA9D34;\">&quot;align&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #EA9D34;\">&quot;full&quot;</span><span style=\"color: #797593;\">,</span><span style=\"color: #EA9D34;\">&quot;style&quot;</span><span style=\"color: #797593;\">:{</span><span style=\"color: #EA9D34;\">&quot;spacing&quot;</span><span style=\"color: #797593;\">:{</span><span style=\"color: #EA9D34;\">&quot;padding&quot;</span><span style=\"color: #797593;\">:{</span><span style=\"color: #EA9D34;\">&quot;top&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #EA9D34;\">&quot;var:preset|spacing|100&quot;</span><span style=\"color: #797593;\">,</span><span style=\"color: #EA9D34;\">&quot;bottom&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #EA9D34;\">&quot;var:preset|spacing|100&quot;</span><span style=\"color: #797593;\">}}},</span><span style=\"color: #EA9D34;\">&quot;layout&quot;</span><span style=\"color: #797593;\">:{</span><span style=\"color: #EA9D34;\">&quot;type&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #EA9D34;\">&quot;constrained&quot;</span><span style=\"color: #797593;\">}}</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">--&gt;</span></span>\n<span class=\"line\"><span style=\"color: #286983;\">&lt;main</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">class=</span><span style=\"color: #EA9D34;\">&quot;wp-block-group alignfull&quot;</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">style=</span><span style=\"color: #EA9D34;\">&quot;padding-top:var(--wp--preset--spacing--100);padding-bottom:var(--wp--preset--spacing--100)&quot;</span><span style=\"color: #286983;\">&gt;</span></span>\n<span class=\"line cbp-line-highlight\"><span style=\"color: #575279;\">	</span><span style=\"color: #286983;\">&lt;!--</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">wp</span><span style=\"color: #797593;\">:</span><span style=\"color: #286983;\">pattern</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">{</span><span style=\"color: #EA9D34;\">&quot;slug&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #EA9D34;\">&quot;pulitzer/hidden-404&quot;</span><span style=\"color: #797593;\">}</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">/--&gt;</span></span>\n<span class=\"line\"><span style=\"color: #286983;\">&lt;/main&gt;</span></span>\n<span class=\"line\"><span style=\"color: #286983;\">&lt;!--</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">/wp</span><span style=\"color: #797593;\">:</span><span style=\"color: #286983;\">group</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">--&gt;</span></span>\n<span class=\"line\"></span>\n<span class=\"line\"><span style=\"color: #286983;\">&lt;!--</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">wp</span><span style=\"color: #797593;\">:</span><span style=\"color: #286983;\">template-part</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">{</span><span style=\"color: #EA9D34;\">&quot;slug&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #EA9D34;\">&quot;footer&quot;</span><span style=\"color: #797593;\">,</span><span style=\"color: #EA9D34;\">&quot;area&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #EA9D34;\">&quot;footer&quot;</span><span style=\"color: #797593;\">,</span><span style=\"color: #EA9D34;\">&quot;tagName&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #EA9D34;\">&quot;footer&quot;</span><span style=\"color: #797593;\">}</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">/--&gt;</span></span></code></pre></div>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<figure class=\"wp-block-image size-large\"><img alt=\"Screenshot of the 404-Page in the Pulitzer theme\" class=\"wp-image-40301\" height=\"575\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/05/GMMXgIiWwAEoM8f-edited-1.jpeg?resize=652%2C575&#038;ssl=1\" width=\"652\" /></figure>\n</div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"fourth-task-handling-blocks\">Fourth task: handling blocks</h2>\n\n\n\n<p>There are specific blocks outside core blocks that need more than styling. Some php code will definitely be involved:</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"jetpack-blocks\">Jetpack blocks</h3>\n\n\n\n<p>For Jetpack blocks, conditional output is simple since the plugin registers blocks only when modules are active. Norén implemented a helper function to check if blocks are registered before using them in pattern PHP files.</p>\n\n\n\n<p>In functions.php Norén created a helper function to check if a certain block is available <code><a href=\"https://github.com/andersnoren/pulitzer/blob/97bd67c0b266fde8260e8993718bcdf8c657fb13/functions.php#L223\">pulitzer_is_block_registered()</a></code>.</p>\n\n\n\n<div class=\"wp-block-kevinbatdorf-code-block-pro cbp-has-line-numbers\"><span>PHP</span><span class=\"code-block-pro-copy-button\" style=\"color: #575279; display: none;\" tabindex=\"0\"><svg fill=\"none\" stroke=\"currentColor\" stroke-width=\"2\" viewBox=\"0 0 24 24\" xmlns=\"http://www.w3.org/2000/svg\"><path class=\"with-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path><path class=\"without-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path></svg></span><pre class=\"shiki rose-pine-dawn\" style=\"background-color: #faf4ed;\" tabindex=\"0\"><code><span class=\"line\"><span style=\"color: #797593; font-style: italic;\">/**</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\"> * Check if a block is registered.</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\"> </span><span style=\"color: #797593; font-style: italic;\">*/</span></span>\n<span class=\"line\"><span style=\"color: #286983;\">if</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">(</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">!</span><span style=\"color: #575279;\"> </span><span style=\"color: #B4637A; font-style: italic;\">function_exists</span><span style=\"color: #797593;\">(</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">\'pulitzer_is_block_registered\'</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">)</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">)</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">:</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">	</span><span style=\"color: #797593; font-style: italic;\">/**</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\">	 * Check if a block is registered</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\">	 *</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\">	 * </span><span style=\"color: #286983; font-style: italic;\">@since</span><span style=\"color: #9893A5; font-style: italic;\"> Pulitzer 1.0</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\">	 * </span><span style=\"color: #286983; font-style: italic;\">@return</span><span style=\"color: #9893A5; font-style: italic;\"> </span><span style=\"color: #286983; font-style: italic;\">bool</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\">	 </span><span style=\"color: #797593; font-style: italic;\">*/</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">	</span><span style=\"color: #286983;\">function</span><span style=\"color: #575279;\"> </span><span style=\"color: #D7827E;\">pulitzer_is_block_registered</span><span style=\"color: #797593;\">(</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593; font-style: italic;\">$</span><span style=\"color: #575279; font-style: italic;\">block_name</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">)</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">		</span><span style=\"color: #797593; font-style: italic;\">$</span><span style=\"color: #575279; font-style: italic;\">registry</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">=</span><span style=\"color: #575279;\"> </span><span style=\"color: #56949F;\">WP_Block_Type_Registry</span><span style=\"color: #286983;\">::</span><span style=\"color: #D7827E;\">get_instance</span><span style=\"color: #797593;\">();</span></span>\n<span class=\"line\"><span style=\"color: #575279;\"> 		</span><span style=\"color: #286983;\">return</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593; font-style: italic;\">$</span><span style=\"color: #575279; font-style: italic;\">registry</span><span style=\"color: #286983;\">-&gt;</span><span style=\"color: #D7827E;\">get_registered</span><span style=\"color: #797593;\">(</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593; font-style: italic;\">$</span><span style=\"color: #575279; font-style: italic;\">block_name</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">);</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">	</span><span style=\"color: #797593;\">}</span></span>\n<span class=\"line\"><span style=\"color: #286983;\">endif</span><span style=\"color: #797593;\">;</span></span></code></pre></div>\n\n\n\n<p>This helper function is then available for the conditional check in the pattern: </p>\n\n\n\n<p>Examples for the <code>jetpack/like</code> button. You can inspect the whole code for the <a href=\"https://github.com/andersnoren/pulitzer/blob/main/patterns/hidden-single-sharing-row.php\">hidden-single sharing-row</a> pattern on GitHub.</p>\n\n\n\n<div class=\"wp-block-kevinbatdorf-code-block-pro cbp-has-line-numbers\"><span>PHP</span><span class=\"code-block-pro-copy-button\" style=\"color: #575279; display: none;\" tabindex=\"0\"><svg fill=\"none\" stroke=\"currentColor\" stroke-width=\"2\" viewBox=\"0 0 24 24\" xmlns=\"http://www.w3.org/2000/svg\"><path class=\"with-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path><path class=\"without-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path></svg></span><pre class=\"shiki rose-pine-dawn\" style=\"background-color: #faf4ed;\" tabindex=\"0\"><code><span class=\"line\"><span style=\"color: #286983;\">&lt;?php</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">if</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">(</span><span style=\"color: #575279;\"> </span><span style=\"color: #D7827E;\">pulitzer_is_block_registered</span><span style=\"color: #797593;\">(</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">\'jetpack/like\'</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">)</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">)</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">:</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">?&gt;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">			</span><span style=\"color: #286983;\">&lt;!--</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">wp:group</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">{</span><span style=\"color: #EA9D34;\">&quot;style&quot;</span><span style=\"color: #797593;\">:{</span><span style=\"color: #EA9D34;\">&quot;spacing&quot;</span><span style=\"color: #797593;\">:{</span><span style=\"color: #EA9D34;\">&quot;padding&quot;</span><span style=\"color: #797593;\">:{</span><span style=\"color: #EA9D34;\">&quot;top&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #EA9D34;\">&quot;6px&quot;</span><span style=\"color: #797593;\">}}}}</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">--&gt;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">			</span><span style=\"color: #286983;\">&lt;div</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">class=</span><span style=\"color: #EA9D34;\">&quot;wp-block-group&quot;</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">style=</span><span style=\"color: #EA9D34;\">&quot;padding-top:6px&quot;</span><span style=\"color: #286983;\">&gt;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				</span><span style=\"color: #286983;\">&lt;!--</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">wp</span><span style=\"color: #797593;\">:</span><span style=\"color: #286983;\">jetpack/like</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">/--&gt;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">			</span><span style=\"color: #286983;\">&lt;/div&gt;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">			</span><span style=\"color: #286983;\">&lt;!--</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">/wp</span><span style=\"color: #797593;\">:</span><span style=\"color: #286983;\">group</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">--&gt;</span></span>\n<span class=\"line\"><span style=\"color: #286983;\">&lt;?php</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">endif</span><span style=\"color: #797593;\">;</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">?&gt;</span></span></code></pre></div>\n\n\n\n<p>For the like button, share buttons and newsletter signup, he utilized styled versions of Jetpack blocks. <a href=\"https://github.com/andersnoren/pulitzer/blob/97bd67c0b266fde8260e8993718bcdf8c657fb13/functions.php#L147\">Using block stylesheet registration</a> ensures the CSS is loaded only when a block is in use.</p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<figure class=\"wp-block-image size-large\"><img alt=\"\" class=\"wp-image-40318\" height=\"425\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/05/GMKJPpHW8AAzSWZ-edited.png?resize=652%2C425&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<p></p>\n</div></div>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"block-bindings-api-blocks\">Block Bindings API blocks</h3>\n\n\n\n<p>In the final version, Pulitzer includes three use cases of the Block Binding API:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Number of comments on a post, with a link to the post comments form.</li>\n\n\n\n<li>Reading time of a post.</li>\n\n\n\n<li>Current year next to the copyright note in the footer.</li>\n</ul>\n\n\n\n<blockquote class=\"wp-block-quote has-accent-color has-text-color has-link-color has-normal-font-size wp-elements-af3f0be7f306bd6cfef399051d4551f2 is-layout-flow wp-block-quote-is-layout-flow\">\n<p>&#8220;Wow. Those of you who said the new Block bindings API is easy to use weren&#8217;t kidding. It took me all of 40 mins to get the reading time and copyright year blocks up and running, having never touched it before. Game changer.&#8221;</p>\n<cite>Anders Norén</cite></blockquote>\n\n\n\n<p>The two blog posts that helped Norén to catch up on the feature:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://t.co/QbCJimRQzF\"><strong>Introducing Block Bindings, Part 1: Connecting Custom Fields</strong></a> by Justin Tadlock</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/03/06/new-feature-the-block-bindings-api/\"><strong>New Feature: The Block Bindings API</strong></a> by Artemio Morales. </li>\n</ul>\n\n\n\n<p><a href=\"https://github.com/andersnoren/pulitzer/blob/97bd67c0b266fde8260e8993718bcdf8c657fb13/functions.php#L240\">The php code is in functions.php, starting line 240</a></p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"the-copyright-year-in-the-footer\"><strong>The copyright year in the footer</strong></h3>\n\n\n\n<p><strong>Step one: register the block binding and its callback in functions.php</strong>.</p>\n\n\n\n<div class=\"wp-block-kevinbatdorf-code-block-pro cbp-has-line-numbers\"><span>PHP</span><span class=\"code-block-pro-copy-button\" style=\"color: #575279; display: none;\" tabindex=\"0\"><svg fill=\"none\" stroke=\"currentColor\" stroke-width=\"2\" viewBox=\"0 0 24 24\" xmlns=\"http://www.w3.org/2000/svg\"><path class=\"with-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path><path class=\"without-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path></svg></span><pre class=\"shiki rose-pine-dawn\" style=\"background-color: #faf4ed;\" tabindex=\"0\"><code><span class=\"line\"><span style=\"color: #286983;\">function</span><span style=\"color: #575279;\"> </span><span style=\"color: #D7827E;\">pulitzer_register_block_bindings</span><span style=\"color: #797593;\">()</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">{</span></span>\n<span class=\"line\"><span style=\"color: #797593; font-style: italic;\">/*</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\">		 * Copyright character with current year.</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\">		 </span><span style=\"color: #797593; font-style: italic;\">*/</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">		</span><span style=\"color: #D7827E;\">register_block_bindings_source</span><span style=\"color: #797593;\">(</span><span style=\"color: #575279;\"> </span></span>\n<span class=\"line\"><span style=\"color: #575279;\">			</span><span style=\"color: #EA9D34;\">\'pulitzer/copyright-year\'</span><span style=\"color: #797593;\">,</span><span style=\"color: #575279;\"> </span></span>\n<span class=\"line\"><span style=\"color: #575279;\">			</span><span style=\"color: #B4637A; font-style: italic;\">array</span><span style=\"color: #797593;\">(</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				</span><span style=\"color: #EA9D34;\">\'label\'</span><span style=\"color: #575279;\">              </span><span style=\"color: #286983;\">=&gt;</span><span style=\"color: #575279;\"> </span><span style=\"color: #D7827E;\">__</span><span style=\"color: #797593;\">(</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">\'Copyright year\'</span><span style=\"color: #797593;\">,</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">\'pulitzer\'</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">),</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				</span><span style=\"color: #EA9D34;\">\'get_value_callback\'</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">=&gt;</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">\'pulitzer_block_binding_callback_copyright_year\'</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">			</span><span style=\"color: #797593;\">)</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">		</span><span style=\"color: #797593;\">);</span></span>\n<span class=\"line\"><span style=\"color: #797593;\">}</span></span>\n<span class=\"line\"><span style=\"color: #D7827E;\">add_action</span><span style=\"color: #797593;\">(</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">\'init\'</span><span style=\"color: #797593;\">,</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">\'pulitzer_register_block_bindings\'</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">);</span></span></code></pre></div>\n\n\n\n<p><strong>Step two: create the callback function reference in the step before.</strong></p>\n\n\n\n<div class=\"wp-block-kevinbatdorf-code-block-pro cbp-has-line-numbers\"><span>pulitzer_block_binding_callback_copyright_year</span><span class=\"code-block-pro-copy-button\" style=\"color: #575279; display: none;\" tabindex=\"0\"><svg fill=\"none\" stroke=\"currentColor\" stroke-width=\"2\" viewBox=\"0 0 24 24\" xmlns=\"http://www.w3.org/2000/svg\"><path class=\"with-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path><path class=\"without-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path></svg></span><pre class=\"shiki rose-pine-dawn\" style=\"background-color: #faf4ed;\" tabindex=\"0\"><code><span class=\"line\"><span style=\"color: #797593; font-style: italic;\">/*</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\"> * Block bindings callback:</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\"> * Copyright character with current year.</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\"> </span><span style=\"color: #797593; font-style: italic;\">*/</span></span>\n<span class=\"line\"><span style=\"color: #286983;\">if</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">(</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">!</span><span style=\"color: #575279;\"> </span><span style=\"color: #B4637A; font-style: italic;\">function_exists</span><span style=\"color: #797593;\">(</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">\'pulitzer_block_binding_callback_copyright_year\'</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">)</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">)</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">:</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">	</span><span style=\"color: #797593; font-style: italic;\">/**</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\">	 * Block bindings callback</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\">	 * Copyright character with current year</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\">	 *</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\">	 * </span><span style=\"color: #286983; font-style: italic;\">@since</span><span style=\"color: #9893A5; font-style: italic;\"> Pulitzer 1.0</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\">	 * </span><span style=\"color: #286983; font-style: italic;\">@return</span><span style=\"color: #9893A5; font-style: italic;\"> </span><span style=\"color: #286983; font-style: italic;\">string</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\">	 </span><span style=\"color: #797593; font-style: italic;\">*/</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">	</span><span style=\"color: #286983;\">function</span><span style=\"color: #575279;\"> </span><span style=\"color: #D7827E;\">pulitzer_block_binding_callback_copyright_year</span><span style=\"color: #797593;\">()</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">		</span><span style=\"color: #286983;\">return</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">\'© \'</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">.</span><span style=\"color: #575279;\"> </span><span style=\"color: #B4637A; font-style: italic;\">date</span><span style=\"color: #797593;\">(</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">\'Y\'</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">);</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">	</span><span style=\"color: #797593;\">}</span></span>\n<span class=\"line\"><span style=\"color: #286983;\">endif</span><span style=\"color: #797593;\">;</span></span>\n<span class=\"line\"></span></code></pre></div>\n\n\n\n<p><strong>Step three: add the block to the pattern</strong>.</p>\n\n\n\n<div class=\"wp-block-kevinbatdorf-code-block-pro cbp-has-line-numbers\"><span>HTML</span><span class=\"code-block-pro-copy-button\" style=\"color: #575279; display: none;\" tabindex=\"0\"><svg fill=\"none\" stroke=\"currentColor\" stroke-width=\"2\" viewBox=\"0 0 24 24\" xmlns=\"http://www.w3.org/2000/svg\"><path class=\"with-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path><path class=\"without-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path></svg></span><pre class=\"shiki rose-pine-dawn\" style=\"background-color: #faf4ed;\" tabindex=\"0\"><code><span class=\"line\"><span style=\"color: #797593; font-style: italic;\">&lt;!--</span><span style=\"color: #9893A5; font-style: italic;\"> wp:paragraph {&quot;metadata&quot;:{&quot;bindings&quot;:{&quot;content&quot;:{&quot;source&quot;:&quot;pulitzer/copyright-year&quot;}}}} </span><span style=\"color: #797593; font-style: italic;\">--&gt;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">			</span><span style=\"color: #9893A5;\">&lt;</span><span style=\"color: #56949F;\">p</span><span style=\"color: #9893A5;\">&gt;</span><span style=\"color: #B4637A;\">&lt;</span><span style=\"color: #575279;\">?php esc_html_e(\'© [year]\', \'pulitzer\');?&gt;</span><span style=\"color: #9893A5;\">&lt;/</span><span style=\"color: #56949F;\">p</span><span style=\"color: #9893A5;\">&gt;</span></span>\n<span class=\"line\"><span style=\"color: #797593; font-style: italic;\">&lt;!--</span><span style=\"color: #9893A5; font-style: italic;\"> /wp:paragraph </span><span style=\"color: #797593; font-style: italic;\">--&gt;</span></span></code></pre></div>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<figure class=\"wp-block-image size-full\"><img alt=\"Close up of the dynamic Copyright block in the footer of the Pulitzer theme\" class=\"wp-image-40333\" height=\"104\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/05/Screenshot-2025-05-09-at-15.43.18.png?resize=383%2C104&#038;ssl=1\" width=\"383\" /></figure>\n</div></div>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"reading-time\">Reading Time </h3>\n\n\n\n<p>Justin Tadlock kindly offered Norén to use <a href=\"https://github.com/x3p0-dev/x3p0-ideas/blob/master/src/Bindings/Post.php#L84-L137\">his code for calculating reading time</a>.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p class=\"has-accent-color has-text-color has-link-color wp-elements-8869475fd7bf672f661db0a03c21d924\">&#8220;I&#8217;ve been using his PHP snippets for 15+ years, so why stop now?&#8221; &#8212; Norén</p>\n</blockquote>\n\n\n\n<p>Functions.php is your first location to find out how <a href=\"https://github.com/andersnoren/pulitzer/blob/97bd67c0b266fde8260e8993718bcdf8c657fb13/functions.php#L275\">this block binding was created.</a> You can also see what the <a href=\"https://github.com/andersnoren/pulitzer/blob/97bd67c0b266fde8260e8993718bcdf8c657fb13/functions.php#L337\">callback function does.</a> Then, look into any of the post patterns to see <a href=\"https://github.com/andersnoren/pulitzer/blob/97bd67c0b266fde8260e8993718bcdf8c657fb13/patterns/hidden-posts.php#L26\">how it is used</a> there.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"comments-count\">Comments count </h3>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"Single post view of the list of posts of the Pulitzer theme\" class=\"wp-image-28517\" height=\"236\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/05/GMPsHwlXsAMHLa3.jpeg?resize=652%2C236&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<blockquote class=\"wp-block-quote has-accent-color has-text-color has-link-color wp-elements-e85aae19b9b1f711b7a643bf7ed49aba is-layout-flow wp-block-quote-is-layout-flow\">\n<p class=\"has-accent-color has-text-color has-link-color wp-elements-10b0b56d9572aaab3748645a5aeb4932\">&#8220;I decided to add one for the comments count link on the archive pages as well. It&#8217;s crazy that a &#8220;X comments&#8221; block linking to the comments field hasn&#8217;t landed in Core yet. (It&#8217;s in Gutenberg). Slippery slope? Maybe, but I&#8217;m on a deadline, so that&#8217;s for another day.&#8221; &#8212; Anders Norén</p>\n</blockquote>\n\n\n\n<div class=\"wp-block-kevinbatdorf-code-block-pro cbp-has-line-numbers\"><span>PHP</span><span class=\"code-block-pro-copy-button\" style=\"color: #575279; display: none;\" tabindex=\"0\"><svg fill=\"none\" stroke=\"currentColor\" stroke-width=\"2\" viewBox=\"0 0 24 24\" xmlns=\"http://www.w3.org/2000/svg\"><path class=\"with-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path><path class=\"without-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path></svg></span><pre class=\"shiki rose-pine-dawn\" style=\"background-color: #faf4ed;\" tabindex=\"0\"><code><span class=\"line\"><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">*</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">Block</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">bindings</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">callback</span><span style=\"color: #797593;\">:</span></span>\n<span class=\"line\"><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">*</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">Post</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">comments</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">count</span><span style=\"color: #286983;\">.</span></span>\n<span class=\"line\"><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">*/</span></span>\n<span class=\"line\"></span>\n<span class=\"line\"><span style=\"color: #286983;\">if</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">(</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">!</span><span style=\"color: #575279;\"> </span><span style=\"color: #B4637A; font-style: italic;\">function_exists</span><span style=\"color: #797593;\">(</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">\'pulitzer_block_binding_callback_post_comments_count\'</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">)</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">)</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">:</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">	</span><span style=\"color: #797593; font-style: italic;\">/**</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\">	 * Block bindings callback</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\">	 * Post comments count.</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\">	 *</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\">	 * </span><span style=\"color: #286983; font-style: italic;\">@since</span><span style=\"color: #9893A5; font-style: italic;\"> Pulitzer 1.0</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\">	 * </span><span style=\"color: #286983; font-style: italic;\">@return</span><span style=\"color: #9893A5; font-style: italic;\"> </span><span style=\"color: #286983; font-style: italic;\">string</span></span>\n<span class=\"line\"><span style=\"color: #9893A5; font-style: italic;\">	 </span><span style=\"color: #797593; font-style: italic;\">*/</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">	</span><span style=\"color: #286983;\">function</span><span style=\"color: #575279;\"> </span><span style=\"color: #D7827E;\">pulitzer_block_binding_callback_post_comments_count</span><span style=\"color: #797593;\">(</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">array</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593; font-style: italic;\">$</span><span style=\"color: #575279; font-style: italic;\">source_args</span><span style=\"color: #797593;\">,</span><span style=\"color: #575279;\"> </span><span style=\"color: #56949F;\">WP_Block</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593; font-style: italic;\">$</span><span style=\"color: #575279; font-style: italic;\">block_instance</span><span style=\"color: #797593;\">,</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">string</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593; font-style: italic;\">$</span><span style=\"color: #575279; font-style: italic;\">attribute_name</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">)</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">		</span><span style=\"color: #797593; font-style: italic;\">$</span><span style=\"color: #575279; font-style: italic;\">post_id</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">=</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593; font-style: italic;\">$</span><span style=\"color: #575279; font-style: italic;\">block_instance</span><span style=\"color: #286983;\">-&gt;</span><span style=\"color: #575279; font-style: italic;\">context</span><span style=\"color: #797593;\">[</span><span style=\"color: #EA9D34;\">\'postId\'</span><span style=\"color: #797593;\">]</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">??</span><span style=\"color: #575279;\"> </span><span style=\"color: #D7827E;\">get_the_ID</span><span style=\"color: #797593;\">();</span></span>\n<span class=\"line\"></span>\n<span class=\"line\"><span style=\"color: #575279;\">		</span><span style=\"color: #286983;\">if</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">(</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">!</span><span style=\"color: #575279;\"> </span><span style=\"color: #D7827E;\">comments_open</span><span style=\"color: #797593;\">(</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593; font-style: italic;\">$</span><span style=\"color: #575279; font-style: italic;\">post_id</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">)</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">)</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">return</span><span style=\"color: #575279;\"> </span><span style=\"color: #D7827E;\">false</span><span style=\"color: #797593;\">;</span></span>\n<span class=\"line\"></span>\n<span class=\"line\"><span style=\"color: #575279;\">		</span><span style=\"color: #797593; font-style: italic;\">$</span><span style=\"color: #575279; font-style: italic;\">comments_link</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">=</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">\'&lt;a class=&quot;pulitzer-comment-count-link&quot; href=&quot;\'</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">.</span><span style=\"color: #575279;\"> </span><span style=\"color: #D7827E;\">esc_url</span><span style=\"color: #797593;\">(</span><span style=\"color: #575279;\"> </span><span style=\"color: #D7827E;\">get_comments_link</span><span style=\"color: #797593;\">(</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593; font-style: italic;\">$</span><span style=\"color: #575279; font-style: italic;\">post_id</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">)</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">)</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">.</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">\'&quot;&gt;\'</span><span style=\"color: #797593;\">;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">		</span><span style=\"color: #797593; font-style: italic;\">$</span><span style=\"color: #575279; font-style: italic;\">comments_link</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">.=</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">\'&lt;span class=&quot;count&quot;&gt;\'</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">.</span><span style=\"color: #575279;\"> </span><span style=\"color: #D7827E;\">esc_html</span><span style=\"color: #797593;\">(</span><span style=\"color: #575279;\"> </span><span style=\"color: #D7827E;\">get_comments_number</span><span style=\"color: #797593;\">(</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593; font-style: italic;\">$</span><span style=\"color: #575279; font-style: italic;\">post_id</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">)</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">)</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">.</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">\'&lt;/span&gt;\'</span><span style=\"color: #797593;\">;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">		</span><span style=\"color: #797593; font-style: italic;\">$</span><span style=\"color: #575279; font-style: italic;\">comments_link</span><span style=\"color: #575279;\"> </span><span style=\"color: #286983;\">.=</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">\'&lt;/a&gt;\'</span><span style=\"color: #797593;\">;</span></span>\n<span class=\"line\"></span>\n<span class=\"line\"><span style=\"color: #575279;\">		</span><span style=\"color: #286983;\">return</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593; font-style: italic;\">$</span><span style=\"color: #575279; font-style: italic;\">comments_link</span><span style=\"color: #797593;\">;</span></span>\n<span class=\"line\"></span>\n<span class=\"line\"><span style=\"color: #575279;\">	</span><span style=\"color: #797593;\">}</span></span>\n<span class=\"line\"><span style=\"color: #286983;\">endif</span><span style=\"color: #797593;\">;</span></span></code></pre></div>\n\n\n\n<p>It&#8217;s one of the rare moments you need to look into the <a href=\"https://github.com/andersnoren/pulitzer/blob/97bd67c0b266fde8260e8993718bcdf8c657fb13/style.css#L88\">theme&#8217;s <code>style.css</code></a> to find the styling for the comment count bubble. </p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p class=\"has-accent-color has-text-color has-link-color wp-elements-585ecd19e40399cee9a43b313f3d01ee\">&#8220;Rare is the block theme where you don&#8217;t end up creating at least one issue in the Gutenberg repo, or think you ought to. Turns out the <code>hasIcon:false</code> setting for the navigation block only works if the navigation doesn&#8217;t have any styles set. (<a href=\"https://github.com/WordPress/gutenberg/issues/61181\">61181</a>)&#8221; &#8211; Anders Norén</p>\n</blockquote>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"fifth-task-patterns\">Fifth Task: Patterns</h2>\n\n\n\n<p>In block themes, patterns are simply PHP files in the <code>/patterns/</code> folder. </p>\n\n\n\n<p>You can study the code for the Patterns by following the GitHub links. As mentioned above, Norén uses small php snippets with his text strings, to allow for translations.</p>\n\n\n\n<p>Here is an example:</p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<pre class=\"wp-block-code has-000000-color has-text-color has-875-rem-font-size\"><code>&lt;!-- wp:paragraph {\"fontSize\":\"large\"} --&gt;\n&lt;p class=\"has-large-font-size\"&gt;<strong>&lt;?php esc_html_e( \'I have a long and storied career in the newspaper and publishing industry behind me. Testimonials are available by request.\', \'pulitzer\' ); ?&gt;</strong>&lt;/p&gt;\n&lt;!-- /wp:paragraph --&gt;</code></pre>\n</div></div>\n\n\n\n<p>Learn more about preparing a theme to be used with multiple languages in the <a href=\"https://developer.wordpress.org/themes/advanced-topics/internationalization/\">Theme Handbook &gt; Advanced topics &gt; Internationalization</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"the-newsletter-page-pattern\">The newsletter page pattern</h3>\n\n\n\n<p><a href=\"https://pulitzer.andersnoren.se/subscriptions-form/\">See Demo page</a> &#8211; <a href=\"https://github.com/andersnoren/pulitzer/blob/main/patterns/page-newsletter.php\">Code on GitHub</a></p>\n\n\n\n<figure class=\"wp-block-image size-full is-resized\"><img alt=\"Close up of the Newsletter signup pattern of the Pulitzer theme\" class=\"wp-image-40305\" height=\"418\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/05/Screenshot-2025-05-08-at-18.09.39.png?resize=581%2C418&#038;ssl=1\" style=\"width: 550px; height: auto;\" width=\"581\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"the-resume-page-pattern\">The resume page pattern</h3>\n\n\n\n<p>The resume list is separate. It can be added on its own to an existing page. It can also be modified for a different historical timeline.</p>\n\n\n\n<p><a href=\"https://pulitzer.andersnoren.se/curriculum-vitae/\">See Demo Page</a>  | <a href=\"https://github.com/andersnoren/pulitzer/blob/main/patterns/page-resume.php\">Code view on GitHub</a> | <a href=\"https://github.com/andersnoren/pulitzer/blob/main/patterns/general-resume-list.php\">Code Resume List Pattern</a></p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped wp-block-gallery-4 is-layout-flex wp-block-gallery-is-layout-flex\">\n<figure class=\"wp-block-image size-large\"><img alt=\"Screenshot of the Curriculum Vitae page made with the Pulitzer theme\" class=\"wp-image-28521\" height=\"639\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/05/GMQS6rlXkAEl5ej.jpeg?resize=652%2C639&#038;ssl=1\" width=\"652\" /></figure>\n</figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"contact-page-pattern\">Contact Page Pattern</h3>\n\n\n\n<p>Patterns are PHP files. You can use loops to output recurring block layouts. This includes layouts like the stack of five columns used to list contact approaches in the Contact page pattern. It makes the patterns easier to maintain.</p>\n\n\n\n<p>On GitHub: <a href=\"https://github.com/andersnoren/pulitzer/blob/main/patterns/general-contact-list.php\">Contact List Pattern</a> | <a href=\"https://github.com/andersnoren/pulitzer/blob/main/patterns/page-contact.php\">Contact Page Pattern</a> </p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped wp-block-gallery-5 is-layout-flex wp-block-gallery-is-layout-flex\">\n<figure class=\"wp-block-image size-large\"><img alt=\"Screenshot of Contact page in the Pulitzer theme\" class=\"wp-image-40308\" height=\"606\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/05/GMQXaJlXsAAJAPr-edited.jpeg?resize=652%2C606&#038;ssl=1\" width=\"652\" /></figure>\n</figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"sixth-task-style-variations\">Sixth Task: Style Variations</h2>\n\n\n\n<p>On to theme style variations! These are included as <code>/styles/[name].json</code> files in block themes. Users can select them at <em>Editor → Styles</em>. Theme style variations can modify just about anything set in theme.json, but Norén was sticking to a single simple <strong>Inverted</strong> style for 1.0. Later he added two more styles, &#8220;Humanist&#8221; and &#8220;Parchment.&#8221;</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"Screenshot of Pulitzer Theme with Inverted Style Variation. \" class=\"wp-image-28527\" height=\"586\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/05/GMQpkpmXQAAJtgV.jpeg?resize=652%2C586&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<div class=\"wp-block-kevinbatdorf-code-block-pro cbp-has-line-numbers\"><span>Inverted.json</span><span class=\"code-block-pro-copy-button\" style=\"color: #575279; display: none;\" tabindex=\"0\"><svg fill=\"none\" stroke=\"currentColor\" stroke-width=\"2\" viewBox=\"0 0 24 24\" xmlns=\"http://www.w3.org/2000/svg\"><path class=\"with-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path><path class=\"without-check\" d=\"M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></path></svg></span><pre class=\"shiki rose-pine-dawn\" style=\"background-color: #faf4ed;\" tabindex=\"0\"><code><span class=\"line\"><span style=\"color: #797593;\">{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">	</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #56949F;\">settings</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">		</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #56949F;\">color</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">			</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #56949F;\">palette</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #575279;\"> </span><span style=\"color: #797593;\">[</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				</span><span style=\"color: #797593;\">{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #56949F;\">color</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">&quot;#111111&quot;</span><span style=\"color: #797593;\">,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #56949F;\">name</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">&quot;Base&quot;</span><span style=\"color: #797593;\">,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #56949F;\">slug</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">&quot;base&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				</span><span style=\"color: #797593;\">},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				</span><span style=\"color: #797593;\">{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #56949F;\">color</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">&quot;#161616&quot;</span><span style=\"color: #797593;\">,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #56949F;\">name</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">&quot;Base / Two&quot;</span><span style=\"color: #797593;\">,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #56949F;\">slug</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">&quot;base-2&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				</span><span style=\"color: #797593;\">},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				</span><span style=\"color: #797593;\">{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #56949F;\">color</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">&quot;#FFFFFF&quot;</span><span style=\"color: #797593;\">,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #56949F;\">name</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">&quot;Contrast&quot;</span><span style=\"color: #797593;\">,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #56949F;\">slug</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">&quot;contrast&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				</span><span style=\"color: #797593;\">},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				</span><span style=\"color: #797593;\">{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #56949F;\">color</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">&quot;#7F7F7F&quot;</span><span style=\"color: #797593;\">,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #56949F;\">name</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">&quot;Contrast / Two&quot;</span><span style=\"color: #797593;\">,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #56949F;\">slug</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">&quot;contrast-2&quot;</span></span>\n<span class=\"line cbp-see-more-line \"><span style=\"color: #575279;\">				</span><span style=\"color: #797593;\">},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				</span><span style=\"color: #797593;\">{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #56949F;\">color</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">&quot;#616161&quot;</span><span style=\"color: #797593;\">,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #56949F;\">name</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">&quot;Contrast / Three&quot;</span><span style=\"color: #797593;\">,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #56949F;\">slug</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">&quot;contrast-3&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				</span><span style=\"color: #797593;\">},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				</span><span style=\"color: #797593;\">{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #56949F;\">color</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">&quot;#4A4A4A&quot;</span><span style=\"color: #797593;\">,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #56949F;\">name</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">&quot;Contrast / Four&quot;</span><span style=\"color: #797593;\">,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #56949F;\">slug</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">&quot;contrast-4&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				</span><span style=\"color: #797593;\">},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				</span><span style=\"color: #797593;\">{</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #56949F;\">color</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">&quot;#222222&quot;</span><span style=\"color: #797593;\">,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #56949F;\">name</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">&quot;Contrast / Five&quot;</span><span style=\"color: #797593;\">,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">					</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #56949F;\">slug</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">&quot;contrast-5&quot;</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">				</span><span style=\"color: #797593;\">}</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">			</span><span style=\"color: #797593;\">]</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">		</span><span style=\"color: #797593;\">}</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">	</span><span style=\"color: #797593;\">},</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">    </span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #56949F;\">title</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">&quot;Inverted&quot;</span><span style=\"color: #797593;\">,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">	</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #56949F;\">$schema</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #575279;\"> </span><span style=\"color: #EA9D34;\">&quot;https://schemas.wp.org/trunk/theme.json&quot;</span><span style=\"color: #797593;\">,</span></span>\n<span class=\"line\"><span style=\"color: #575279;\">    </span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #56949F;\">version</span><span style=\"color: #797593;\">&quot;</span><span style=\"color: #797593;\">:</span><span style=\"color: #575279;\"> </span><span style=\"color: #D7827E;\">2</span></span>\n<span class=\"line\"><span style=\"color: #797593;\">}</span></span></code></pre></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"seventh-task-submit-to-the-repository\">Seventh Task: Submit to the Repository</h2>\n\n\n\n<blockquote class=\"wp-block-quote has-accent-color has-text-color has-link-color wp-elements-c38a0f673e5a6a90b40282c2d37eb46c is-layout-flow wp-block-quote-is-layout-flow\">\n<p>&#8220;I&#8217;ve done another round of cleanup and polish, received the all-clear from the <a href=\"https://github.com/WordPress/theme-check\">theme check plugin</a>, added a proper theme description and <a href=\"https://pulitzer.andersnoren.se/\">created an info page about the theme on my site</a>.&#8221;</p>\n\n\n\n<p class=\"has-accent-color has-text-color has-link-color wp-elements-e076c461daae77ab5ab339a5b96bf8ef\">Anders Norén</p>\n</blockquote>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"Screenshot of the Result of automated Theme Scanning.\" class=\"wp-image-28529\" height=\"225\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/05/GMQ11PaWAAAiEXG.jpeg?resize=652%2C225&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<p>For more detailed information, you can find in the Theme Handbook page: <a href=\"https://developer.wordpress.org/themes/releasing-your-theme/submitting-your-theme-to-wordpress-org/\">Submitting Your Theme to WordPress.org</a>. </p>\n\n\n\n<p><a href=\"https://wordpress.org/themes/pulitzer/\">Pulitzer is available in the WordPress Theme repository</a></p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"Final full page view of Pulitzer theme.\" class=\"wp-image-28531\" height=\"489\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/05/GMQ1uZHWoAAs3op-2.png?resize=652%2C489&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>After the X (formerly known as Twitter) Thread was published, Anders Norén wrote a blog post almost exactly a year ago. <a href=\"https://andersnoren.se/introducing-pulitzer/\"><strong>The post introduced the Pulitzer theme</strong></a>.</p>\n\n\n\n<blockquote class=\"wp-block-quote has-accent-color has-text-color has-link-color has-normal-font-size wp-elements-59c93e449ba3278e9efca737199b4283 is-layout-flow wp-block-quote-is-layout-flow\">\n<p>&#8220;I also want to say thank you to everyone who has reached out to say they appreciate the thread. I wasn&#8217;t sure if this would end up at all useful or interesting to anyone, so it means a lot.&#8221;</p>\n<cite>Anders Norén</cite></blockquote>\n\n\n\n<p>Share what your process looks like in the comments, also share your challenges working with block themes, or what you learn on the way.  You can also <a href=\"https://discord.gg/rmj7pmBh\">join us on Discord</a> to discuss with other theme and block developers. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"who-is-anders-noren\">Who is Anders Norén?</h2>\n\n\n<div class=\"wp-block-image\">\n<figure class=\"alignleft size-full\"><a href=\"https://profiles.wordpress.org/anlino/\"><img alt=\"Avatar: Anders Norén, as seen on his WordPress profile\" class=\"wp-image-40352\" height=\"100\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/05/Anders-Noren-avatar.png?resize=100%2C100&#038;ssl=1\" width=\"100\" /></a></figure></div>\n\n\n<p><a href=\"https://andersnoren.se/\">Andres Norén</a> is a freelance designer &amp; developer living in the Swedish mountains. You can now follow him<a href=\"https://bsky.app/profile/andersnoren.bsky.social\"> on Bluesky</a>, or read his <a href=\"https://andersnoren.se/blog/\">blog</a>.</p>\n\n\n\n<p>Eleven years ago, Norén published his first Theme in the WordPress repository, <a href=\"https://wordpress.org/themes/wilson/\">Wilson in 2014</a>. There are now 33 Themes by him available.</p>\n\n\n\n<p>He has been an early adopter of block themes with his theme <a href=\"https://wordpress.org/themes/tove/\">Tove</a>, first released in September 2021. In January of this year, he released his twelfth block theme: <a href=\"https://wordpress.org/themes/spiekermann/\">Speakermann</a>. You can take a look at <a href=\"https://wordpress.org/themes/author/anlino/?tag_slug__and%5B%5D=full-site-editing\">all block themes by Norén</a> in the repository.</p>\n\n\n\n<p>You can support Anders Norén and his work by sponsoring him on <a href=\"https://ko-fi.com/andersnoren\">Ko-fi</a>, <a href=\"https://github.com/sponsors/andersnoren\">GitHub</a>, or <a href=\"https://www.paypal.com/cgi-bin/webscr?cmd=_donations&amp;business=anders%40andersnoren%2ese&amp;lc=US&amp;item_name=Free%20WordPress%20Themes%20from%20Anders%20Noren%C2%A4cy_code=USD&amp;bn=PP%2dDonationsBF%3abtn_donateCC_LG%2egif%3aNonHosted\">PayPal</a>. </p>\n\n\n\n<p>Anders Norén was also a guest on the Gutenberg Time Live Q &amp; A. <br /><a href=\"https://www.youtube.com/watch?v=eiIhJdFfamA\"><strong>He discussed the transition from Classic Themes to block-based Themes</strong></a> together with Carolina Nymark and Ellen Bauer. This took place on October 21, 2021. </p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n\n\n\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 10 May 2025 09:46:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"Gutenberg Times: Block Styles, Woo Product Collection, Deepwiki, Accessibility Day — Weekend Edition 329\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=40222\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"https://gutenbergtimes.com/block-styles-woo-product-collection-deepwiki-accessibility-day-weekend-edition-329/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:22785:\"<p>Hi, </p>\n\n\n\n<p>&#8220;And just like that, winter has faded from our collective memory&#8230;&#8221;, Om Malik wrote in his <a href=\"https://om.co/2025/05/04/a-letter-from-om-may-2025-edition/\">Letter from Om, May edition</a>. In Munich, we just had another cold spell, though. There is no doubt we are heading into the next hot summer.</p>\n\n\n\n<p>So it&#8217;s Saturday afternoon, and I am way behind on your newsletter edition. This week, I published approximately 7,500 words over three posts. Definitely a record! Plus, two podcast episodes (one is still with the editor).</p>\n\n\n\n<p>Don&#8217;t worry, this weekend edition is not entirely about me. <img alt=\"😜\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f61c.png\" style=\"height: 1em;\" /></p>\n\n\n\n<p>Have a splendid weekend ahead! </p>\n\n\n\n<p>Yours, <img alt=\"💕\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f495.png\" style=\"height: 1em;\" /><br /><em>Birgit</em></p>\n\n\n<section class=\"wp-block-newsletterglue-group\" style=\"padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;\">\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<nav class=\"wp-block-table-of-contents\"><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/block-styles-woo-product-collection-deepwiki-accessibility-day-weekend-edition-329/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/block-styles-woo-product-collection-deepwiki-accessibility-day-weekend-edition-329/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/block-styles-woo-product-collection-deepwiki-accessibility-day-weekend-edition-329/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor.</a></li></ol></nav>\n</div></div>\n</section>\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p><img alt=\"🎙\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/15.1.0/72x72/1f399.png\" style=\"height: 1em;\" /> The latest episode <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-117-woocommerce-starter-theme-and-blocks/\">Gutenberg Changelog 117 – WooCommerce Starter Theme and Blocks, WordCamp Europe, and Gutenberg 20.7 and 20.8</a> I sat down with Ellen Bauer, WooCommerce product lead and discussed what she is working on, WordCamp Europe, Create Block Theme, WP-CLI, Gutenberg 20.7 and Gutenberg 20.8 releases. </p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img alt=\"Ellen Bauer and Birgit Pauli-Haack recording Gutenberg Changelog 117\" class=\"wp-image-40375\" height=\"184\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2022/03/Screenshot-2025-05-10-at-12.16.57.png?resize=652%2C184&#038;ssl=1\" width=\"652\" /></figure>\n</div></div>\n\n\n\n<p><a href=\"https://europe.wordcamp.org/2025/workshop-registration-now-open/\"><strong>Workshop Registration Now Open for WordCamp Europe 2025 </strong></a>– Secure Your Spot Today! A reminder of the workshops offered: </p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://europe.wordcamp.org/2025/session/the-block-developer-cookbook-wceu-2025-edition/\">The Block Developer Cookbook: WCEU 2025 Edition</a> with Ryan Welcher</li>\n\n\n\n<li><a href=\"https://europe.wordcamp.org/2025/session/from-zero-to-demo-mastering-wordpress-playground-blueprints/\">From Zero to Demo: Mastering WordPress Playground Blueprints</a> with yours truly</li>\n\n\n\n<li><a href=\"https://europe.wordcamp.org/2025/session/building-automated-tests-with-wordpress-playground/\">Building Automated Tests with WordPress Playground</a> with Berislav (Bero)  Grgicak</li>\n\n\n\n<li><a href=\"https://europe.wordcamp.org/2025/session/wordpress-gems-for-devs-interactivity-api/\">Interactivity API for Developers: WordPress Gems You Should Know</a> with Milana Cap</li>\n</ul>\n\n\n\n<p><a href=\"https://europe.wordcamp.org/2025/workshop-registration/\">Here is the Workshop Registration page</a>. You already need to have a ticket, and use for this registration the same email.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><em>Global Accessibility Awareness Day (GAAD)</em> is celebrated on May 15, 2025. <strong>Amber Hinds</strong> from <em>Equalize Digital</em> invites people to join in a virtual accessibility contributor day. This event aims to improve accessibility in WordPress. Whether you’re a developer, designer, content creator, or site owner, you have the skills. You can help make the internet more usable. You can make a difference for millions of people with disabilities. she wrote. You pledge your time <a href=\"https://equalizedigital.com/gaad2025/\"><strong>Global Accessibility Awareness Day Pledge &#8211; May 15, 2025</strong></a>.</p>\n\n\n\n<p>Suggested activities include reporting issues for Core, plugins, or themes. They also cover testing patches on accessibility tickets. You can offer feedback on existing accessibility issues or add captions to videos on WordPressTV. Additionally, running a webinar is another activity choice.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://equalizedigital.com/gaad2025/\"><img alt=\"cover image of the Accessibility Pledge page on Equalize digital\" class=\"wp-image-40382\" height=\"370\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/05/Screenshot-2025-05-10-at-14.50.59.png?resize=652%2C370&#038;ssl=1\" width=\"652\" /></a></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p><strong>Brian Coords</strong> published the release notes for <a href=\"https://developer.woocommerce.com/2025/05/06/woocommerce-9-8-4-dot-release/\"><strong>WooCommerce 9.8.4</strong></a>.  It addresses a fatal error that occurred as the result of a remote service failure. </p>\n\n\n\n<p><strong>Stephanie Pi</strong> issued a <a href=\"https://developer.woocommerce.com/2025/05/06/developer-advisory-subscriptions-core-code-moving-into-woocommerce-subscriptions-plugin/\"><strong>Developer advisory: Subscriptions core code moving into WooCommerce Subscriptions plugin</strong></a>. he core code that powers WooCommerce Subscriptions will now be managed directly within the main plugin repository, rather than the separate, public <code>Automattic/woocommerce-subscriptions-core</code> codebase. This change, effective May 20, 2025, aims to reduce complexity, streamline versioning, and align with management of other WooCommerce extensions. Only developers directly depending on the core package or monitoring its repository are affected; regular plugin users or API integrators need not take action. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Fabian Kägy</strong> and I hung out with <strong>Nathan Wrigley </strong><a href=\"https://wpbuilds.com/2025/05/08/421-at-the-core-with-birgit-pauli-haack-and-fabian-kaegy-episode-3/\"><strong>for the third episode of the At the Core show</strong></a>. We dove into the latest buzz in WordPress. We especially focused on the 6.8 release. We covered some cool new features like</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>better details and accordion blocks, </li>\n\n\n\n<li>tweaks to the stylebook, </li>\n\n\n\n<li>fresh pattern section styles, </li>\n\n\n\n<li>upgraded gallery image options, and </li>\n\n\n\n<li>some nice improvements in template editing. </li>\n</ul>\n\n\n\n<p>We discussed the shift toward a slower, more thoughtful approach to WordPress core releases. There are changes in the dev workflow. We also talked about some new plugins like <a href=\"https://classifaiplugin.com/\">ClassifAI</a> and <a href=\"https://themeswitcher.com/\">ThemeSwitcher Pro</a>. These plugins make it easier to integrate AI. They also help to gradually move to block themes. This episode is packed with great tips for anyone looking to stay updated on new developments in WordPress. You also get hands-on insights about the latest features.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://wpbuilds.com/2025/05/08/421-at-the-core-with-birgit-pauli-haack-and-fabian-kaegy-episode-3/\"><img alt=\"cover image for the 421st episode of the WPBuilds podcast\" class=\"wp-image-40275\" height=\"342\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/05/WP-Builds-Podcast-Episode-421-768x403-1.jpg?resize=652%2C342&#038;ssl=1\" width=\"652\" /></a></figure>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Kaspars Dambis</strong> created a nifty optimizing plugin called <a href=\"https://wpelevator.com/plugins/lazy-load-blocks\"><strong>Lazy Load Blocks for WordPress</strong></a>. It does exactly what it says on the tin. Configurable per block, even. Lazy loading blocks improves the Web Vitals. It enhances the Page Speed metrics. It does not impact the layout shift (CLS) when the lazy loading is triggered. There is a great demo video on the page. You will also find screenshots and instructions. Explanations of how this actually works are also included. It&#8217;s comes with a small price tag of $5 per month, billed annually. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his latest video: <a href=\"https://www.youtube.com/watch?v=FHqh6oBEzRI\"><strong>How Thousands Use WordPress to Get Customer Feedback</strong></a>, Wes Theron demonstrates techniques for content creators and site owners. He shows how to use blocks by <a href=\"https://crowdsignal.com/\">Crowdsignal</a> to gather feedback. You can use highly interactive elements like polls, surveys, voting buttons, and more. Theron provides a step-by-step guide on how to add feedback tools to your site. This helps you start making smarter decisions based on real data.</p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-4-3 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p>In my latest post, <a href=\"https://wordpress.com/blog/2025/05/07/custom-block-styles/\"><strong>Mastering Custom Block Styles in WordPress: 6 Methods for Theme and Plugin Developers</strong></a>, I’m sharing some cool tips. These tips are for theme and plugin developers. They cover how to create and manage block styles in WordPress. The article discusses using JSON files. It also covers PHP functions like <code>register_block_style()</code>.  </p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://wordpress.com/blog/2025/05/07/custom-block-styles/\"><img alt=\"list of various methods to create block styles\" class=\"wp-image-40278\" height=\"283\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/05/Screenshot-2025-05-07-at-20.17.25.png?resize=652%2C283&#038;ssl=1\" width=\"652\" /></a></figure>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In, <a href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/\"><strong>Seven Tasks to a Custom Block Theme: Anders Norén’s Weekend Workflow</strong></a>, A year ago, over a weekend, Anders Norén shared his block theme building process in a X thread. I finally found the time to make it a more enhanced tutorial for theme builders&#8217; perusal. You learn about Norén&#8217;s tools, his methods, and his tricks to enhance his designs.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://gutenbergtimes.com/seven-steps-to-a-custom-block-theme-anders-norens-weekend-workflow/\"><img alt=\"An artist painting a website in the Sweden. \" class=\"wp-image-40357\" height=\"453\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/05/Swedish-artist-making-a-website.jpg?resize=652%2C453&#038;ssl=1\" width=\"652\" /></a></figure>\n\n\n<section class=\"wp-block-newsletterglue-callout undefined not-color-set\" style=\"border-color: #f9f9e5; border-radius: 22px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f9f9e5;\">\n<p><strong> <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" rel=\"noreferrer noopener\" target=\"_blank\">&#8220;Keeping up with Gutenberg &#8211; Index 2025&#8221;</a> </strong><br />A chronological list of the WordPress Make Blog posts. It includes contributions from various teams involved in Gutenberg development. These teams are Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. The previous years are also available: <strong><strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">2020</a> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/\">2021</a></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/\">2022</a></strong></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023\">2023</a></strong> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2024/\"><strong>2024</strong></a></p>\n</section>\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor.</h2>\n\n\n\n<p><strong>Eric Karkovack</strong> just published a tutorial on <a href=\"https://speckyboy.com/display-wordpress-custom-field-data-blocks/\"><strong>how to display WordPress custom field data with blocks</strong></a>. He introduces you to the Block Bindings API and walks you through an example from start to finish. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Jonathan Bossenger</strong> shared with me <strong>DeepWiki,</strong> a service by <a href=\"https://devin.ai/\">Devin AI</a>. it introduces itself as &#8220;your collaborative AI teammate, built to help ambitious engineering teams achieve more.&#8221; </p>\n\n\n\n<p>You can make it your companion developing for the Block Editor by visiting the sub-site for <a href=\"https://deepwiki.com/WordPress/gutenberg\" rel=\"noreferrer noopener\" target=\"_blank\">WordPress/Gutenberg</a>. It provides you with access to the documentation and code in a human-readable form. The chatbot will answer your questions. I tested it with two questions:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>What are Gutenberg stores and what information can you find there?</strong> You can read <a href=\"https://deepwiki.com/search/what-are-gutenberg-stores-and_c11c547c-e195-46a6-991b-ded2a3fe4379\">the answer here</a>. </li>\n\n\n\n<li><strong>Is there a good analogy for state to better explain state management?</strong> T<a href=\"https://deepwiki.com/search/is-there-a-good-analogy-for-st_7d01d0ed-c449-44a3-afe6-31cf45929a51\">he answer shows</a> quite a few real live analogies: working with a notebook, a collaborative drawing board and a room with light switches and fixtures.</li>\n</ul>\n\n\n\n<p> Try it out yourself! It&#8217;s pretty helpful as it searches the documentation  and digs through the whole Gutenberg code base for answers. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his <a href=\"https://developer.woocommerce.com/2025/05/08/tutorial-how-to-build-blocks-with-woocommerce/\"><strong>tutorial on how to build blocks with WooCommerce</strong></a>, <a href=\"https://x.com/sunyatasattva\"><strong>Marco Lucio Giannotta</strong></a> and <strong>Karol Manijak</strong> guide developers. They show how to build a WooCommerce Product Collection block. They break it down with an easy-going video and some code examples. You&#8217;ll get the scoop on block theory. You&#8217;ll watch a live-coding session where they create interactive blocks. You&#8217;ll dig deep into the default Product Collection block. There are two hands-on exercises. One teaches how to add a “Featured” filter. Another focuses on registering a custom collection of &#8220;on-sale products under $40.&#8221; It’s a great way to get the hang of block settings, custom queries, and using the WooCommerce API!</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img alt=\"Screenshot of the Video cover image Crafting Dynamic Catalogs\" class=\"wp-image-40379\" height=\"365\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/05/Screenshot-2025-05-10-at-13.39.53.png?resize=652%2C365&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<p>The <strong><a href=\"https://www.youtube.com/watch?v=vDL8zDRaSiY\">second part of the Unit test (with Jest) for WordPress Blocks</a></strong> is out. <strong>JuanMa Garrido</strong> programs unit tests for the copyright block from the &#8220;Tutorial: Build your first block&#8221;. He also explores how to  debug the Save component of a block. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>The <strong>Codeable</strong> Team published <a href=\"https://www.codeable.io/blog/how-to-get-started-with-the-interactivity-api/\"><strong>How to Get Started with the Interactivity API</strong></a>. This article introduces WordPress developers to a way of adding real-time features to websites without using heavy scripts or plugins. It explains that the Interactivity API, available from WordPress 6.5, allows developers to update page elements quickly, enhancing site performance and making development easier. It highlights the API’s benefits in performance, scalability, and WordPress integration.</p>\n\n\n\n<p>The next episode of <em>Jon learns to code with AI</em> is up. In <a href=\"https://www.youtube.com/watch?v=XO4L5Hv3RTw\" rel=\"noreferrer noopener\" target=\"_blank\">WordPress as a MCP Server</a>, <strong>Jonathan Bossenger</strong> reviewed the WordPress MCP plugin from Automattic. This plugin turns your WordPress site into an MCP server that your AI Agent can interact with. To learn what that exactly means, you need to watch the video. </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n<section class=\"wp-block-newsletterglue-callout undefined not-color-set\" style=\"border-color: #eeeeee; border-radius: 26px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f3efe9;\">\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. </p>\n\n\n\n<p>Now also available via <a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href=\"mailto:pauli@gutenbergtimes.com\">Email me </a>with your experience</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n</section>\n\n\n<p class=\"has-text-align-center has-small-font-size\"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, <br />send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n<section class=\"wp-block-newsletterglue-group\" style=\"padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;\">\n<p>Featured Image: New York &#8211; View from The Highline 2015 by Birgit Pauli-Haack</p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n<form action=\"https://gutenbergtimes.com/feed/\" autocomplete=\"on\" class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\" style=\"margin-bottom: 25px;\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input autocomplete=\"email\" class=\"ngl-form-input-text\" id=\"ngl_email\" name=\"ngl_email\" required=\"required\" style=\"border-radius: 21px;\" type=\"email\" /></div></div><button class=\"ngl-form-button\" style=\"background-color: #005075; border-color: #005075; border-width: 1px; border-style: solid; color: #ffffff; border-radius: 21px;\" type=\"submit\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too, and won&#8217;t give your email address to anyone <br />except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"><svg fill=\"none\" height=\"24\" stroke=\"#fff\" stroke-width=\"2\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><polyline points=\"20 6 9 17 4 12\"></polyline></svg></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input id=\"ngl_list_id\" name=\"ngl_list_id\" type=\"hidden\" value=\"26f81bd8ae\" /><input id=\"ngl_double_optin\" name=\"ngl_double_optin\" type=\"hidden\" value=\"yes\" /></form>\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n</section>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 10 May 2025 00:49:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Matt: Code Matters\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=142334\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ma.tt/2025/05/code-matters/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:413:\"<p>It looks like the code that the newly announced Figma Sites is producing isn&#8217;t the best.</p>\n\n\n\n<figure class=\"wp-block-embed alignwide is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n\n\n\n<p>There are some cool Figma-to-WordPress workflows; I hope Sites gets more people exploring those options.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 May 2025 22:59:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"Gravatar: How to Design an Author Brand Readers Remember\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://blog.gravatar.com/?p=3165\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://blog.gravatar.com/2025/05/09/author-branding/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:17951:\"<p>With <a href=\"https://www.tonerbuzz.com/blog/how-many-books-are-published-each-year/\">more than 500,000 books published each year</a>, many authors struggle to differentiate themselves in a saturated market. Your words might be brilliant, but without a recognizable brand, they can easily get lost among countless other titles on physical and virtual shelves. </p>\n\n\n\n<p>A solid author branding strategy needs to go beyond traditional approaches. If you want people to recognize and remember your work, you need a multi-platform presence and to maintain brand consistency. The most successful authors don&#8217;t just write great books – they craft authentic identities that resonate with their target audience.</p>\n\n\n\n<p>If you’re struggling to get to this point, you’re not alone. For many creatives, the most challenging part of being an author is the need to promote oneself, which makes the whole branding process a bit intimidating. </p>\n\n\n\n<p>To help you in this, we&#8217;ll give you a practical roadmap for establishing an authentic author brand, helping you to create visual recognition with advanced strategies that will help your work get noticed. Whether you&#8217;re just starting out or looking to refresh your existing presence, these techniques will help you build meaningful connections with readers.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Crafting an unforgettable author brand: Key strategies for standing out</strong></h2>\n\n\n\n<p>Authors face a unique challenge: Creating a professional presence that attracts readers while remaining authentic to their writing style and voice. This balance between marketability and authenticity forms the foundation of effective author branding.</p>\n\n\n\n<p>The first thing you need to understand is that your genre is the main thing that will shape branding decisions. For example, fiction writers often benefit from creative visual branding or custom-built websites that reflect their story themes. A fantasy author might use mystical imagery and an immersive website design, while a thriller writer, like <a href=\"https://jamesrollins.com/\">James Rollins</a>, might opt for darker tones and suspenseful elements. </p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"1 – James Rollins author website example\" class=\"wp-image-3168\" height=\"369\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/04/1-james-rollins-website-homepage.png?w=660\" width=\"660\" /></figure>\n\n\n\n<p>Academic and non-fiction authors (like <a href=\"https://thecruxbook.com/\">Richard P. Rumelt</a> in the example below) typically prefer sleeker, more professional branding with verified credentials, professional profiles, and links to the various places people can buy their books.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"2 – Richard P. Rumelt website homepage\" class=\"wp-image-3169\" height=\"414\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/04/2-richard-p-rumelt-website-homepage.png?w=660\" width=\"660\" /></figure>\n\n\n\n<p>However, for successful author brands, the website design is just the beginning. You need to create an overarching strategy that intersects your unique writing style, genre positioning, and reader relationships. Each element reinforces the others, creating a cohesive identity readers can connect with.</p>\n\n\n\n<p>To start developing your author brand, follow these practical steps:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li>Extract core themes from your writing – recurring motifs, values, or perspectives – and incorporate them into your brand identity.</li>\n\n\n\n<li>Study successful authors in your genre, noting how they position themselves visually and verbally.</li>\n\n\n\n<li>Design a sustainable engagement strategy across multiple platforms that fits your writing schedule and energy levels.</li>\n\n\n\n<li>Build recognition through consistent profile management across publishing platforms, social media, and professional networks.</li>\n</ol>\n\n\n\n<p><strong><img alt=\"⚠\" class=\"wp-smiley\" src=\"https://s0.wp.com/wp-content/mu-plugins/wpcom-smileys/twemoji/2/72x72/26a0.png\" style=\"height: 1em;\" />Branding isn&#8217;t about creating a false persona, and authenticity resonates more than perfection.</strong> Let your unique voice guide your branding decisions, and readers will naturally connect with both you and your work.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Storytelling and voice: Making your brand uniquely yours</strong></h3>\n\n\n\n<p>The most effective author brands maintain narrative consistency across all touchpoints – books, newsletters, social media posts, and author interviews. However, being consistent doesn&#8217;t equal being repetitive; it means ensuring your unique perspective shines through everything you create.</p>\n\n\n\n<p>Now, we know this can sound a bit like a chore, especially if you’re not used to being active online. Still, it’s a necessary one and kind of like an extension of your storytelling abilities – an opportunity to weave your experiences and expertise into every interaction with readers. Your personal anecdotes, thought processes, and distinct point of view are assets that make your brand impossible to duplicate.</p>\n\n\n\n<p>One of the most common ways for authors to connect with audiences is to share their knowledge through workshops and writing tips, which serve multiple purposes. Not only does teaching help others, but it also positions you as an authority in your genre. A romance novelist hosting dialogue-writing workshops or a mystery author sharing plot-twisting techniques creates value while strengthening their brand identity.</p>\n\n\n\n<p>And these brand-building activities need not feel forced. The same creativity that fuels your writing can make branding feel like a natural extension of your work rather than a separate marketing task. When your authentic voice remains consistent, readers recognize it instantly, whether in your books or your latest social media update.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Visual elements that captivate readers</strong></h3>\n\n\n\n<p>While written content forms the foundation of an author&#8217;s work, visual elements create immediate recognition and emotional connection. Your visual identity – from author photos to website design – communicates volumes before readers encounter a single word you&#8217;ve written.</p>\n\n\n\n<p>Video content has become particularly powerful for author branding. Maintaining a <a href=\"https://www.youtube.com/\">YouTube</a> channel, like authors <a href=\"https://www.youtube.com/@christopher_paolini\">Christopher Paolini</a> and <a href=\"https://www.youtube.com/@XiranJayZhao\">Xiran Jay Zhao</a> have done, allows readers to connect with your personality beyond the page. </p>\n\n\n\n<p>They’re also great examples of the different approaches authors can take regarding their content. Christopher’s channel is all centered around his books, especially the Eragon universe, with only his latest video being about keyboards (an author’s best friend). </p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"3 – Christopher Paolini YouTube channel homepage\" class=\"wp-image-3170\" height=\"417\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/04/3-christopher-paolini-youtube-channel.png?w=660\" width=\"660\" /></figure>\n\n\n\n<p>Xiran, on the other hand, actually built her YouTube audience before she even published her book and got popular by analyzing movies and series that contain Chinese elements and characters (Mulan, Avatar: The Last Airbender, and Turning Red, just to mention a few). </p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"4 – Xiran Jay Zhao YouTube channel homepage\" class=\"wp-image-3171\" height=\"449\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/04/4-xiran-jay-zhao-youtube-channel.png?w=660\" width=\"660\" /></figure>\n\n\n\n<p>All of this is to say that your channel can be about anything that your audience (and you!) find interesting. This could include book discussions, writing process insights, or behind-the-scenes glimpses of research trips.</p>\n\n\n\n<p>Beyond YouTube, simple visual consistency across platforms can also dramatically increase recognition. When readers see the same professional headshot, color scheme, and typography across your website, book jackets, and social accounts, they subconsciously register a cohesive brand.</p>\n\n\n\n<p>Several tools help maintain this visual consistency without requiring graphic design expertise. <a href=\"https://gravatar.com/\">Gravatar</a>, for instance, provides profile management that ensures your image appears consistently across hundreds of websites and platforms. This visual continuity builds recognition while simplifying the technical aspects of maintaining your author brand across the internet.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Building a multi-platform author presence</strong></h2>\n\n\n\n<p>Being on multiple platforms is great. It lets you cast a wider net on potential audiences, and it keeps you in the loop. However, there is one drawback – you don’t actually own any of those profiles. If a platform goes down, so does your profile, and while some of them look eternal, none of them are (remember MySpace?). </p>\n\n\n\n<p>This is why your author website should be the central hub of your online presence – a permanent digital home where readers can find your complete bibliography, background information, upcoming releases, and blog content. Unlike social media platforms that come and go, your website remains under your control, making it an essential foundation for long-term brand building.</p>\n\n\n\n<p>For authors using <a href=\"https://wordpress.org/\">WordPress</a>, the <a href=\"https://blog.gravatar.com/2024/10/23/upgrade-author-profiles-with-the-gravatar-block-for-wordpress/\">Gravatar author block</a> can automatically sign off blog posts with your profile information, providing consistent branding while boosting your site&#8217;s SEO through proper authorship markup. </p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"5 – Personalized Gravatar author block for WordPress\" class=\"wp-image-3172\" height=\"426\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/04/5-gravatar-profile-block-customized.png?w=660\" width=\"660\" /></figure>\n\n\n\n<p>This simple implementation helps search engines understand who created the content, potentially improving visibility for your work.</p>\n\n\n\n<p>Still, you shouldn’t write off other platforms completely, despite their potential brevity. A multi-platform approach allows you to meet readers where they already spend time online, expanding your reach beyond those who actively seek you out.</p>\n\n\n\n<p><a href=\"https://twitter.com/\">X</a> (formerly Twitter) has long been a primary platform for authors to share thoughts, engage with readers, and connect with publishing professionals. Now, it is slowly being overtaken by <a href=\"https://blog.gravatar.com/2025/02/06/bluesky-handle/\">Bluesky</a>, and the idea behind it is the same – share immediate thoughts and updates and connect quickly with your readers. </p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"6 – Raymond E. Feist Bluesky profile\" class=\"wp-image-3174\" height=\"509\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/04/6-raymond-e-feist-bluesky-profile.png?w=660\" width=\"660\" /></figure>\n\n\n\n<p>There are also alternative platforms, which often provide more targeted opportunities to reach specific audiences. <a href=\"https://slack.com/\">Slack</a> and <a href=\"https://discord.com/\">Discord</a> communities dedicated to literature or particular genres are becoming increasingly more popular because they promote safe spaces for meaningful discussion with engaged readers. </p>\n\n\n\n<p>Technical authors, on the other hand, might find <a href=\"https://github.com/\">GitHub</a> an unexpected but valuable platform for demonstrating expertise and connecting with technically-minded readers. On both platforms, your Gravatar avatar automatically displays, maintaining visual consistency across these diverse spaces.</p>\n\n\n\n<p>Whatever you chosen bundle of platforms is, <a href=\"https://www.optimizely.com/insights/blog/content-repurposing-guide/\">strategic content adaptation</a> will maximizes the impact of your work across platforms. A blog post can transform into a Twitter thread, newsletter excerpts, <a href=\"https://www.instagram.com/\">Instagram</a> quotes, or discussion topics for online communities – each tailored to the platform&#8217;s format while preserving your distinctive voice and message.</p>\n\n\n\n<p>This cross-platform presence builds more than just visibility. It establishes trust through verification and consistency. When readers encounter your recognizable branding across multiple channels, their confidence in your authenticity grows, especially when platforms like Gravatar provide verification mechanisms that confirm you are who you claim to be.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Streamline your brand management with Gravatar</strong></h3>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"7 – Gravatar homepage\" class=\"wp-image-3175\" height=\"343\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/04/7-gravatar-new-homepage.png?w=660\" width=\"660\" /></figure>\n\n\n\n<p>Managing multiple online profiles across various platforms can quickly become overwhelming. Gravatar offers a solution specifically valuable for authors seeking efficient brand management without the administrative headache.</p>\n\n\n\n<p>A Gravatar profile serves as a <a href=\"https://blog.gravatar.com/2024/11/18/create-online-profile/\">centralized online identity hub</a> where authors can build an authentic digital presence that fosters trust with readers. The platform includes:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Verification badges and the ability to link to your various online profiles, proving you&#8217;re the genuine author behind the work. </li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"8 – Verified links in a Gravatar profile\" class=\"wp-image-3176\" height=\"478\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/04/8-gravatar-profile-verified-accounts-section.png?w=660\" width=\"660\" /></figure>\n\n\n\n<ul class=\"wp-block-list\">\n<li>The ability to showcase your portfolio directly within your Gravatar profile, making it easy for potential readers to discover your publications with a single click.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"9 – Portfolio and article links in a Gravatar profile\" class=\"wp-image-3178\" height=\"429\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/04/9-gravatar-links-feature.png?w=660\" width=\"660\" /></figure>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Customization options that allow you to tailor your profile to match your author brand&#8217;s visual style. This includes colors, fonts, and imagery that align with your book covers and website design.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"10 – Personalized Gravatar profile with a custom background, colour palette, and cover photo\" class=\"wp-image-3179\" height=\"469\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/04/10-profile-design-customization-in-gravatar.png?w=660\" width=\"660\" /></figure>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Automatic profile syncing – this means that when you update your author photo once, the changes propagate everywhere your Gravatar appears, including WordPress, GitHub, Slack, and hundreds of other platforms. </li>\n\n\n\n<li>The ability to maintain separate profiles for different genres, pen names, or to separate professional and personal identities – all managed from a single account.</li>\n\n\n\n<li>A <a href=\"https://docs.gravatar.com/2024/05/23/qr-me-this-qr-me-that/\">unique QR code for each profile</a>, allowing you to instantly connect with people in real-life conversations like conventions, university talks, or other events. Just add the code to your phone wallet, and you’re ready to share your profile!</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"11 – Adding a Gravatar profile QR code to Apple and Google wallet\" class=\"wp-image-3180\" height=\"536\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/04/11-add-qr-code-to-wallet.png?w=660\" width=\"660\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Launch your enhanced author brand today</strong></h2>\n\n\n\n<p>Effective author branding doesn&#8217;t require massive budgets or complex marketing strategies. It&#8217;s about starting small with authentic, consistent efforts that grow over time. Even minor improvements to your online presence can significantly impact how readers perceive and remember your work.</p>\n\n\n\n<p>Begin by examining authors you admire. Study how they present themselves online – not to copy their style, but to understand what makes their brand effective. Notice how the most memorable author brands maintain consistency across all platforms while allowing their authentic personality to shine through.</p>\n\n\n\n<p>You should also pay attention to their profile management – the authors whose careers continue to flourish typically maintain consistent, professional images across platforms. This is where tools like Gravatar naturally tie into author branding. By centralizing your profile management, Gravatar helps you maintain a consistent and trusted professional author presence across numerous platforms without the typical administrative burden. </p>\n\n\n\n<p>Building an authentic author brand takes time, but the first steps are simple. Start today and <a href=\"https://gravatar.com/\">create a free Gravatar profile</a> to begin establishing your consistent online presence.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://gravatar.com/connect/?gravatar_from=blog\"><img alt=\"\" class=\"wp-image-2616\" height=\"729\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/free_profile_cta.png\" width=\"3243\" /></a></figure>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 May 2025 14:38:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Ronnie Burt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"Felix Arntz: Deploying Your WordPress Plugin’s “Tested Up To” Version Bump in Isolation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://felix-arntz.me/?p=2085\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"https://felix-arntz.me/blog/deploying-your-wordpress-plugins-tested-up-to-version-bump-in-isolation/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:12748:\"<p>Keeping the &#8220;Tested Up To&#8221; version of your WordPress plugin up-to-date on WordPress.org is crucial for ensuring compatibility and giving your users confidence. However, the process of manually updating this information can be a bit tedious, often involving a new release even if no other code changes are necessary.</p>\n\n\n\n<p>While there are existing GitHub Actions that can deploy plugin assets to WordPress.org, such as the excellent <a href=\"https://www.google.com/search?q=%5Bhttps://github.com/10up/action-wordpress-plugin-asset-update%5D(https://github.com/10up/action-wordpress-plugin-asset-update)\"><code>10up/action-wordpress-plugin-asset-update</code></a>, using them solely for updating the &#8220;Tested Up To&#8221; version without any customization can be less than ideal. You might inadvertently deploy other changes you&#8217;ve made to your <code>readme.txt</code> file or other assets, even if those weren&#8217;t intended for immediate release. This could lead to unexpected updates on the plugin directory.</p>\n\n\n\n<p>Imagine you implemented a new plugin feature in your GitHub repository which is not released yet, and you&#8217;ve already included documentation about it in the <code>readme.txt</code>. You wouldn&#8217;t want that to be deployed by accident when all you want to do is bump the &#8220;Tested Up To&#8221; version.</p>\n\n\n\n<p>This post highlights a targeted GitHub workflow for exactly this purpose, which allows you to automate the deployment of bumping your WordPress plugin&#8217;s &#8220;Tested Up To&#8221; version in isolation.</p>\n\n\n\n<span id=\"more-2085\"></span>\n\n\n\n<h2 class=\"wp-block-heading\">A More Targeted Approach: Updating Only the &#8220;Tested Up To&#8221; Version</h2>\n\n\n\n<p>To address this specific need, we need a more targeted solution – one that would update <em>only</em> the &#8220;Tested Up To&#8221; line in the <code>readme.txt</code> file on WordPress.org, directly from GitHub, without the risk of deploying any other unintended changes. This should also happen without needing to push a full new release of the plugin.</p>\n\n\n\n<p>We can still use <a href=\"https://www.google.com/search?q=%5Bhttps://github.com/10up/action-wordpress-plugin-asset-update%5D(https://github.com/10up/action-wordpress-plugin-asset-update)\"><code>10up/action-wordpress-plugin-asset-update</code></a> for that workflow, but with some additional tweaks in place.</p>\n\n\n\n<p>The initial implementation of such a workflow was <a href=\"https://github.com/WordPress/performance/pull/1969\">developed in a pull request for the Performance Lab project</a> &#8211; huge props to <a href=\"https://profiles.wordpress.org/shyamgadde/\">Shyamsundar Gadde</a> for leading that effort. Howev